package at.tugraz.genome.maspectras.quantification.vos;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ByteOrder;

import at.tugraz.genome.dbutilities.Base64;

/**
 * Holds the peak or intensity arrays
 * @author Juergen Hartler
 *
 */
public class CgMzPeakOrIntensityValueVO
{
  /** precision (32 or 64 bit)*/
  private int precision;
  /** the byte order (network, little endian, ...)*/
  private String byteOrder;
  /** the number of values */
  private int length;
  /** the data encoded as Base64 string*/
  private String data;
  /** the decoded float values */
  float[] values;
  
  /**
   * @param precision precision (32 or 64 bit)
   * @param byteOrder byte order (network, little endian, ...)
   * @param length number of values 
   * @param data data encoded as Base64 string
   */
  public CgMzPeakOrIntensityValueVO(int precision, String byteOrder, int length, String data){
    this.precision = precision;
    this.byteOrder = byteOrder;
    this.length = length;
    if (data!=null){
      this.setData(data);
    }
  }
  
  /**
   * @param precision precision (32 or 64 bit)
   * @param byteOrder byte order (network, little endian, ...)
   * @param length number of values
   */
  public CgMzPeakOrIntensityValueVO(int precision, String byteOrder, int length){
    this (precision,byteOrder, length, null);
  }
  /**
   * @return byte order (network, little endian, ...)
   */
  public String getByteOrder()
  {
    return byteOrder;
  }
  /**
   * @param byteOrder byte order (network, little endian, ...)
   */
  public void setByteOrder(String byteOrder)
  {
    this.byteOrder = byteOrder;
  }
  /**
   * @return data encoded as Base64 string
   */
  public String getData()
  {
    return data;
  }
  /**
   * @param data data encoded as Base64 string; decoding starts automatically
   */
  public void setData(String data)
  {
    this.data = data;
    values = new float[length];
    ByteBuffer buffer = ByteBuffer.wrap(Base64.decode(data));
    if (byteOrder.equalsIgnoreCase("little")){
      buffer.order(ByteOrder.LITTLE_ENDIAN);
    }
    if (byteOrder.equalsIgnoreCase("big")){
      buffer.order(ByteOrder.BIG_ENDIAN);
    }
    FloatBuffer flBuffer = buffer.asFloatBuffer();
    for (int i=0;i!=values.length;i++){
      values[i] = flBuffer.get();
    }
  }
  /**
   * @return number of values
   */
  public int getLength()
  {
    return length;
  }
  /**
   * @param length number of values
   */
  public void setLength(int length)
  {
    this.length = length;
  }
  /**
   * @return precision (32 or 64 bit)
   */
  public int getPrecision()
  {
    return precision;
  }
  /**
   * @param precision precision (32 or 64 bit)
   */
  public void setPrecision(int precision)
  {
    this.precision = precision;
  }
  /**
   * @return decoded float values
   */
  public float[] getValues()
  {
    return values;
  }
  
  
  
}
