package at.tugraz.genome.maspectras.quantification;

import java.util.StringTokenizer;

/**
 * Extension of the normal CgScan, to store MS/MS specific values
 * @author Juergen Hartler
 *
 */
public class MsMsScan extends CgScan
{
  /** the precursor m/z */
  private String precursorMz;
  /** the precursor intensity */
  private float precursorIntensity;
  
  /**
   * @param peaksCount the amount of peaks
   * @param num scan number
   * @param msLevel MS level
   * @param retentionTime retention time
   * @param lowMz the lower m/z threshold
   * @param highMz the upper m/z threshold
   * @param basePeakMz the base peak m/z
   * @param basePeakIntensity the intensity of the base peak
   * @param totIonCurrent the total ion current
   * @param precursorMz the precursor m/z
   * @param precursorIntensity the precursor intensity
   * @param polarity the polarity of the scan according to CgDefines
   */
  public MsMsScan(int peaksCount, int num, int msLevel, float retentionTime, float lowMz, float highMz, float basePeakMz, float basePeakIntensity,
      float totIonCurrent,String precursorMz,float precursorIntensity, int polarity){
    super(peaksCount, num, msLevel, retentionTime, lowMz, highMz, basePeakMz, basePeakIntensity,totIonCurrent,polarity);
    this.precursorMz = precursorMz;
    this.precursorIntensity = precursorIntensity;
  }
  
  /**
   * constructor creating a clone of the current object
   * @param other the other MsMsScan object to be cloned
   */
  public MsMsScan(MsMsScan other){
    super(other);
    this.precursorMz = other.precursorMz;
    this.precursorIntensity = other.precursorIntensity;
  }
  
  /**
   * @return the precursor intensity
   */
  public float getPrecursorIntensity()
  {
    return precursorIntensity;
  }
  /**
   * @param precursorIntensity precursor intensity
   */
  public void setPrecursorIntensity(float precursorIntensity)
  {
    this.precursorIntensity = precursorIntensity;
  }
  /**
   * @return precursor m/z
   */
  public float getMs1PrecursorMz()
  {
    float precMz = 0;
    if (precursorMz!=null && precursorMz.length()>0){
      if (precursorMz.indexOf(" ")!=-1)
        precMz = Float.valueOf((new StringTokenizer(precursorMz," ")).nextToken());
      else
        precMz = Float.valueOf(precursorMz);
    }
    return precMz;
  }
  /**
   * @param precursorMz precursor m/z
   */
  public void setPrecursorMz(String precursorMz)
  {
    this.precursorMz = precursorMz;
  }
  
  public String getPrecursorMzAsString()
  {
    return precursorMz;
  }
  public int getNum(){
    return this.Num;
  }
}
