package at.tugraz.genome.maspectras.quantification;

public interface CgReader
{
  /**
   * Reads in the file
   * @param fileName the path to the file
   * @throws CgException
   */
  public void ReadFile(String fileName) throws CgException;
  
  /**
   *  same like the other ReadFile but here it is definable if just the mzMaxima should be read
   * @param fileName he path to the file
   * @param readJustMzMaxima should just the maxima be read?
   * @throws CgException
   */
  public void ReadFile(String fileName, boolean readJustMzMaxima) throws CgException;
  
  /** 
   * 
   * @return the highest possible m/z value in the file
   */
  public int getHighestMz();
  
  /**
   * 
   * @return the lowest possible m/z value in the file
   */
  public int getLowestMz();
  
  /**
   * this is to read only parts of the file into memory and so save space
   * @param lowerThreshold the lower m/z value for the scans to be read
   */
  public void setLowerThreshold(float lowerThreshold);
 
  /**
   * this is to read only parts of the file into memory and so save space
   * @param upperThreshold the upper m/z value for the scans to be read
   */
  public void setUpperThreshold(float upperThreshold);
  
  /**
   * 
   * @return true when the data is polarity switched 
   */
  public boolean usesPolaritySwitching();
 
}
