/*
 * Created on 24.06.2005
 * Erik Koerner, FH Joanneum
 * erik.koerner@fh-joanneum.at
 */
package at.tugraz.genome.maspectras.quantification;

/**
 * Callback interface for the CgMzXmlReader class.
 * Any calling class should implement this class to receive the 
 * evaluated CgScanHeaders and CgScans
 * 
 * @author koerner
 */
public interface CgIAddScan
{
    /**
     * Delivers a Scan generated by an CgMzXmlReader object.
     * 
     * @param sx
     *      CgScan generated by the CgMzXmlReader object calling 
     *      this callback
     * @throws CgException
     */
    public void AddScan(CgScan sx) throws CgException;
    /**
     * Delivers Header information generated by an CgMzXmlReader object.
     * 
     * @param hx
     *      CgScanHeader generated by the CgMzXmlReader object calling 
     *      this callback
     * @throws CgException
     */
    public void AddHeader(CgScanHeader hx) throws CgException;
    
    public void setStartStopHeader(CgScanHeader hx)throws CgException;
    
    public CgScan getLastBaseScan();
    
    public void addParentFileName(String fileName) throws CgException;
}
