/*
 * Created on 24.06.2005
 * Erik Koerner, FH Joanneum
 * erik.koerner@fh-joanneum.at
 */
package at.tugraz.genome.maspectras.quantification;

/**
 * Just some global constants we need...
 * 
 * @author koerner
 */
public class CgDefines
{
    public static int		MaxCharge = 22;
    
    public static int		StandardValleyMethod = 0;
    public static int		EnhancedValleyMethod = 1;
   
    
    /** for the storage of the values int is chosen, because it is less space consuming; eg. 1000 than 1 in the file corresponds to 1mDa*/
    public final static int mzMultiplicationFactorForInt = 1000;
    /** the resolution in the units with the multiplicationFactor*/
    public final static int lowestResolution = 1;
    
    /** how many lines must pass to make one index entry*/
    public final static int numberOfEntriesForIndex = 1000;
    /** how big is the array for the chromatogram translation; through this a lot of iterations are saved*/
    public final static int elementsForBatchCalculation = mzMultiplicationFactorForInt/lowestResolution;
    /** when you are using big raw files they are translated in parts; this is to be on the save side, this additional Da are taken into account for an section*/
    public final static int overlapAllowed = 10;
    
    public final static int SECONDS = 0;
    public final static int MINUTES = 1;
    
    /** no polarity switching*/
    public final static int POLARITY_NO = 0;
    /** positive polarity in polarity switched data*/
    public final static int POLARITY_POSITIVE = 1;
    /** negative polarity in polarity switched data*/
    public final static int POLARITY_NEGATIVE = 2;
    
/*    public static int OV_POS_NONE = 0;
    public static int OV_POS_LATER_LOWER_MZ = 1;
    public static int OV_POS_LATER = 2;
    public static int OV_POS_LATER_HIGHER_MZ = 3;
    public static int OV_POS_HIGHER_MZ = 4;
    public static int OV_POS_BEFORE_HIGHER_MZ = 5;
    public static int OV_POS_BEFORE = 6;
    public static int OV_POS_BEFORE_LOWER_MZ = 7;
    public static int OV_POS_LOWER_MZ = 8;*/
    
}