package at.tugraz.genome.maspectras.parser.spectrummill.vos;


import java.util.Vector;
import java.util.Collections;

import at.tugraz.genome.voutils.GeneralComparator;

/**
 * VO for chemical elements; holds the mass values
 * @author Juergen Hartler
 *
 */
public class SmChemicalElementVO
{
  /** chemical symbol */
  private String chemicalSymbol;
  /** monoisotopic mass*/
  private double monoMass;
  /** average mass*/
  private double averageMass;
  
  private Vector<Double> probabilities;
  
  /**
   * @param chemicalSymbol chemical symbol
   * @param isotopes vector containing the isotopes and their relative occurence
   */
  public SmChemicalElementVO (String chemicalSymbol, Vector<SmIsotopeVO> isotopes){
    probabilities = new Vector<Double>();
    double highestAbundance = 0;
    this.monoMass = 0;
    this.averageMass = 0;
    this.chemicalSymbol = chemicalSymbol;
    Collections.sort(isotopes, new GeneralComparator("at.tugraz.genome.maspectras.parser.spectrummill.vos.SmIsotopeVO", "getMass", "java.lang.Double"));
    for (SmIsotopeVO isotope: isotopes){
      if (isotope.getAbundance()>highestAbundance){
        highestAbundance = isotope.getAbundance();
        this.monoMass = isotope.getMass();
      }
      probabilities.add(isotope.getAbundance());
      this.averageMass += isotope.getMass()*isotope.getAbundance();
    }
  }
  /**
   * @return the average mass value
   */
  public double getAverageMass()
  {
    return averageMass;
  }
  /**
   * @return the chemical symbol
   */
  public String getChemicalSymbol()
  {
    return chemicalSymbol;
  }
  /**
   * @return the monoisotopic mass value
   */
  public double getMonoMass()
  {
    return monoMass;
  }
  public Vector<Double> getProbabilities()
  {
    return probabilities;
  }
  
  
  
}
