package at.tugraz.genome.maspectras.chromaviewer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import at.tugraz.genome.maspectras.quantification.vos.CgAllChromatogramSets;

public class CgThreadedDataLoader extends Thread
{
  private CgChromaSetInfo m_info[] = null;

  private String m_url = "";

  private CgChromaViewer m_viewer;

  private boolean m_firstCall;

  Long quantId;

  public CgThreadedDataLoader(CgChromaViewer myViewer)
  {
    super();
    m_viewer = myViewer;
  }

  public void setUrl(String newValue)
  {
    m_url = newValue;
  }

  public boolean getBusy()
  {
    return this.isAlive();
  }

  public boolean getJustReady()
  {
    if (m_firstCall == true) {
      m_firstCall = false;
      return true;
    }
    return false;
  }

  public CgChromaSetInfo[] getInfo()
  {
    return m_info;
  }

  public void run()
  {
    URLConnection servletConnection = null;

    String url = m_url;
    try {
      checkUrl(url); // this is only necessary for testing purposes, with
                      // applet loaded from the server not necessary
      if (url.startsWith("https")) {
        TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
          public boolean checkClientTrusted(
              java.security.cert.X509Certificate[] chain)
          {
            return true;
          }

          public java.security.cert.X509Certificate[] getAcceptedIssuers()
          {
            return null;
          }

          public void checkClientTrusted(
              java.security.cert.X509Certificate[] chain, String authType)
          {
          }

          public void checkServerTrusted(
              java.security.cert.X509Certificate[] chain, String authType)
          {
          }
        } };
        try {
          SSLContext ctx;
          ctx = SSLContext.getInstance("SSL");
          ctx.init(null, trustAllCerts, null);
////          HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        catch (Exception e) {
          e.printStackTrace();
        }
      } // this is only necessary for testing purposes, with applet loaded from
        // the server not necessary

      servletConnection = getServletConnection(url);
      ObjectInputStream input = new ObjectInputStream(servletConnection
          .getInputStream());
      CgAllChromatogramSets sets = (CgAllChromatogramSets) input.readObject();
      /**
       * **m_viewer.idealIntensityDistribution =
       * sets.getIdealIntensityDistribution();
       */

      m_info = new CgChromaSetInfo[CgChromaViewer.maxCharge_];
      boolean hasRawData=false;
     
      m_info[0] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 1, sets.getCharge1());
      m_info[1] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 2, sets.getCharge2());
      m_info[2] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 3, sets.getCharge3());
      m_info[3] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 4, sets.getCharge4());
      m_info[4] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 5, sets.getCharge5());
      m_info[5] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 6, sets.getCharge6());
      m_info[6] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 7, sets.getCharge7());
      m_info[7] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 8, sets.getCharge8());
      m_info[8] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 9, sets.getCharge9());
      m_info[9] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 10, sets.getCharge10());
      m_info[10] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 11, sets.getCharge11());
      m_info[11] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 12, sets.getCharge12());
      m_info[12] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 13, sets.getCharge13());
      m_info[13] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 14, sets.getCharge14());
      m_info[14] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 15, sets.getCharge15());
      m_info[15] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 16, sets.getCharge16());
      m_info[16] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 17, sets.getCharge17());
      m_info[17] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 18, sets.getCharge18());
      m_info[18] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 19, sets.getCharge19());
      m_info[19] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 20, sets.getCharge20());
      m_info[20] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 21, sets.getCharge21());
      m_info[21] = new CgChromaSetInfo(m_viewer, m_viewer.get2dPanel(), m_viewer
          .get3dPanel(), 22, sets.getCharge22());
      if ((sets.getCharge1()!=null&&sets.getCharge1().getRawData()!=null)||
          (sets.getCharge2()!=null&&sets.getCharge2().getRawData()!=null)||
          (sets.getCharge3()!=null&&sets.getCharge3().getRawData()!=null)||
          (sets.getCharge4()!=null&&sets.getCharge4().getRawData()!=null)||
          (sets.getCharge5()!=null&&sets.getCharge5().getRawData()!=null)||
          (sets.getCharge6()!=null&&sets.getCharge6().getRawData()!=null)||
          (sets.getCharge7()!=null&&sets.getCharge7().getRawData()!=null)||
          (sets.getCharge8()!=null&&sets.getCharge8().getRawData()!=null)||
          (sets.getCharge9()!=null&&sets.getCharge9().getRawData()!=null)||
          (sets.getCharge10()!=null&&sets.getCharge10().getRawData()!=null)||
          (sets.getCharge11()!=null&&sets.getCharge11().getRawData()!=null)||
          (sets.getCharge12()!=null&&sets.getCharge12().getRawData()!=null)||
          (sets.getCharge13()!=null&&sets.getCharge13().getRawData()!=null)||
          (sets.getCharge14()!=null&&sets.getCharge14().getRawData()!=null)||
          (sets.getCharge15()!=null&&sets.getCharge15().getRawData()!=null)||
          (sets.getCharge16()!=null&&sets.getCharge16().getRawData()!=null)||
          (sets.getCharge17()!=null&&sets.getCharge17().getRawData()!=null)||
          (sets.getCharge18()!=null&&sets.getCharge18().getRawData()!=null)||
          (sets.getCharge19()!=null&&sets.getCharge19().getRawData()!=null)||
          (sets.getCharge20()!=null&&sets.getCharge20().getRawData()!=null)||
          (sets.getCharge21()!=null&&sets.getCharge21().getRawData()!=null)||
          (sets.getCharge22()!=null&&sets.getCharge22().getRawData()!=null))
        hasRawData=true;
      quantId = sets.getQuantparametersId();
      if (m_viewer.getCurrentSettingVO()==null){
        m_viewer.setCurrentSettingVO(sets.getSettings());
        if (sets.getSettings()!=null&&sets.getSettings().getThreeDDefault().booleanValue()&&hasRawData){
          m_viewer.m_chk3D.setEnabled(true);
          m_viewer.m_chk3D.setState(true);
          m_viewer.m_chkQuasi3D.setState(false);
        }  
      }  
    }
    catch (Exception ex) {
      System.out.println(ex.toString());
    }
    m_viewer.setChromaSetInfoArray(m_info);
    m_viewer.quantId = this.quantId;
//    Runtime.getRuntime().gc();
    m_firstCall = true;
  }

  public static boolean checkUrl(String url) throws Exception
  {
    if (url.length() > 1024)
      throw new Exception("http request to long >1024!");
    return true;
  }

  public static URLConnection getServletConnection(String serverName)
  {
    URL url = null;
    URLConnection servletConnection = null;
    try {
      url = new URL(serverName);
      servletConnection = url.openConnection();
      servletConnection.setDoInput(true);
      servletConnection.setDoOutput(true);
      servletConnection.setUseCaches(false);
      servletConnection.setRequestProperty("Content-type",
          "application/octet-stream");
    }
    catch (IOException ioe) {
      System.out.println(ioe.getMessage());
      System.out.println("IOException " + ioe);
    }
    catch (Exception e) {
      System.out.println("Error in getServletConnection: " + e.getMessage());
    }
    return servletConnection;
  }
  public void destroyDataLoader(){
    if (this.m_info!=null){
      for (int i=0;i!=m_info.length;i++){
        if (m_info[i]!=null){
          m_info[i].destroyInfoObject();
        }
        m_info[i] = null;
      }
      m_info = null;
    }
    this.m_url = null;
    if (this.m_viewer!=null)
      this.m_viewer.getGraphics().dispose();
    this.m_viewer = null;
//    try {
//      this.finalize();
//    }
//    catch (Throwable e) {
      // TODO Auto-generated catch block
//      e.printStackTrace();
//    }
//    super.destroy();
  }
}
