package at.tugraz.genome.maspectras.chromaviewer;

import java.awt.*;

public class Cg3dGraphicsManager extends Panel
{
  /** the uid */
  private static final long serialVersionUID = 1L;

  private CgChromaViewer m_viewer;

  private TextField m_txtBack;

  private TextField m_txtFront;

  private TextField m_txtArea;

  private Button m_plusGain;

  private Button m_minusGain;

  private Image m_bufferImage;

  private Graphics m_bufferGraphics;

  private float m_totalArea;

  public Cg3dGraphicsManager(CgChromaViewer myViewer)
  {
    super(null);
    m_viewer = myViewer;
    m_bufferImage = null;
    m_bufferGraphics = null;
    m_totalArea = 0;
  }

  public void initialize()
  {
    m_txtBack = new TextField();
    m_txtBack.setBounds(this.getWidth() - 150, 5, 145, 20);
    m_txtBack.setBackground(Color.WHITE);
    m_txtBack.setEnabled(false);
    m_txtBack.setForeground(Color.BLACK);
    m_txtBack.setVisible(true);
    this.add(m_txtBack);

    m_txtFront = new TextField();
    m_txtFront.setBounds(this.getWidth() - 150, 27, 145, 20);
    m_txtFront.setBackground(Color.WHITE);
    m_txtFront.setForeground(Color.BLACK);
    m_txtFront.setEnabled(false);
    m_txtFront.setVisible(true);
    this.add(m_txtFront);

    m_txtArea = new TextField();
    m_txtArea.setBounds(this.getWidth() - 150, 49, 145, 20);
    m_txtArea.setBackground(Color.WHITE);
    m_txtArea.setForeground(Color.BLACK);
    m_txtArea.setEnabled(false);
    m_txtArea.setVisible(true);
    this.add(m_txtArea);

    m_plusGain = new Button();
    m_plusGain.setLabel("+ Gain");
    m_plusGain.setBounds(this.getWidth() - 55, 72, 50, 24);
    m_plusGain.addActionListener(new CgActionListener(m_viewer, "Plus3dGain"));
    this.add(m_plusGain);
    m_minusGain = new Button();
    m_minusGain.setLabel("- Gain");
    m_minusGain.setBounds(this.getWidth() - 55, 97, 50, 24);
    m_minusGain
        .addActionListener(new CgActionListener(m_viewer, "Minus3dGain"));
    this.add(m_minusGain);

    hideFields();
  }

  public void showFields()
  {
    m_txtBack.setVisible(true);
    m_txtFront.setVisible(true);
    m_txtArea.setVisible(true);
    m_plusGain.setVisible(true);
    m_minusGain.setVisible(true);
  }

  public void hideFields()
  {
    m_txtBack.setVisible(false);
    m_txtFront.setVisible(false);
    m_txtArea.setVisible(false);
    m_plusGain.setVisible(false);
    m_minusGain.setVisible(false);
  }

  public void setFrontmostMz(float val)
  {
    showFields();
    m_txtFront.setText("Frontmost mz = " + CgUtilities.Format(val, 2) + "d");
  }

  public void setBackmostMz(float val)
  {
    showFields();
    m_txtBack.setText("Backmost mz = " + CgUtilities.Format(val, 2) + "d");
  }

  public void resetArea()
  {
    m_totalArea = 0;
    m_txtArea.setText("");
  }

  public void addArea(float val)
  {
    m_totalArea += val;
    String s = String.format("Total Area = %4.3e", m_totalArea);
    s = s.replace(",", ".").replace("e0", "e");
    m_txtArea.setText(s);
  }

  public Graphics getBufferGraphics()
  {
    if (m_bufferImage == null) {
      m_bufferImage = createImage(this.getWidth(), this.getHeight());
      m_bufferGraphics = m_bufferImage.getGraphics();
      preparePaint();
    }
    return m_bufferGraphics;
  }

  public void refresh()
  {
    if (m_bufferImage == null) {
      m_bufferImage = createImage(this.getWidth(), this.getHeight());
      m_bufferGraphics = m_bufferImage.getGraphics();
      preparePaint();
    }
    if (super.getGraphics() != null)
      super.getGraphics().drawImage(m_bufferImage, 0, 0, this);
  }

  public void setBounds(int x, int y, int w, int h)
  {
    super.setBounds(x, y, w, h);
    m_bufferImage = null;
    m_bufferGraphics = null;
  }

  public void preparePaint()
  {
    if (m_bufferImage == null) {
      m_bufferImage = createImage(this.getWidth(), this.getHeight());
      m_bufferGraphics = m_bufferImage.getGraphics();
    }
    m_bufferGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
    m_bufferGraphics.setColor(new Color(240, 240, 240));
    m_bufferGraphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
  }

  public void paint(Graphics g)
  {
    refresh();
  }

  public void reshape(int x, int y, int width, int height)
  {
    super.reshape(x, y, width, height);
    if (m_txtBack != null) {
      m_txtBack.setBounds(this.getWidth() - 150, 5, 145, 20);
      m_txtFront.setBounds(this.getWidth() - 150, 27, 145, 20);
      m_txtArea.setBounds(this.getWidth() - 150, 49, 145, 20);
      m_plusGain.setBounds(this.getWidth() - 55, 72, 50, 24);
      m_minusGain.setBounds(this.getWidth() - 55, 97, 50, 24);
    }
  }

  public void destroy3dGraphicsManager()
  {
    if (this.m_bufferGraphics!=null)
      this.m_bufferGraphics.dispose();
    this.m_bufferGraphics = null;
    if (this.m_bufferImage!=null){
      this.m_bufferImage.getGraphics().dispose();
      this.m_bufferImage.flush();
    }  
    this.m_bufferImage = null;
    if (this.m_minusGain!=null&&this.m_minusGain.getGraphics()!=null){
      this.m_minusGain.getGraphics().dispose();
    }
    this.m_minusGain = null;
    if (this.m_plusGain!=null&&this.m_plusGain.getGraphics()!=null){
      this.m_plusGain.getGraphics().dispose();
    }  
    this.m_plusGain = null;
    if (this.m_txtArea!=null&&this.m_txtArea.getGraphics()!=null)
      this.m_txtArea.getGraphics().dispose();
    this.m_txtArea = null;
    if (this.m_txtBack!=null&&this.m_txtBack.getGraphics()!=null)
      this.m_txtBack.getGraphics().dispose();
    this.m_txtBack = null;
    if (this.m_txtFront!=null&&this.m_txtFront.getGraphics()!=null)
      this.m_txtFront.getGraphics().dispose();
    this.m_txtFront = null;
    if (this.m_viewer!=null)
      this.m_viewer.getGraphics().dispose();
    this.m_viewer = null;
//    try {
//      this.finalize();
//    }
//    catch (Throwable e) {
      // TODO Auto-generated catch block
//      e.printStackTrace();
//    }
  }

}
