package at.tugraz.genome.maspectras;

import java.util.Vector;

import at.tugraz.genome.utils.UtilsConstants;
import at.tugraz.genome.utils.upload.vos.ParserClassVO;

/**
 * Global constants used by the application.
 * @author Juergen Hartler
 */
public class GlobalConstants extends GlobalConstantsGenerated
{
  public static final String VERSION = "2.4_SNAPSHOT";
  
  /**
   * @return the URL to the JClusterService
   */
  public static String getClusterURL()
  {
    return UtilsConstants.getClusterURL();
  }
  /**
   * @return the username for the cluster user
   */
  public static String getClusterUsername()
  {
    return UtilsConstants.getClusterUsername();
  }
  /**
   * @return password for the MASPECTRAS user on the cluster
   */
  public static String getClusterPassword()
  {
    return UtilsConstants.getClusterPassword();
  }
  /**
   * @return the update intervall for asking the cluster if it is finished
   */
  public static int getClusterUpdateIntervall()
  {
    return UtilsConstants.getClusterUpdateIntervall();
  }
  /**
   * @return whole URL needed for SSH connection
   */
  public static String getClusterURLPlusUser()
  {
    return UtilsConstants.getClusterURLPlusUser();
  }
  /**
   * @return the threshold to send a quantification to the cluster
   */
  public static int getThresholdForClusterQuantification()
  {
    return UtilsConstants.getThresholdForClusterQuantification();
  }
  
  /**
   * @return if the cemm specific implementation is needed.
   */
  public static boolean forCemm()
  {
    return UtilsConstants.cemmImplementation();
  }

  /**
   * @return if the translation to the chromatogram file should take place
   */
  public static boolean translateChromatograms()
  {
    return UtilsConstants.translateChromatograms();
  }

  /**
   * @return the threshold use a cache for the quantification
   */
  public static int getMaxChromSizeForCacheInMB()
  {
    return UtilsConstants.getMaxChromSizeForCacheInMB();
  }
  
  /**
   * @return he file pieces for the file translation to the chrom file
   */
  public static int getmMaxFileSizeForChromTranslationAtOnceInMB()
  {
    return UtilsConstants.getmMaxFileSizeForChromTranslationAtOnceInMB();
  }

  public static int getExternalDatabaseInformationRefreshHour()
  {
    return UtilsConstants.getExternalDatabaseInformationRefreshHour();
  }
  public static int getExternalDatabaseInformationRefreshDay()
  {
    return UtilsConstants.getExternalDatabaseInformationRefreshDay();
  }
  
  public static int getExternalDatabaseInformationRefreshMonth()
  {
    return UtilsConstants.getExternalDatabaseInformationRefreshMonth();
  }
  
  public static Class getSequenceInformationParserInstance(String parserClass) throws ClassNotFoundException{
    return UtilsConstants.getSequenceInformationParserInstance(parserClass);
  }
  
  public static Vector<ParserClassVO> getExternalDatabaseParsers(){
    return UtilsConstants.getExternalDatabaseParsers();
  }
  
  public static boolean getMsExpPeaklistUploadCheck(){
    return UtilsConstants.getMsExpPeaklistUploadCheck();
  }
  
  public static boolean isPhenyxKeepSearchProteinseqs()
  {
    return UtilsConstants.isPhenyxKeepSearchProteinseqs();
  }
  
  /*
   * public static int getAmountOfPeptidesPerNode(int totalNumberOfPeptides){
   * int amount = 50; if
   * (UtilsConstants.getAmountOfPeptidesPerNode().equalsIgnoreCase("dynamic")){
   * amount = totalNumberOfPeptides/UtilsConstants.getNumberOfProcessors();
   * }else{ amount =
   * Integer.parseInt(UtilsConstants.getAmountOfPeptidesPerNode()); } return
   * amount; }
   */

  /**
   * the amount of processors used for quantification
   */
  public static int getNumberOfProcessors()
  {
    return UtilsConstants.getNumberOfProcessors();
  }

  public static final String QUERY_FIELD_COMPLEX_QUERY = "complexQueryField";
  
  public static final String QUERY_FIELD_EXT_QUERY = "extQueryField";

  public static final String SAMPLE_FIELD_EXPERIMENT_FK = "sampleExperimentFK";

  public static final String SAMPLE_FIELD_EXPERIMENT_TITLE = "Experiment Title";

  public static final String PROTEIN_FIELD_DBSEARCHPARAMETERS_ID = "proteinDBSearchParametersFK";

  public static final String PEAKLIST_LIST_TYPE_MSMS = "MSMS Result";

  public static final String MASCOT_INDEX_PARAMETERS = "parameters";

  public static final String MASCOT_INDEX_HEADERS = "header";

  public static final String MASCOT_INDEX_MASSES = "masses";

  public static final String MASCOT_INDEX_SUMMARY = "summary";
  
  public static final String MASCOT_INDEX_SUMMARY_ERROR_TOLERANT = "et_summary";

  public static final String MASCOT_INDEX_SUMMARY_DECOY = "decoy_summary";
  
  public static final String MASCOT_INDEX_MIXTURE = "mixture";

  public static final String MASCOT_INDEX_PEPTIDES = "peptides";
  
  public static final String MASCOT_INDEX_PEPTIDES_ERROR_TOLERANT = "et_peptides";
  
  public static final String MASCOT_INDEX_PEPTIDES_DECOY = "decoy_peptides";

  public static final String MASCOT_INDEX_PROTEINS = "proteins";

  public static final String MASCOT_INDEX_QUERY = "query";
  
  public static final String MASCOT_INDEX_UNIMOD = "unimod";
  
  public static final String MASCOT_INDEX_ENZYME = "enzyme";

  public static final String MASCOT_INDEX_INDEX = "index";
  
  public static final String MASCOT_INDEX_TAXONOMY = "taxonomy";

  public static final String MASCOT_INDEX_QUANTITATION = "quantitation";
  
  public static final String MASCOT_INDEX_DECOY_SUMMARY = "decoy_summary";
  
  public static final String MASCOT_INDEX_DECOY_PEPTIDES = "decoy_peptides";
  
  public static final String MASCOT_PARAMETER_DB = "DB";

  public static final String MASCOT_PARAMETER_RELEASE = "release";

  public static final String MASCOT_PARAMETER_PARAM_FILE = "COM";

  public static final String MASCOT_PARAMETER_RAW_FILE = "FILE";

  public static final String MASCOT_PARAMETER_TAXONOMY = "TAXONOMY";

  public static final String MASCOT_PARAMETER_INSTRUMENT = "INSTRUMENT";

  public static final String MASCOT_PARAMETER_FIXED_MOD = "MODS";

  public static final String MASCOT_PARAMETER_VAR_MOD = "IT_MODS";

  public static final String MASCOT_PARAMETER_MAX_MISSED_CLEAVAGES = "PFA";

  public static final String MASCOT_PARAMETER_MASS_VALUE_TYPE = "MASS";

  public static final String MASCOT_PARAMETER_FRAGM_ION_TOL = "ITOL";

  public static final String MASCOT_PARAMETER_PEP_MASS_TOL = "TOL";

  public static final String MASCOT_PARAMETER_ICAT_OPTION = "ICAT";

  public static final String MASCOT_PARAMETER_QUERIES = "queries";

  public static final String MASCOT_PARAMETER_C_TERM = "C_term";

  public static final String MASCOT_PARAMETER_N_TERM = "N_term";

  public static final String MASCOT_QUERY_TITLE = "title";

  public static final String MASCOT_QUERY_CHARGE = "charge";

  public static final String MASCOT_QUERY_NUM_VALS = "num_vals";

  public static final String MASCOT_QUERY_IONS = "Ions1";
  
  public static final String MASCOT_RETENTION_TIME = "rtinseconds";

  public static final String MASCOT_NUMBER_OF_HITS = "num_hits";

  public static final String MASCOT_SUMMARY_MASS = "qmass";
  
  public static final String MASCOT_SUMMARY_PARENTIONINTENSITY = "qintensity";
  
  public static final String MASCOT_SUMMARY_EXP_MASS = "qexp";

  public static final String MASCOT_SUMMARY_MATCH = "qmatch";

  public static final String MASCOT_EMPTY_STRING = "-1";

  public static final int MASCOT_PEPTIDE_POSITION_MISSED_CLEAV = 1;

  public static final int MASCOT_PEPTIDE_POSITION_MASS = 2;

  public static final int MASCOT_PEPTIDE_POSITION_DELTA = 3;

  public static final int MASCOT_PEPTIDE_POSITION_NR_IONS_MATCHED = 4;

  public static final int MASCOT_PEPTIDE_POSITION_SEQUENCE = 5;

  public static final int MASCOT_PEPTIDE_POSITION_PEAKS_USED_FROM_IONS1 = 6;

  public static final int MASCOT_PEPTIDE_POSITION_VAR_MOD = 7;

  public static final int MASCOT_PEPTIDE_POSITION_SCORE = 8;

  // I do not know what's the purpos of the values at that position
  public static final int MASCOT_PEPTIDE_POSITION_ION_SER_FOUND = 9;

  public static final int MASCOT_PEPTIDE_POSITION_PEAKS_USED_FROM_IONS2 = 10;

  public static final int MASCOT_PEPTIDE_POSITION_PEAKS_USED_FROM_IONS3 = 11;

  // public static final int MASCOT_GI_POSITION_ACC_STRING = 1;

  public static final int MASCOT_GI_POSITION_FRAME_NUMBER = 1;

  public static final int MASCOT_GI_POSITION_START = 2;

  public static final int MASCOT_GI_POSITION_END = 3;

  public static final int MASCOT_GI_POSITION_MULTIPLICITY = 4;

  public static final String MASCOT_SCORE = "MOWSE"; 
  public static final String MASCOT_SCORE_IDENTITY = "IdentityScore";
  public static final String MASCOT_SCORE_EXPECT = "Expect";
  
  public static final String PROTEIN_PROPHET_SCORE = "Prot-Prophet"; 

  public static final String MASCOT_PARAMETER_ENZYME = "CLE";

  public static final String MASCOT_ENZYME_TRYPSIN = "Trypsin";

  public static final String MASCOT_ENZYME_CHYMOTRYPSIN = "Chymotrypsin";

  public static final String MASCOT_ENZYME_NO_ENZYME = "None";

  public static final String SPECTRUM_MILL_SCORE = "SpectrumMill";

  public static final String SEQUEST_PARAMETER_DATABASE_NAME = "database_name";

  public static final String SEQUEST_PARAMETER_DATABASE_NAME_FIRST = "first_database_name";
  
  public static final String SEQUEST_PARAMETER_DATABASE_NAME_PROTEIN = "protein_db_name";

  public static final String SEQUEST_PARAMETER_PEP_MASS_TOLERANCE = "peptide_mass_tolerance";

  public static final String SEQUEST_PARAMETER_FRAGM_ION_TOLERANCE = "fragment_ion_tolerance";

  public static final String SEQUEST_SCORE_XCORR = "XCorr";

  public static final String SEQUEST_PARAMETER_MAX_MISSED_CLEAV = "max_num_internal_cleavage_sites";

  public static final String SEQUEST_PARAMETER_MASS_VALUE_TYPE = "mass_type_parent";

  public static final String SEQUEST_MASS_VALUE_TYPE_MONO = "1";

  public static final String SEQUEST_MASS_VALUE_TYPE_AVG = "0";
  
  public static final String SEQUEST_SCORE_SF = "Sf";
  
  public static final String SEQUEST_SCORE_SP = "Sp";
  
  public static final String MASS_VALUE_TYPE_MONO = "Monoisotopic";

  public static final String MASS_VALUE_TYPE_AVG = "Average";

  public static final String MASS_VALUE_TYPE_N15 = "N15";

  public static final String MASS_VALUE_TYPE_EXACT = "Exact";

  public static final String SEQUEST_HEADER_ENZYME_INFO = "[SEQUEST_ENZYME_INFO]";

  public static final String SEQUEST_PARAMETER_ENZYME_INFO = "enzyme_info";

  public static final String SEQUEST_PARAMETER_FIXED_ENZYME_NUMBER = "enzyme_number";

  public static final String SEQUEST_PARAMETER_FIXED_C_TERM = "add_Cterm_peptide";

  public static final String SEQUEST_PARAMETER_FIXED_N_TERM = "add_Nterm_peptide";

  public static final String SEQUEST_PARAMETER_FIXED_G = "add_G_Glycine";

  public static final String SEQUEST_PARAMETER_FIXED_A = "add_A_Alanine";

  public static final String SEQUEST_PARAMETER_FIXED_S = "add_S_Serine";

  public static final String SEQUEST_PARAMETER_FIXED_P = "add_P_Proline";

  public static final String SEQUEST_PARAMETER_FIXED_V = "add_V_Valine";

  public static final String SEQUEST_PARAMETER_FIXED_T = "add_T_Threonine";

  public static final String SEQUEST_PARAMETER_FIXED_C = "add_C_Cysteine";

  public static final String SEQUEST_PARAMETER_FIXED_L = "add_L_Leucine";

  public static final String SEQUEST_PARAMETER_FIXED_I = "add_I_Isoleucine";

  public static final String SEQUEST_PARAMETER_FIXED_N = "add_N_Asparagine";

  public static final String SEQUEST_PARAMETER_FIXED_B = "add_B_avg_NandD";

  public static final String SEQUEST_PARAMETER_FIXED_D = "add_D_Aspartic_Acid";

  public static final String SEQUEST_PARAMETER_FIXED_Q = "add_Q_Glutamine";

  public static final String SEQUEST_PARAMETER_FIXED_K = "add_K_Lysine";

  public static final String SEQUEST_PARAMETER_FIXED_E = "add_E_Glutamic_Acid";

  public static final String SEQUEST_PARAMETER_FIXED_M = "add_M_Methionine";

  public static final String SEQUEST_PARAMETER_FIXED_H = "add_H_Histidine";

  public static final String SEQUEST_PARAMETER_FIXED_F = "add_F_Phenylalanine";

  public static final String SEQUEST_PARAMETER_FIXED_R = "add_R_Arginine";

  public static final String SEQUEST_PARAMETER_FIXED_Y = "add_Y_Tyrosine";

  public static final String SEQUEST_PARAMETER_FIXED_W = "add_W_Tryptophan";

  public static final String SEQUEST_PARAMETER_FIXED_O = "add_O_Ornithine";

  public static final String SEQUEST_PARAMETER_FIXED_X = "add_X_LorI";

  public static final String SEQUEST_PARAMETER_FIXED_Z = "add_Z_avg_QandE";

  public static final String SEQUEST_PARAMETER_MASS = "(M+H)+ mass";

  public static final String SEQUEST_SCORE = "SEQUEST";
  public static final String PEPARML_SCORE_PRED = "pred";
  public static final String PEPARML_SCORE_ESTFDR = "estfdr";

  public static final String SEQUEST_ENZYME_TRYPSIN = "Trypsin";

  public static final String SEQUEST_ENZYME_GlUC = "GluC";

  public static final String SEQUEST_ENZYME_CHYMOTRYPSIN = "Chymotrypsin";

  public static final String SEQUEST_ENZYME_ELASTASE = "Elastase";

  public static final String SEQUEST_ENZYME_NO_ENZYME = "No_Enzyme";

  public static final String SPECTRUM_MILL_RESULTS_FILE = "tagSummary.1.tsv";

  public static final String SPECTRUM_MILL_DIR_SPECTRA = "cpick_in";

  public static final String SPECTRUM_MILL_PARAM_FILE = "mstag.1.params";

  public static final String SPECTRUM_MILL_MASS_VALUE_TYPE_MONO = "monoisotopic";

  public static final String SPECTRUM_MILL_MASS_VALUE_TYPE_AVERAGE = "average";

  public static final String SPECTRUM_MILL_PARAMETER_DATABASE_NAME = "database";

  public static final String SPECTRUM_MILL_PARAMETER_TAXONOMY = "species";

  public static final String SPECTRUM_MILL_PARAMETER_MASS_VALUE_TYPE = "parent_mass_convert";

  public static final String SPECTRUM_MILL_PARAMETER_MAX_MISSED_CLEAV = "missed_cleavages";

  public static final String SPECTRUM_MILL_PARAMETER_PEP_MASS_TOLERANCE = "parent_mass_tolerance";

  public static final String SPECTRUM_MILL_PARAMETER_FRAGM_ION_TOLERANCE = "fragment_mass_tolerance";

  public static final String SPECTRUM_MILL_PARAMETER_FIXED_MODIFICATION = "fixedMods";

  public static final String SPECTRUM_MILL_PARAMETER_VARIABLE_MODIFICATION = "varMods";

  public static final String SPECTRUM_MILL_PARAMETER_FILENAME = "filename";

  public static final String SPECTRUM_MILL_PARAMETER_SCORE = "score";

  public static final String SPECTRUM_MILL_PARAMETER_PERCENT_SCORED_PEAK_INTENSITY = "percent_scored_peak_intensity";

  public static final String SPECTRUM_MILL_PARAMETER_BACKBONE_CLEAVAGE_SCORE = "backbone_cleavage_score";

  public static final String SPECTRUM_MILL_PARAMETER_NUM_UNUSED_IONS = "num_unused_ions";

  public static final String SPECTRUM_MILL_PARAMETER_NUM_FRAGMENT_IONS = "num_fragment_ions";

  public static final String SPECTRUM_MILL_PARAMETER_MODIFICATION = "modification";

  public static final String SPECTRUM_MILL_PARAMETER_PREVIOUS_AA = "previous_aa";

  public static final String SPECTRUM_MILL_PARAMETER_SEQUENCE = "sequence";

  public static final String SPECTRUM_MILL_PARAMETER_NEXT_AA = "next_aa";

  public static final String SPECTRUM_MILL_PARAMETER_PARENT_M_OVER_Z = "parent_m_over_z";

  public static final String SPECTRUM_MILL_PARAMETER_PARENT_CHARGE = "parent_charge";

  public static final String SPECTRUM_MILL_PARAMETER_MATCHED_PARENT_MASS = "matched_parent_mass";

  public static final String SPECTRUM_MILL_PARAMETER_DELTA_PARENT_MASS = "delta_parent_mass";

  public static final String SPECTRUM_MILL_PARAMETER_PROTEIN_MW = "protein_mw";

  public static final String SPECTRUM_MILL_PARAMETER_PROTEIN_PI = "protein_pI";

  public static final String SPECTRUM_MILL_PARAMETER_SPECIES = "species";

  public static final String SPECTRUM_MILL_PARAMETER_ACCESSION_NUMBER = "accession_number";

  public static final String SPECTRUM_MILL_PARAMETER_INDEX_NUMBER = "index_number";

  public static final String SPECTRUM_MILL_PARAMETER_COVERAGE_MAP = "coverage_map";

  public static final String SPECTRUM_MILL_PARAMETER_DATABASE = "database";

  public static final String SPECTRUM_MILL_PARAMETER_ENZYME = "enzyme";

  public static final String SPECTRUM_MILL_PARAMETER_MISSED_CLEAVAGES = "missed_cleavages";

  public static final String SPECTRUM_MILL_PARAMETER_PARENT_MASS_CONVERT = "parent_mass_convert";

  public static final String SPECTRUM_MILL_PARAMETER_CYS = "cys";

  public static final String SPECTRUM_MILL_PARAMETER_NTERM = "nterm";

  public static final String SPECTRUM_MILL_PARAMETER_CTERM = "cterm";

  public static final String SPECTRUM_MILL_PARAMETER_TOLERANCE_UNITS = "tolerance_units";

  public static final String SPECTRUM_MILL_PARAMETER_PARENT_MASS_TOLERANCE = "parent_mass_tolerance";

  public static final String SPECTRUM_MILL_PARAMETER_FRAGMENT_MASS_TOLERANCE = "fragment_mass_tolerance";

  public static final String SPECTRUM_MILL_PARAMETER_INSTRUMENT_NAME = "instrument_name";

  public static final String SPECTRUM_MILL_PARAMETER_SEARCH_TYPE = "search_type";

  public static final String SPECTRUM_MILL_PARAMETER_MUTATION_MATRIX_OFF = "mutation_matrix_off";

  public static final String SPECTRUM_MILL_PARAMETER_STAR_IONS_OFF = "star_ions_off";

  public static final String SPECTRUM_MILL_PARAMETER_PARENT_SHIFT_TYPE = "parent_shift_type";

  public static final String SPECTRUM_MILL_PARAMETER_PARENT_SHIFT = "parent_shift";

  public static final String SPECTRUM_MILL_PARAMETER_ENTRY_NAME = "entry_name";

  public static final String SPECTRUM_MILL_PARAMETER_N_TERM = "N-term";

  public static final String SPECTRUM_MILL_PARAMETER_C_TERM = "C-term";

  public static final String SPECTRUM_MILL_PARAMETER_AA_A = "ala";

  public static final String SPECTRUM_MILL_PARAMETER_AA_C = "cys";

  public static final String SPECTRUM_MILL_PARAMETER_FIXED_MODS = "fixedMods";

  public static final Long SPECTRUM_MILL_VAR_VALUES_AVERAGE = new Long(2);

  public static final Long SPECTRUM_MILL_VAR_VALUES_MONO = new Long(3);

  public static final String SPECTRUM_MILL_MODIFICATION_CARBAMIDO_C = "carbamidomethylation";

  public static final String SPECTRUM_MILL_MODIFICATION_UNMODIFIED_C = "unmodified";

  public static final String SPECTRUM_MILL_MODIFICATION_OXIDIZED_LINEAR_C = "oxidized_linear";

  public static final String SPECTRUM_MILL_MODIFICATION_ACRYLAMIDE_C = "acrylamide";

  public static final String SPECTRUM_MILL_MODIFICATION_CARBOXYMETHYLATION_C = "carboxymethylation";

  public static final String SPECTRUM_MILL_MODIFICATION_PYRDYLETHYLATION_C = "pyridylethylation";

  public static final String SPECTRUM_MILL_MODIFICATION_DTT_C = "dtt";

  public static final String SPECTRUM_MILL_BIOTIN_HPDP_C = "biotin-hpdp";

  public static final String SPECTRUM_MILL_ACETYL_PEO_BIOTIN_C = "acetyl-peo-biotin";

  public static final String SPECTRUM_MILL_N_ETHYL_ACETAMIDE_D0_C = "n-ethyl-acetamide-d0";

  public static final String SPECTRUM_MILL_N_ETHYL_ACETAMIDE_D5_C = "n-ethyl-acetamide-d5";

  public static final String SPECTRUM_MILL_ICAT_D0_C = "icat-d0";

  public static final String SPECTRUM_MILL_ICAT_D8_C = "icat-d8";

  public static final String SPECTRUM_MILL_CICAT_C12_C = "cicat-c12";

  public static final String SPECTRUM_MILL_CICAT_C13_C = "cicat-c13";

  public static final String SPECTRUM_MILL_SULFOXIDE_C = "sulfoxide";

  public static final Double SPECTRUM_MILL_MODIFICATION_CARBAMIDO_C_MONO_VALUE = new Double(
      160.030649);

  public static final Double SPECTRUM_MILL_MODIFICATION_UNMODIFIED_C_MONO_VALUE = new Double(
      103.00919);

  public static final Double SPECTRUM_MILL_MODIFICATION_OXIDIZED_LINEAR_C_MONO_VALUE = new Double(
      102.00136);

  public static final Double SPECTRUM_MILL_MODIFICATION_ACRYLAMIDE_C_MONO_VALUE = new Double(
      174.0463);

  public static final Double SPECTRUM_MILL_MODIFICATION_CARBOXYMETHYLATION_C_MONO_VALUE = new Double(
      161.01467);

  public static final Double SPECTRUM_MILL_MODIFICATION_PYRDYLETHYLATION_C_MONO_VALUE = new Double(
      208.06704);

  public static final Double SPECTRUM_MILL_MODIFICATION_DTT_C_MONO_VALUE = new Double(
      236.99519);

  public static final Double SPECTRUM_MILL_MODIFICATION_BIOTIN_HPDP_C_MONO_VALUE = new Double(
      531.20077);

  public static final Double SPECTRUM_MILL_MODIFICATION_ACETYL_PEO_BIOTIN_C_MONO_VALUE = new Double(
      517.20288);

  public static final Double SPECTRUM_MILL_MODIFICATION_N_ETHYL_ACETAMIDE_D0_C_MONO_VALUE = new Double(
      188.06195);

  public static final Double SPECTRUM_MILL_MODIFICATION_N_ETHYL_ACETAMIDE_D5_C_MONO_VALUE = new Double(
      193.09333);

  public static final Double SPECTRUM_MILL_MODIFICATION_ICAT_D0_C_MONO_VALUE = new Double(
      545.23418);

  public static final Double SPECTRUM_MILL_MODIFICATION_ICAT_D8_C_MONO_VALUE = new Double(
      553.28439);

  public static final Double SPECTRUM_MILL_MODIFICATION_CICAT_C12_C_MONO_VALUE = new Double(
      330.13618);

  public static final Double SPECTRUM_MILL_MODIFICATION_CICAT_C13_C_MONO_VALUE = new Double(
      339.16637);

  public static final Double SPECTRUM_MILL_MODIFICATION_SULFOXIDE_C_MONO_VALUE = new Double(
      119.0041);

  public static final Double SPECTRUM_MILL_MODIFICATION_CARBAMIDO_C_AVG_VALUE = new Double(
      160.1942);

  public static final Double SPECTRUM_MILL_MODIFICATION_UNMODIFIED_C_AVG_VALUE = new Double(
      103.1388);

  public static final Double SPECTRUM_MILL_MODIFICATION_OXIDIZED_LINEAR_C_AVG_VALUE = new Double(
      102.13086);

  public static final Double SPECTRUM_MILL_MODIFICATION_ACRYLAMIDE_C_AVG_VALUE = new Double(
      174.2167);

  public static final Double SPECTRUM_MILL_MODIFICATION_CARBOXYMETHYLATION_C_AVG_VALUE = new Double(
      161.1749);

  public static final Double SPECTRUM_MILL_MODIFICATION_PYRDYLETHYLATION_C_AVG_VALUE = new Double(
      208.276);

  public static final Double SPECTRUM_MILL_MODIFICATION_DTT_C_AVG_VALUE = new Double(
      237.2248); // // Here I did not find the average mass shift (estimated)

  public static final Double SPECTRUM_MILL_MODIFICATION_BIOTIN_HPDP_C_AVG_VALUE = new Double(
      531.7512);

  public static final Double SPECTRUM_MILL_MODIFICATION_ACETYL_PEO_BIOTIN_C_AVG_VALUE = new Double(
      517.6584);

  public static final Double SPECTRUM_MILL_MODIFICATION_N_ETHYL_ACETAMIDE_D0_C_AVG_VALUE = new Double(
      188.2433);

  public static final Double SPECTRUM_MILL_MODIFICATION_N_ETHYL_ACETAMIDE_D5_C_AVG_VALUE = new Double(
      193.2741);

  public static final Double SPECTRUM_MILL_MODIFICATION_ICAT_D0_C_AVG_VALUE = new Double(
      545.7116);

  public static final Double SPECTRUM_MILL_MODIFICATION_ICAT_D8_C_AVG_VALUE = new Double(
      553.7609);

  public static final Double SPECTRUM_MILL_MODIFICATION_CICAT_C12_C_AVG_VALUE = new Double(
      330.3991);

  public static final Double SPECTRUM_MILL_MODIFICATION_CICAT_C13_C_AVG_VALUE = new Double(
      339.333);

  public static final Double SPECTRUM_MILL_MODIFICATION_SULFOXIDE_C_AVG_VALUE = new Double(
      119.1384);

  public static final String SM_CONFIG_XML_ROOT_ELEMENT = "configurations";

  public static final String SM_CONFIG_XML_CONF_ELEMENT = "config";

  public static final String SM_CONFIG_XML_ELEMENTS = "elements";

  public static final String SM_CONFIG_XML_ELEMENT = "element";

  public static final String SM_CONFIG_XML_ELEMENT_ATTR_SYMBOL = "symbol";

  public static final String SM_CONFIG_XML_ELEMENT_ISOTOPE = "isotope";

  public static final String SM_CONFIG_XML_ELEMENT_ISOTOPE_ATTR_MASS = "mass";

  public static final String SM_CONFIG_XML_ELEMENT_ISOTOPE_ATTR_ABUNDANCE = "abund";

  public static final String SM_CONFIG_XML_AAS = "aminoAcids";

  public static final String SM_CONFIG_XML_AA = "aa";

  public static final String SM_CONFIG_XML_AA_ATTR_SYMBOL = "symbol";

  public static final String SM_CONFIG_XML_AA_ATTR_FORMULA = "formula";

  public static final String SM_CONFIG_XML_MODIFICATIONS = "modifications";

  public static final String SM_CONFIG_XML_MODIFICATION = "mod";

  public static final String SM_CONFIG_XML_MODIFICATION_ATTR_ID = "id";

  public static final String SM_CONFIG_XML_MODIFICATION_ATTR_NAME = "name";

  public static final String SM_CONFIG_XML_MODIFICATION_ATTR_TYPE = "type";

  public static final String SM_CONFIG_XML_MODIFICATION_ATTR_FORMULA = "formula";

  public static final String SM_CONFIG_XML_MODIFICATION_TYPE_VALUE_VARIABLE = "variable";

  public static final String SM_CONFIG_XML_MODIFICATION_TYPE_VALUE_CYCLIC = "cyclic";

  public static final String SM_CONFIG_XML_MODIFICATION_SITE = "site";

  public static final String SM_CONFIG_XML_MODIFICATION_SITE_ATTR_AA = "aa";

  public static final String SM_CONFIG_XML_MODIFICATION_SITE_ATTR_TERM = "term";

  public static final String SM_CONFIG_XML_MODIFICATION_SITE_TERM_VALUE_N_TERM = "n";

  public static final String SM_CONFIG_XML_MODIFICATION_SITE_TERM_VALUE_C_TERM = "c";

  public static final String SM_CONFIG_XML_MODIFICATION_CYCLES = "cycles";

  public static final String SM_CONFIG_XML_MODIFICATION_CYCLE = "cycle";

  public static final String SM_CONFIG_XML_MODIFICATION_CYCLEMOD = "cyclemod";

  public static final String SM_CONFIG_XML_MODIFICATION_CYCLEMOD_ATTR_MOD = "mod";

  public static final String XTANDEM_SCORE_TANDEM_EXPECT = "X!Tandem expect";

  public static final String XTANDEM_SCORE_HYPER = "X!Tandem Hyperscore";

  public static final String XTANDEM_XML_BIOML = "bioml";

  public static final String XTANDEM_XML_ATT_LABEL = "label";

  public static final String XTANDEM_XML_VALUE_DESCRIPTION = "description";

  public static final String XTANDEM_XML_LABEL_PARAMETERS_INPUT = "input parameters";

  public static final String XTANDEM_XML_LABEL_PARAMETERS_PERFORMANCE = "performance parameters";

  public static final String XTANDEM_XML_NOTE = "note";

  public static final String XTANDEM_XML_GROUP = "group";

  public static final String XTANDEM_XML_GROUP_ATT_ID = "id";

  public static final String XTANDEM_XML_GROUP_ATT_TYPE = "type";

  public static final String XTANDEM_XML_GROUP_TYPE_PROTEIN_ENTRY = "model";

  public static final String XTANDEM_XML_GROUP_TYPE_PARAMETERS = "parameters";

  public static final String XTANDEM_XML_GROUP_ATTR_MPLUSH = "mh";

  public static final String XTANDEM_XML_GROUP_ATTR_CHARGE = "z";

  public static final String XTANDEM_XML_PROTEIN = "protein";

  public static final String XTANDEM_XML_PROTEIN_ATT_EXPECT_SCORE = "expect";

  public static final String XTANDEM_XML_PROTEIN_ATT_UID = "uid";

  public static final String XTANDEM_XML_PROTEIN_ATT_SUM_I = "sumI";

  public static final String XTANDEM_XML_PEPTIDE = "peptide";

  public static final String XTANDEM_XML_INPUT_C_TERM = "protein, C-terminal residue modification mass";

  public static final String XTANDEM_XML_INPUT_N_TERM = "protein, N-terminal residue modification mass";

  public static final String XTANDEM_XML_INPUT_CLEAVAGE_SITE_RULE = "protein, cleavage site";

  public static final String XTANDEM_XML_INPUT_TAXONOMY = "protein, taxon";

  public static final String XTANDEM_XML_INPUT_MODIFICATION = "residue, modification mass";

  public static final String XTANDEM_XML_INPUT_POTENTIAL_MODIFICATION = "residue, potential modification mass";

  public static final String XTANDEM_XML_INPUT_MISSED_CLEAVAGES = "scoring, maximum missed cleavage sites";

  public static final String XTANDEM_XML_MASS_VALUE_TYPE = "spectrum, fragment mass type";

  public static final String XTANDEM_XML_FRAGMENT_ION_TOLERANCE = "spectrum, fragment monoisotopic mass error";

  public static final String XTANDEM_XML_PARENT_MASS_ERROR_MINUS = "spectrum, parent monoisotopic mass error minus";

  public static final String XTANDEM_XML_PARENT_MASS_ERROR_PLUS = "spectrum, parent monoisotopic mass error plus";

  public static final String XTANDEM_XML_PARENT_MASS_ERROR_TYPE = "spectrum, parent monoisotopic mass error units";

  public static final String XTANDEM_XML_DATABASE = "list path, sequence source #1";

  public static final String XTANDEM_XML_DOMAIN = "domain";

  public static final String XTANDEM_XML_DOMAIN_ATT_START = "start";

  public static final String XTANDEM_XML_DOMAIN_ATT_STOP = "end";

  public static final String XTANDEM_XML_DOMAIN_ATT_EXPECT_SCORE = "expect";

  public static final String XTANDEM_XML_DOMAIN_ATT_MASS = "mh";

  public static final String XTANDEM_XML_DOMAIN_ATT_DELTA = "delta";

  public static final String XTANDEM_XML_DOMAIN_ATT_HYPER_SCORE = "hyperscore";

  public static final String XTANDEM_XML_DOMAIN_ATT_IONS = "_ions";

  public static final String XTANDEM_XML_DOMAIN_ATT_SEQUENCE = "seq";

  public static final String XTANDEM_XML_DOMAIN_ATT_MISSED_CLEAVAGES = "missed_cleavages";

  public static final String XTANDEM_XML_AA = "aa";

  public static final String XTANDEM_XML_AA_ATT_TYPE = "type";

  public static final String XTANDEM_XML_AA_ATT_POSITION = "at";

  public static final String XTANDEM_XML_AA_ATT_MOD_VALUE = "modified";

  public static final String XTANDEM_XML_TYPE_VALUE_SUPPORT = "support";

  public static final String XTANDEM_XML_LABEL_VALUE_FRAGMENT_SPECTRUM = "fragment ion mass spectrum";

  public static final String XTANDEM_XML_SPECTRUM_X_VALUES = "Xdata";

  public static final String XTANDEM_XML_SPECTRUM_Y_VALUES = "Ydata";

  public static final String XTANDEM_XML_SPECTRUM_VALUES = "values";

  public static final String XTANDEM_MASS_VALUE_TYPE_MONO = "monoisotopic";

  public static final String XTANDEM_MASS_VALUE_TYPE_AVERAGE = "average";

  public static final String OMSSA_SCORE = "Omssa_Score";

  public static final String OMSSA_XML_MODIFICATION_ROOT_ELEMENT = "MSModSpecSet";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_ELEMENT = "MSModSpec";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_MODIFICATION = "MSModSpec_mod";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_MS_MOD = "MSMod";

  public static final String OMSSA_XML_MODIFICATION_ATTR_VALUE = "value";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_MODIFICATION_TYPE = "MSModSpec_type";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_MS_MOD_TYPE = "MSModType";

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_AA = "modaa";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_AA_INT = 0;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_N_TERM = "modn";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_N_TERM_INT = 1;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_N_TERM_PART_AAS = "modnaa";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_N_TERM_PART_AAS_INT = 2;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_C_TERM = "modc";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_C_TERM_INT = 3;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_C_TERM_PART_AAS = "modcaa";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PROTEIN_C_TERM_PART_AAS_INT = 4;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_N_TERM = "modnp";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_N_TERM_INT = 5;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_N_TERM_PART_AAS = "modnpaa";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_N_TERM_PART_AAS_INT = 6;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_C_TERM = "modcp";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_C_TERM_INT = 7;

  public static final String OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_C_TERM_PART_AAS = "modcpaa";

  public static final int OMSSA_XML_MODIFICATION_TYPE_MODIFIED_PEPTIDE_C_TERM_PART_AAS_INT = 8;

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_MODIFICATION_NAME = "MSModSpec_name";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_MONOMASS_VALUE = "MSModSpec_monomass";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_AVERAGEMASS_VALUE = "MSModSpec_averagemass";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_N15MASS_VALUE = "MSModSpec_n15mass";

  public static final String OMSSA_XML_MODIFICATION_SPECIFICATION_POSSIBLE_AAS = "MSModSpec_residues";

  public static final String OMSSA_XML_MODIFICATION_POSSIBLE_AAS_MODIFICATION = "MSModSpec_residues_E";

  public static final String OMSSA_XML_ROOT_ELEMENT = "MSSearch";

  public static final String OMSSA_XML_MSSEARCH_REQUEST = "MSSearch_request";

  public static final String OMSSA_XML_MS_REQUEST = "MSRequest";

  public static final String OMSSA_XML_MS_REQUEST_SPECTRA = "MSRequest_spectra";

  public static final String OMSSA_XML_MS_REQUEST_SPECTRUM_SET = "MSSpectrumset";

  public static final String OMSSA_XML_MS_REQUEST_SPECTRUM = "MSSpectrum";

  public static final String OMSSA_XML_MS_SPECTRUM_NUMBER = "MSSpectrum_number";

  public static final String OMSSA_XML_MS_SPECTRUM_CHARGE = "MSSpectrum_charge";

  public static final String OMSSA_XML_MS_SPECTRUM_CHARGE_VALUE = "MSSpectrum_charge_E";

  public static final String OMSSA_XML_MS_SPECTRUM_IDS = "MSSpectrum_ids";

  public static final String OMSSA_XML_MS_SPECTRUM_IDS_VALUE = "MSSpectrum_ids_E";

  public static final String OMSSA_XML_MS_SPECTRUM_PRECURSOR_MZ = "MSSpectrum_precursormz";

  public static final String OMSSA_XML_MS_SPECTRUM_MZ_VALUES = "MSSpectrum_mz";

  public static final String OMSSA_XML_MS_SPECTRUM_MZ_VALUE = "MSSpectrum_mz_E";

  public static final String OMSSA_XML_MS_SPECTRUM_MZ_INTENSITIES = "MSSpectrum_abundance";

  public static final String OMSSA_XML_MS_SPECTRUM_MZ_INTENSITY = "MSSpectrum_abundance_E";

  public static final String OMSSA_XML_MS_SPECTRUM_MZ_INTENSITY_SCALE = "MSSpectrum_iscale";

  public static final String OMSSA_XML_MS_REQUEST_SETTINGS = "MSRequest_settings";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS = "MSSearchSettings";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_PRECURSORSEARCHTYPE = "MSSearchSettings_precursorsearchtype";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_PRODUCTIONSEARCHTYPE = "MSSearchSettings_productsearchtype";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_MSSEARCHTYPE = "MSSearchType";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_MSMODIFICATION = "MSMod";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_PEPTIDE_TOLERANCE = "MSSearchSettings_peptol";
  
  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_MZ_SCALE = "MSSearchSettings_scale";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_FRAGMENTION_TOLERANCE = "MSSearchSettings_msmstol";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_FIXED_MODIFICATIONS = "MSSearchSettings_fixed";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_VARIABLE_MODIFICATIONS = "MSSearchSettings_variable";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_ENZYME = "MSSearchSettings_enzyme";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_MSENZYMES = "MSEnzymes";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_MISSED_CLEAVAGES = "MSSearchSettings_missedcleave";

  public static final String OMSSA_XML_MS_SEARCH_SETTINGS_DATABASE = "MSSearchSettings_db";

  public static final String OMSSA_XML_MSSEARCH_RESPONSE = "MSSearch_response";

  public static final String OMSSA_XML_MS_RESPONSE = "MSResponse";

  public static final String OMSSA_XML_MS_RESPONSE_PROTEINS = "MSResponse_bioseqs";

  public static final String OMSSA_XML_MS_RESPONSE_PROTEIN_SET = "MSBioseqSet";

  public static final String OMSSA_XML_MS_RESPONSE_PROTEIN = "MSBioseq";

  public static final String OMSSA_XML_MS_RESPONSE_PROTEIN_OID = "MSBioseq_oid";

  public static final String OMSSA_XML_MS_RESPONSE_PROTEIN_SEQUENCE = "MSBioseq_seq";

  public static final String OMSSA_XML_MS_RESPONSE_PROTEIN_BIO_SEQUENCE = "Bioseq";

  public static final String OMSSA_XML_MS_RESPONSE_BIOSEQUENCE_ID = "Bioseq_id";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID = "Seq-id";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_LOCAL = "Seq-id_local";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_GIBBSQ = "Seq-id_gibbsq";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_GIBBMT = "Seq-id_gibbmt";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_GIIM = "Seq-id_giim";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_GENBANK = "Seq-id_genbank";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_EMBL = "Seq-id_embl";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_PIR = "Seq-id_pir";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_SWISSPROT = "Seq-id_swissprot";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_PATENT = "Seq-id_patent";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_OTHER = "Seq-id_other";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_GENERAL = "Seq-id_general";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_GI = "Seq-id_gi";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_DDBJ = "Seq-id_ddbj";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_PRF = "Seq-id_prf";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_PDB = "Seq-id_pdb";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_TPG = "Seq-id_tpg";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_TPE = "Seq-id_tpe";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_TPD = "Seq-id_tpd";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_ID_GPIPE = "Seq-id_gpipe";

  public static final String OMSSA_XML_MS_RESPONSE_BIOSEQUENCE_DESCR = "Bioseq_descr";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_DESCR = "Seq-descr";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_DESCR_DETAIL = "Seqdesc";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_DESCR_TITLE = "Seqdesc_title";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_TEXTSEQU_ID = "Textseq-id";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_TEXTSEQU_ID_NAME = "Textseq-id_name";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_TEXTSEQU_ID_ACCESSION = "Textseq-id_accession";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_TEXTSEQU_ID_RELEASE = "Textseq-id_release";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_TEXTSEQU_ID_VERSION = "Textseq-id_version";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_PDB_ID = "PDB-seq-id";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_PDB_ID_MOL = "PDB-seq-id_mol";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_PDB_ID_MOL_ID = "PDB-mol-id";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_PDB_ID_CHAIN = "PDB-seq-id_chain";

  public static final String OMSSA_XML_MS_RESPONSE_SEQUENCE_PDB_ID_RELEASE = "PDB-seq-id_rel";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDES = "MSResponse_hitsets";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT = "MSHitSet";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_NUMBER = "MSHitSet_number";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_PEAKLIST_IDS = "MSHitSet_ids";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_PEAKLIST_ID = "MSHitSet_ids_E";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_HITS = "MSHitSet_hits";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_HIT = "MSHits";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_E_VALUE = "MSHits_evalue";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_P_VALUE = "MSHits_pvalue";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_CHARGE = "MSHits_charge";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_PROTHITS = "MSHits_pephits";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_PROTHIT = "MSPepHit";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_PROTHIT_OID = "MSPepHit_oid";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_IONS = "MSHits_mzhits";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_ION = "MSMZHit";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_SEQUENCE = "MSHits_pepstring";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_MASS = "MSHits_mass";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_MODIFICATIONS = "MSHits_mods";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_MODIFICATION = "MSModHit";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_MODIFICATION_POSITION = "MSModHit_site";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_MODIFICATION_TYPE = "MSModHit_modtype";

  public static final String OMSSA_XML_MS_RESPONSE_PEPTIDEHIT_THEORETICAL_MASS = "MSHits_theomass";

  public static final int OMSSA_XML_ENZYME_TRYPSIN = 0;

  public static final int OMSSA_XML_ENZYME_ARG_C = 1;

  public static final int OMSSA_XML_ENZYME_CNBR = 2;

  public static final int OMSSA_XML_ENZYME_CHYMOTRYPSIN = 3;

  public static final int OMSSA_XML_ENZYME_FORMIC_ACID = 4;

  public static final int OMSSA_XML_ENZYME_LYS_C = 5;

  public static final int OMSSA_XML_ENZYME_LYS_C_NO_P_RULE = 6;

  public static final int OMSSA_XML_ENZYME_PEPSIN_A = 7;

  public static final int OMSSA_XML_ENZYME_TRYPSIN_PLUS_CNBR = 8;

  public static final int OMSSA_XML_ENZYME_TRYPSIN_PLUS_CHYMOTRYPSIN = 9;

  public static final int OMSSA_XML_ENZYME_TRYPSIN_NO_P_RULE = 10;

  public static final int OMSSA_XML_ENZYME_WHOLE_PROTEIN = 11;

  public static final int OMSSA_XML_ENZYME_ASP_N = 12;

  public static final int OMSSA_XML_ENZYME_GLU_C = 13;

  public static final int OMSSA_XML_ENZYME_ASP_N_PLUS_GLU_C = 14;

  public static final int OMSSA_XML_ENZYME_TOP_DOWMN = 15;

  public static final int OMSSA_XML_ENZYME_SEMI_TRYPTIC = 16;

  public static final int OMSSA_XML_ENZYME_NO_ENZYME = 17;

  public static final int OMSSA_XML_ENZYME_CHYMOTRYPSIN_NO_P_RULE = 18;

  public static final int OMSSA_XML_ENZYME_ASP_N_DE = 19;

  public static final int OMSSA_XML_ENZYME_GLU_C_DE = 20;

  public static final int OMSSA_XML_MASS_VALUE_TYPE_MONO = 0;

  public static final int OMSSA_XML_MASS_VALUE_TYPE_AVG = 1;

  public static final int OMSSA_XML_MASS_VALUE_TYPE_N15 = 2;

  public static final int OMSSA_XML_MASS_VALUE_TYPE_EXACT = 3;

  public static final String OMSSA_SCORE_E_VALUE = "-10*log10(Omssa e-Value)";

  public static final String OMSSA_SCORE_P_VALUE = "Omssa p-Value";
  
  public static final String CEMM_PROTEIN_SCORE = "CeMMProtSumScore";

  // public static final String XTANDEM_XML_GROUP_ATTR_PROTEIN_LABEL = "expect";
  // public static final String SPECTRUM_MILL_PARAMETER_
  // public static final String SPECTRUM_MILL_PARAMETER_

  public static final String SPECTRUM_MILL_BACKBONE_CLEAVAGE_SCORE = "BackBoneClvScore";
  public static final String SPECTRUM_MILL_SCORED_PEAK_INTENSITY = "SPI";

  public static final String MASCOT_INDEX_DELIMTER = "Content-Type: application/x-Mascot; name=\"index\"";

  public static final String MASCOT_INDEX_BEGINNING = "Content-Type: application/x-Mascot; name=";
  
  public static final String MASCOT_GLOBAL_DELIMTER = "--gc0p4Jq0M2Yt08jU534c0p--";

  public static final String MASCOT_QUERY_DELIMITER = "--gc0p4Jq0M2Yt08jU534c0p";
  
  public static final String PHENYX_SCORE = "Phenyx-Z-Score";
  
  public static final String PHENYX_P_VALUE = "Phenyx p-Value";
  
  public static final String MASCOT_P_VALUE = "Mascot p-Value";
  
  public static final String PHENYX_NORMAL_SCORE = "Phenyx-Score";
  
  public static final String PHENYX_PROTEIN_SCORE = "Phenyx-Protein-Score";
  
  public static final String PHENYX_TAGNAME_IDENTIFICATION = "IdentificationResult";
  public static final String PHENYX_TAGNAME_IDENTIFICATION_LIST = "IdentificationList";
  public static final String PHENYX_TAG_SUBMISSION_PARAM = "SubmissionParam";
  public static final String PHENYX_TAG_OLAV_SUBMISSION_PARAM = "olavJobSubmission";
  public static final String PHENYX_TAG_SEARCH_SPACE = "searchSpace";
  public static final String PHENYX_TAG_DATABASES = "databases";
  public static final String PHENYX_TAG_DATABASE = "database";
  public static final String PHENYX_TAG_TAXONOMY = "taxoCriterion";
  
  public static final String PHENYX_ATTR_DATABASE_NAME = "db";
  public static final String PHENYX_ATTR_DATABASE_KEY = "instancekey";
  public static final String PHENYX_ATTR_DATABASE_RELEASE = "release";

  public static final String PHENYX_TAGNAME_ALGOS = "identificationAlgos";
  public static final String PHENYX_TAGNAME_ALGO = "oneIdentificationAlgo";
  public static final String PHENYX_TAGNAME_ALGO_PARAMETERS = "identificationAlgoParameters";
  public static final String PHENYX_TAGNAME_DBSEARCHPARAMETERS = "DbSearchParameters";
  public static final String PHENYX_TAGNAME_SEARCH_ROUND = "OneSearchRound";

  public static final String PHENYX_TAGNAME_DATABASERESULT = "DatabaseResults";
  public static final String PHENYX_TAGNAME_SAMPLEINFOS = "SampleInfos";
  public static final String PHENYX_TAGNAME_SAMPLEINFO = "oneSampleInfo";
  public static final String PHENYX_TAGNAME_COMPOUNDINFO = "compoundInfo";
  
  public static final String PHENYX_ATTR_COMPOUND_KEY = "key";
  public static final String PHENYX_ATTR_COMPOUND_SAMPLE_NR = "sampleNumber";
  public static final String PHENYX_ATTR_COMPOUND_COMPOUND_NR = "compoundNumber";
  
  public static final String PHENYX_COMPOUND_TAG_DESCRIPTION = "description";
  public static final String PHENYX_COMPOUND_TAG_PRECURSOR = "precursor";
  public static final String PHENYX_PRECURSOR_TAG_SCAN = "scan";
  public static final String PHENYX_PRECURSOR_ATTR_START = "start";
  public static final String PHENYX_PRECURSOR_ATTR_END = "end";
  public static final String PHENYX_PRECURSOR_TAG_MZ = "moz";
  public static final String PHENYX_PRECURSOR_TAG_INT = "intensity";
  public static final String PHENYX_PRECURSOR_TAG_CHARGE = "charges";
  public static final String PHENYX_PRECURSOR_TAG_RETTIME = "acquTime";
  
  public static final String PHENYX_TAGNAME_ANALYSIS_LIST = "AnalysisList";
  public static final String PHENYX_TAGNAME_PEAKLIST_EXPORT = "ple:PeakListExport";
  public static final String PHENYX_TAGNAME_PEAKLISTS = "ple:PeakLists";
  
  public static final String PHENYX_TAGNAME_PEAKLIST_ITEM_ORDER = "ple:ItemOrder";
  public static final String PHENYX_TAGNAME_PEAKLIST_ITEM = "ple:item";
  public final static String PHENYX_TAGNAME_PEAKLIST_ITEM_TYPE = "type";
  public final static String PHENYX_TAGNAME_PEAKLIST_ITEM_MASS = "moz";
  public final static String PHENYX_TAGNAME_PEAKLIST_ITEM_INTENSITY = "intensity";
  public final static String PHENYX_TAGNAME_PEAKLIST_MSMSRUN = "ple:MSMSRun";
  public final static String PHENYX_TAGNAME_PEAKLIST_ONE_HIT = "ple:peptide";
  public final static String PHENYX_TAGNAME_PEAKLIST_PEAKS = "ple:peaks";
  
  public static final String PHENYX_COMPOUND_TAG_PEPS = "PeptideMatchesDefRefList";
  public static final String PHENYX_COMPOUND_TAG_PEP = "onePeptideMatchesDefRef";
  
  public static final String PHENYX_TAGNAME_PEPTIDE_MATCHES = "PeptideMatchesDefDictionary";
  
  public static final String PHENYX_TAGNAME_PEPTIDE_MATCH = "PeptideMatchDef";

  public static final String PHENYX_TAGNAME_SEQUENCE = "sequence";

  public static final String PHENYX_TAGNAME_MODIFICATION = "modifAt";
  
  public static final String PHENYX_TAGNAME_SCORE = "peptScore";
  
  public static final String PHENYX_TAGNAME_Z_SCORE = "peptZScore";

  public static final String PHENYX_TAGNAME_P_VALUE = "peptPvalue";
  
  public static final String PHENYX_TAGNAME_PEPTIDE_SPECTRUM_REF = "spectrumRef";

  public static final String PHENYX_TAGNAME_PEPTIDE_CHARGE = "charge";
  
  public static final String PHENYX_TAGNAME_PEPTIDE_MASS = "theoMass";
  
  public static final String PHENYX_TAGNAME_PEPTIDE_DELTA = "deltaMass";
  
  public static final String PHENYX_TAGNAME_PEPTIDE_IONIC_SERIES = "ionicSeries";
  
  public static final String PHENYX_TAG_PEPTIDE_PROTEIN_REFS = "DBMatchesRefList";
  
  public static final String PHENYX_TAG_PEPTIDE_PROTEIN_REF = "oneDBMatchesRef";
  
  public static final String PHENYX_ATTR_PEPTIDE_MATCH_KEY =  "key";
  
  public static final String PHENYX_TAGNAME_ONE_DATABASERESULT = "OneDatabaseResult";
  public static final String PHENYX_TAG_DBRESULT_IDENT_ALGO = "IdentificationAlg";
  public static final String PHENYX_TAG_DBRESULT_PARAMETERS = "parameters";
  public static final String PHENYX_TAG_DBRESULT_MATCHES = "DBMatches";
  public static final String PHENYX_TAG_DBRESULT_MATCH = "DBMatch";
  public static final String PHENYX_ATTR_DATABASERESULT_DBNAME = "name";
  
  public static final String PHENYX_TAG_DBRESULT_ACCESSION = "AC";
  public static final String PHENYX_TAG_DBRESULT_DESCRIPTION = "description";
  public static final String PHENYX_TAG_DBRESULT_SEQUENCE = "seqString";
  public static final String PHENYX_TAG_DBRESULT_TAXONOMY = "taxoID";
  public static final String PHENYX_TAG_DBRESULT_MASS = "seqMass";
  public static final String PHENYX_TAG_DBRESULT_PI = "seqPI";
  public static final String PHENYX_TAG_SCORE = "score";
  
  public static final String PHENYX_TAGNAME_MODTYPE = "Modifications";
  
  public static final String PHENYX_TAGNAME_ONE_MODIF = "OneModif";
  
  public static final String PHENYX_TAGNAME_ONE_RESULTPARM = "OneParam";

  public static final String PHENYX_ATTRNAME_PARMNAME = "name";
  
  public static final String PHENYX_TAGNAME_DBSEARCH_PARAMS = "dbSearchSubmitScriptParameters";
  
  public static final String PHENYX_TAGNAME_DEFINITONS = "inSilicoDefinitions";  
  
  public static final String PHENYX_TAGNAME_CHEM_ELEM = "oneElement";  
  
  public static final String PHENYX_TAGNAME_AMINO = "oneAminoAcid";
  
  public static final String PHENYX_TAGNAME_MODRES = "oneModRes";
  
  public static final String PHENYX_TAGNAME_MASS = "mass";
  
  public static final String PHENYX_TAGNAME_DELTA_MASS = "delta";
  
  public static final String PHENYX_TAGNAME_MODRES_DESCRIPTION = "description";
  
  public static final String PHENYX_TAGNAME_MODRES_RESIDUE = "residue";
  
  public static final String PHENYX_TAGNAME_MODRES_RESIDUES = "residues";
  
  public static final String PHENYX_ATTRNAME_MODIFNAME = "name";  
  
  public static final String PHENY_ATTRNAME_MODIFTYPE = "mode";
  
  public static final String PHENYX_ATTRNAME_ELMENTNAME = "name";
  
  public static final String PHENYX_ATTRNAME_DELTA_MASS_AVRG = "average";
  
  public static final String PHENYX_ATTRNAME_DELTA_MASS_MONOISOTOPIC = "monoisotopic";
  
  public static final String PHENYX_ATTRNAME_MASS_AVRG = "average";  

  public static final String PHENYX_ATTRNAME_MASS_MONOISOTOPIC = "monoisotopic";
  
  public static final String PHENYX_ATTRNAME_ELMNAME = "name";
  public static final String PHENYX_ATTRNAME_DESCRIPTION = "description";
  
  public static final String PHENYX_ATTRNAME_AMINONAME = "code1";
  
  public static final String PHENYX_N_TERM = "nterm";
  
  public static final String PHENYX_C_TERM = "cterm";
  
  public static final String PHENYX_ATTRNAME_MODRES_TYPE = "type";
  
  public static final String PHENYX_ATTRNAME_DATABASE_VERSION = "release";
  
  public static final String PHENYX_ATTRNAME_DATABASE_NAME = "name";
  
  public static final String PHENYX_ATTRNAME_AA = "aa";
  
  public static final String PHENYX_ATTRNAME_PARMVAL = "value";
  
  public static final String PHENYX_ATTRVAL_MODRES_TYPE_AMINO = "aaModif";
  
  public static final String PHENYX_ATTRVAL_MODRES_TYPE_PTM = "ptm";
  
  public static final String PHENY_ATTRVAL_MODIFTYPE_FIXED = "fixed";  
  
  public static final String PHENY_ATTRVAL_MODIFTYPE_VAR = "variable";
  
  public static final String PHENY_ATTRVAL_PARMNAME_FRAGMENTATION_TOLERANCE = "fragTol";  
  
  public static final Vector<String> PHENY_REQUIRED_ELMS = new Vector<String>(
         java.util.Arrays.asList(
               "Hydrogen",
               "Carbon",
               "Nitrogen",
               "Oxygen"               
             )
      );
  
  public static final String PHENYX_TAG_ENZYME = "cleavageEnzyme";
  
  public static final String PHENYX_TAG_PEPTIDE_TOLERANCE = "peptTolerance";
  
  public static final String PHENYX_ATTR_PEPTIDE_TOL_UNIT = "unit";
  
  public static final String PHENYX_ATTR_PEPTIDE_TOLERANCE = "value";
  
  public static final String PHENYX_ATTR_ENZYME_NAME = "name";
  
  public static final String PHENYX_ATTR_ENZYME_CLEAVAGE = "missedCleavage";
  
  public static final String DB_SEARCH_PROGRAM_NAME_MASCOT = "MASCOT";

  public static final String PROTEIN_FIELD_SEQU_COV_MAX = "SequCovMax";

  public static final String PROTEIN_FIELD_PEPSCORE = "PepScore";

  public static final String PROTEIN_FIELD_PEPSECSCORE = "PepSecondScore";
  
  public static final String PROTEIN_FIELD_SCORE = "Score";

  public static final String PROTEIN_FIELD_SEQUEST_CHARGE1 = "SQ/+1 Score";

  public static final String PROTEIN_FIELD_SEQUEST_CHARGE2 = "SQ/+2 Score";

  public static final String PROTEIN_FIELD_SEQUEST_CHARGE3 = "SQ/+3 Score";

  public static final String PROTEIN_FIELD_SEQUEST_CHARGE4 = "SQ/+4 Score";
  
  public static final String PROTEIN_FIELD_SEQUEST_DELTA = "Sequest Delta";

  public static final String PROTEIN_FIELD_MASCOT_CHARGE1 = "Masc/+1 Score";

  public static final String PROTEIN_FIELD_MASCOT_CHARGE2 = "Masc/+2 Score";

  public static final String PROTEIN_FIELD_MASCOT_CHARGE3 = "Masc/+3 Score";

  public static final String PROTEIN_FIELD_MASCOT_CHARGE4 = "Masc/+4 Score";

  public static final String PROTEIN_FIELD_MASCOT_DELTA = "Masc Delta";
  
  public static final String FILTER_MASCOT_SCORE = "Masc Pep Score";
  
  public static final String FILTER_MASCOT_PROTEIN_SCORE = "Masc Protein Score";
  
  public static final String PROTEIN_FIELD_SM_CHARGE1 = "SMill/+1 Score";

  public static final String PROTEIN_FIELD_SM_CHARGE2 = "SMill/+2 Score";

  public static final String PROTEIN_FIELD_SM_CHARGE3 = "SMill/+3 Score";

  public static final String PROTEIN_FIELD_SM_CHARGE4 = "SMill/+4 Score";

  public static final String PROTEIN_FIELD_SM = "Spectrum Mill Threshold";

  public static final String PROTEIN_FIELD_XTANDEM = "X! Tandem Threshold";
  
  public static final String PROTEIN_FIELD_XTANDEM_DELTA = "X! Tandem Delta Threshold";

  public static final String PROTEIN_FIELD_OMSSA = "OMSSA Threshold";

  public static final String PROTEIN_FIELD_PEPSEQUENCE = "PepSequence";

  public static final String PROTEIN_FIELD_PEPMASS = "PepMass";

  public static final String PROTEIN_FIELD_PEPDELTA = "Delta";

  public static final String PROTEIN_FIELD_PEPPARENTCHARGE = "PepParentCharge";

  public static final String PROTEIN_FIELD_PEPMISSEDCLEAV = "MissedCleavages";

  public static final String PROTEIN_FIELD_PEPPEAKAREA = "PepPeakArea";

  public static final String PROTEIN_FIELD_PEPPROPHETSCORE = "PepProphetScore";
  
  public static final String PROTEIN_FIELD_PEPDELTASCORE = "PepDeltaScore";
  
  public static final String PROTEIN_FIELD_PHENYX_PROTEIN_SCORE = "PhenyxProteinScore";

  public static final String PROTEIN_FIELD_PEPARML_FDR = "-10*log(PepArML-FDR)";
  public static final String PROTEIN_FIELD_PEPARML_ENGINE_COUNT = "searchEngineCount";
  
  public static final String PROTEIN_DE_NOVO_ACCESSION = "de-novo-peptide";
  public static final String PROTEIN_DE_NOVO_SEQUENCE = "DENOVO";
  public static final String PROTEIN_DE_NOVO_DATABASE = "denovo";

  public static final String PROTEIN_FIELD_SEQUENCE = "Sequence";

  public static final String PROTEIN_FIELD_NR_OF_PROTS_IN_CLUSTER = "NrOfProtsInCluster";
  
  public static final String PROTEIN_FIELD_NR_OF_DIFFERENT_PEPTIDES = "NrOfDifferentPeptides";
  
  public static final String PROTEIN_FIELD_NR_OF_DIFFERENT_SPECTRA = "NrOfDifferentSpectra";

  public static final String PROTEIN_FIELD_NR_OF_PASSING_SPECTRA = "NrOfPassingSpectra";

  public static final String PROTEIN_FIELD_NR_OF_PASSING_FH_SPECTRA = "NrOfPassingFirstHitSpectra";

  public static final String PROTEIN_FIELD_NR_OF_PASSING_PEP_SPECTRA = "PassingPepSpectraForOneHit";

  public static final String PROTEIN_FIELD_NR_OF_PASSING_PEP_FH_SPECTRA = "PassingPepFirstHitSpectraForOneHit";

  public static final String PROTEIN_FIELD_NR_OF_DIFFERENT_PEP_SEQUENCES = "NrOfDifferentPepSequences";

  public static final String PROTEIN_FIELD_NR_OF_SPECTRA_PEP_SEQUENCES = "NrOfSpectraForPepSequence";

  public static final String PROTEIN_FIELD_NR_OF_FH_SPECTRA_PEP_SEQUENCES = "NrOfFhSpectraForPepSequence";

  public static final String PROTEIN_FIELD_NR_OF_DIFFERENT_PEP_SEQUENCE_MODIFICATIONS = "NrOfDifferentPepSeqAndModi";

  public static final String PROTEIN_FIELD_NR_OF_SPECTRA_PEP_SEQUENCES_MODIFICATIONS = "NrOfSpectraForPepSeqAndModi";

  public static final String PROTEIN_FIELD_NR_OF_FH_SPECTRA_PEP_SEQUENCES_MODIFICATIONS = "NrOfFhSpectraForPepSeqAndModi";

  public static final String PROTEIN_FIELD_NR_OF_PASSING_TOTAL_PEP_SPECTRA = "TotalSpectraForPepOfSearches";

  public static final String PROTEIN_FIELD_NR_OF_PASSING_TOTAL_PEP_FH_SPECTRA = "TotalFhSpectraForPepOfSearches";

  public static final String PROTEIN_FIELD_NR_OF_PASSING_TOTAL_PROTEIN_SPECTRA = "SpectraForOneProteinFromMultiSearches";
  
  public static final String PROTEIN_FIELD_SF_SCORE = "Sequest Sf Score";

  public static final String PROTEIN_FIELD_SF_DELTA = "Sequest Sf Delta";
  
  public static final String PROTEIN_FIELD_NR_OF_PASSING_TOTAL_PROTEIN_FH_SPECTRA = "FhSpectraForOneProteinFromMultiOfSearches";
  
  public static final String PROTEIN_FIELD_FDR = "False Discovery Rate";
  
  /** the constant for the column DOMAINS of the database table PROTEIN */
  public static final String PROTEIN_FIELD_DOMAINS = "Domains";
  
  public static final String PROTEIN_HEATMAP_SORT_PEPCOUNT = "pepCount";

  public static final String PROTEIN_HEATMAP_SORT_SEQU_COVERAGE = "sequCov";
  
  public static final String PROTEIN_HEATMAP_SORT_SPECT_COUNT = "spectCount";
  
  public static final String PEPTIDEHIT_FIELD_NR_OF_PASSING_SPECTRA = "NrOfPassingSpectra";

  public static final String PEPTIDEHIT_FIELD_NR_OF_TOTAL_PASSING_SPECTRA = "NrOfTotalPassingSpectra";

  public static final String PEPTIDEHIT_FIELD_NR_OF_PASSING_FH_SPECTRA = "NrOfPassingFirstHitSpectra";

  public static final String PEPTIDEHIT_FIELD_NR_OF_TOTAL_PASSING_FH_SPECTRA = "NrOfTotalPassingFirstHitSpectra";
  
  public static final String PEPTIDEHIT_FIELD_DELTA_SCORE = "DeltaScore";
  
  public static final String PEPTIDEHIT_FIELD_RETENTION_TIME = "RetentionTime";
  
  public static final String PEPTIDEHIT_FIELD_NR_OF_DIFFERENT_SPECTRA = "nrOfDifferentSpectra";
  
  public static final String PEPTIDEHIT_FIELD_PARENTIONMASS = "ParentIonMass";
  
  public static final String PROTEIN_EXPORT_PEPSEQUENCE = "PepSequence";

  public static final String PROTEIN_EXPORT_PEPSCORE = "PepScore";
  
  public static final String PROTEIN_EXPORT_PEPSPECTRA = "PepNrOfSpectra";
  
  public static final String FILTER_MINIMUM_PEPTIDE_LENGTH = "minum peptide length";
  
  public static final String FILTER_MINIMUM_PEPTIDES_FOR_PROTEIN = "minum peptides for protein";

  public static final String FILTER_TOP_INTENSITY_PEAKS = "number of top intensity peaks";
  
  public static final String PARAM_DBSEARCH_VO = "dbSearchVO";

  public static final String PARAM_SPECTRUM_FORM = "spectrumForm";

  public static final String SPECTRUM_SERIES = "calculatedSeries";

  public static final String MASSREFERENCE_KEY_C_TERM = "C-term";

  public static final String MASSREFERENCE_KEY_N_TERM = "N-term";

  public static final String MASSREFERENCE_KEY_HYDRO = "Hydrogen";

  public static final String MASSREFERENCE_KEY_CARBON = "Carbon";

  public static final String MASSREFERENCE_KEY_NITRO = "Nitrogen";

  public static final String MASSREFERENCE_KEY_OXY = "Oxygen";

  public static final String MASSREFERENCE_KEY_ELECTRON = "Electron";

  public static final String MASSREFERENCE_KEY_SULFUR = "Sulfur";

  public static final String MASSREFERENCE_KEY_PHOSPHOR = "Phosphor";

  public static final String MASSREFERENCE_KEY_NEUTRAL_LOSS = "NeutralLoss";

  public static final String MASSREFERENCE_KEY_FREE_ACID = "Free acid";

  public static final double MASS_ELECTRON = 1.007825;

  public static final String ANALYTE_PROC_TYPE_SAMPLE = "Sample";

  public static final String ANALYTE_PROC_TYPE_CHEM_TREAT = "ChemicalTreatment";

  public static final String ANALYTE_PROC_TYPE_GEL_1D = "Gel1D";

  public static final String ANALYTE_PROC_TYPE_GEL_2D = "Gel2D";

  public static final String ANALYTE_PROC_TYPE_OTHER_ANAL_PS = "OtherAnalytePS";

  public static final String ANALYTE_PROC_TYPE_MASS_SPEC_EXPERIMENT = "analyte.proc.type.mass.spec.exp";

  public static final String ANALYTE_PROC_TYPE_MS_SEARCH = "MassSpecExperiment";

  public static final String ANALYTE_PROC_TYPE_LC_COL = "LCColumn";

  public static final String ANALYTE_PROC_TYPE_BAND = "Band";

  public static final String ANALYTE_PROC_TYPE_SPOT = "Spot";

  public static final String ANALYTE_PROC_TYPE_FRACTION = "Fraction";

  public static final String ANALYTE_PROC_TYPE_OTHER_ANAL = "OtherAnalyte";

  public static final String ANALYTE_PROC_TYPE_TREATED_ANAL = "TreatedAnalyte";

  public static final String ANALYTE_PROC_TYPE_DB_SEARCHES = ANALYTE_PROC_TYPE_MS_SEARCH;

  public static final String DBSEARCHPARAMETERS_FIELD_MASSSPECEXPERIMENT_FK = "MassspecexperimentFK";

  public static final String DBSEARCHPARAMETERS_FIELD_UPLOADNAME = "UploadName";

  public static final String PROPHET_ENZYME_TRYPSIN = "tryptic";

  public static final String PROPHET_ENZYME_GLUC = "gluC";

  public static final String PROPHET_ENZYME_GLUC_BICARB = "gluC_bicarb";

  public static final String PROPHET_ENZYME_CHYMOTRYPSIN = "chymotryptic";

  public static final String PROPHET_ENZYME_ELASTASE = "elastase";

  public static final String PROPHET_ENZYME_TRYPSIN_CHYMOTRYPSIN_ASP_N = "tca";

  public static final String PROPHET_ENZYME_NO_ENZYME = "nonspecific";

  public static final Integer DATABASE_STATUS_ACTIVE = new Integer(0);

  public static final Integer DATABASE_STATUS_INDEXING = new Integer(1);

  public static final Integer DATABASE_STATUS_INACTIVE = new Integer(2);
  
  public static final Integer DATABASE_STATUS_ERROR = new Integer(3);

  public static final String DATABASE_FASTA_PREFIX_GENBBANK = "gb";

  public static final String DATABASE_FASTA_PREFIX_EMBL = "emb";

  public static final String DATABASE_FASTA_PREFIX_PIR = "pir";

  public static final String DATABASE_FASTA_PREFIX_SWISSPROT = "sp";

  public static final String DATABASE_FASTA_PREFIX_OTHER = "ref";

  public static final String DATABASE_FASTA_PREFIX_DDBJ = "dbj";

  public static final String DATABASE_FASTA_PREFIX_PRF = "prf";

  public static final String DATABASE_FASTA_PREFIX_PDB = "pdb";

  public static final String TREE_SAMPLE_PROCESSING_DETAILS = "sample.processing.details.tree.model";
  
  public static final String TREE_SAMPLE_PROCESSING_DETAILS_OTHERINTERFACE = "experiment.sample.processing.details.tree.model";

  public static final String TREE_NODE = "tree.node";
  
  public static final String TREE_ROOTNODE = "tree.rootnode";

  public static final String TREE_NODE_ID_STORE = "tree.node.id.store";

  public static final String TREE_EXPERIMENT_TYPE= "tree.experiment.type";
  
  public static final String TREE_SUBEXPERIMENT_TYPE= "tree.subexperiment.type";
  
  public static final String TREE_SAMPLE_TYPE = "tree.sample.type";

  public static final String TREE_GEL_1D_TYPE = "tree.gel.1d.type";

  public static final String TREE_GEL_2D_TYPE = "tree.gel.2d.type";

  public static final String TREE_LC_COLUMN_TYPE = "tree.lccolumnd.type";

  public static final String TREE_OTHERANALYTE_PS_TYPE = "tree.otheranalyte.ps.type";

  public static final String TREE_CHEMICALTREATMENT_TYPE = "tree.chemical.treatment.type";

  public static final String TREE_MS_SEARCH_TYPE = "tree.ms.search.type";

  public static final String TREE_MASS_SPEC_EXPERIMENT_TYPE = "tree.mass.spec.experiment.type";

  public static final String TREE_BAND_TYPE = "tree.band.type";

  public static final String TREE_SPOT_TYPE = "tree.spot.type";

  public static final String TREE_FRACTION_TYPE = "tree.fraction.type";

  public static final String TREE_OTHERANALYTE_TYPE = "tree.other.analyte.type";

  public static final String TREE_TREATEDANALYTE_TYPE = "tree.treated.analyte.type";

  public static final String TREE_DB_SEARCHES_TYPE = "tree.db.searches.type";

  public static final String ANALYTE_PROC_STEP_ID = "anaProcStepId";

  // for single processing step viewing
  public static final String GEL1D_VO = "gel1dVo";

  public static final String INCLUDE_GEL1D = "include.gel1d";

  public static final String GEL2D_VO = "gel2dVo";

  public static final String INCLUDE_GEL2D = "include.gel2d";

  public static final String INCLUDE_LCCOLUMN_DETAILS = "include.lccolumn";

  public static final String OTHER_ANALYTE_PROC_STEP_VO = "otheranalyteVo";

  public static final String INCLUDE_OTHERANAPROCSTEPS_DETAILS = "include.otheranalyteprocstep";

  public static final String INCLUDE_MS_SEARCHES = "include.ms.searches";

  public static final String BAND_VO = "bandVo";

  public static final String SHOW_DETAILS = "showDetailpage";

  public static final String PROBE_TYPE = "probeType";

  public static final String MASSSPECEXPERIMENT_FIELD_RAW_FILE = "Raw File";

  public static final String MASSSPECEXPERIMENT_FIELD_PARAMETERS_FILE = "ParametersFile";

  public static final String MASSSPECEXPERIMENT_FIELD_CONTROLSOFTWARE = "Controlsoftware";

  public static final String SOFTWARE_ROLE_VALUE_CONTROLSOFTWARE = "MS-Control Software";

  public static final String ACTION_VIEW_EDIT = "ViewEdit";

  public static final String ACTION_CREATE_EDIT = "CreateEdit";

  public static final String GEL1_D_ID = "gel1DId";

  public static final String OTHERANALYTEPS_ID = "otheranalytepsId";

  public static final String GEL2_D_ID = "gel2DId";

  public static final String SAMPLE_ID = "sampleId";

  public static final String PROPERTY_FORM_ACTION = "formButton";

  public static final String PARAM_HIDE_TREE = "hideTree";

  public static final String ACTION_SHOW_TREE = "showTree";

  public static final String ACTION_SHOW_MIDDLE_PAGE = "showMiddlePage";

  public static final String ELECTROSPRAY_ID = "electrosprayId";

  public static final String ELECTROSPRAY_FIELD_ID = "Id";

  public static final String ELECTROSPRAY_FIELD_NAME = "Name";

  public static final String ELECTROSPRAY_FIELD_SUPPLY_TYPE = "SupplyType";

  public static final String ELECTROSPRAY_FIELD_SOLVENT_COMPOSITION = "SolventComposition";

  public static final String ELECTROSPRAY_FIELD_SOLVENT_FLOWRATE = "SolventFlowrate";

  public static final String ELECTROSPRAY_FIELD_SOLVENT_FLOWRATE_UNITS = "SolventFlowrateUnits";

  public static final String ELECTROSPRAY_FIELD_INTERFACE_MANUFACTURER = "InterfaceManufacturer";

  public static final String ELECTROSPRAY_FIELD_INTERFACE_NAME = "InterfaceName";

  public static final String ELECTROSPRAY_FIELD_INTERFACE_CATALOGNUMBER = "InterfaceCatalognumber";

  public static final String ELECTROSPRAY_FIELD_SPRAY_TIP_MANUFACTURER = "SprayTipManufacturer";

  public static final String ELECTROSPRAY_FIELD_SPRAYER_NAME = "SprayerName";

  public static final String ELECTROSPRAY_FIELD_SPRAYER_CATALOGNUMBER = "SprayerCatalognumber";

  public static final String ELECTROSPRAY_FIELD_SPRAYER_COATING = "SprayerCoating";

  public static final String ELECTROSPRAY_FIELD_SPRAYER_DESCRIPTION = "SprayerDescription";

  public static final String ELECTROSPRAY_FIELD_SPRAY_TIP_VOLTAGE = "SprayTipVoltage";

  public static final String ELECTROSPRAY_FIELD_SPRAY_TIP_DIAMETER = "SprayTipDiameter";

  public static final String ELECTROSPRAY_FIELD_CONE_VOLTAGE = "ConeVoltage";

  public static final String ELECTROSPRAY_FIELD_IN_SOURCE_DISSOCIATION = "InSourceDissociation";

  public static final String ELECTROSPRAY_FIELD_NEBULISING_GAS = "NebulisingGas";

  public static final String ELECTROSPRAY_FIELD_NEBULISING_GAS_PRESSURE = "NebulisingGasPressure";

  public static final String ELECTROSPRAY_FIELD_INTERFACE_DESCRIPTION = "InterfaceDescription";

  public static final String MALDI_ID = "maldiId";

  public static final String MALDI_FIELD_ID = "Id";

  public static final String MALDI_FIELD_PLATE_COMPOSITION = "PlateComposition";

  public static final String MALDI_FIELD_MATRIX_COMPOSITION = "MatrixComposition";

  public static final String MALDI_FIELD_DEPOSITION_TECHNIQUE = "DepositionTechnique";

  public static final String MALDI_FIELD_GRID_VOLTAGE = "GridVoltage";

  public static final String MALDI_FIELD_PSD_TYPE = "PsdType";

  public static final String MALDI_FIELD_PSD_DESCRIPTION = "PsdDescription";

  public static final String MALDI_FIELD_EXTRACTION_DELAYED = "ExtractionDelayed";

  public static final String MALDI_FIELD_LASER_TYPE = "LaserType";

  public static final String MALDI_FIELD_LASER_WAVELENGTH = "LaserWavelength";

  public static final String MALDI_FIELD_LASER_POWER = "LaserPower";

  public static final String MALDI_FIELD_FOCUS_DIAMETER = "FocusDiameter";

  public static final String MALDI_FIELD_ATTENUATION_DETAILS = "AttenuationDetails";

  public static final String MALDI_FIELD_PULSE_DURATION = "PulseDuration";

  public static final String MALDI_FIELD_SHOT_FREQUENCY = "ShotFrequency";

  public static final String MALDI_FIELD_AVG_NR_SHOTS_FIRED_ON_SPECTRUM = "AvgNrShotsFiredOnSpectrum";

  public static final String OTHERIONISATION_ID = "otherionisationId";

  public static final String OTHERIONISATION_FIELD_ID = "Id";

  public static final String OTHERIONISATION_FIELD_DESCRIPTION = "Description";

  public static final String MZANALYSIS_FIELD_IONOPTIC_DESCRIPTION = "IonopticDescription";

  public static final String MZANALYSIS_FIELD_QUADRUPOLE_DESCRIPTION = "QuadrupoleDescription";

  public static final String MZANALYSIS_FIELD_HEXAPOLE_DESCRIPTION = "HexapoleDescription";

  public static final String MZANALYSIS_FIELD_OTHERMZANALYSIS_DESCRIPTION = "OthermzanalysisDescription";

  public static final String COLLISIONCELL_ID = "collisioncellId";

  public static final String COLLISIONCELL_FIELD_ID = "Id";

  public static final String COLLISIONCELL_FIELD_GAS_TYPE = "GasTypeCollisionCell";

  public static final String COLLISIONCELL_FIELD_GAS_PRESSURE = "GasPressureCollisionCell";

  public static final String COLLISIONCELL_FIELD_COLLISION_OFFSET = "CollisionOffset";

  public static final String COLLISIONCELL_FIELD_COLLISION_ENERGY = "CollisionEnergy";

  public static final String IONTRAP_ID = "iontrapId";

  public static final String IONTRAP_FIELD_ID = "IdIontrap";

  public static final String IONTRAP_FIELD_GAS_TYPE = "GasType Iontrap/FT";

  public static final String IONTRAP_FIELD_GAS_PRESSURE = "GasPressure Iontrap/FT";

  public static final String IONTRAP_FIELD_RF_FREQUENCY = "RfFrequency";

  public static final String IONTRAP_FIELD_EXCITATION_AMPLITUDE = "ExcitationAmplitude";

  public static final String IONTRAP_FIELD_ISOLATION_CENTRE = "IsolationCentre";

  public static final String IONTRAP_FIELD_ISOLATION_WIDTH = "IsolationWidth";

  public static final String IONTRAP_FIELD_FINAL_MS_LEVEL = "FinalMsLevel";

  public static final String TOF_ID = "tofId";

  public static final String TOF_FIELD_ID = "Id";

  public static final String TOF_FIELD_REFLECTRON_STATE = "ReflectronState";

  public static final String TOF_FIELD_INTERNAL_LENGTH = "InternalLength";

  public static final String MASSSPECMACHINE_FIELD_IONSOURCE = "Ionsource";

  public static final String MASSSPECMACHINE_FIELD_MZANALYSIS = "Mzanalysis";

  public static final String MASSSPECMACHINE_FIELD_DETECTION = "Detection";

  public static final String MASSSPECEXPERIMENT_FIELD_MASSSPECMACHINE = "Massspecmachine";

  public static final String SAMPLEORIGIN_FIELD_ORGANISM = "Organism";

  public static final String SAMPLEORIGIN_FIELD_TAGGINGPROCESS = "Taggingprocess";

  public static final String ACTION_SHOW_TREE_WITH_MASSSPEC_EXP = "showTreeWithMassspec";

  public static final String SAMPLE_VO = "sampleVO";
  public static final String EXPERIMENT_VO = "experimentVO";
  public static final String GELMATRIX_FIELD_X_VALUE = "x Value";

  public static final String GELMATRIX_FIELD_Y_VALUE = "y Value";

  public static final String GELMATRIX_FIELD_Z_VALUE = "z Value";

  public static final String GELMATRIX_FIELD_PERCENT_ACRYLAMIDE = "percent acrylamide";

  public static final String GELMATRIX_FIELD_ACRYLAMIDE_BISACRYLAMIDE_RATIO = "acrylamide:bisacrylamide";

  public static final String GELMATRIX_FIELD_DIMENSIONS = "dimensions";

  public static final String GELMATRIX_FIELD_PART_DIMENSIONS = "partDimensions";

  public static final String GELMATRIX_FIELD_PART_PERCENT_ACRYLAMIDE = "partPercentAcrylamide";

  public static final String GELMATRIX_FIELD_PART_ACRYLAMIDE_BISACRYLAMIDE_RATIO = "partAcrylamideBisacrylamide";

  public static final String GEL1D_FIELD_SEPARATION_METHOD_DIM1 = "gel1dSeparationMethodDim1";

  public static final String GEL1D_FIELD_PHYSICAL_DIMENSION_DIM1 = "gel1dPhysicalDimensionDim1";

  public static final String GEL1D_FIELD_PROPERTY_RANGE_DIM1 = "gel1dPropertyRangeDim1";

  public static final String GEL1D_FIELD_PROPERTY_RANGE_START_DIM1 = "gel1dPropertyRangeStartDim1";

  public static final String GEL1D_FIELD_PROPERTY_RANGE_STOP_DIM1 = "gel1dPropertyRangeStopDim1";

  public static final String GEL1D_FIELD_DISTRIBUTION_DIM1 = "gel1dDistributionDim1";

  public static final String GEL1D_FIELD_RAW_IMAGE = "g1RawImage";

  public static final String GEL1D_FIELD_WARPED_IMAGE = "g1WarpedImage";

  public static final String GEL1D_FIELD_ANNOTATED_IMAGE = "g1AnnoImage";

  public static final String GEL1D_FIELD_WARPING_MAP = "g1WarpingMap";

  public static final String GEL2D_FIELD_SEPARATION_METHOD_DIM1 = "gel2dSeparationMethodDim1";

  public static final String GEL2D_FIELD_SEPARATION_METHOD_DIM2 = "gel2dSeparationMethodDim2";

  public static final String GEL2D_FIELD_PHYSICAL_DIMENSION_DIM1 = "gel2dPhysicalDimensionDim1";

  public static final String GEL2D_FIELD_PHYSICAL_DIMENSION_DIM2 = "gel2dPhysicalDimensionDim2";

  public static final String GEL2D_FIELD_PROPERTY_RANGE_DIM1 = "gel2dPropertyRangeDim1";

  public static final String GEL2D_FIELD_PROPERTY_RANGE_DIM2 = "gel2dPropertyRangeDim2";

  public static final String GEL2D_FIELD_PROPERTY_RANGE_START_DIM1 = "gel2dPropertyRangeStartDim1";

  public static final String GEL2D_FIELD_PROPERTY_RANGE_START_DIM2 = "gel2dPropertyRangeStartDim2";

  public static final String GEL2D_FIELD_PROPERTY_RANGE_STOP_DIM1 = "gel2dPropertyRangeStopDim1";

  public static final String GEL2D_FIELD_PROPERTY_RANGE_STOP_DIM2 = "gel2dPropertyRangeStopDim2";

  public static final String GEL2D_FIELD_DISTRIBUTION_DIM1 = "gel2dDistributionDim1";

  public static final String GEL2D_FIELD_DISTRIBUTION_DIM2 = "gel2dDistributionDim2";

  public static final String GEL2D_FIELD_RAW_IMAGE = "g2RawImage";

  public static final String GEL2D_FIELD_WARPED_IMAGE = "g2WarpedImage";

  public static final String GEL2D_FIELD_ANNOTATED_IMAGE = "g2AnnoImage";

  public static final String GEL2D_FIELD_WARPING_MAP = "g2WarpingMap";

  public static final String GEL1D_GELITEMDETECTION_ID = "gel1dgelitemdetectionId";

  public static final String GEL1D_GELITEMDETECTION_FIELD_ID = "Id";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_PROCESS = "gel1dDetectionProcess";

  public static final String GEL1D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_NAME = "gel1dTransferMediumName";

  public static final String GEL1D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_TYPE = "gel1dTransferMediumType";

  public static final String GEL1D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_MANUFACTURER = "gel1dTransferMediumManufacturer";

  public static final String GEL1D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_MODEL = "gel1dTransferMediumModel";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_MEDIUM_NAME = "gel1dDetectionMediumName";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_MEDIUM_MANUFACTRURER = "gel1dDetectionMediumManufactrurer";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_MEDIUM_MODEL = "gel1dDetectionMediumModel";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_PROTOCOL = "gel1dDetectionProtocol";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_AGENTS_DESCRIPTION = "gel1dDetectionAgentsDescription";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_DENATURATINGAGENTS = "gel1dDenaturatingagents";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_ADDREAGENTS = "gel1dAddreagents";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_ADDBUFFERS = "gel1dAdddetectionbuffers";

  public static final String GEL1D_GELITEMDETECTION_FIELD_DETECTION_EQUIPMENTS = "gel1dDetectionequipments";

  public static final String GEL1D_GELITEMDETECTION_FIELD_ACQUISITION_EQUIPMENTS = "gel1dAcquisitionequipments";

  public static final String GEL1D_GELITEMDETECTION_FIELD_ACQUISITION_SOFTWARES = "gel1dAcquisitionsoftwares";

  public static final String GEL1D_GELITEMDETECTION_FIELD_ACQUISITION_MATRIXCOMPONENTS = "gel1dAcquisitionmatrixcomponents";

  public static final String GEL1D_GELITEMDETECTION_FIELD_IMAGE_ITEMDETECTION = "gel1dImageitemdetection";

  public static final String GEL1D_GELITEMDETECTION_FIELD_IMAGE_ITEMQUANTITATION = "gel1dImageitemquantitation";

  public static final String GEL2D_GELITEMDETECTION_ID = "gel2dgelitemdetectionId";

  public static final String GEL2D_GELITEMDETECTION_FIELD_ID = "Id";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_PROCESS = "gel2dDetectionProcess";

  public static final String GEL2D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_NAME = "gel2dTransferMediumName";

  public static final String GEL2D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_TYPE = "gel2dTransferMediumType";

  public static final String GEL2D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_MANUFACTURER = "gel2dTransferMediumManufacturer";

  public static final String GEL2D_GELITEMDETECTION_FIELD_TRANSFER_MEDIUM_MODEL = "gel2dTransferMediumModel";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_MEDIUM_NAME = "gel2dDetectionMediumName";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_MEDIUM_MANUFACTRURER = "gel2dDetectionMediumManufactrurer";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_MEDIUM_MODEL = "gel2dDetectionMediumModel";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_PROTOCOL = "gel2dDetectionProtocol";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_AGENTS_DESCRIPTION = "gel2dDetectionAgentsDescription";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_DENATURATINGAGENTS = "gel2dDenaturatingagents";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_ADDREAGENTS = "gel2dAddreagents";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_ADDBUFFERS = "gel2dAdddetectionbuffers";

  public static final String GEL2D_GELITEMDETECTION_FIELD_DETECTION_EQUIPMENTS = "gel2dDetectionequipments";

  public static final String GEL2D_GELITEMDETECTION_FIELD_ACQUISITION_EQUIPMENTS = "gel2dAcquisitionequipments";

  public static final String GEL2D_GELITEMDETECTION_FIELD_ACQUISITION_SOFTWARES = "gel2dAcquisitionsoftwares";

  public static final String GEL2D_GELITEMDETECTION_FIELD_ACQUISITION_MATRIXCOMPONENTS = "gel2dAcquisitionmatrixcomponents";

  public static final String GEL2D_GELITEMDETECTION_FIELD_IMAGE_ITEMDETECTION = "gel2dImageitemdetection";

  public static final String GEL2D_GELITEMDETECTION_FIELD_IMAGE_ITEMQUANTITATION = "gel2dImageitemquantitation";

  public static final String GEL2D_INTERDIM_FIELD_STEP_NAMES = "gel2dInterdimStepNames";

  public static final String GEL2D_INTERDIM_FIELD_STEPS = "gel2dInterdimSteps";

  public static final String GEL2D_INTERDIM_FIELD_PRE_DIMENSION = "gel2dPreDimension";

  public static final String GEL2D_INTERDIM_FIELD_ADDBUFFERS = "gel2dAddinterdimbuffers";

  public static final String GEL2D_INTERDIM_FIELD_ADDREAGENTS = "gel2dAddInterdimreagents";

  public static final String GEL2D_INTERDIM_FIELD_EQUIPMENTS = "gel2dInterdimequipments";

  public static final String GEL2D_INTERDIM_FIELD_PROTOCOL = "gel2dInterdimprotocol";

  public static final String LCCOLUMN_FIELD_PARAMETERS_FILE = "lcParametersFile";

  public static final int PRIDE_INCLUDE_SPECTRUM_NONE = 0;

  public static final int PRIDE_INCLUDE_SPECTRUM_DB = 1;

  public static final int PRIDE_INCLUDE_SPECTRUM = 2;

  /** Constant to store the multiplication factor for mzValues to make integer lines */
  public static final String CHROMATOGRAM_HEADER_FILE_MZ_MULTIPLICATION_FACTOR = "mzMultiplicationFactorForInt";
  
  /** How many should be stored into one line*/
  public static final String CHROMATOGRAM_HEADER_FILE_LOWEST_RESOLUTION = "lowestResolution";
  
  /** The lowest m/z value of the quantification*/
  public static final String CHROMATOGRAM_HEADER_FILE_LOWEST_MZ = "lowestMz";
  
  /** The highest m/z value of the quantification*/
  public static final String CHROMATOGRAM_HEADER_FILE_HIGHEST_MZ = "highestMz";
  
  /** The total number of scans used for the quantification*/
  public static final String CHROMATOGRAM_HEADER_FILE_NUMBER_SCANS = "numberOfScans";
  
  /** The name of the retention file*/
  public static final String CHROMATOGRAM_HEADER_FILE_RETENTION_TIME = "retentionTimeFile";
  
  /** The highest MS Level of the file*/
  public static final String CHROMATOGRAM_HEADER_FILE_MS_LEVEL = "msLevel";
 
  /** The the type of the MS/MS file*/
  public static final String CHROMATOGRAM_HEADER_FILE_MSMS_TYPE = "msmsType";
  
  /** This file comes from polarity switched data*/
  public static final String CHROMATOGRAM_HEADER_FILE_POLARITY_SWITCHED = "polaritySwitched";
  
  /** The positive polarity of a polarity switched data file*/
  public static final String CHROMATOGRAM_HEADER_FILE_POLARITY_POSITIVE = "positive";

  /** The negative polarity of a polarity switched data file*/
  public static final String CHROMATOGRAM_HEADER_FILE_POLARITY_NEGATIVE = "negative";
  
  /** Status when a raw file is translated in the corresponding chromatogram files*/
  public static final String UPLOADSTATUSTRANSLATING = "TRANSLATING";
  /** Status when the translation to the chromatogram file is finisched*/
  public static final String UPLOADSTATUSTRANSLATED = UtilsConstants.UPLOADSTATUSTRANSLATED;
  
  public static final String QUANTIFICATION_METHOD_ASAPRATIO = "ASAPRatio Standard";
  public static final String QUANTIFICATION_METHOD_ENHANCED_VALLEY = "ASAPRatio Enhanced Valley";

  public static final String UPLOADSTATUSQUEUED = "QUEUED";
  /** possible upload status type: FAILURE*/
  public static final String UPLOADSTATUSFAILURE = "FAILURE";
  /** possible upload status type: LOADING FINISHED */
  public static final String UPLOADSTATUSFINISHED = "LOADING FINISHED";
  
  public static final String  MASSSPECMACHINE_PAGE_QUERY_INCLUDE_PREFIX="Massspecmachine page query";
  public static final String  TASKBAR_ACTION_DISPLAY_FILTER_BAR="display_filter_bar";

  /** for getting external cross reference links from IPI */
 
  public static final String PROTEIN_CLUSTERING_MASS_SPECTROMETRY_EVIDENCE = "Massspec Evidence";
  public static final String PROTEIN_CLUSTERING_MS_EVIDENCE_PEP_THRESHOLD = "MS Ev Pep Threshold";

  public static final String PROTEIN_CLUSTERING_SEQUENCE_BASED = "Protein Sequence";
  
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_BASED = "GO";
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_BP_BASED = "GO-BiologicalProcess";
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_CC_BASED = "GO-CellularComponent";
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_MF_BASED = "GO-MolecularFunction";
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_CLUEGO_BASED = "ClueGO";
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_CLUEGO_BP_BASED = "ClueGO-BiologicalProcess";
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_CLUEGO_CC_BASED = "ClueGO-CellularComponent";
  public static final String PROTEIN_CLUSTERING_GENEONTOLOGY_CLUEGO_MF_BASED = "ClueGO-MolecularFunction";
  
//for linking the external database crossreference and the detailed link opens for database Id  selection 
  public static final String EXTDBENTRY_DB_ENSEMBL = "Ensembl";
  public static final String EXTDBENTRY_DB_ENSEMBL_HAVANA = "EnsemblHavana";
  public static final String EXTDBENTRY_DB_ENTREZ_GENE = "EntrezGene";
  public static final String EXTDBENTRY_DB_GENE3D = "Gene3D";
  public static final String EXTDBENTRY_DB_GO = "GO";
  public static final String EXTDBENTRY_DB_PUBMED = "Pubmed";
  public static final String EXTDBENTRY_DB_INTER_PRO = "InterPro";
  public static final String EXTDBENTRY_DB_NCBI_TAX_ID = "NcbiTaxId";
  public static final String EXTDBENTRY_DB_PATHO_SIGN = "PathoSign";
  public static final String EXTDBENTRY_DB_PFAM = "Pfam";
  public static final String EXTDBENTRY_DB_PROSITE = "Prosite";
  public static final String EXTDBENTRY_DB_REF_SEQ = "RefSeq";
  public static final String EXTDBENTRY_DB_SMART = "Smart";
  public static final String EXTDBENTRY_DB_UNIPROT_SWISSPROT = "UniprotSwissprot";
  public static final String EXTDBENTRY_DB_UNIPROT_TREMBL = "UniprotTrembl";
  public static final String EXTDBENTRY_DB_VEGA = "Vega";  
  public static final String EXTDBENTRY_DB_KEGG = "Kegg"; 
  public static final String EXTDBENTRY_DB_GENECARD= "GeneCard";
  
  public static final String EXTDBENTRY_DB_IHOP = "iHop";
  public static final String EXTDBENTRY_DB_GENESYMBOL = "genesymbol";
  public static final String EXTDBENTRY_DB_SYNONYM = "synonym";
  public static final String EXTDBENTRY_DB_PEPTIDEMAPPER = "peptideMapper";
  
  
  public static final String EXTDBENTRY_FIELD_DESCRIPTION = "extdbentry_description";

  
  //for linking the external database crossreference and the detailed link opens for Icon selection
  public static final String EXTDBENTRY_DB_ENSEMBL_ICON = "EnsemblIcon";
  public static final String EXTDBENTRY_DB_ENSEMBL_HAVANA_ICON = "EnsemblHavanaIcon";
  public static final String EXTDBENTRY_DB_ENTREZ_GENE_ICON = "EntrezGeneIcon";
  public static final String EXTDBENTRY_DB_GENE3D_ICON = "Gene3DIcon";
  public static final String EXTDBENTRY_DB_GO_ICON = "GOIcon";
  public static final String EXTDBENTRY_DB_PUBMED_ICON = "PubmedIcon";
  public static final String EXTDBENTRY_DB_INTER_PRO_ICON = "InterProIcon";
  public static final String EXTDBENTRY_DB_NCBI_TAX_ID_ICON = "NcbiTaxIdIcon";
  public static final String EXTDBENTRY_DB_PATHO_SIGN_ICON = "PathoSignIcon";
  public static final String EXTDBENTRY_DB_PFAM_ICON = "PfamIcon";
  public static final String EXTDBENTRY_DB_PROSITE_ICON = "PrositeIcon";
  public static final String EXTDBENTRY_DB_REF_SEQ_ICON = "RefSeqIcon";
  public static final String EXTDBENTRY_DB_SMART_ICON = "SmartIcon";
  public static final String EXTDBENTRY_DB_UNIPROT_SWISSPROT_ICON = "UniprotSwissprotIcon";
  public static final String EXTDBENTRY_DB_UNIPROT_TREMBL_ICON = "UniprotTremblIcon";
  public static final String EXTDBENTRY_DB_VEGA_ICON= "VegaIcon";  
  public static final String EXTDBENTRY_DB_KEGG_ICON = "KeggIcon"; 
  
  public static final String HIDE_KERATIN_GENENAME = "GeneName"; 
  public static final String HIDE_KERATIN_GENESYMBOL = "GeneSymbol";
  
  public static String getExpressoBlastServer(){
    return UtilsConstants.getExpressoBlastServer();
  }
  
  /**
   * Returns corresponding PeptideMapper Property.
   * If there is no entry for the key, null is returned.
   * @param key
   * @return property
   */
  public static String getPepmapperProperty(String key){
    return UtilsConstants.getPepmapperProperty(key);
  }
  
  public static final String SPECTRUM_SERIES_B = "bSeries";
  public static final String SPECTRUM_SERIES_B_2_PLUS = "b2PlusSeries";
  public static final String SPECTRUM_SERIES_B_3_PLUS = "b3PlusSeries";
  public static final String SPECTRUM_SERIES_B_STAR = "bStarSeries";
  public static final String SPECTRUM_SERIES_B_STAR_2_PLUS = "bStar2PlusSeries";
  public static final String SPECTRUM_SERIES_B_STAR_3_PLUS = "bStar3PlusSeries";
  public static final String SPECTRUM_SERIES_B_ZERO = "bZeroSeries";
  public static final String SPECTRUM_SERIES_B_ZERO_2_PLUS = "bZero2PlusSeries";
  public static final String SPECTRUM_SERIES_B_ZERO_3_PLUS = "bZero3PlusSeries";

  public static final String SPECTRUM_SERIES_Y = "ySeries";
  public static final String SPECTRUM_SERIES_Y_2_PLUS = "y2PlusSeries";
  public static final String SPECTRUM_SERIES_Y_3_PLUS = "y3PlusSeries";
  public static final String SPECTRUM_SERIES_Y_STAR = "yStarSeries";
  public static final String SPECTRUM_SERIES_Y_STAR_2_PLUS = "yStar2PlusSeries";
  public static final String SPECTRUM_SERIES_Y_STAR_3_PLUS = "yStar3PlusSeries";
  public static final String SPECTRUM_SERIES_Y_ZERO = "yZeroSeries";
  public static final String SPECTRUM_SERIES_Y_ZERO_2_PLUS = "yZeroSeries2PlusSeries";
  public static final String SPECTRUM_SERIES_Y_ZERO_3_PLUS = "yZeroSeries3PlusSeries";

  public static final String SPECTRUM_SERIES_A = "aSeries";
  public static final String SPECTRUM_SERIES_A_2_PLUS = "a2PlusSeries";
  public static final String SPECTRUM_SERIES_A_3_PLUS = "a3PlusSeries";
  public static final String SPECTRUM_SERIES_A_STAR = "aStarSeries";
  public static final String SPECTRUM_SERIES_A_STAR_2_PLUS = "aStar2PlusSeries";
  public static final String SPECTRUM_SERIES_A_STAR_3_PLUS = "aStar3PlusSeries";
  public static final String SPECTRUM_SERIES_A_ZERO = "aZeroSeries";
  public static final String SPECTRUM_SERIES_A_ZERO_2_PLUS = "aZero2PlusSeries";
  public static final String SPECTRUM_SERIES_A_ZERO_3_PLUS = "aZero3PlusSeries";

  public static final String PROTEIN_GO_TERM = "GeneOntologyTerm";
  public static final String PROTEIN_GO_PVALUE = "GeneOntologyPValue";
  public static final String PROTEIN_GO_ID = "GeneOntologyID";

  public static final String EXTDBENTRY_DB_GO_COMPONENT = "GO-component";
  public static final String EXTDBENTRY_DB_GO_FUNCTION = "GO-function";
  public static final String EXTDBENTRY_DB_GO_PROCESS = "GO-process";
  
}
