package at.tugraz.genome.dbutilities.exception;

/**
 * <p>Title: MARS EJB</p>
 * <p>Description: Microarray Analysis and Retrieval System</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: genome.tugraz.at</p>
 * @author Michael Maurer
 * @version 1.0
 * To be used to report:
 * NamingExceptions,
 */
public class EJBServerException extends Exception {
  private Class invokerClass_ = null;

  public EJBServerException() {
    super();
  }
  public EJBServerException(String e) {
    super(e);
  }

  public EJBServerException(String e, Class invokerClass) {
    super(e);
    invokerClass_ = invokerClass;
  }

  public String getClassName() {
    if (invokerClass_ != null) {
      return invokerClass_.getName();
    } else {
      return "Name of class not available!";
    }
  }

  public String getExceptionMessage() {
    return super.getMessage();
  }
}