package at.tugraz.genome.dbutilities;

import java.sql.*;
import java.util.ArrayList;
import java.util.Hashtable;

/**
 * <p>
 * Title: MARS EJB
 * </p>
 * <p>
 * Description: Microarray Analysis and Retrieval System
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * <p>
 * Company: genome.tugraz.at
 * </p>
 * 
 * @author Robert Molidor
 * @version 1.0
 */

public class OraclePKGenerator implements PKGenerator {
	  private static int cacheSize_ = 50;

	  private static OraclePKGenerator instance_ = null;

	  private static GenericDAOFactory daoFactory_ = null;

	  private Hashtable pkCache_ = null;

	  private OraclePKGenerator() {
	    pkCache_ = new Hashtable();
	  }

	  public static OraclePKGenerator getInstance(GenericDAOFactory daoFactory) {
	    daoFactory_ = daoFactory;
	    if (instance_ == null) {
	      instance_ = new OraclePKGenerator();
	    }
	    return instance_;
	  }

	  /**
	   * Returns the primary key for the given table for an ORACLE database.
	   * 
	   * @param tableName
	   *            The name of the table the primary key is used for
	   * @return The primary key. A unique number, or NULL if the primary key is
	   *         not available.
	   */
	  public Long getPrimaryKey(String tableName) {
	    //check if PKs are in cache
	    tableName = tableName.replaceAll("-", "_");
	    ArrayList pkList = (ArrayList) pkCache_.get(tableName);
	    if (pkList != null) {
	      Long cachedPK = (Long) pkList.remove(0);
	      if (pkList.size() == 0) {
	        pkCache_.remove(tableName);
	      }
	      return cachedPK;
	    }
	    Long pk = null;
	    Connection con = null;
	    try {
	      con = daoFactory_.createConnection();
	      String sqlQuery = "select " + tableName + "seq.nextval from dual";
	      PreparedStatement stmt = con.prepareStatement(sqlQuery);
	      ArrayList currentPKList = new ArrayList();
	      for (int i = 0; i < cacheSize_; i++) {
	        ResultSet rs = stmt.executeQuery();
	        if (rs.next()) {
	          pk = new Long(rs.getLong(1));
	          currentPKList.add(pk);
	        }
	        rs.close();
	      }
	      pk = (Long) currentPKList.remove(0); //retrieve first element in
												   // order to avoid duplicate PKs
	      pkCache_.put(tableName, currentPKList);
	      stmt.close();
	    } catch (java.sql.SQLException sqlExc) {
	      /*
	       * SQL statement to create a sequence CREATE SEQUENCE surfacetypeseq
	       * INCREMENT BY 1 START WITH 100 MINVALUE 100 MAXVALUE
	       * 999999999999999999999999999 CACHE 20 /
	       */
	      if (sqlExc.getMessage().startsWith("ORA-02289")) {
	        //the requested sequence is not available
	        //therefore create it
	        String sqlQuery = "CREATE SEQUENCE " + tableName + "seq ";
	        sqlQuery = sqlQuery + "INCREMENT BY 1 ";
	        sqlQuery = sqlQuery + "START WITH 100 ";
	        sqlQuery = sqlQuery + "MINVALUE 100 ";
	        sqlQuery = sqlQuery + "MAXVALUE 999999999999999999999999999 ";
	        sqlQuery = sqlQuery + "CACHE 50";
	        try {
	          Statement stmt = con.createStatement();
	          stmt.execute(sqlQuery);
	          stmt.close();
	          //sequence successfully created, now get PK
	          sqlQuery = "SELECT " + tableName + "seq.nextval from dual";
	          stmt = con.createStatement();
	          ResultSet rs = stmt.executeQuery(sqlQuery);
	          if (rs.next())
	            pk = new Long(rs.getLong(1));
	          rs.close();
	          stmt.close();
	        } catch (java.sql.SQLException createSQLExc) {
	          createSQLExc.printStackTrace();
	        }
	      } else {
	        sqlExc.printStackTrace();
	      }
	    } finally {
	      try {
	        con.close();
	      } catch (java.sql.SQLException sqlExc) {
	        sqlExc.printStackTrace();
	      }
	    }
	    return pk;
	  }

	  public Long getPrimaryKeyWithoutCache(String tableName) {
	    tableName = tableName.replaceAll("-", "_");
	    Long pk = null;
	    Connection con = null;
	    try {
	      con = daoFactory_.createConnection();
	      String sqlQuery = "select " + tableName + "seq.nextval from dual";
	      PreparedStatement stmt = con.prepareStatement(sqlQuery);
	      ResultSet rs = stmt.executeQuery();
	      if (rs.next())
	        pk = new Long(rs.getLong(1));
	      rs.close();
	      stmt.close();
	    } catch (java.sql.SQLException sqlExc) {
	      /*
	       * SQL statement to create a sequence CREATE SEQUENCE surfacetypeseq
	       * INCREMENT BY 1 START WITH 100 MINVALUE 100 MAXVALUE
	       * 999999999999999999999999999 CACHE 20 /
	       */
	      if (sqlExc.getMessage().startsWith("ORA-02289")) {
	        //the requested sequence is not available
	        //therefore create it
	        String sqlQuery = "CREATE SEQUENCE " + tableName + "seq ";
	        sqlQuery = sqlQuery + "INCREMENT BY 1 ";
	        sqlQuery = sqlQuery + "START WITH 100 ";
	        sqlQuery = sqlQuery + "MINVALUE 100 ";
	        sqlQuery = sqlQuery + "MAXVALUE 999999999999999999999999999 ";
	        sqlQuery = sqlQuery + "CACHE 20";
	        try {
	          Statement stmt = con.createStatement();
	          stmt.execute(sqlQuery);
	          stmt.close();
	          //sequence successfully created, now get PK
	          sqlQuery = "SELECT " + tableName + "seq.nextval from dual";
	          stmt = con.createStatement();
	          ResultSet rs = stmt.executeQuery(sqlQuery);
	          if (rs.next())
	            pk = new Long(rs.getLong(1));
	          rs.close();
	          stmt.close();
	        } catch (java.sql.SQLException createSQLExc) {
	          createSQLExc.printStackTrace();
	        }
	      } else {
	        sqlExc.printStackTrace();
	      }
	    } finally {
	      try {
	        con.close();
	      } catch (java.sql.SQLException sqlExc) {
	        sqlExc.printStackTrace();
	      }
	    }
	    return pk;
	  }

	  public String toString() {
	    return "OraclePKGenerator";
	  }
  public void setPkValuesAtBeginning(Connection con, String tableName) throws SQLException{
    tableName = tableName.replaceAll("-", "_");
    Long pk = null;
    try {
      String sqlQuery = "select " + tableName + "seq.nextval from dual";
      PreparedStatement stmt = con.prepareStatement(sqlQuery);
      ResultSet rs = stmt.executeQuery();
      if (rs.next()) {
        pk = new Long(rs.getLong(1));
      }
      rs.close();
    } catch (java.sql.SQLException sqlExc) {
    }
    if (pk!=null&&pk.longValue()>0){
      pkCache_.remove(tableName);
      String sqlQuery = "ALTER SEQUENCE " + tableName + "seq INCREMENT BY "+String.valueOf((pk.longValue()-100)*-1)+" MINVALUE 99";
      PreparedStatement stmt = con.prepareStatement(sqlQuery);
      stmt.executeQuery();
      stmt.close();
      sqlQuery = "SELECT " + tableName + "seq.NEXTVAL S FROM dual";
      stmt = con.prepareStatement(sqlQuery);
      stmt.executeQuery();
      stmt.close();
      sqlQuery = "ALTER SEQUENCE " + tableName + "seq INCREMENT BY 1 MINVALUE 100";
      stmt = con.prepareStatement(sqlQuery);
      stmt.executeQuery();
      stmt.close();
    }
  }
}