package at.tugraz.genome.dbutilities;

import java.lang.Long;
import java.rmi.*;
import java.sql.*;
import java.util.ArrayList;
import java.util.Hashtable;

import javax.ejb.CreateException;
import javax.naming.*;
import javax.sql.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * @author hartler
 * @version 1.0
 */

public class MYSQLPKGenerator implements PKGenerator {
  
  /** one singleton for all database accesses */
  private static MYSQLPKGenerator instance_ = null;

  /** singleton for database access*/
  private static GenericDAOFactory daoFactory_ = null;
  
  /** holds specific amount of pks; a retrieving of every single PK does not need a database transaction */
  private Hashtable pkCache_ = null;
  /** amount of PKf fetched at once */
  private static int cacheSize_ = 50;
  
 
  protected static Log log;
  static
  {
    log = LogFactory.getLog(at.tugraz.genome.dbutilities.MYSQLPKGenerator.class);
  }


  /**
   * 
   * @param daoFactory factory for database connection
   * @return the pk generator
   */
    public static MYSQLPKGenerator getInstance(GenericDAOFactory daoFactory) {
        daoFactory_ = daoFactory;
        if (instance_ == null) {
            instance_ = new MYSQLPKGenerator();
        }
        return instance_;
    }

  /**
   * 
   * @return MySQL pk generator as singleton
   */
  public static MYSQLPKGenerator getInstance() {
    log.info("create instance MYSQLPKGenerator");
    if (instance_ == null) {
      instance_ = new MYSQLPKGenerator();
    }
    return instance_;
  }
  
  /**
   * initialization of the singleton
   *
   */
  private MYSQLPKGenerator() {
    pkCache_ = new Hashtable();
  }

  /**
   * Returns the primary key for the given table for an MYSQL database.
   * @param tableName The name of the table the primary key is used for
   * @return The primary key. A unique number, or NULL if the primary key
   * is not available.
   */
  public Long getPrimaryKey(String tableName) {
    Long pk = null; 
    log.debug("##create primary key##");
    String sequenceTable = tableName.replaceAll("-", "_").toUpperCase()+"SEQ";
    ArrayList pkList = (ArrayList)pkCache_.get(sequenceTable);
    if (pkList != null) {
        Long cachedPK = (Long)pkList.remove(0);
        if (pkList.size() == 0) {
            pkCache_.remove(sequenceTable);
        }
        pk = cachedPK;
    }else{
      Connection con = daoFactory_.createConnection();
      ArrayList currentPKList = new ArrayList();
      if (!checkTableExists(sequenceTable,con)) {    
        createTable(sequenceTable,con);
        pk = new Long(100);
      }else{
        if (!checkEntryExists(sequenceTable,con)){
          addRequiredProperties(sequenceTable, con);
          pk = new Long(100);
        }else{  
          try { 
            String sqlQuery = "select id from "+sequenceTable;
            PreparedStatement stmt = con.prepareStatement(sqlQuery);          
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
              pk = new Long(rs.getLong(1));
            }
            rs.close();
            stmt.close();
            String sqlUpdate = "UPDATE "+sequenceTable+" SET id = ? WHERE (id = ?)";
            stmt = con.prepareStatement(sqlUpdate);
            stmt.setLong(1, pk.longValue()+Long.parseLong(String.valueOf(cacheSize_)));
            stmt.setLong(2, pk.longValue());
 
            stmt.executeUpdate();
            stmt.close();
          } catch (java.sql.SQLException sqlExc) {
            sqlExc.printStackTrace();            
          } finally {
            try {
              con.close();
            } catch (java.sql.SQLException sqlExc) {
              sqlExc.printStackTrace();
            }
          }
        }
      }  
      for (int i=0; i<cacheSize_; i++) {
        currentPKList.add(pk);
        pk = new Long(pk.longValue()+1);  
      }
      pk = (Long)currentPKList.remove(0);  //retrieve first element in order to avoid duplicate PKs            
      pkCache_.put(sequenceTable, currentPKList);
    }
    return pk;
  }

  public String toString() {
    return "MYSQLPKGenerator";
  }
  
  /**
   * Checks if the desired table exists
   * @param tableName name of the database table
   * @param con database connection
   * @return true when it exists
   */
  private boolean checkTableExists(String tableName, Connection con) {
    String sqlStatement = "SELECT * FROM "+tableName;
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con.prepareStatement(sqlStatement);
      rs = pStmt.executeQuery();
      rs.close();
      pStmt.close();
      return true;
    } catch (SQLException ex) {
      try {
        pStmt.close();
      }
      catch (SQLException ex1) {
      }
      return false;
    }
  }
  
  /**
   * checks if a sequence table for the corresponding table exists
   * @param tableName name of the sequence table
   * @param con database connection
   * @return true if it exists
   */
  private boolean checkEntryExists(String tableName, Connection con) {
    String sqlStatement = "SELECT COUNT(*) FROM "+tableName;
    PreparedStatement pStmt = null;
    ResultSet rs = null;
    try {
      pStmt = con.prepareStatement(sqlStatement);
      rs = pStmt.executeQuery();
      Long nrOfEntries = new Long(0);
      if (rs.next()){
        nrOfEntries = new Long(rs.getLong(1));
      }
      rs.close();
      pStmt.close();
      if ((nrOfEntries.longValue()>0)){
        return true;
      }
      return false;
    } catch (SQLException ex) {
      try {
        pStmt.close();
      }
      catch (SQLException ex1) {
        return false;
      }
      return false;
    }
  }
  
  /**
   * creates a sequence table to fetch the PKs
   * @param tableName name of the sequence table
   * @param con database connection
   * @return true if it has been created successfully
   */
  private boolean createTable(String tableName, Connection con) {
    String sqlStatement = null;
    sqlStatement = "CREATE TABLE "+tableName+" (\n ID BIGINT(20)\n)";
    PreparedStatement pStmt = null;
    try {
      pStmt = con.prepareStatement(sqlStatement);
      pStmt.execute();
      pStmt.close();
      addRequiredProperties(tableName, con);
      return true;
    }catch (SQLException ex) {
      ex.printStackTrace();
      try {
        pStmt.close();
      }
      catch (SQLException ex1) {
      }
      return false;
    }        
  }
  
  /**
   * adds the actual sequence value into the database
   * @param tableName name of the sequence table
   * @param con database connection
   */
  private void addRequiredProperties(String tableName, Connection con) {
    String sqlStatement = "INSERT INTO "+tableName+" VALUES (?)";
    PreparedStatement pStmt = null;
    try {
      pStmt = con.prepareStatement(sqlStatement);
      pStmt.setLong(1, 150);
      pStmt.executeUpdate();
      pStmt.close();
    }catch (SQLException ex) {
      ex.printStackTrace();
      try {
        pStmt.close();
      }catch (SQLException ex1) {
      }
    } finally {
      try {
        con.close();
      } catch (java.sql.SQLException sqlExc) {
        sqlExc.printStackTrace();
      }
  }    
  }
  
  public void setPkValuesAtBeginning(Connection con, String tableName) throws SQLException{
    String sequenceTable = tableName.replaceAll("-", "_").toUpperCase()+"SEQ";
    if (checkTableExists(sequenceTable,con)) {   
      String sqlQuery = "select id from "+sequenceTable;
      PreparedStatement stmt = con.prepareStatement(sqlQuery);          
      ResultSet rs = stmt.executeQuery();
      Long pk = null;
      if (rs.next()) {
        pk = new Long(rs.getLong(1));
      }
      rs.close();
      stmt.close();
      if (pk!=null){
        pkCache_.remove(tableName);
        String sqlUpdate = "UPDATE "+sequenceTable+" SET id = ? WHERE (id = ?)";
        stmt = con.prepareStatement(sqlUpdate);
        stmt.setLong(1, new Long(100));
        stmt.setLong(2, pk.longValue());

        stmt.executeUpdate();
        stmt.close();
      }
    }
  }

}
