package at.tugraz.genome.dbutilities;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.io.CharArrayReader;

import org.andromda.core.common.StringUtilsHelper;
import org.apache.log4j.Logger;

public abstract class GenericDAOImpl implements GenericDAOInterface
{

  protected static Logger log_ = Logger.getLogger(at.tugraz.genome.dbutilities.GenericDAOImpl.class);
  protected GenericDAOFactory factory_; 
  protected PKGenerator pkGenerator;
  
  protected Hashtable columnNamesCache = new Hashtable();
  protected Hashtable fkColumnsCache = new Hashtable();
  protected Hashtable referenceTablesCache = new Hashtable();
  protected Hashtable pkColumnNamesCache = new Hashtable();
  protected Hashtable fkNameInReferencingTableCache = new Hashtable();
  // for m:n relations
  protected Hashtable collectionNameCache = new Hashtable();
  protected Hashtable fkColumnNameCache = new Hashtable();
  protected Hashtable fkColumnThisTableNameCache = new Hashtable();
  
  
  public List selectAll(String tableName, String pkFieldName, DatabaseTableField orderBy, String direction) {
    log_.debug("selectAll");
    List list = null;
    Connection con = factory_.createConnection();
    String sqlSelect = "SELECT " + pkFieldName + " FROM " + tableName;
    if (orderBy != null) {
        if (orderBy != null) {
            log_.debug("FIELDNAME 3: " + this.getTableNames(orderBy));
        }

        if (orderBy.isFake()) {
            sqlSelect = sqlSelect + ", " + orderBy.getFakeTableName();
            //FIXME: add additional where statement to select empty buffers
            //        sqlSelect = sqlSelect + " AND
            // ("+orderBy.getDBTableName()+"."+orderBy.getFakeTableConnectorFieldName()+"="+orderBy.getFakeTableName()+"."+orderBy.getFakeDBTableField()+")";
            sqlSelect = sqlSelect + " AND (" + orderBy.getDBTableName() + "." + orderBy.getFakeDBTableField() + "="
                    + orderBy.getFakeTableName() + "." + orderBy.getFakeTableConnectorFieldName() + ")";
            sqlSelect = sqlSelect + " ORDER BY " + orderBy.getFakeTableName() + "." + orderBy.getFakeOrderByField();
        }
        if (!orderBy.isFake()) {
            sqlSelect = sqlSelect + " ORDER BY " + orderBy.getDBTableName() + "." + orderBy.getDBFieldName();
        } else {
        }
    }
    if ((direction != null) && ((direction.toUpperCase().equals("ASC") || (direction.toUpperCase().equals("DESC"))))) {
        sqlSelect = sqlSelect + " " + direction;
    }
    try {
        PreparedStatement pStmt = con.prepareStatement(sqlSelect, ResultSet.TYPE_FORWARD_ONLY,
                ResultSet.CONCUR_READ_ONLY);
        ResultSet rs = pStmt.executeQuery();
        list = prepareResult(rs);
        rs.close();
        pStmt.close();
        con.close();
        return list;
    } catch (java.sql.SQLException sqlExc) {
        log_.error(sqlExc);
    }
    return null;
  }

    public List selectCustom(String tableName, String tableNameAlias, String pkFieldName, Collection searchCriteria,
        DatabaseTableField orderBy, String direction) {
      log_.debug("selectCustom");
    List list = null;
    Connection con = factory_.createConnection();
    String sqlSelect = "SELECT " + tableNameAlias + "." + pkFieldName + " FROM ";
    String[] tables = this.getTableNames(searchCriteria);
    Hashtable tableHash = new Hashtable();
    //all tables of the searchCriteria are there
    //except if one has to left joined
  
    if (orderBy != null) {
        log_.debug("FIELDNAME 2: " + this.getTableNames(orderBy));
    }
  
    if ((orderBy != null) && (orderBy.isFake()) && (orderBy.getFakeTableName() != null)) {
  
        String dummyTable = orderBy.getFakeTableName();
        if (orderBy.getFakeTableAlias() != null) {
            dummyTable = dummyTable + " " + orderBy.getFakeTableAlias();
        }
        for (int i = 0; i < tables.length; i++) {
            if (!tables[i].equalsIgnoreCase(dummyTable)) {
                tableHash.put(tables[i], tables[i]);
                sqlSelect = sqlSelect + tables[i] + ", ";
            }
        }
    } else {
        for (int i = 0; i < tables.length; i++) {
            tableHash.put(tables[i], tables[i]);
            sqlSelect = sqlSelect + tables[i] + ", ";
        }
    }
    log_.debug("sqlSelect A: " + sqlSelect);
    if (orderBy != null) { //check if orderBy contains additional tables
        if (orderBy.isFake()) {
            if (orderBy.getSQLSubStatement() != null) {
                String[] additionalTables = this.getTableNames(orderBy);
                for (int i = 0; i < additionalTables.length; i++) {
                    if (!tableHash.containsKey(additionalTables[i])) {
                        tableHash.put(additionalTables[i], additionalTables[i]);
                        sqlSelect = sqlSelect + additionalTables[i] + ", ";
                    }
                }
            }
        }
    }
    log_.debug("sqlSelect B: " + sqlSelect);
    sqlSelect = sqlSelect + tableName + " " + tableNameAlias;
    log_.debug("sqlSelect C: " + sqlSelect);
    //Left join
    String whereStatmentInLeftJoin = "";
    if ((orderBy != null) && (orderBy.isFake()) && (orderBy.getFakeTableName() != null)) {
        String dummyTable = orderBy.getFakeTableName();
        if (orderBy.getFakeTableAlias() != null) {
            dummyTable = dummyTable + " " + orderBy.getFakeTableAlias();
        }
        whereStatmentInLeftJoin = this.generateWhereStatementInLeftJoin(orderBy, whereStatmentInLeftJoin);
        sqlSelect = sqlSelect + " LEFT JOIN " + dummyTable + " ON " + whereStatmentInLeftJoin;
    }
  
    sqlSelect = sqlSelect + " WHERE " + generateWhereClause(searchCriteria);
    if (whereStatmentInLeftJoin.length() > 0) {
        sqlSelect = sqlSelect + " AND " + whereStatmentInLeftJoin;
    }
    log_.debug("sqlSelect D: " + sqlSelect);
    if (orderBy != null) {
        if (orderBy.getANDCombinedFields().size() > 0) {
            sqlSelect = sqlSelect + " AND " + generateWhereClause(orderBy.getANDCombinedFields());
        }
        if (orderBy.getORCombinedFields().size() > 0) {
            sqlSelect = sqlSelect + " OR " + generateWhereClause(orderBy.getANDCombinedFields());
        }
        if (orderBy.getSQLSubStatement() == null) {
            if (orderBy.isFake()) {
                if (orderBy.getFakeTableAlias() != null) {
                    sqlSelect = sqlSelect + " ORDER BY " + orderBy.getFakeTableAlias() + "."
                            + orderBy.getFakeOrderByField();
                } else {
                    sqlSelect = sqlSelect + " ORDER BY " + orderBy.getFakeTableName() + "."
                            + orderBy.getFakeOrderByField();
                }
            } else {
                if (orderBy.getDBTableAlias() != null) {
                    sqlSelect = sqlSelect + " ORDER BY " + orderBy.getDBTableAlias() + "." + orderBy.getDBFieldName();
                } else {
                    sqlSelect = sqlSelect + " ORDER BY " + orderBy.getDBTableName() + "." + orderBy.getDBFieldName();
                }
            }
        } else {
            if ((orderBy.getFakeTableAlias() != null) && (orderBy.getFakeTableName() != null)) {
                if (orderBy.getDBTableAlias() != null) {
                    sqlSelect = sqlSelect + " AND (" + orderBy.getDBTableAlias();
                } else {
                    sqlSelect = sqlSelect + " AND (" + orderBy.getDBTableName();
                }
                sqlSelect = sqlSelect + "." + orderBy.getDBFieldName() + " = ";
                if (orderBy.getFakeTableAlias() != null) {
                    sqlSelect = sqlSelect + orderBy.getFakeTableAlias() + "." + orderBy.getFakeTableConnectorFieldName()
                            + ") ";
                } else {
                    sqlSelect = sqlSelect + orderBy.getFakeTableName() + "." + orderBy.getFakeTableConnectorFieldName()
                            + ") ";
                }
            } else {
                for (int i = 0; i < orderBy.getFakeTableAliases().length; i++) {
                    if (orderBy.getDBTableAlias() != null) {
                        sqlSelect = sqlSelect + " AND (" + orderBy.getDBTableAlias();
                    } else {
                        sqlSelect = sqlSelect + " AND (" + orderBy.getDBTableName();
                    }
                    sqlSelect = sqlSelect + "." + orderBy.getDBFieldName() + " = ";
                    if (orderBy.getFakeTableAliases()[i] != null) {
                        sqlSelect = sqlSelect + orderBy.getFakeTableAliases()[i] + "."
                                + orderBy.getFakeTableConnectorFieldName() + ") ";
                    } else {
                        sqlSelect = sqlSelect + orderBy.getFakeTableNames()[i] + "."
                                + orderBy.getFakeTableConnectorFieldName() + ") ";
                    }
                }
            }
            sqlSelect = sqlSelect + " ORDER BY " + orderBy.getSQLSubStatement();
        }
    }
    if ((direction != null) && ((direction.toUpperCase().equals("ASC") || (direction.toUpperCase().equals("DESC"))))) {
        sqlSelect = sqlSelect + " " + direction;
    }
    log_.info("SQL Statement: " + sqlSelect);
    try {
        PreparedStatement pStmt = con.prepareStatement(sqlSelect, ResultSet.TYPE_FORWARD_ONLY,
                ResultSet.CONCUR_READ_ONLY);
        ResultSet rs = pStmt.executeQuery();
        list = prepareResult(rs);
        rs.close();
        pStmt.close();
        con.close();
        return list;
    } catch (java.sql.SQLException sqlExc) {
        log_.error(sqlExc);
    }
    return null;
    }

    public List selectCustom(String tableName, String pkFieldName, Collection searchCriteria, DatabaseTableField orderBy,
        String direction) {
      return this.selectCustom(tableName, pkFieldName, searchCriteria, orderBy, direction, null);   
   }

    /**
     * Allows to query, whereby the tables for the select statement can be explicitely chosen
     * @param tableName name of the database table
     * @param pkFieldName name of the field which will be returned (normally the PK)
     * @param searchCriteria collection of query criteria (SearchableField)
     * @param orderBy entries are sorted by this field
     * @param direction direction of sorting "asc" for ascending or "desc" for descending
     * @param selectTables database table fields for the from statement
     * @author hartler 
     */
    public List selectCustom(String tableName, String pkFieldName, Collection searchCriteria, DatabaseTableField orderBy,
        String direction, Collection selectTables) {
      return this.selectCustom(tableName, pkFieldName, searchCriteria, orderBy,direction, selectTables,null);
    }

    /**
     * Allows to query, whereby the tables for the select statement can be explicitely chosen,
     * or even explicitely hard coded with the String fromStatement
     * @param tableName name of the database table
     * @param pkFieldName name of the field which will be returned (normally the PK)
     * @param searchCriteria collection of query criteria (SearchableField)
     * @param orderBy entries are sorted by this field
     * @param direction direction of sorting "asc" for ascending or "desc" for descending
     * @param selectTables database table fields for the from statement
     * @param fromStatement explicit string for the fromStatement 
     */
      public List selectCustom(String tableName, String pkFieldName, Collection searchCriteria, DatabaseTableField orderBy,
          String direction, Collection selectTables, String fromStatement) {
      log_.debug("++++ selectCustom");
      List list = null;
      String sqlSelect = "SELECT " + tableName + "." + pkFieldName + " FROM ";
      if (selectTables!=null&&selectTables.size()>0){
        sqlSelect = "SELECT " + tableName + "." + pkFieldName;
        Iterator it = selectTables.iterator();
        while(it.hasNext()){
          sqlSelect = sqlSelect+", ";
          DatabaseTableField field = (DatabaseTableField)it.next();
          sqlSelect = sqlSelect+field.getDBTableName()+"."+field.getDBFieldName();
        }
        sqlSelect = sqlSelect+" FROM ";
      }
      if (fromStatement==null||fromStatement.length()<1){
        String[] aTables = this.getTableNames(searchCriteria);
        String[] bTables = new String[0];
        if (orderBy != null) {
          bTables = this.getTableNames(orderBy);
        }
        Hashtable tableHash = new Hashtable();
        //    String[] tables = new String[aTables.length+bTables.length];
        for (int i = 0; i < aTables.length; i++) {
          tableHash.put(aTables[i], aTables[i]);
          //      tables[i] = aTables[i];
        }
        for (int i = 0; i < bTables.length; i++) {
          tableHash.put(bTables[i], bTables[i]);
        }
        String[] tables = new String[tableHash.size()];
        java.util.Enumeration enumer = tableHash.elements();
        int z = 0;
        while (enumer.hasMoreElements()) {
          tables[z] = (String) enumer.nextElement();
          z++;
        }
        /*
         * for (int i=aTables.length; i <aTables.length+bTables.length; i++) {
         * tables[i] = bTables[i-aTables.length]; }
         */
        for (int i = 0; i < tables.length; i++) {
          if ((orderBy != null) && (orderBy.isFake()) && (orderBy.getFakeTableName().equals(tables[i]))) {
  
          } else {
              sqlSelect = sqlSelect + tables[i] + ",";
          }
        }
        sqlSelect = sqlSelect + tableName;
        if ((orderBy != null) && (orderBy.isFake())) {
          log_.debug("XXXX   sqlSelect: " + sqlSelect);
          if (sqlSelect.indexOf(orderBy.getDBTableName() + ",") != -1) {
              log_.debug("sqlSelect: found item");
              sqlSelect = sqlSelect.replaceAll(orderBy.getDBTableName() + ",", "");
              sqlSelect = sqlSelect + ", " + orderBy.getDBTableName();
          }
          log_.debug("xxxx   sqlSelect: " + sqlSelect);
  //        sqlSelect = sqlSelect + " LEFT JOIN " + orderBy.getFakeTableName() + " ON (" + orderBy.getDBTableName() + "."
  //                + orderBy.getDBFieldName() + "=" + orderBy.getFakeTableName() + "."
  //                + orderBy.getFakeTableConnectorFieldName() + ")";
        sqlSelect = sqlSelect + " LEFT JOIN " + orderBy.getFakeTableName() + " ON "+this.generateWhereStatementInLeftJoin(orderBy,"");
  
        }
      }else{
        sqlSelect = sqlSelect+fromStatement;
      }
  
      sqlSelect = sqlSelect + " WHERE " + generateWhereClause(searchCriteria);
  
      if (orderBy != null) {
          if (orderBy.getANDCombinedFields().size() > 0) {
              sqlSelect = sqlSelect + " AND " + generateWhereClause(orderBy.getANDCombinedFields());
          }
          if (orderBy.getORCombinedFields().size() > 0) {
              sqlSelect = sqlSelect + " OR " + generateWhereClause(orderBy.getANDCombinedFields());
          }
  
          if (orderBy.isFake()) {
              sqlSelect = sqlSelect + " ORDER BY " + orderBy.getFakeTableName() + "." + orderBy.getFakeOrderByField();
          } else {
              if ((orderBy.getDBTableAlias() == null) || (orderBy.getDBTableAlias().trim().equals(""))) {
                  sqlSelect = sqlSelect + " ORDER BY " + orderBy.getDBTableName() + "." + orderBy.getDBFieldName();
              } else {
                  sqlSelect = sqlSelect + " ORDER BY " + orderBy.getDBTableAlias() + "." + orderBy.getDBFieldName();
              }
          }
      }
      if ((direction != null) && ((direction.toUpperCase().equals("ASC") || (direction.toUpperCase().equals("DESC"))))) {
          sqlSelect = sqlSelect + " " + direction;
      }
      log_.info("SQL Statement: " + sqlSelect);
      try {
          Connection con = factory_.createConnection();
          PreparedStatement pStmt = con.prepareStatement(sqlSelect, ResultSet.TYPE_FORWARD_ONLY,
                  ResultSet.CONCUR_READ_ONLY);
          ResultSet rs = pStmt.executeQuery();
          if (selectTables!=null&&selectTables.size()>0){
            list = prepareResult(rs,selectTables);    
          }else{
            list = prepareResult(rs);
          }  
          rs.close();
          pStmt.close();
          con.close();
          return list;
      } catch (java.sql.SQLException sqlExc) {
          log_.error(sqlExc);
      }
      return null;
  }

  /** 
   * Processes the results returned from the database (elimation of doubled PK entries)
   * @param rs result set from the database
   * @return cleaned list
   * @throws java.sql.SQLException
   */
  protected List prepareResult(ResultSet rs) throws java.sql.SQLException {
    Hashtable ht = new Hashtable();
    ArrayList list = new ArrayList();
    while (rs.next()) {
        Long key = new Long(rs.getLong(1));
        if (ht.get(key) == null) {
            ht.put(key, key);
            list.add(key);
        } else {
            log_.debug("key already in list");
        }
    }
    return list;
  }

  /**
   * Processes the results returned from the database (elimation of doubled PK entries)
   * and reads additional information defined by selectTables
   * @param rs result set from the database
   * @param selectTables columns which are returned additionally to the PK
   * @return cleaned List
   * @throws java.sql.SQLException
   * @author hartler
   */
  protected List prepareResult(ResultSet rs, Collection selectTables) throws java.sql.SQLException {
    Hashtable ht = new Hashtable();
    ArrayList list = new ArrayList();
    while (rs.next()) {
        Long key = new Long(rs.getLong(1));
        Vector values = new Vector();
//        if (ht.get(key) == null) {
            ht.put(key, key);
            values.add(key);
            //list.add(key);
            Iterator it = selectTables.iterator();
            int count = 1;
            while (it.hasNext()){
              count++;
              DatabaseTableField field = ((DatabaseTableField)it.next());
              if (field.getDBFieldDisplayName().equalsIgnoreCase("java.lang.Long")){
                values.add(new Long(rs.getLong(count)));  
              }
              if (field.getDBFieldDisplayName().equalsIgnoreCase("java.lang.String")){
                values.add(rs.getString(count));  
              }  
              if (field.getDBFieldDisplayName().equalsIgnoreCase("java.lang.Double")){
                values.add(new Double(rs.getDouble(count)));  
              }
              if (field.getDBFieldDisplayName().equalsIgnoreCase("java.lang.Integer")){
                values.add(new Integer(rs.getInt(count)));  
              }
              if (field.getDBFieldDisplayName().equalsIgnoreCase("java.lang.Boolean")){
                values.add(rs.getBoolean(count));  
              }
            }
            list.add(values);
        if (ht.get(key) == null) {                
        } else {
            log_.debug("key already in list");
        }
    }
    return list;
  }    

    public String[] getTableNames(Collection searchCriteria) {
      log_.debug("+++ getTableNames()");
      java.util.Hashtable hashtable = new java.util.Hashtable();
      Iterator iterator = searchCriteria.iterator();
      while (iterator.hasNext()) {
          SearchableField field = (SearchableField) iterator.next();
          if (field.isFake()) {
              //        log_.info("1");
              if (field.getFakeTableAlias() != null) {
                  //          log_.info("1a");
                  if (field.getFakeTableName() != null) {
                      hashtable.put(new Integer((field.getFakeTableName() + " " + field.getFakeTableAlias()).hashCode()),
                              field.getFakeTableName() + " " + field.getFakeTableAlias());
                  }
              } else {
                  //          log_.info("1b");
                  if (field.getFakeTableName() != null) {
                      hashtable.put(new Integer(field.getFakeTableName().hashCode()), field.getFakeTableName());
                  }
              }
              //        log_.info("2");
              if (field.getFakeTableAliases() != null) {
                  //          log_.info("2a");
                  if (field.getFakeTableNames() != null) {
                      for (int i = 0; i < field.getFakeTableAliases().length; i++) {
                          hashtable.put(new Integer((field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i])
                                  .hashCode()), field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i]);
                      }
                  }
              } else {
                  //          log_.info("2b");
                  if (field.getFakeTableNames() != null) {
                      for (int i = 0; i < field.getFakeTableNames().length; i++) {
                          hashtable.put(new Integer((field.getFakeTableNames()[i]).hashCode()),
                                  field.getFakeTableNames()[i]);
                      }
                  }
              }
              //        log_.info("3");
          }
  
          log_.debug("+++ fetching additional tables");
          String[] additionalTables = field.getAdditionalTables();
          for (int i = 0; i < additionalTables.length; i++) {
              hashtable.put(new Integer(additionalTables[i].hashCode()), additionalTables[i]);
          }
          log_.debug("--- fetching additional tables: " + additionalTables.length);
      }
      String[] retValues = new String[hashtable.size()];
      iterator = hashtable.values().iterator();
      int i = 0;
      while (iterator.hasNext()) {
          retValues[i] = (String) iterator.next();
          log_.debug("* " + retValues[i]);
          i++;
      }
      log_.debug("--- getTableNames(): " + retValues);
      return retValues;
  }

    public String[] getTableNames(DatabaseTableField field) {
      log_.debug("+++ getTableNames(): " + field);
      java.util.Hashtable hashtable = new java.util.Hashtable();
      //    log_.info("1");
      if (field.getFakeTableAlias() != null) {
          //      log_.info("1a");
          if (field.getFakeTableName() != null) {
              hashtable.put(new Integer((field.getFakeTableName() + " " + field.getFakeTableAlias()).hashCode()), field
                      .getFakeTableName()
                      + " " + field.getFakeTableAlias());
          }
      } else {
          //      log_.info("1b");
          if (field.getFakeTableName() != null) {
              hashtable.put(new Integer(field.getFakeTableName().hashCode()), field.getFakeTableName());
          }
      }
      //    log_.info("2");
      if (field.getFakeTableAliases() != null) {
          //      log_.info("2a");
          if (field.getFakeTableNames() != null) {
              for (int i = 0; i < field.getFakeTableAliases().length; i++) {
                  hashtable.put(new Integer((field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i])
                          .hashCode()), field.getFakeTableNames()[i] + " " + field.getFakeTableAliases()[i]);
              }
          }
      } else {
          //      log_.info("2b");
          if (field.getFakeTableNames() != null) {
              for (int i = 0; i < field.getFakeTableNames().length; i++) {
                  hashtable.put(new Integer((field.getFakeTableNames()[i]).hashCode()), field.getFakeTableNames()[i]);
              }
          }
      }
      log_.debug("+++ fetching additional tables");
      String[] additionalTables = field.getAdditionalTables();
      for (int i = 0; i < additionalTables.length; i++) {
          hashtable.put(new Integer(additionalTables[i].hashCode()), additionalTables[i]);
      }
      log_.debug("--- fetching additional tables: " + additionalTables.length);

      String[] retValues = new String[hashtable.size()];
      Iterator iterator = hashtable.values().iterator();
      int numElements = hashtable.values().size();
      int i = 0;
      while (iterator.hasNext()) {
          retValues[i] = (String) iterator.next();
          i++;
      }
      log_.debug("--- getTableNames(): " + retValues);
      return retValues;
  }
  
      public String generateWhereClause(Collection searchCriteria) {
        String whereClause = "";
        if ((searchCriteria == null) || (searchCriteria.size() == 0)) {
            whereClause = "(1=1)";
        } else {
            Iterator iterator = searchCriteria.iterator();
            while (iterator.hasNext()) {
                if (whereClause.trim().length() > 0) {
                    whereClause = whereClause + " AND ";
                }
                SearchableField field = (SearchableField) iterator.next();
                if (field.getORCombinedFields().size() > 0) {
                    whereClause = whereClause + "(";
                }
                whereClause = whereClause + parseField(field);
                if (field.getORCombinedFields().size() > 0) {
                    whereClause = whereClause + " OR " + generateWhereClause(field.getORCombinedFields()) + ")";
                }
  
                if (field.getANDCombinedFields().size() > 0) {
                    whereClause = whereClause + " AND " + generateWhereClause(field.getANDCombinedFields());
                }
            }
        }
        log_.info("WHERECLAUSE: " + whereClause);
        return whereClause;
    }
  
      public static String parseField(SearchableField field) {
      String whereClause = "";
      if (field.getOperator().equalsIgnoreCase("like")||field.getOperator().equalsIgnoreCase("not like")) {
          String searchValue = field.getSearchValue();
          searchValue = searchValue.replace('*', '%');
          searchValue = searchValue.replace('?', '_');
          searchValue = searchValue.toUpperCase();
          field.setSearchValue(searchValue);
      }
      if (field.isFake()) {
          if ((field.getFakeTableConnectorFieldName() != null) && (field.getDBFieldName() != null)) {
              whereClause = GenericDAOImpl.findConnectorConstraints(field, whereClause);
          }
          
          if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
              //adapt searchValue (BETWEEN value1 AND value2)
              String searchValue = field.getSearchValue();
              searchValue = searchValue.trim();
              java.util.regex.Pattern pattern = java.util.regex.Pattern
                      .compile("([-+a-zA-Z_0-9\\s\\.]+),([-+a-zA-Z_0-9\\s\\.]+)");
              java.util.regex.Matcher matcher = pattern.matcher(searchValue);
              if (matcher.matches()) {
                log_.debug("MATCH BETWEEN");
                  String value1 = matcher.group(1).trim();
                  String value2 = matcher.group(2).trim();
                  if (field.getSQLSubStatement() != null) {
                      whereClause = whereClause + "(" + field.getSQLSubStatement() + " " + field.getOperator() + " " + "'"
                              + value1 + "'" + " AND " + "'" + value2 + "'" + ")";
                  } else {
                      if (field.getFakeTableAlias() != null) {
                          whereClause = whereClause + "(" + field.getFakeTableAlias() + "." + field.getFakeDBTableField()
                                  + " " + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'"
                                  + ")";
                      } else {
                          whereClause = whereClause + "(" + field.getFakeTableName() + "." + field.getFakeDBTableField()
                                  + " " + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'"
                                  + ")";
                      }
                  }
              } else {
                  //throw Exception
                  //FIXME
              }
          } else {
              if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
                  //adapt searchValue (IN (value1, value2, ...))
                  String searchValue = field.getSearchValue();
                  searchValue = searchValue.trim();
                  if (!searchValue.endsWith(",")) {
                      searchValue = searchValue + ",";
                  }
                  java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("([-+a-zA-Z_0-9\\s\\.]{1,},){1,}");
                  java.util.regex.Matcher matcher = pattern.matcher(searchValue);
                  //adapt searchValue from value1,value2, to
                  // 'value1','value2'
                  if (matcher.matches()) {
                      log_.debug("MATCH IN");
                      //                whereClause = whereClause
                      // +"("+field.getFakeTableName()+"."+field.getFakeDBTableField()+"
                      // "+field.getOperator()+"
                      // ("+"'"+field.getSearchValue().trim()+"'"+"))";
                      if (field.getSQLSubStatement() != null) {
                          whereClause = whereClause + "(" + field.getSQLSubStatement() + " " + field.getOperator() + " ('"
                                  + field.getSearchValue().trim().replaceAll(",", "','") + "'))";
                      } else {
                          if (field.getFakeTableAlias() != null) {
                              whereClause = whereClause + "(" + field.getFakeTableAlias() + "."
                                      + field.getFakeDBTableField() + " " + field.getOperator() + " ('"
                                      + field.getSearchValue().trim().replaceAll(",", "','") + "'))";
                          } else {
                              whereClause = whereClause + "(" + field.getFakeTableName() + "."
                                      + field.getFakeDBTableField() + " " + field.getOperator() + " ('"
                                      + field.getSearchValue().trim().replaceAll(",", "','") + "'))";
                          }
                      }
                  } else {
                      //throw Exception
                      //FIXME
                  }
              } else {
                  if (field.getOperator().equalsIgnoreCase("like")||field.getOperator().equalsIgnoreCase("not like")) {
                      if (field.getSQLSubStatement() != null) {
                          whereClause = whereClause + "(UPPER(" + field.getSQLSubStatement() + ") " + field.getOperator()
                                  + " " + "'" + field.getSearchValue() + "'" + ")";
                      } else {
                          if (field.getFakeTableAlias() != null) {
                              whereClause = whereClause + "(UPPER(" + field.getFakeTableAlias() + "."
                                      + field.getFakeDBTableField() + ") " + field.getOperator() + " " + "'"
                                      + field.getSearchValue() + "'" + ")";
                          } else {
                              whereClause = whereClause + "(UPPER(" + field.getFakeTableName() + "."
                                      + field.getFakeDBTableField() + ") " + field.getOperator() + " " + "'"
                                      + field.getSearchValue() + "'" + ")";
                          }
                      }
                  } else {
                      if (field.getSQLSubStatement() != null) {
                          whereClause = whereClause + "(" + field.getSQLSubStatement();
                      } else {
                          if (field.getFakeTableAlias() != null) {
                              whereClause = whereClause + "(" + field.getFakeTableAlias() + "."
                                      + field.getFakeDBTableField() + " ";
                          } else {
                              whereClause = whereClause + "(" + field.getFakeTableName() + "."
                                      + field.getFakeDBTableField() + " ";
                          }
                      }
                      if (field.getOperator().equalsIgnoreCase("=")&&field.getSearchValue().equalsIgnoreCase("null")){
                        whereClause += "IS NULL)";
                      }else if (field.getOperator().equalsIgnoreCase("<>")&&field.getSearchValue().equalsIgnoreCase("null")){
                        whereClause += "IS NOT NULL)";
                      }else{
                        whereClause += field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")";
                      }
                  }
              }
          }
  //        if (field.getDbField()!=)
      } else {
          if (field.getOperator().equalsIgnoreCase("between") || field.getOperator().equalsIgnoreCase("not between")) {
              //adapt searchValue (BETWEEN value1 AND value2)
              String searchValue = field.getSearchValue();
              searchValue = searchValue.trim();
              java.util.regex.Pattern pattern = java.util.regex.Pattern
                      .compile("([-+a-zA-Z_0-9\\s\\.]+),([-+a-zA-Z_0-9\\s\\.]+)");
              java.util.regex.Matcher matcher = pattern.matcher(searchValue);
              if (matcher.matches()) {
                log_.debug("MATCH BETWEEN");
                  String value1 = matcher.group(1).trim();
                  String value2 = matcher.group(2).trim();
                  if (field.getDBTableAlias() != null) {
                      whereClause = whereClause + "(" + field.getDBTableAlias() + "." + field.getDBFieldName() + " "
                              + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'" + ")";
                  } else {
                      whereClause = whereClause + "(" + field.getDBTableName() + "." + field.getDBFieldName() + " "
                              + field.getOperator() + " " + "'" + value1 + "'" + " AND " + "'" + value2 + "'" + ")";
                  }
              } else {
                  //throw Exception
                  //FIXME
              }
          } else {
              if (field.getOperator().equalsIgnoreCase("in") || field.getOperator().equalsIgnoreCase("not in")) {
                  //adapt searchValue (IN (value1, value2, ...))
                  String searchValue = field.getSearchValue();
                  searchValue = searchValue.trim();
                  if (!searchValue.endsWith(",")) {
                      searchValue = searchValue + ",";
                  }
                  java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("([-+a-zA-Z_0-9\\s\\.]{1,},){1,}");
                  java.util.regex.Matcher matcher = pattern.matcher(searchValue);
                  if (matcher.matches()) {
                    log_.debug("MATCH IN");
                      //                whereClause = whereClause
                      // +"("+field.getDBTableName()+"."+field.getDBFieldName()+"
                      // "+field.getOperator()+"
                      // ("+"'"+field.getSearchValue().trim()+"'"+"))";
                      if (field.getDBTableAlias() != null) {
                          whereClause = whereClause + "(" + field.getDBTableAlias() + "." + field.getDBFieldName() + " "
                                  + field.getOperator() + " (" + "'"
                                  + field.getSearchValue().trim().replaceAll(",", "','") + "'" + "))";
                      } else {
                          whereClause = whereClause + "(" + field.getDBTableName() + "." + field.getDBFieldName() + " "
                                  + field.getOperator() + " (" + "'"
                                  + field.getSearchValue().trim().replaceAll(",", "','") + "'" + "))";
                      }
                  } else {
                      //throw Exception
                      //FIXME
                  }
              } else {
                  //          whereClause = whereClause +
                  // "("+field.getDBTableName()+"."+field.getDBFieldName()+"
                  // "+field.getOperator()+"
                  // "+"'"+field.getSearchValue()+"'"+")";
                  if (field.getOperator().equalsIgnoreCase("like")||field.getOperator().equalsIgnoreCase("not like")) {
                      if (field.getDBTableAlias() != null) {
                          whereClause = whereClause + "(UPPER(" + field.getDBTableAlias() + "." + field.getDBFieldName()
                                  + ") " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")";
                      } else {
                          whereClause = whereClause + "(UPPER(" + field.getDBTableName() + "." + field.getDBFieldName()
                                  + ") " + field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")";
                      }
                  } else {
                      if (field.getDBTableAlias() != null) {
                          whereClause = whereClause + "(" + field.getDBTableAlias() + "." + field.getDBFieldName() + " ";
                      } else {
                          whereClause = whereClause + "(" + field.getDBTableName() + "." + field.getDBFieldName() + " ";
                      }
                      if (field.getOperator().equalsIgnoreCase("=")&&field.getSearchValue().equalsIgnoreCase("null")){
                        whereClause += "IS NULL)";
                      }else if (field.getOperator().equalsIgnoreCase("<>")&&field.getSearchValue().equalsIgnoreCase("null")){
                        whereClause += "IS NOT NULL)";
                      }else{
                        whereClause += field.getOperator() + " " + "'" + field.getSearchValue() + "'" + ")";
                      }
                  }
              }
          }
      }
      if (field.getAdditionalWhereClause()!=null){
        whereClause = whereClause+field.getAdditionalWhereClause();
      }
      
      return whereClause;
  }

  protected String generateWhereStatementInLeftJoin(DatabaseTableField orderBy, String whereStatmentInLeftJoin){
    whereStatmentInLeftJoin = whereStatmentInLeftJoin+" (";
    String fakeTable = orderBy.getFakeTableAlias();
    if (fakeTable==null||fakeTable.length()<0){
      fakeTable = orderBy.getFakeTableName();
    }
    if (orderBy.getDBTableAlias() != null) {
      whereStatmentInLeftJoin = whereStatmentInLeftJoin + orderBy.getDBTableAlias() + "."
        + orderBy.getDBFieldName() + "=" + fakeTable + "."
        + orderBy.getFakeTableConnectorFieldName() + ")";
     } else {
       whereStatmentInLeftJoin = whereStatmentInLeftJoin + orderBy.getDBTableName() + "."
         + orderBy.getDBFieldName() + "=" + fakeTable + "."
         + orderBy.getFakeTableConnectorFieldName() + ")";
     }
      //  if (orderBy.getDbField()!=null){
      //    whereStatmentInLeftJoin = " AND ";
     //     whereStatmentInLeftJoin = this.generateWhereStatementInLeftJoin(orderBy.getDbField(), whereStatmentInLeftJoin);
     //   }
        return whereStatmentInLeftJoin;
    }
  
  protected static String findConnectorConstraints(DatabaseTableField field,String whereClause){
    if ((field.getFakeTableAlias() != null) && (field.getFakeTableName() != null)) {
        if (field.getDBTableAlias() != null) {
            whereClause = whereClause + "(" + field.getDBTableAlias();
        } else {
            whereClause = whereClause + "(" + field.getDBTableName();
        }
        whereClause = whereClause + "." + field.getDBFieldName() + " = ";
        if (field.getFakeTableAlias() != null) {
            whereClause = whereClause + field.getFakeTableAlias() + "." + field.getFakeTableConnectorFieldName()
                    + ") AND ";
        } else {
            whereClause = whereClause + field.getFakeTableName() + "." + field.getFakeTableConnectorFieldName()
                    + ") AND ";
        }
    } else {
        if (field.getFakeTableAliases() != null) {
            for (int i = 0; i < field.getFakeTableAliases().length; i++) {
                if (field.getDBTableAlias() != null) {
                    whereClause = whereClause + "(" + field.getDBTableAlias();
                } else {
                    whereClause = whereClause + "(" + field.getDBTableName();
                }
                whereClause = whereClause + "." + field.getDBFieldName() + " = ";
                if (field.getFakeTableAliases()[i] != null) {
                    whereClause = whereClause + field.getFakeTableAliases()[i] + "."
                            + field.getFakeTableConnectorFieldName() + ") AND ";
                } else {
                    whereClause = whereClause + field.getFakeTableNames()[i] + "."
                            + field.getFakeTableConnectorFieldName() + ") AND ";
                }
            }
        } else {
            if (field.getFakeTableName() != null) {
                if (field.getDBTableAlias() != null) {
                    whereClause = whereClause + "(" + field.getDBTableAlias();
                } else {
                    whereClause = whereClause + "(" + field.getDBTableName();
                }
                whereClause = whereClause + "." + field.getDBFieldName() + " = ";
                if (field.getFakeTableAlias() != null) {
                    whereClause = whereClause + field.getFakeTableAlias() + "."
                            + field.getFakeTableConnectorFieldName() + ") AND ";
                } else {
                    whereClause = whereClause + field.getFakeTableName() + "."
                            + field.getFakeTableConnectorFieldName() + ") AND ";
                }

            }
        }
    }
    if (field.getDbField()!=null){
      whereClause = GenericDAOImpl.findConnectorConstraints(field.getDbField(),whereClause);
    }
    return whereClause;
  }
  
  /**
   * Inserts an object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * @param object VO to insert
   * @return returns the generated PK for the object
   * @author hartler
   */
  public java.lang.Object insertVOByJDBC(Object object) {
    Connection con = null;
    PreparedStatement pStmt = null;
    pkGenerator = this.getPKGenerator();
    try {
        con = factory_.createConnection();
        Object pk = this.insertVOByJDBC(object, con, pStmt);
        con.close();
        return pk;
    } catch (SQLException sqx) {
        sqx.printStackTrace();
        try {
            if (pStmt != null) {
                pStmt.close();
            }
            con.close();
        } catch (SQLException ex1) {
            return null;
        }
        return null;
    }
  }

  /**
   * Inserts a collection of object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * @param collection collection of VOs to be inserted
   * @return returns collection of PKs for the objects
   * @author hartler
   */
  public Collection insertVOByJDBC(Collection collection) {
    Connection con = null;
    PreparedStatement pStmt = null;
    pkGenerator = this.getPKGenerator();
    if (collection != null && collection.size() > 0) {
        try {
            con = factory_.createConnection();
//            con.setAutoCommit(false);
            Collection pks = this.insertVOByJDBC(collection, con, pStmt);
            //        pStmt.close();
            con.close();
            return pks;
        } catch (SQLException sqx) {
            sqx.printStackTrace();
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                con.close();
//                con.rollback();
            } catch (SQLException ex1) {
                return null;
            }
        }
    }
    return null;
  }

  /**
   * Inserts a collection of object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * It is possible to run this method within the same database connection
   * @param collection collection of VOs to be inserted
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return returns collection of PKs for the objects
   * @author hartler
   */
  public Collection insertVOByJDBC(Collection coll, Connection con, PreparedStatement pStmt) throws SQLException {
    if (pkGenerator==null) this.pkGenerator = this.getPKGenerator();
    Vector pks = new Vector();
    Iterator it = coll.iterator();
    while (it.hasNext()) {
        pks.add(this.insertVOByJDBC(it.next(), con, pStmt));
    }
    return pks;
  }

  /**
   * Removes a VO and the whole underlying tree via JDBC statements
   * @param object object to be removed
   * @return if the operation has been successful
   */
  public boolean removeVOByJDBC(Object object) {
    boolean removed = false;
    Connection con = null;
    PreparedStatement pStmt = null;
    try {
        con = factory_.createConnection();
//        con.setAutoCommit(false);
        removed = this.removeVOByJDBC(object, con, pStmt);
        con.close();
        return removed;
    } catch (SQLException sqx) {
        sqx.printStackTrace();
        try {
            if (pStmt != null) {
                pStmt.close();
            }
            con.close();
//            con.rollback();
        } catch (SQLException ex1) {
            return removed;
        }
        return removed;
    }
  }

  /**
   * Removes a colection of VOs and the whole underlying tree via JDBC statements
   * @param objects objects to be removed
   * @return if the operation has been successful
   * @author hartler
   */
  public boolean removeVOByJDBC(Collection objects) {
    boolean removed = false;
    Connection con = null;
    PreparedStatement pStmt = null;
    try {
        con = factory_.createConnection();
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.removeVOByJDBC(it.next(), con, pStmt);
        }
        con.close();
        return removed;
    } catch (SQLException sqx) {
        sqx.printStackTrace();
        try {
            if (pStmt != null) {
                pStmt.close();
            }
            con.close();
        } catch (SQLException ex1) {
            return removed;
        }
        return removed;
    }

  }

  /**
   * Removes a colection of VOs and the whole underlying tree via JDBC statements
   * It is possible to run this method within the same database connection
   * @param pks objects to be removed
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return if the operation has been successful
   * @throws SQLException
   * @author hartler
   */  
  public boolean removeVOByJDBC(Collection pks, Connection con, PreparedStatement pStmt)throws SQLException{
    Iterator it = pks.iterator();
    while (it.hasNext()) {
        this.removeVOByJDBC(it.next(), con, pStmt);
    }
    return true;
  }

  /**
   * Inserts an object plus the whole VO tree to the database via JDBC statements.
   * It works only with VOs generated by the AndroMDA code generation template.
   * It is possible to run this method within the same database connection
   * @param object VO to insert
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return returns the generated PK for the object
   * @author hartler
   */
  public java.lang.Object insertVOByJDBC(Object object, Connection con, PreparedStatement pStmt) throws SQLException {
    if (pkGenerator==null) this.pkGenerator = this.getPKGenerator();
    Class objectClass = object.getClass();
    String tableName = "";
    String tableNameLowerCase = null;
    Object pk = null;
    if (objectClass.getName().endsWith("VO")) {
        StringTokenizer tokenizer = new StringTokenizer(objectClass.getName(), ".");
        while (tokenizer.hasMoreElements()) {
            tableNameLowerCase = tokenizer.nextToken();
        }
        tableNameLowerCase = tableNameLowerCase.substring(0, tableNameLowerCase.length() - 2);
        tableName = this.getDatabaseConformTablename(StringUtilsHelper.toDatabaseAttributeName(tableNameLowerCase, "_"));
        Method[] methods = objectClass.getMethods();
        boolean isPKSet = false;
        try {

            // the first Iteration is only important to set the primary Key
            // if it has not been set
            for (int i = 0; i != methods.length; i++) {
                if (methods[i].getName() != null && methods[i].getName().length() > 0
                        && methods[i].getName().equalsIgnoreCase("getPrimaryKey")) {
                    Object[] attributes = null;
                    Object pkObject = methods[i].invoke(object, attributes);
                    //              pkType = pkObject.getClass().getn
                    if (pkObject != null) {
                        pk = pkObject;
                        isPKSet = true;
                    } else {
                        // PKGenerator is implemented only for LONG Values
                        if (methods[i].getReturnType().getName().length() >= 14
                                && methods[i].getReturnType().getName().equalsIgnoreCase("java.lang.Long")) {
                            pk = pkGenerator.getPrimaryKey(tableName);
                            Object[] pkArray = new Object[1];
                            pkArray[0] = pk;
                            for (int j = 0; j != methods.length; j++) {
                                if (methods[j].getName() != null && methods[j].getName().length() > 0
                                        && methods[j].getName().equalsIgnoreCase("setPrimaryKey")) {
                                    methods[j].invoke(object, pkArray);
                                    isPKSet = true;
                                }
                            }
                        }
                    }
                }
            }
            if (isPKSet) {
                String pkType = pk.getClass().getName();
                Hashtable attributeValues = new Hashtable();
                Hashtable types = new Hashtable();
                Object attributeValue = null;
                Hashtable manyRelations = new Hashtable();
                Vector referenceTables = new Vector();
                //            Hashtable referenceTables = new Hashtable();
                //     Hashtable isForeignKey = new Hashtable();
                for (int i = 0; i != methods.length; i++) {
                    // only the getter Methods are interesting
                    if (methods[i].getName().length() >= 3 && methods[i].getName().startsWith("get")) {
                        // the added, updated and removed methods are not
                        // interesting either
                        if (!((methods[i].getName().length() >= 8 && methods[i].getName().startsWith("getAdded"))
                                || ((methods[i].getName().length() > 11) && (methods[i].getName().startsWith(
                                        "getUpdated") || methods[i].getName().startsWith("getRemoved"))) || methods[i]
                                .getName() != null
                                && methods[i].getName().length() > 0
                                && methods[i].getName().equalsIgnoreCase("getPrimaryKey"))) {
                            if (methods[i].getReturnType().getName() != null
                                    && methods[i].getReturnType().getName().length() > 0) {
                                String retType = methods[i].getReturnType().getName();
                                if (retType.equalsIgnoreCase("java.lang.Long")
                                        || retType.equalsIgnoreCase("java.lang.Double")
                                        || retType.equalsIgnoreCase("java.lang.String")
                                        || retType.equalsIgnoreCase("java.lang.Character")
                                        || retType.equalsIgnoreCase("java.sql.Date")
                                        || retType.equalsIgnoreCase("java.lang.Boolean")
                                        || retType.equalsIgnoreCase("java.lang.Integer")) {
                                    Object[] attributes = null;
                                    attributeValue = methods[i].invoke(object, attributes);
                                    if (attributeValue != null) {
                                        attributeValues.put(this.getDatabaseConformString(StringUtilsHelper.toDatabaseAttributeName(methods[i]
                                                .getName().substring(3), "_")), attributeValue);
                                    }
                                    types.put(this.getDatabaseConformString(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName()
                                            .substring(3), "_")), methods[i].getReturnType().getName());
                                } else {
                                    if (retType.equalsIgnoreCase("java.util.Collection")) {
                                        Object[] attributes = null;
                                        Object manyCollection = methods[i].invoke(object, attributes);
                                        //                        if (manyCollection!=null){
                                        if (manyCollection==null){
                                          manyCollection = new Vector();
                                        }
                                        manyRelations.put(this.getDatabaseConformTablename(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName()
                                                .substring(3).substring(0, methods[i].getName().length() - 4), "_")),
                                                manyCollection);
                                        //                        }
                                        //                        manyRelations.add(methods[i].invoke(object,null));
                                    } else {
                                        Object[] attributes = null;
                                        Object fkObject = methods[i].invoke(object, attributes);
                                        if (fkObject != null) {
                                            Method[] fkMethods = fkObject.getClass().getMethods();
                                            for (int j = 0; j != fkMethods.length; j++) {
                                                if (fkMethods[j].getName() != null
                                                        && fkMethods[j].getName().length() > 0
                                                        && fkMethods[j].getName().equalsIgnoreCase("getPrimaryKey")) {
                                                    attributeValue = fkMethods[j].invoke(fkObject, attributes);
                                                    if (attributeValue != null) {
                                                        attributeValues.put(this.getDatabaseConformTablename(StringUtilsHelper.toDatabaseAttributeName(
                                                                methods[i].getName().substring(3), "_")), attributeValue);
                                                    }
                                                    types.put(this.getDatabaseConformTablename(StringUtilsHelper.toDatabaseAttributeName(methods[i]
                                                            .getName().substring(3), "_")), fkMethods[j].getReturnType()
                                                            .getName());
                                                }

                                            }
                                        } else {
                                            //                         attributeValues.put(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName().substring(3),"_"),null);
                                            types.put(this.getDatabaseConformTablename(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName()
                                                    .substring(3), "_")), "NullType");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                // now preparing the statement
                String sqlStatement = "INSERT INTO " + tableName + " VALUES (";
                for (int i = 0; i != types.size(); i++) {
                    sqlStatement = sqlStatement.concat("?,");
                }
                if (sqlStatement.endsWith(",")) {
                    sqlStatement = sqlStatement.substring(0, sqlStatement.length() - 1);
                }
                sqlStatement = sqlStatement.concat(")");
                pStmt = con.prepareStatement(sqlStatement);
                Hashtable fkColumns = new Hashtable();
                Vector columnNames = new Vector();
                Vector primaryKeys = new Vector();
                Vector fkNameInReferencingTable = new Vector();
                if (columnNamesCache.containsKey(tableName)) {
                    columnNames = (Vector) columnNamesCache.get(tableName);
                    fkColumns = (Hashtable) fkColumnsCache.get(tableName);
                    referenceTables = (Vector) referenceTablesCache.get(tableName);
                    fkNameInReferencingTable = (Vector) fkNameInReferencingTableCache.get(tableName);
                } else {
                    DatabaseMetaData metadata = con.getMetaData();
                    ResultSet columnRs = metadata.getImportedKeys(null, null, tableName);
                    //metadata.getd
                    while (columnRs.next()) {
                        fkColumns.put(columnRs.getString("FKCOLUMN_NAME"), columnRs.getString("PKTABLE_NAME"));
                    }
                    columnRs.close();
                    fkColumnsCache.put(tableName, fkColumns);
                    columnRs = metadata.getExportedKeys(null, null, tableName);
                    while (columnRs.next()) {
                        referenceTables.add(columnRs.getString("FKTABLE_NAME"));
                        fkNameInReferencingTable.add(columnRs.getString("FKCOLUMN_NAME"));
                    }
                    fkNameInReferencingTableCache.put(tableName, fkNameInReferencingTable);
                    columnRs.close();
                    referenceTablesCache.put(tableName, referenceTables);
                    columnRs = metadata.getColumns(null, null, tableName, null);
                    while (columnRs.next()) {
                        columnNames.add(columnRs.getString("COLUMN_NAME"));
                    }
                    columnRs.close();
                    columnNamesCache.put(tableName, columnNames);
                    columnRs = metadata.getPrimaryKeys(null, null, tableName);
                    while (columnRs.next()) {
                        primaryKeys.add(columnRs.getString("COLUMN_NAME"));
                    }
                    pkColumnNamesCache.put(tableName, primaryKeys);
                    columnRs.close();

                }
                pStmt = insertValuesIntoPstmt(pStmt, columnNames, attributeValues, fkColumns, types);

                try {
                    pStmt.executeUpdate();
                    pStmt.close();
                    //              for (int i=0; i!=manyRelations.size();i++){

                    for (int j = 0; j != referenceTables.size(); j++) {

                        String referenceTable = (String) referenceTables.get(j);
                        // one to many relationship
                        if (manyRelations.get(referenceTable) != null) {
                            Iterator values = ((Collection) manyRelations.get(referenceTable)).iterator();
                            while (values.hasNext()) {
                                Object nextObject = values.next();
                                Class nextObjectClass = nextObject.getClass();
                                Method[] nextMethods = nextObjectClass.getMethods();
                                boolean foundFK = false;
                                for (int k = 0; k != nextMethods.length; k++) {
                                    if (nextMethods[k].getName().equalsIgnoreCase("set" + tableNameLowerCase)) {
                                        Object[] args = new Object[1];
                                        args[0] = object;
                                        nextMethods[k].invoke(nextObject, args);
                                        foundFK = true;
                                    }
                                }
                                if (foundFK) {
                                    this.insertVOByJDBC(nextObject, con, pStmt);
                                }
                            }
                        } else {
                            // many to many relationship
                            String collectionName = "";
                            String fkColumnName = "";
                            String fkColumnThisTableName = "";
                            Vector lookupColumns = new Vector();
                            if (columnNamesCache.containsKey(referenceTable)) {
                                collectionName = (String) collectionNameCache.get(referenceTable);
                                fkColumnName = (String) fkColumnNameCache.get(referenceTable);
                                fkColumnThisTableName = (String) fkColumnThisTableNameCache.get(referenceTable);
                                lookupColumns = (Vector) columnNamesCache.get(referenceTable);
                            } else {
                                DatabaseMetaData metadata = con.getMetaData();
                                ResultSet columnRs = metadata.getImportedKeys(null, null, referenceTable);

                                //  these Vectors are only for completeness
                                // in the cache
                                Vector referenceTablesReference = new Vector();
                                Vector fkNameInReferencingTableReference = new Vector();
                                Vector primaryKeysReference = new Vector();
                                while (columnRs.next()) {
                                    if (manyRelations.get(columnRs.getString("PKTABLE_NAME")) != null) {
                                        collectionName = columnRs.getString("PKTABLE_NAME");
                                        fkColumnName = columnRs.getString("FKCOLUMN_NAME");
                                    }
                                    if (columnRs.getString("PKTABLE_NAME").equalsIgnoreCase(tableName)) {
                                        fkColumnThisTableName = columnRs.getString("FKCOLUMN_NAME");
                                    }
                                }
                                columnRs.close();
                                collectionNameCache.put(referenceTable, collectionName);
                                fkColumnNameCache.put(referenceTable, fkColumnName);
                                fkColumnThisTableNameCache.put(referenceTable, fkColumnThisTableName);

                                columnRs = metadata.getPrimaryKeys(null, null, tableName);
                                while (columnRs.next()) {
                                    primaryKeys.add(columnRs.getString("COLUMN_NAME"));
                                }
                                pkColumnNamesCache.put(referenceTable, primaryKeys);
                                columnRs.close();

                                columnRs = metadata.getColumns(null, null, referenceTable, null);
                                while (columnRs.next()) {
                                    lookupColumns.add(columnRs.getString("COLUMN_NAME"));

                                }
                                columnRs.close();
                                columnNamesCache.put(referenceTable, lookupColumns);

                                columnRs = metadata.getExportedKeys(null, null, referenceTable);
                                while (columnRs.next()) {
                                    referenceTablesReference.add(columnRs.getString("FKTABLE_NAME"));
                                    fkNameInReferencingTableReference.add(columnRs.getString("FKCOLUMN_NAME"));
                                }
                                fkNameInReferencingTableCache.put(referenceTable, fkNameInReferencingTableReference);
                                columnRs.close();
                                referenceTablesCache.put(referenceTable, referenceTablesReference);

                                columnRs = metadata.getPrimaryKeys(null, null, referenceTable);
                                while (columnRs.next()) {
                                    primaryKeysReference.add(columnRs.getString("COLUMN_NAME"));
                                }
                                pkColumnNamesCache.put(referenceTable, primaryKeysReference);
                                columnRs.close();

                            }
                            String sqlStatement2 = "INSERT INTO " + referenceTable + " VALUES (";
                            for (int k = 0; k != lookupColumns.size(); k++) {
                                sqlStatement2 = sqlStatement2.concat("?,");
                            }

                            if (sqlStatement2.endsWith(",")) {
                                sqlStatement2 = sqlStatement2.substring(0, sqlStatement2.length() - 1);
                            }
                            sqlStatement2 = sqlStatement2.concat(")");

                            pStmt = con.prepareStatement(sqlStatement2);

                            if (collectionName != null && collectionName.length() > 0 && fkColumnName != null
                                    && fkColumnName.length() > 0 && fkColumnThisTableName != null
                                    && fkColumnThisTableName.length() > 0) {
                                Iterator values = ((Collection) manyRelations.get(collectionName)).iterator();
                                // Vector mToMFks = new Vector();
                                Object mToMFk = null;
                                String mToMFkType = null;
                                while (values.hasNext()) {
                                    Object nextObject = values.next();
                                    Class nextObjectClass = nextObject.getClass();
                                    Method[] nextMethods = nextObjectClass.getMethods();
                                    mToMFk = null;
                                    // boolean foundFK = false;
                                    for (int k = 0; k != nextMethods.length; k++) {
                                        if (nextMethods[k].getName().equalsIgnoreCase("getPrimaryKey")) {
                                            Object[] attributes = null;
                                            mToMFk = nextMethods[k].invoke(nextObject, attributes);
                                            mToMFkType = nextMethods[k].getReturnType().getName();
                                            // foundFK = true;
                                        }
                                    }
                                    if (mToMFk != null) {
                                        //
                                        for (int k = 0; k != lookupColumns.size(); k++) {
                                            if (((String) lookupColumns.get(k)).equalsIgnoreCase(fkColumnName)) {
                                                this.setJDBCValue(pStmt, mToMFk, mToMFkType, k + 1);
                                            } else {
                                                if (((String) lookupColumns.get(k))
                                                        .equalsIgnoreCase(fkColumnThisTableName)) {
                                                    this.setJDBCValue(pStmt, pk, pkType, k + 1);
                                                } else {
                                                    this.setJDBCValue(pStmt, null, "NullType", k + 1);
                                                }
                                            }
                                        }
                                        try {
                                            pStmt.executeUpdate();
                                            // pStmt.close();
                                        } catch (java.sql.SQLException sqx) {
                                            sqx.printStackTrace();
//                                            con.rollback();
                                            // pStmt.close();
                                        }

                                    }
                                }
                            }
                            pStmt.close();
                            // columnRs.close();
                        }
                    }
                    // }
                } catch (java.sql.SQLException sqx) {
                    sqx.printStackTrace();
                    pStmt.close();
//                    con.rollback();
                }

            }

        } catch (java.lang.IllegalAccessException iax) {
            iax.printStackTrace();
        } catch (java.lang.reflect.InvocationTargetException itx) {
            itx.printStackTrace();
        }

        //            }

    }

    return pk;
  }

  /**
   * Removes a VO and the whole underlying tree via JDBC statements
   * It is possible to run this method within the same database connection
   * @param object object to be removed
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return if the operation has been successful
   * @throws SQLException
   * @author hartler
   */
  public boolean removeVOByJDBC(Object object, Connection con, PreparedStatement pStmt) throws SQLException {
    boolean removed = false;
    Class objectClass = object.getClass();
    String tableName = "";
    String tableNameLowerCase = null;
    Object pk = null;
    boolean isPKSet = false;
    if (objectClass.getName().endsWith("VO")) {
        StringTokenizer tokenizer = new StringTokenizer(objectClass.getName(), ".");
        while (tokenizer.hasMoreElements()) {
            tableNameLowerCase = tokenizer.nextToken();
        }
        tableNameLowerCase = tableNameLowerCase.substring(0, tableNameLowerCase.length() - 2);
        tableName = this.getDatabaseConformTablename(StringUtilsHelper.toDatabaseAttributeName(tableNameLowerCase, ""));

        Method[] methods = objectClass.getMethods();
        try {
            // the first Iteration is only important to set the primary Key
            // if it has not been set
            for (int i = 0; i != methods.length; i++) {
                if (methods[i].getName() != null && methods[i].getName().length() > 0
                        && methods[i].getName().equalsIgnoreCase("getPrimaryKey")) {
                    Object[] attributes = null;
                    Object pkObject = methods[i].invoke(object, attributes);
                    if (pkObject != null) {
                        pk = pkObject;
                        isPKSet = true;
                    }
                }
            }
            if (isPKSet) {
              Hashtable<String,String> tablesAllreadyRemoved = new Hashtable<String,String>();
                this.removeVOByJDBC(pk, tableName, con, pStmt,tablesAllreadyRemoved);
                /*
                 * String sqlStatement = "DELETE FROM "+tableName+" WHERE
                 * ("+tableName+".ID = '"+pk.toString()+"')";
                 * pStmt =
                 * con.prepareStatement(sqlStatement); pStmt.execute();
                 * pStmt.close();
                 */
                /*
                 * Hashtable manyRelations = new Hashtable(); for (int i =
                 * 0; i != methods.length; i++) { // only the getter Methods
                 * are interesting if (methods[i].getName().length() >= 3 &&
                 * methods[i].getName().startsWith("get")) { // the added,
                 * updated and removed methods are not interesting either if
                 * (!((methods[i].getName().length()>=8&&methods[i].getName().startsWith("getAdded"))||
                 * ((methods[i].getName().length()>11)&&(methods[i].getName().startsWith("getUpdated")||methods[i].getName().startsWith("getRemoved")))||
                 * methods[i].getName()!=null&&methods[i].getName().length()>0&&methods[i].getName().equalsIgnoreCase("getPrimaryKey")
                 * )){ if
                 * (methods[i].getReturnType().getName()!=null&&methods[i].getReturnType().getName().length()>0){
                 * String retType = methods[i].getReturnType().getName(); //
                 * only the many to many and the one to many relations are
                 * interesting for removing if
                 * (retType.equalsIgnoreCase("java.util.Collection")){
                 * Object manyCollection = methods[i].invoke(object,null);
                 * manyRelations.put(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName().substring(3).substring(0,methods[i].getName().length()-4),"_"),manyCollection); } } } } }
                 */
                // first the relations that refer to the actual VO have to
                // be removed and the Object itself can be removed -> not
                // implemented
            }
        } catch (java.lang.IllegalAccessException iax) {
            iax.printStackTrace();
        } catch (java.lang.reflect.InvocationTargetException itx) {
            itx.printStackTrace();
        }
        //        this.removeVOByJDBC(pk,tableName,con,pStmt);
    }
    removed = true;
    return removed;
  }

  /**
   * Removes a VO and the whole underlying tree via JDBC statements
   * It is possible to run this method within the same database connection
   * @param pk primary key for the object to be removed
   * @param tableName name for the database tabel
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return if the operation has been successful
   * @author hartler
   */
  protected boolean removeVOByJDBC(Object pk, String tableName, Connection con, PreparedStatement pStmt,Hashtable<String,String> tablesAllreadyRemoved) throws SQLException {
    boolean removed = false;
    Vector columnNames = new Vector();
    Hashtable fkColumns = new Hashtable();
    Vector referenceTables = new Vector();
    Vector primaryKeys = new Vector();
    Vector fkNameInReferencingTable = new Vector();
    if (columnNamesCache.containsKey(tableName)) {
        columnNames = (Vector) columnNamesCache.get(tableName);
        fkColumns = (Hashtable) fkColumnsCache.get(tableName);
        referenceTables = (Vector) referenceTablesCache.get(tableName);
        primaryKeys = (Vector) pkColumnNamesCache.get(tableName);
        fkNameInReferencingTable = (Vector) fkNameInReferencingTableCache.get(tableName);
    } else {
        DatabaseMetaData metadata = con.getMetaData();
        ResultSet columnRs = metadata.getImportedKeys(null, null, tableName);
        // metadata about the table
        while (columnRs.next()) {
            fkColumns.put(columnRs.getString("FKCOLUMN_NAME"), columnRs.getString("PKTABLE_NAME"));
        }
        columnRs.close();
        fkColumnsCache.put(tableName, fkColumns);
        //        metadata.getp
        columnRs = metadata.getExportedKeys(null, null, tableName);
        while (columnRs.next()) {
            referenceTables.add(columnRs.getString("FKTABLE_NAME"));
            fkNameInReferencingTable.add(columnRs.getString("FKCOLUMN_NAME"));
        }
        fkNameInReferencingTableCache.put(tableName, fkNameInReferencingTable);
        columnRs.close();
        referenceTablesCache.put(tableName, referenceTables);
        columnRs = metadata.getColumns(null, null, tableName, null);
        while (columnRs.next()) {
            columnNames.add(columnRs.getString("COLUMN_NAME"));
        }
        columnRs.close();
        columnNamesCache.put(tableName, columnNames);

        columnRs = metadata.getPrimaryKeys(null, null, tableName);
        while (columnRs.next()) {
            primaryKeys.add(columnRs.getString("COLUMN_NAME"));
        }
        pkColumnNamesCache.put(tableName, primaryKeys);
        columnRs.close();
    }
    // here we have a M:N Relationship -> All Keys with this FK have to be
    // removed
    //      if (primaryKeys.size()>1){
    //        String sqlStatement = "DELETE FROM "+tableName+" WHERE
    // ("+tableName+".ID = '"+pk.toString()+"')";
    //                    pStmt = con.prepareStatement(sqlStatement);
    //                    pStmt.execute();
    //                    pStmt.close();
    //
    //      }else{
    //
    //      }
    boolean isOneToOneRelation = false;
    String referencOfOneToOneRelation = "";
    if (referenceTables.size() > 0) {
        for (int i = 0; i != referenceTables.size(); i++) {
            boolean ok = true;
            String referenceTable = (String) referenceTables.get(i);
            Vector columnNamesReference = new Vector();
            Hashtable fkColumnsReference = new Hashtable();
            Vector referenceTablesReference = new Vector();
            Vector primaryKeysReference = new Vector();
            Vector fkNameInReferencingTableReference = new Vector();

            if (columnNamesCache.containsKey(referenceTable)) {
                columnNamesReference = (Vector) columnNamesCache.get(referenceTable);
                fkColumnsReference = (Hashtable) fkColumnsCache.get(referenceTable);
                referenceTablesReference = (Vector) referenceTablesCache.get(referenceTable);
                primaryKeysReference = (Vector) pkColumnNamesCache.get(referenceTable);
                fkNameInReferencingTableReference = (Vector) fkNameInReferencingTableCache.get(referenceTable);
            } else {
                DatabaseMetaData metadata = con.getMetaData();
                ResultSet columnRs = metadata.getImportedKeys(null, null, referenceTable);
                // metadata about the table
                while (columnRs.next()) {
                    fkColumnsReference.put(columnRs.getString("FKCOLUMN_NAME"), columnRs.getString("PKTABLE_NAME"));
                }
                columnRs.close();
                fkColumnsCache.put(referenceTable, fkColumnsReference);
                //        metadata.getp
                columnRs = metadata.getExportedKeys(null, null, referenceTable);
                while (columnRs.next()) {
                    referenceTablesReference.add(columnRs.getString("FKTABLE_NAME"));
                    fkNameInReferencingTableReference.add(columnRs.getString("FKCOLUMN_NAME"));
                }
                fkNameInReferencingTableCache.put(referenceTable, fkNameInReferencingTableReference);
                columnRs.close();
                referenceTablesCache.put(referenceTable, referenceTablesReference);
                columnRs = metadata.getColumns(null, null, referenceTable, null);
                while (columnRs.next()) {
                    columnNamesReference.add(columnRs.getString("COLUMN_NAME"));
                }
                columnRs.close();
                columnNamesCache.put(referenceTable, columnNamesReference);

                columnRs = metadata.getPrimaryKeys(null, null, referenceTable);
                while (columnRs.next()) {
                    primaryKeysReference.add(columnRs.getString("COLUMN_NAME"));
                }
                pkColumnNamesCache.put(referenceTable, primaryKeysReference);
                columnRs.close();
            }
            // is a m:n Relationship
            if (primaryKeysReference.size() > 1) {
                String sqlStatement = "DELETE FROM " + referenceTable + " WHERE (" + referenceTable + "."
                        + fkNameInReferencingTable.get(i) + " = '" + pk.toString() + "')";
                pStmt = con.prepareStatement(sqlStatement);
                pStmt.executeUpdate();
                pStmt.close();

            }
            // is a 1:n Relationship
            if (primaryKeysReference.size() == 1) {
                // get PKs in the next Table
              if (!tablesAllreadyRemoved.containsKey(referenceTable)){
                String sqlStatement = "SELECT " + referenceTable + "." + primaryKeysReference.get(0) + " FROM "
                        + referenceTable + " WHERE (" + referenceTable + "." + fkNameInReferencingTable.get(i) + " = '"
                        + pk.toString() + "')";
                pStmt = con.prepareStatement(sqlStatement);
                ResultSet rs = pStmt.executeQuery();
                List pks = prepareResult(rs);
                rs.close();
                pStmt.close();
                if (pks != null && pks.size() > 0) {
                  Hashtable<String,String> newTablesAllreadyRemoved = new Hashtable<String,String>(tablesAllreadyRemoved);
                  newTablesAllreadyRemoved.put(tableName, tableName);
                    ok = this.removeVOByJDBC(pks, referenceTable, con, pStmt,newTablesAllreadyRemoved);
                }
              }
               // then it is a 1:1 relation
               else{
                isOneToOneRelation=true;
                referencOfOneToOneRelation = referenceTable;
              }
            }
        }
    }
    if (isOneToOneRelation){
      String sqlStatement = "UPDATE " +referencOfOneToOneRelation+" SET THE_"+tableName+"_FK=NULL WHERE THE_"+tableName+"_FK="+pk.toString();
      pStmt = con.prepareStatement(sqlStatement);
      pStmt.executeUpdate();
      pStmt.close();      
    }
    String sqlStatement = "DELETE FROM " + tableName + " WHERE (" + tableName + "." + primaryKeys.get(0) + " = '"
            + pk.toString() + "')";

    pStmt = con.prepareStatement(sqlStatement);
    pStmt.executeUpdate();
    pStmt.close();
    removed = true;
    return removed;
  }

  /**
   * Removes a collection of VOs and the whole underlying tree via JDBC statements
   * It is possible to run this method within the same database connection
   * @param pks primary keys for the objects to be removed
   * @param tableName name for the database tabel
   * @param con database connection
   * @param pStmt prepared statement which is used to sumbit the JDBC statements
   * @return if the operation has been successful
   * @author hartler
   */
  protected boolean removeVOByJDBC(Collection pks, String tableName, Connection con, PreparedStatement pStmt,Hashtable<String,String> tablesAllreadyRemoved)
    throws SQLException {
      boolean removed = true;
      Iterator it = pks.iterator();
      while (it.hasNext()) {
        boolean ok = this.removeVOByJDBC(it.next(), tableName, con, pStmt,tablesAllreadyRemoved);
        if (!ok)
          removed = false;
      }
      return removed;
  }

  /** not used at all*/
  public void updateVOByJDBC(Object object) {
    boolean removed = false;
    Connection con = null;
    PreparedStatement pStmt = null;
    try {
        con = factory_.createConnection();
//        con.setAutoCommit(false);
        this.updateVOByJDBC(object, con, pStmt);
        con.close();
    } catch (SQLException sqx) {
        sqx.printStackTrace();
        try {
            if (pStmt != null) {
                pStmt.close();
            }
            con.close();
//            con.rollback();
        } catch (SQLException ex1) {
        }
    }
  }
  
  /** not used at all*/
  public void updateVOByJDBC(Collection objects) {
    boolean removed = false;
    Connection con = null;
    
    PreparedStatement pStmt = null;
    try {
        con = factory_.createConnection();
//        con.setAutoCommit(false);
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.updateVOByJDBC(it.next(), con, pStmt);
        }
        con.close();
    } catch (SQLException sqx) {
        sqx.printStackTrace();
        try {
            if (pStmt != null) {
                pStmt.close();
            }
            con.close();
//            con.rollback();
        } catch (SQLException ex1) {
        }
    }

  }

  /** not used at all*/
  protected void updateVOByJDBC(Object object, Connection con, PreparedStatement pStmt) throws SQLException {
    Class objectClass = object.getClass();
    String tableName = "";
    String tableNameLowerCase = null;
    Object pk = null;
    boolean isPKSet = false;
    if (objectClass.getName().endsWith("VO")) {
        StringTokenizer tokenizer = new StringTokenizer(objectClass.getName(), ".");
        while (tokenizer.hasMoreElements()) {
            tableNameLowerCase = tokenizer.nextToken();
        }
        tableNameLowerCase = tableNameLowerCase.substring(0, tableNameLowerCase.length() - 2);
        tableName = this.getDatabaseConformTablename(StringUtilsHelper.toDatabaseAttributeName(tableNameLowerCase, "_"));
        Method[] methods = objectClass.getMethods();
        try {
            // the first Iteration is only important to set the primary Key
            // if it has not been set
            for (int i = 0; i != methods.length; i++) {
                if (methods[i].getName() != null && methods[i].getName().length() > 0
                        && methods[i].getName().equalsIgnoreCase("getPrimaryKey")) {
                    Object[] attributes = null;
                    Object pkObject = methods[i].invoke(object, attributes);
                    //              pkType = pkObject.getClass().getn
                    if (pkObject != null) {
                        pk = pkObject;
                        isPKSet = true;
                    }
                }
            }
            if (isPKSet) {
                String pkType = pk.getClass().getName();
                Hashtable attributeValues = new Hashtable();
                Hashtable types = new Hashtable();
                Object attributeValue = null;
                for (int i = 0; i != methods.length; i++) {
                    // only the getter Methods are interesting
                    if (methods[i].getName().length() >= 3 && methods[i].getName().startsWith("get")) {
                        // the added, updated and removed methods are not
                        // interesting either
                        if (!((methods[i].getName().length() >= 8 && methods[i].getName().startsWith("getAdded"))
                                || ((methods[i].getName().length() > 11) && (methods[i].getName().startsWith(
                                        "getUpdated") || methods[i].getName().startsWith("getRemoved"))) || methods[i]
                                .getName() != null
                                && methods[i].getName().length() > 0
                                && methods[i].getName().equalsIgnoreCase("getPrimaryKey"))) {
                            if (methods[i].getReturnType().getName() != null
                                    && methods[i].getReturnType().getName().length() > 0) {
                                String retType = methods[i].getReturnType().getName();
                                if (retType.equalsIgnoreCase("java.lang.Long")
                                        || retType.equalsIgnoreCase("java.lang.Double")
                                        || retType.equalsIgnoreCase("java.lang.String")
                                        || retType.equalsIgnoreCase("java.lang.Character")
                                        || retType.equalsIgnoreCase("java.sql.Date")
                                        || retType.equalsIgnoreCase("java.lang.Boolean")
                                        || retType.equalsIgnoreCase("java.lang.Integer")) {
                                    Object[] attributes = null;
                                    attributeValue = methods[i].invoke(object, attributes);
                                    if (attributeValue != null) {
                                        attributeValues.put(this.getDatabaseConformString(StringUtilsHelper.toDatabaseAttributeName(methods[i]
                                                .getName().substring(3), "_")), attributeValue);
                                    }
                                    types.put(this.getDatabaseConformString(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName()
                                            .substring(3), "_")), methods[i].getReturnType().getName());
                                } else {
                                    if (!retType.equalsIgnoreCase("java.util.Collection")) {
                                        Object[] attributes = null;
                                        Object fkObject = methods[i].invoke(object, attributes);
                                        if (fkObject != null) {
                                            Method[] fkMethods = fkObject.getClass().getMethods();
                                            for (int j = 0; j != fkMethods.length; j++) {
                                                if (fkMethods[j].getName() != null
                                                        && fkMethods[j].getName().length() > 0
                                                        && fkMethods[j].getName().equalsIgnoreCase("getPrimaryKey")) {
                                                    attributeValue = fkMethods[j].invoke(fkObject, attributes);
                                                    if (attributeValue != null) {
                                                        attributeValues.put(this.getDatabaseConformString(StringUtilsHelper.toDatabaseAttributeName(
                                                                methods[i].getName().substring(3), "_")), attributeValue);
                                                    }
                                                    types.put(this.getDatabaseConformString(StringUtilsHelper.toDatabaseAttributeName(methods[i]
                                                            .getName().substring(3), "_")), fkMethods[j].getReturnType()
                                                            .getName());
                                                }

                                            }
                                        } else {
                                            //                         attributeValues.put(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName().substring(3),"_"),null);
                                            types.put(this.getDatabaseConformString(StringUtilsHelper.toDatabaseAttributeName(methods[i].getName()
                                                    .substring(3), "_")), "NullType");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                // now preparing the statement
                String sqlStatement = "INSERT INTO " + tableName + " VALUES (";
                for (int i = 0; i != types.size(); i++) {
                    sqlStatement = sqlStatement.concat("?,");
                }
                if (sqlStatement.endsWith(",")) {
                    sqlStatement = sqlStatement.substring(0, sqlStatement.length() - 1);
                }
                sqlStatement = sqlStatement.concat(")");
                pStmt = con.prepareStatement(sqlStatement);
                Hashtable fkColumns = new Hashtable();
                Vector columnNames = new Vector();
                Vector primaryKeys = new Vector();
                Vector fkNameInReferencingTable = new Vector();
                if (columnNamesCache.containsKey(tableName)) {
                    columnNames = (Vector) columnNamesCache.get(tableName);
                    fkColumns = (Hashtable) fkColumnsCache.get(tableName);
                    fkNameInReferencingTable = (Vector) fkNameInReferencingTableCache.get(tableName);
                } else {
                    DatabaseMetaData metadata = con.getMetaData();
                    ResultSet columnRs = metadata.getImportedKeys(null, null, tableName);
                    //metadata.getd
                    while (columnRs.next()) {
                        fkColumns.put(columnRs.getString("FKCOLUMN_NAME"), columnRs.getString("PKTABLE_NAME"));
                    }
                    columnRs.close();
                    fkColumnsCache.put(tableName, fkColumns);
                    columnRs = metadata.getExportedKeys(null, null, tableName);
                    Vector referenceTables = new Vector();
                    while (columnRs.next()) {
                        referenceTables.add(columnRs.getString("FKTABLE_NAME"));
                        fkNameInReferencingTable.add(columnRs.getString("FKCOLUMN_NAME"));
                    }
                    fkNameInReferencingTableCache.put(tableName, fkNameInReferencingTable);
                    columnRs.close();
                    referenceTablesCache.put(tableName, referenceTables);
                    columnRs = metadata.getColumns(null, null, tableName, null);
                    while (columnRs.next()) {
                        columnNames.add(columnRs.getString("COLUMN_NAME"));
                    }
                    columnRs.close();
                    columnNamesCache.put(tableName, columnNames);
                    columnRs = metadata.getPrimaryKeys(null, null, tableName);
                    while (columnRs.next()) {
                        primaryKeys.add(columnRs.getString("COLUMN_NAME"));
                    }
                    pkColumnNamesCache.put(tableName, primaryKeys);
                    columnRs.close();

                }

            }

        } catch (java.lang.IllegalAccessException iax) {
            iax.printStackTrace();
        } catch (java.lang.reflect.InvocationTargetException itx) {
            itx.printStackTrace();
        }
    }
  }

  /**
   * Inserts the values into the prepared Statement for one JDBC insert statement
   * @param pStmt the produced prepared statement
   * @param columnNames the name of the database columns
   * @param attributeValues the values to be inserted
   * @param fkColumns when a column in the table is a fk column the corresponding pk of the other table is inserted
   * @param types the datatype of the value
   * @return the executable prepared statement
   * @throws SQLException
   */
  protected PreparedStatement insertValuesIntoPstmt(PreparedStatement pStmt, Vector columnNames, Hashtable attributeValues,
      Hashtable fkColumns, Hashtable types) throws SQLException {
    int count = 0;
    for (int i = 0; i != columnNames.size(); i++) {
        //              while (columnRs.next()) {
        count = i + 1;
        String columnName = (String) columnNames.get(i);
        String typeName = columnName;
        if (fkColumns.get(columnName) != null) {
            typeName = (String) fkColumns.get(columnName);
        }
        if (attributeValues.get(typeName) != null) {
            if (((String) types.get(typeName)).equalsIgnoreCase("java.lang.String")) {
              String value = (String) attributeValues.get(typeName);
              if ((typeName.equalsIgnoreCase("geneName")||typeName.equalsIgnoreCase("GENE_NAME"))&&value.length()>3000)
                System.out.println("TypeName "+typeName+": "+value.length()+"\n"+value);
              if (typeName.equalsIgnoreCase("GENE_NAME")&&value!=null&&value.length()>4000){
                value = value.substring(0,3999);
              }
              if (value.length()>=32766){
                log_.info("BigStringLength: "+value.length());
                pStmt.setCharacterStream(count,new CharArrayReader(value.toCharArray()),value.length());
             }else{
               pStmt.setString(count,(String)value);  
             }            
            }
            if (((String) types.get(typeName)).equalsIgnoreCase("java.lang.Long")) {
                pStmt.setLong(count, ((Long) attributeValues.get(typeName)).longValue());
            }
            if (((String) types.get(typeName)).equalsIgnoreCase("java.lang.Double")) {
              double value = ((Double) attributeValues.get(typeName)).doubleValue();
              double absoluteValue = value;
              if (absoluteValue<0) absoluteValue = absoluteValue*(-1);
              if (absoluteValue<Databases.DATABASE_SMALLEST_STOREABLE_ABSOLUTE_VALUE){
                attributeValues.put(typeName,new Double(0));
              }
              pStmt.setDouble(count, ((Double) attributeValues.get(typeName)).doubleValue());
            }
            if (((String) types.get(typeName)).equalsIgnoreCase("java.lang.Character")) {
                pStmt.setString(count, ((Character) attributeValues.get(typeName)).toString());
            }
            if (((String) types.get(typeName)).equalsIgnoreCase("java.sql.Date")) {
                pStmt.setDate(count, (java.sql.Date) attributeValues.get(typeName));
            }
            if (((String) types.get(typeName)).equalsIgnoreCase("java.lang.Boolean")) {
                pStmt.setBoolean(count, ((Boolean) attributeValues.get(typeName)).booleanValue());
            }
            if (((String) types.get(typeName)).equalsIgnoreCase("java.lang.Integer")) {
                pStmt.setInt(count, ((Integer) attributeValues.get(typeName)).intValue());
            }
            if (((String) types.get(typeName)).equalsIgnoreCase("NullType")) {
                pStmt.setNull(count, java.sql.Types.NULL);
            }
        } else {
            pStmt.setNull(count, java.sql.Types.NULL);
        }
    }
    return pStmt;
  
  }

  /**
   * Sets the value for one statement, if the string array is higher than what is commitable via string
   * a CharArrayReader for the procedure is used
   * @param pStmt the prepared statement
   * @param value the value to be inserted
   * @param typeName the type of the value
   * @param count the position in the insert statement
   * @throws SQLException
   */
  protected void setJDBCValue(PreparedStatement pStmt, Object value, String typeName, int count) throws SQLException {
    if (value != null) {
        if (typeName.equalsIgnoreCase("java.lang.String")) {
          if (((String)value).length()>=32766){
            log_.info("BigStringLength: "+((String)value).length());
             pStmt.setCharacterStream(count,new CharArrayReader(((String)value).toCharArray()),((String)value).length());
          }else{
            pStmt.setString(count,(String)value);  
          }            
        }
        if (typeName.equalsIgnoreCase("java.lang.Long")) {
            pStmt.setLong(count, ((Long) value).longValue());
        }
        if (typeName.equalsIgnoreCase("java.lang.Double")) {
            pStmt.setDouble(count, ((Double) value).doubleValue());
        }
        if (typeName.equalsIgnoreCase("java.lang.Character")) {
            pStmt.setString(count, ((Character) value).toString());
        }
        if (typeName.equalsIgnoreCase("java.sql.Date")) {
            pStmt.setDate(count, (java.sql.Date) value);
        }
        if (typeName.equalsIgnoreCase("java.lang.Boolean")) {
            pStmt.setBoolean(count, ((Boolean) value).booleanValue());
        }
        if (typeName.equalsIgnoreCase("java.lang.Integer")) {
            pStmt.setInt(count, ((Integer) value).intValue());
        }
        if (typeName.equalsIgnoreCase("NullType")) {
            pStmt.setNull(count, java.sql.Types.NULL);
        }
    } else {
        pStmt.setNull(count, java.sql.Types.NULL);
    }
  }
  
  /**
   * 
   * @return the primary key generator for the corresponding database
   */
  public abstract PKGenerator getPKGenerator();
  
  /**
   * 
   * @param input column name extracted from VO
   * @return database conform column name
   */
  protected abstract String getDatabaseConformString (String input);
  
  /**
   * 
   * @param input table name extracted from VO
   * @return database conform table name
   */
  protected abstract String getDatabaseConformTablename (String input);

  // checks if the MySQL Database supports case sensitivity, if not the mySQLLowerCase is set to true
  // default is the support of case sensitivity
  
  public void setPkValuesAtBeginning(Connection con, String tableName) throws SQLException{
    this.getPKGenerator().setPkValuesAtBeginning(con, tableName);
  }
  
}
