package at.tugraz.genome.dbutilities;

import java.sql.Connection;
import java.util.Hashtable;

import javax.naming.Context;

import org.apache.log4j.Logger;

import java.io.Serializable;

/**
 * <p>
 * Title: MARS EJB
 * </p>
 * <p>
 * Description: Microarray Analysis and Retrieval System
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * <p>
 * Company: genome.tugraz.at
 * </p>
 * 
 * @author unascribed
 * @version 1.0
 */

public abstract class GenericDAOFactory implements Serializable
{
  private static Hashtable classNames_ = new Hashtable();
  
  private static Logger log_ = Logger.getLogger(at.tugraz.genome.dbutilities.GenericDAOFactory.class);

  public static GenericDAOFactory getDAOFactory(String className)
  {
    GenericDAOFactory factory = (GenericDAOFactory) classNames_.get(className);
    if (factory == null) {
      try {
        factory = (GenericDAOFactory) Class.forName(className).newInstance();
        classNames_.put(className, factory);
        return factory;
      }
      catch (java.lang.ClassNotFoundException classNotFoundExc) {
        log_.error(classNotFoundExc);
      }
      catch (java.lang.IllegalAccessException illegalAccessExc) {
        log_.error(illegalAccessExc);
      }
      catch (java.lang.InstantiationException instatiationExc) {
        log_.error(instatiationExc);
      }
    }
    return factory;
  }

  public abstract Connection createConnection();

  public abstract Context getContext();

  public abstract GenericDAOInterface getDAO();
}
