package at.tugraz.genome.dbutilities;

import org.apache.log4j.Logger;

import at.tugraz.genome.dbutilities.exception.*;

/**
 * <p>
 * Title: MARS EJB
 * </p>
 * <p>
 * Description: Microarray Analysis and Retrieval System
 * </p>
 * <p>
 * Copyright: Copyright (c) 2002
 * </p>
 * <p>
 * Company: genome.tugraz.at
 * </p>
 * 
 * @author Robert Molidor
 * @version 1.0
 */

public class EJBExceptionFactory {
	public static void throwEJBCreateExceptions(String database,
			javax.ejb.CreateException createExc) throws UniqueException,
			ForeignKeyException, EJBCreateException {
		Logger log = Logger.getLogger("EJBExceptionFactory");
		log.debug("throwEJBCreateException - CreateException");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc.throwEJBCreateException(createExc);
		} else {
			throw new EJBCreateException(createExc.getMessage());
		}
	}

	public static void throwEJBCreateExceptions(String database,
			String exceptionMessage) throws UniqueException,
			ForeignKeyException, EJBCreateException {
		Logger log = Logger.getLogger("EJBExceptionFactory");
		log.debug("throwEJBCreateException - exceptionMessage");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc
					.throwEJBCreateException(new javax.ejb.CreateException(
							exceptionMessage));
		} else {
			throw new EJBCreateException(exceptionMessage);
		}
	}

	public static void throwEJBServerException(String database,
			javax.naming.NamingException namingExc) throws EJBServerException {
		Logger log = Logger.getLogger("EJBExceptionFactory - NamingException");
		log.debug("throwEJBServerException");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc.throwEJBServerException(namingExc);
		} else {
			throw new EJBServerException(namingExc.getMessage());
		}
	}

	public static void throwEJBServerException(String database,
			String exceptionMessage) throws EJBServerException {
		Logger log = Logger.getLogger("EJBExceptionFactory - exceptionMessage");
		log.debug("throwEJBServerException");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc
					.throwEJBServerException(new javax.naming.NamingException(
							exceptionMessage));
		} else {
			throw new EJBServerException(exceptionMessage);
		}
	}

	public static void throwEJBFinderException(String database,
			javax.ejb.FinderException finderExc) throws EJBFinderException {
		Logger log = Logger.getLogger("EJBExceptionFactory - FinderException");
		log.debug("throwEJBFinderException");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc.throwEJBFinderException(finderExc);
		} else {
			throw new EJBFinderException(finderExc.getMessage());
		}
	}

	public static void throwEJBFinderException(String database,
			String exceptionMessage) throws EJBFinderException {
		Logger log = Logger.getLogger("EJBExceptionFactory - exceptionMessage");
		log.debug("throwEJBFinderException");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc
					.throwEJBFinderException(new javax.ejb.FinderException(
							exceptionMessage));
		} else {
			throw new EJBFinderException(exceptionMessage);
		}
	}

	public static void throwEJBRemoveException(String database,
			javax.ejb.RemoveException removeExc) throws EJBRemoveException {
		Logger log = Logger.getLogger("EJBExceptionFactory - RemoveException");
		log.debug("throwEJBRemoveException");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc.throwEJBRemoveException(removeExc);
		} else {
			throw new EJBRemoveException(removeExc.getMessage());
		}
	}

	public static void throwEJBRemoveException(String database,
			String exceptionMessage) throws EJBRemoveException {
		Logger log = Logger.getLogger("EJBExceptionFactory - RemoveException");
		log.debug("throwEJBRemoveException");
		if (database.equals(Databases.ORACLE)) {
			AbstractEJBException abstractEJBExc = new OracleEJBException();
			abstractEJBExc
					.throwEJBRemoveException(new javax.ejb.RemoveException(
							exceptionMessage));
		} else {
			throw new EJBRemoveException(exceptionMessage);
		}
	}

}