/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.exception.SettingsException;
import at.tugraz.genome.lda.swing.CutoffSettingsPanel;
import at.tugraz.genome.lda.xml.XMLFileLoader;
import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CutoffSettingsReader
extends XMLFileLoader {
    CutoffSettingsPanel panel_;

    public CutoffSettingsReader(String fileName, CutoffSettingsPanel panel) {
        super(new File(fileName));
        this.panel_ = panel;
    }

    @Override
    public void parseXMLFile() throws SAXException {
        super.parseXMLFile();
        if (this.doc != null) {
            Element root = this.doc.getDocumentElement();
            if (root.getNodeName().equalsIgnoreCase("cutoff-settings")) {
                NodeList rootList = root.getChildNodes();
                for (int i = 0; i != rootList.getLength(); ++i) {
                    Node rootSubNode = rootList.item(i);
                    if (rootSubNode.getNodeName().equalsIgnoreCase("isotope")) {
                        String isotopeString = rootSubNode.getTextContent();
                        if (isotopeString == null || isotopeString.length() == 0) {
                            throw new SAXException("The content of isotope must not be empty!");
                        }
                        try {
                            int isotope = Integer.parseInt(isotopeString);
                            if (isotope < 0) {
                                throw new SAXException("The content of isotope must not be a negative integer!");
                            }
                            this.panel_.setMaxIsotope(isotope);
                        }
                        catch (NumberFormatException nfx) {
                            throw new SAXException("The content of isotope must not be empty!");
                        }
                        catch (SettingsException nfx) {
                            // empty catch block
                        }
                    }
                    if (!rootSubNode.getNodeName().equalsIgnoreCase("cutoff")) continue;
                    Element cutoff = (Element)rootSubNode;
                    String lipidClass = cutoff.getAttribute("class");
                    String valueString = cutoff.getAttribute("value");
                    if (lipidClass == null || lipidClass.length() == 0) {
                        throw new SAXException("The attribute class of cutoff must not be empty!");
                    }
                    if (valueString == null || valueString.length() == 0) {
                        throw new SAXException("The attribute value of cutoff must not be empty!");
                    }
                    try {
                        this.panel_.setCutoff(lipidClass, valueString);
                        continue;
                    }
                    catch (NumberFormatException nfx) {
                        throw new SAXException("The attribute value of cutoff must be double format! The parsed value " + valueString + " is not!");
                    }
                    catch (AbsoluteSettingsInputException nfx) {
                        continue;
                    }
                    catch (SettingsException sx) {
                        throw new SAXException("The attribute value of cutoff must not be negative! The parsed value " + valueString + " is negative!");
                    }
                }
            } else {
                throw new SAXException("The document is not valid! The root element must be of type \"cutoff-settings\"!");
            }
        }
    }
}

