/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.math3.util.Pair;

public class DoubleBondPositionVO
implements Comparable<DoubleBondPositionVO> {
    public static final int ACCURACY_LOW = 0;
    public static final int ACCURACY_MEDIUM = 1;
    public static final int ACCURACY_HIGH = 2;
    Vector<FattyAcidVO> chainCombination_;
    double expectedRetentionTime_;
    int accuracy_;
    String molecularSpecies_;
    boolean isAssigned_;
    Hashtable<Pair<String, Integer>, Double> experimentRTLookup_ = new Hashtable();

    public DoubleBondPositionVO(Vector<FattyAcidVO> chainCombination, double expectedRetentionTime) {
        this(chainCombination, expectedRetentionTime, 0, null);
    }

    public DoubleBondPositionVO(Vector<FattyAcidVO> chainCombination, double expectedRetentionTime, int accuracy, String molecularSpecies) {
        this(chainCombination, expectedRetentionTime, accuracy, molecularSpecies, false);
    }

    public DoubleBondPositionVO(Vector<FattyAcidVO> chainCombination, double expectedRetentionTime, int accuracy, String molecularSpecies, boolean isAssigned) {
        this.chainCombination_ = chainCombination;
        this.expectedRetentionTime_ = expectedRetentionTime;
        this.accuracy_ = accuracy;
        this.molecularSpecies_ = molecularSpecies;
        this.isAssigned_ = isAssigned;
    }

    public DoubleBondPositionVO(DoubleBondPositionVO that) {
        this(DoubleBondPositionVO.getDeepCopyOfChainCombination(that.getChainCombination()), that.getExpectedRetentionTime(), that.getAccuracy(), that.getMolecularSpecies(), that.getIsAssigned());
    }

    private static Vector<FattyAcidVO> getDeepCopyOfChainCombination(Vector<FattyAcidVO> chainCombination) {
        Vector<FattyAcidVO> newChainCombination = new Vector<FattyAcidVO>();
        for (FattyAcidVO fattyAcid : chainCombination) {
            newChainCombination.add(new FattyAcidVO(fattyAcid));
        }
        return newChainCombination;
    }

    @Override
    public int compareTo(DoubleBondPositionVO anotherVO) {
        return Comparator.comparing(DoubleBondPositionVO::getAccuracy).reversed().thenComparing(vo -> vo.getEncodedDetailed(false, false)).thenComparing(DoubleBondPositionVO::getExpectedRetentionTime).thenComparing(DoubleBondPositionVO::getOmegaSum).compare(this, anotherVO);
    }

    public String getDoubleBondPositionsHumanReadable() {
        return this.getDoubleBondPositionsHumanReadable(2);
    }

    public String getDoubleBondPositionsHumanReadable(int snLevel) {
        boolean chainPositionsFixed = false;
        if (snLevel == 2) {
            chainPositionsFixed = this.areChainPositionsFixed();
        }
        String doubleBondPositionsHumanReadable = null;
        try {
            doubleBondPositionsHumanReadable = StaticUtils.getHumanReadableCombiName(this.getChainCombination(), Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), chainPositionsFixed);
        }
        catch (LipidCombinameEncodingException lcx) {
            lcx.printStackTrace();
        }
        return doubleBondPositionsHumanReadable;
    }

    public boolean areChainPositionsFixed() {
        if (this.molecularSpecies_ != null && this.molecularSpecies_.contains("/") && this.chainCombination_.size() > 1) {
            HashSet<String> unassignedSet;
            HashSet<FattyAcidVO> assignedSet = new HashSet<FattyAcidVO>(this.chainCombination_);
            if (assignedSet.size() == 1) {
                return true;
            }
            String[] individualChains = this.molecularSpecies_.split("/");
            if (individualChains.length == (unassignedSet = new HashSet<String>(Arrays.asList(individualChains))).size()) {
                return true;
            }
        }
        return false;
    }

    public Vector<Integer> getPositionAssignmentPattern() {
        Vector<Integer> pattern = new Vector<Integer>();
        for (FattyAcidVO fattyAcid : this.chainCombination_) {
            pattern.add(fattyAcid.getOmegaPosition());
        }
        return pattern;
    }

    private int getOmegaSum() {
        Vector<Integer> pattern = this.getPositionAssignmentPattern();
        int sum = 0;
        for (int omega : pattern) {
            sum += omega;
        }
        return sum;
    }

    public Vector<Boolean> getPermutationPattern() {
        Vector<Boolean> pattern = new Vector<Boolean>();
        for (int i = 0; i < this.chainCombination_.size(); ++i) {
            FattyAcidVO fattyAcid1 = this.chainCombination_.get(i);
            pattern.add(i, false);
            for (FattyAcidVO fattyAcid2 : this.chainCombination_) {
                if (fattyAcid1 == fattyAcid2 || !fattyAcid1.equalsNotConsideringOmegaPosition(fattyAcid2)) continue;
                pattern.setElementAt(true, i);
            }
        }
        return pattern;
    }

    public String getEncoded() {
        return StaticUtils.encodeLipidCombi(this.chainCombination_);
    }

    public String getEncodedDetailed(boolean includePrefix, boolean includeOmegaPosition) {
        Vector<String> chainIds = new Vector<String>();
        for (FattyAcidVO chain : this.chainCombination_) {
            chainIds.add(chain.getChainIdDetailed(includePrefix, includeOmegaPosition));
        }
        return StaticUtils.encodeLipidCombiFromIds(chainIds);
    }

    public int getNumberOfCarbons() {
        int num = 0;
        for (FattyAcidVO fa : this.chainCombination_) {
            num += fa.getcAtoms();
        }
        return num;
    }

    public int getNumberOfDoubleBonds() {
        int num = 0;
        for (FattyAcidVO fa : this.chainCombination_) {
            num += fa.getDoubleBonds();
        }
        return num;
    }

    public int getNumberOfOH() {
        int num = 0;
        for (FattyAcidVO fa : this.chainCombination_) {
            num += fa.getOhNumber();
        }
        return num == 0 ? -1 : num;
    }

    public void setIsAssigned(boolean isAssigned) {
        this.isAssigned_ = isAssigned;
    }

    public boolean getIsAssigned() {
        return this.isAssigned_;
    }

    public void setMolecularSpecies(String molecularSpecies) {
        this.molecularSpecies_ = molecularSpecies;
    }

    public String getMolecularSpecies() {
        return this.molecularSpecies_;
    }

    public void setExpectedRetentionTime(double currentRT) {
        this.expectedRetentionTime_ = currentRT;
    }

    public double getExpectedRetentionTime() {
        return this.expectedRetentionTime_;
    }

    public void setChainCombination(Vector<FattyAcidVO> chainCombination) {
        this.chainCombination_ = chainCombination;
    }

    public Vector<FattyAcidVO> getChainCombination() {
        return this.chainCombination_;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy_ = accuracy;
    }

    public int getAccuracy() {
        return this.accuracy_;
    }

    public Hashtable<Pair<String, Integer>, Double> getExperimentRTLookup() {
        return this.experimentRTLookup_;
    }

    public void addToExperimentRTLookup(Pair<String, Integer> experiment, double d) {
        this.experimentRTLookup_.put(experiment, d);
    }
}

