/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.verifier;

import at.tugraz.genome.lda.WarningMessage;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class DoubleVerifier
extends InputVerifier {
    private boolean biggerZero_ = false;
    private boolean notEmpty_ = false;

    public DoubleVerifier() {
    }

    public DoubleVerifier(boolean biggerZero) {
        this();
        this.biggerZero_ = biggerZero;
    }

    public DoubleVerifier(boolean biggerZero, boolean notEmpty) {
        this(biggerZero);
        this.notEmpty_ = notEmpty;
    }

    @Override
    public boolean verify(JComponent input) {
        String text = ((JTextField)input).getText();
        if (text.contains(",")) {
            text = text.replaceAll(",", ".");
            ((JTextField)input).setText(text);
        }
        if (text != null && text.length() > 0) {
            try {
                double value = Double.parseDouble(text);
                if (this.biggerZero_ && !(value > 0.0)) {
                    new WarningMessage(new JFrame(), "Error", "The entered value must be greater than zero");
                    return false;
                }
                return true;
            }
            catch (NumberFormatException nfx) {
                new WarningMessage(new JFrame(), "Error", "The entered value must be double format (xxx.xxx)");
                return false;
            }
        }
        if (this.notEmpty_) {
            new WarningMessage(new JFrame(), "Error", "This field must not be empty");
            return false;
        }
        return true;
    }
}

