/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.utils;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.swing.RangeColor;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.IntegerStringVO;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import at.tugraz.genome.maspectras.chromaviewer.MSMapViewer;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.utils.StringUtils;
import at.tugraz.genome.voutils.GeneralComparator;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;

public class StaticUtils {
    public static final String RULE_FILE_SUFFIX = ".frag.txt";
    public static final int NO_MS2 = 0;
    public static final int PERCENTAL_SPLIT = 1;
    public static final int SPLIT = 2;
    public static final int MS2_FULL = 3;
    private static final String ALKYL_COMBI_PREFIX = "{O-}";
    private static final String ALKENYL_COMBI_PREFIX = "{P-}";
    public static final String[] physicalMagnitudes_ = new String[]{"", "m", "\u03bc", "n", "p", "f", "a"};
    private static final String EMPTY_AT_BEGINNING = "-_";
    private static final String EMPTY_IN_MIDDLE = "_-_";
    private static final String EMPTY_AT_END = "_-";

    public static String[] extractFileNameAndSuffix(String fileNameFull) {
        String fileName = "";
        String suffix = "";
        String fileNamePlusSuffix = StaticUtils.extractFileName(fileNameFull);
        int dotIndex = fileNamePlusSuffix.lastIndexOf(".");
        if (dotIndex > -1) {
            fileName = fileNamePlusSuffix.substring(0, dotIndex);
            suffix = fileNamePlusSuffix.substring(dotIndex + 1);
        } else {
            fileName = fileNamePlusSuffix;
        }
        String[] result = new String[]{fileName, suffix};
        return result;
    }

    public static String extractDirName(String fileName) {
        int bkSlashIdx;
        int idx = 0;
        int slashIdx = fileName.lastIndexOf("/");
        idx = slashIdx > (bkSlashIdx = fileName.lastIndexOf("\\")) ? slashIdx : bkSlashIdx;
        String newFileName = fileName.substring(0, idx);
        return newFileName;
    }

    public static int[] detectNameUnequalitiesBeforeAndAfter(Vector<String> fileNames) {
        int[] charsToCut = new int[2];
        if (fileNames.size() > 1) {
            char[] expName2;
            int j;
            char[] expName1;
            boolean isSameChar;
            int i;
            int smallestFileNameSize = fileNames.stream().mapToInt(String::length).min().orElse(0);
            for (i = 0; i < smallestFileNameSize; ++i) {
                isSameChar = true;
                expName1 = fileNames.get(0).toCharArray();
                for (j = 0; j != fileNames.size(); ++j) {
                    expName2 = fileNames.get(j).toCharArray();
                    if (expName1[expName1.length - 1 - i] == expName2[expName2.length - 1 - i]) continue;
                    isSameChar = false;
                }
                if (!isSameChar) break;
                charsToCut[1] = charsToCut[1] + 1;
            }
            for (i = 0; i < smallestFileNameSize; ++i) {
                isSameChar = true;
                expName1 = fileNames.get(0).toCharArray();
                for (j = 0; j != fileNames.size(); ++j) {
                    expName2 = fileNames.get(j).toCharArray();
                    if (expName1[i] == expName2[i]) continue;
                    isSameChar = false;
                }
                if (!isSameChar) break;
                charsToCut[0] = charsToCut[0] + 1;
            }
            if (charsToCut[0] + charsToCut[1] >= smallestFileNameSize) {
                charsToCut[0] = charsToCut[0] - 1;
            }
        }
        return charsToCut;
    }

    public static String extractChromBaseName(LipidomicsConstants constants, String resultFilePath) throws IOException {
        Path parentPath = Paths.get(resultFilePath, new String[0]).getParent();
        String rawFileName = null;
        rawFileName = constants != null ? constants.getRawFileName() : LDAResultReader.extractRawFile(resultFilePath);
        if (rawFileName == null) {
            rawFileName = StaticUtils.extractChromFileNameOldVersions(resultFilePath);
        }
        String baseName = rawFileName == null ? "" : rawFileName.replaceAll("\\.[^.]*$", "");
        String basePath = Optional.ofNullable(parentPath.resolve(baseName)).map(Object::toString).orElse("");
        return basePath;
    }

    private static String extractChromFileNameOldVersions(String resultFilePath) {
        File resultFile = new File(resultFilePath);
        String resultName = resultFile.getName();
        File folder = resultFile.getParentFile();
        if (folder == null || !folder.isDirectory()) {
            return null;
        }
        return Arrays.stream(folder.listFiles((dir, name) -> name.endsWith(".chrom"))).map(File::getName).map(name -> name.substring(0, name.length() - 6)).max((a, b) -> Integer.compare(StaticUtils.commonPrefixLength(resultName, a), StaticUtils.commonPrefixLength(resultName, b))).orElse(null);
    }

    private static int commonPrefixLength(String a, String b) {
        int i;
        int len = Math.min(a.length(), b.length());
        for (i = 0; i < len && a.charAt(i) == b.charAt(i); ++i) {
        }
        return i;
    }

    public static String existChromNecessaryFiles(String chromBaseName) {
        String[] chromPaths = StringUtils.getChromFilePaths(chromBaseName + ".");
        String oneDoesNotExist = "";
        if (chromPaths[0] == null || !StaticUtils.existsFile(chromPaths[0])) {
            oneDoesNotExist = "The chrom file is missing: " + chromPaths[0];
        }
        if (chromPaths[1] == null || !StaticUtils.existsFile(chromPaths[1])) {
            oneDoesNotExist = "The head file is missing: " + chromPaths[1];
        }
        if (chromPaths[2] == null || !StaticUtils.existsFile(chromPaths[2])) {
            oneDoesNotExist = "The idx file is missing: " + chromPaths[2];
        }
        if (chromPaths[3] == null || !StaticUtils.existsFile(chromPaths[3])) {
            oneDoesNotExist = "The rtt file is missing: " + chromPaths[3];
        }
        return oneDoesNotExist;
    }

    public static boolean existChromFiles(String chromBaseName) {
        String[] chromPaths = StringUtils.getChromFilePaths(chromBaseName + ".");
        if (chromPaths[0] == null || !StaticUtils.existsFile(chromPaths[0])) {
            new WarningMessage(new JFrame(), "Error", "There is no file with the name " + StaticUtils.extractFileName(chromBaseName + ".chrom") + "!");
            return false;
        }
        if (chromPaths[1] == null || !StaticUtils.existsFile(chromPaths[1])) {
            new WarningMessage(new JFrame(), "Error", "There is no file with the name " + StaticUtils.extractFileName(chromBaseName + ".head") + "! A chrom file requires a head file!");
            return false;
        }
        if (chromPaths[2] == null || !StaticUtils.existsFile(chromPaths[2])) {
            new WarningMessage(new JFrame(), "Error", "There is no file with the name " + StaticUtils.extractFileName(chromBaseName + ".idx") + "! A chrom file requires an idx file!");
            return false;
        }
        if (chromPaths[3] == null || !StaticUtils.existsFile(chromPaths[3])) {
            new WarningMessage(new JFrame(), "Error", "There is no file with the name " + StaticUtils.extractFileName(chromBaseName + ".rtt") + "! A chrom file requires an rtt file!");
            return false;
        }
        return true;
    }

    public static String extractFileName(String fileName) {
        int bkSlashIdx;
        int idx = 0;
        int slashIdx = fileName.lastIndexOf("/");
        idx = slashIdx > (bkSlashIdx = fileName.lastIndexOf("\\")) ? slashIdx : bkSlashIdx;
        String newFileName = fileName.substring(idx + 1);
        return newFileName;
    }

    public static int getMaxApplicableIsotopeHash(Hashtable<String, Hashtable<String, ResultCompVO>> results, int maxIsotope) {
        int isotopes = maxIsotope + 1;
        for (Hashtable<String, ResultCompVO> hash : results.values()) {
            int isos = StaticUtils.getMaxApplicableIsotope(hash, maxIsotope);
            if (isotopes <= isos) continue;
            isotopes = isos;
        }
        return isotopes;
    }

    public static int getMaxApplicableIsotope(Hashtable<String, ResultCompVO> results, int maxIsotope) {
        int isotopes = maxIsotope + 1;
        for (ResultCompVO compVO : results.values()) {
            if (!(compVO.getOriginalArea(0) > 0.0) || isotopes <= compVO.getUsedIsotpes()) continue;
            isotopes = compVO.getUsedIsotpes();
        }
        return isotopes;
    }

    public static void printOutLabelToFile(String label, OutputStream out, Row row, CellStyle cellStyle, int columnCount, boolean excel, boolean tab) throws IOException {
        if (excel) {
            StaticUtils.addExcelLabel(cellStyle, row, columnCount, label);
        } else {
            if (tab) {
                out.write("\t".getBytes());
            }
            out.write(label.getBytes());
        }
    }

    public static void printOutNumberToFile(String number, OutputStream out, Row row, CellStyle cellStyle, int columnCount, boolean excel, boolean tab) throws IOException {
        if (excel) {
            StaticUtils.addExcelNumber(cellStyle, row, columnCount, number);
        } else {
            if (tab) {
                out.write("\t".getBytes());
            }
            out.write(number.getBytes());
        }
    }

    public static void addExcelLabel(CellStyle cellStyle, Row row, int columnCount, String toAdd) {
        Cell label = row.createCell(columnCount, 1);
        label.setCellValue(toAdd);
        if (cellStyle != null) {
            label.setCellStyle(cellStyle);
        }
    }

    private static void addExcelNumber(CellStyle cellStyle, Row row, int columnCount, String toAdd) {
        Cell number = row.createCell(columnCount, 0);
        number.setCellValue(Double.valueOf(toAdd));
        if (cellStyle != null) {
            number.setCellStyle(cellStyle);
        }
    }

    public static String getAreaString(double area, ResultDisplaySettingsVO settingVO, String preferredUnit) {
        double myArea = StaticUtils.getAreaInCorrespondingUnit(area, preferredUnit);
        String unit = StaticUtils.getCorrespondingUnit(settingVO, preferredUnit, false);
        String resultString = StaticUtils.getAreaTypeString(settingVO);
        if (resultString != null && resultString.length() > 1) {
            resultString = resultString + ": ";
        }
        if (!settingVO.getType().equalsIgnoreCase("relative value")) {
            resultString = resultString + StaticUtils.extractDisplayValue(myArea) + unit;
        }
        return resultString;
    }

    public static double getAreaInCorrespondingUnit(double area, String preferredUnit) {
        double myArea = area;
        if (preferredUnit != null) {
            if (preferredUnit.equalsIgnoreCase("%")) {
                myArea *= 100.0;
            } else if (preferredUnit.equalsIgnoreCase("\u2030")) {
                myArea *= 1000.0;
            } else if (preferredUnit.equalsIgnoreCase("m")) {
                myArea *= 1000.0;
            } else if (preferredUnit.equalsIgnoreCase("\u03bc")) {
                myArea *= 1000000.0;
            } else if (preferredUnit.equalsIgnoreCase("n")) {
                myArea *= 1.0E9;
            } else if (preferredUnit.equalsIgnoreCase("p")) {
                myArea *= 1.0E12;
            } else if (preferredUnit.equalsIgnoreCase("f")) {
                myArea *= 1.0E15;
            } else if (preferredUnit.equalsIgnoreCase("a")) {
                myArea *= 1.0E18;
            }
        }
        return myArea;
    }

    public static double getValueDividedByUnit(double inValue, String unit) {
        double value = new Double(inValue);
        if (unit != null && unit.length() > 0) {
            if (unit.equalsIgnoreCase("m")) {
                value /= 1000.0;
            }
            if (unit.equalsIgnoreCase("\u03bc")) {
                value /= 1000000.0;
            }
            if (unit.equalsIgnoreCase("n")) {
                value /= 1.0E9;
            }
            if (unit.equalsIgnoreCase("p")) {
                value /= 1.0E12;
            }
            if (unit.equalsIgnoreCase("f")) {
                value /= 1.0E15;
            }
            if (unit.equalsIgnoreCase("a")) {
                value /= 1.0E18;
            }
        }
        return value;
    }

    public static String getCorrespondingUnit(ResultDisplaySettingsVO settingVO, String preferredUnit, boolean addDescription) {
        String unit = preferredUnit;
        String divisorUnit = settingVO.getDivisorMagnitude();
        if (addDescription) {
            unit = "[" + preferredUnit + "]";
        }
        if (settingVO.getType().equalsIgnoreCase("amount end-volume")) {
            unit = preferredUnit + "mol";
            if (addDescription) {
                unit = "end volume [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("conc. end-volume")) {
            unit = preferredUnit + "mol/" + divisorUnit + "L";
            if (addDescription) {
                unit = "end conc [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("weight end-volume")) {
            unit = preferredUnit + "g";
            if (addDescription) {
                unit = "end weight [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("amount sample-volume")) {
            unit = preferredUnit + "mol";
            if (addDescription) {
                unit = "sample volume [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("conc. sample-volume")) {
            unit = preferredUnit + "mol/" + divisorUnit + "L";
            if (addDescription) {
                unit = "sample conc [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("weight sample-volume")) {
            unit = preferredUnit + "g";
            if (addDescription) {
                unit = "sample weight [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("relative to sample weight")) {
            unit = preferredUnit + "mol/" + divisorUnit + "g";
            if (addDescription) {
                unit = "rel. weight [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("relation to protein content")) {
            if (!(settingVO.getISStandMethod() == 0 && settingVO.getESStandMethod() == 0 || settingVO.isAu())) {
                unit = preferredUnit + "mol/" + divisorUnit + "g";
                if (addDescription) {
                    unit = "rel. protein [" + unit + "]";
                }
            } else {
                unit = "AU/" + divisorUnit + "g";
                if (addDescription) {
                    unit = "rel. protein [" + unit + "]";
                }
            }
        } else if (settingVO.getType().equalsIgnoreCase("relation to neutral lipid content")) {
            if (!(settingVO.getISStandMethod() == 0 && settingVO.getESStandMethod() == 0 || settingVO.isAu())) {
                unit = preferredUnit + "mol/" + divisorUnit + "g";
                if (addDescription) {
                    unit = "rel. lipid [" + unit + "]";
                }
            } else {
                unit = "AU/" + divisorUnit + "g";
                if (addDescription) {
                    unit = "rel. lipid [" + unit + "]";
                }
            }
        } else if (settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
            unit = preferredUnit + "mol/" + divisorUnit + "g";
            if (addDescription) {
                unit = "rel. to lipid [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("relative to base peak")) {
            unit = preferredUnit;
            if (addDescription) {
                unit = "base peak [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("relative to measured class amount")) {
            unit = preferredUnit;
            if (addDescription) {
                unit = "total amount [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("relative to highest total peak")) {
            unit = preferredUnit;
            if (addDescription) {
                unit = "high tot peak [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("relative to total amount")) {
            unit = preferredUnit;
            if (addDescription) {
                unit = "rel total int [" + unit + "]";
            }
        } else if (settingVO.getType().equalsIgnoreCase("relative value") && addDescription) {
            unit = "area [AU]";
        }
        return unit;
    }

    public static String extractDisplayValue(double area) {
        return StaticUtils.extractDisplayValue(area, 3);
    }

    public static String extractDisplayValue(double area, int commaPositions) {
        String value = "";
        if (!Double.isInfinite(area) && !Double.isNaN(area)) {
            String doubleString = String.valueOf(StaticUtils.roundDBL(area, commaPositions));
            value = doubleString.indexOf(".") == -1 || doubleString.indexOf("E") != -1 || doubleString.indexOf(".") + (commaPositions + 1) >= doubleString.length() ? doubleString : doubleString.substring(0, doubleString.indexOf(".") + (commaPositions + 1));
        }
        return value;
    }

    private static double roundDBL(double targetDBL, int decimalPlace) {
        BigDecimal bd = new BigDecimal(targetDBL);
        bd = bd.setScale(decimalPlace, 4);
        return bd.doubleValue();
    }

    public static String getAreaTypeString(ResultDisplaySettingsVO settingVO) {
        String resultString = "";
        if (settingVO.getType().equalsIgnoreCase("amount end-volume")) {
            resultString = resultString + "Amount end-volume";
        } else if (settingVO.getType().equalsIgnoreCase("relative to base peak")) {
            resultString = resultString + "Base peak";
        } else if (settingVO.getType().equalsIgnoreCase("relative to measured class amount")) {
            resultString = resultString + "Total class amount";
        } else if (settingVO.getType().equalsIgnoreCase("relative to highest total peak")) {
            resultString = resultString + "Total base peak";
        } else if (settingVO.getType().equalsIgnoreCase("relative to total amount")) {
            resultString = resultString + "Total amount";
        } else if (settingVO.getType().equalsIgnoreCase("conc. end-volume")) {
            resultString = resultString + "Conc. end-volume";
        } else if (settingVO.getType().equalsIgnoreCase("weight end-volume")) {
            resultString = resultString + "Weight end-volume";
        } else if (settingVO.getType().equalsIgnoreCase("amount sample-volume")) {
            resultString = resultString + "Amount sample-volume";
        } else if (settingVO.getType().equalsIgnoreCase("conc. sample-volume")) {
            resultString = resultString + "Conc. sample-volume";
        } else if (settingVO.getType().equalsIgnoreCase("weight sample-volume")) {
            resultString = resultString + "Weight sample-volume";
        } else if (settingVO.getType().equalsIgnoreCase("relative to sample weight")) {
            resultString = resultString + "Rel. to sample weight";
        } else if (settingVO.getType().equalsIgnoreCase("relation to protein content")) {
            resultString = resultString + "Rel. to protein";
        } else if (settingVO.getType().equalsIgnoreCase("relation to neutral lipid content")) {
            resultString = resultString + "Rel. to neutral lipid";
        } else if (settingVO.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
            resultString = resultString + "Rel. to neutral lipid (measured)";
        }
        return resultString;
    }

    public static String extractPreferredUnit(double value) {
        if (value <= 0.0) {
            return null;
        }
        if (value >= 1.0) {
            return "";
        }
        if (value * 1000.0 >= 1.0) {
            return "m";
        }
        if (value * 1000000.0 >= 1.0) {
            return "\u03bc";
        }
        if (value * 1.0E9 >= 1.0) {
            return "n";
        }
        if (value * 1.0E12 >= 1.0) {
            return "p";
        }
        if (value * 1.0E15 >= 1.0) {
            return "f";
        }
        return "a";
    }

    public static Hashtable<String, Integer> categorizeFormula(String formula) throws ChemicalFormulaException {
        return StaticUtils.categorizeFormula(formula, false);
    }

    public static Hashtable<String, Integer> categorizeFormula(String formula, boolean allowLowerCase) throws ChemicalFormulaException {
        Hashtable<String, Integer> categorized = new Hashtable<String, Integer>();
        if (formula == null || formula.length() == 0) {
            return categorized;
        }
        boolean add = true;
        char[] chars = formula.replaceAll(" ", "+").toCharArray();
        String currentElement = "";
        String currentAmountString = "";
        for (int i = 0; i != chars.length; ++i) {
            if (chars[i] == ' ') {
                StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, null, add);
                add = true;
                currentElement = "";
                currentAmountString = "";
                continue;
            }
            if (chars[i] == '+') {
                StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, null, add);
                add = true;
                currentElement = "";
                currentAmountString = "";
                continue;
            }
            if (chars[i] == '-') {
                StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, null, add);
                add = false;
                currentElement = "";
                currentAmountString = "";
                continue;
            }
            if (Character.isLetter(chars[i])) {
                if (Character.isUpperCase(chars[i]) || allowLowerCase && Settings.getElementParser().isElementAvailable(String.valueOf(chars[i]))) {
                    if (currentElement.length() == 0) {
                        currentElement = currentElement + String.valueOf(chars[i]);
                        continue;
                    }
                    StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, null, add);
                    currentElement = String.valueOf(chars[i]);
                    currentAmountString = "";
                    continue;
                }
                if (currentElement.length() == 1 && currentAmountString.length() == 0) {
                    currentElement = currentElement + String.valueOf(chars[i]);
                    continue;
                }
                throw new ChemicalFormulaException("The formula \"" + formula + "\" is invalid! An element must not start lower case!");
            }
            if (!Character.isDigit(chars[i])) continue;
            if (currentElement.length() > 0) {
                currentAmountString = currentAmountString + String.valueOf(chars[i]);
                continue;
            }
            throw new ChemicalFormulaException("The formula \"" + formula + "\" is invalid! A term cannot start with a digit! Avoid empty spaces between element and amount!");
        }
        StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, null, add);
        return categorized;
    }

    public static Hashtable<String, Integer> categorizeAdduct(String formula) throws ChemicalFormulaException {
        Hashtable<String, Integer> categorized = new Hashtable<String, Integer>();
        if (formula == null || formula.length() == 0) {
            return categorized;
        }
        boolean add = true;
        char[] chars = formula.toCharArray();
        String currentElement = "";
        String currentAmountString = "";
        String currentMultiString = "";
        boolean formulaAlreadyAdded = false;
        for (int i = 0; i != chars.length; ++i) {
            if (chars[i] == ' ') {
                StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, currentMultiString, add);
                add = true;
                currentElement = "";
                currentAmountString = "";
                currentMultiString = "";
                formulaAlreadyAdded = true;
                continue;
            }
            if (chars[i] == '+') {
                if (!formulaAlreadyAdded) {
                    StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, currentMultiString, add);
                }
                add = true;
                currentElement = "";
                currentAmountString = "";
                currentMultiString = "";
                formulaAlreadyAdded = true;
                continue;
            }
            if (chars[i] == '-') {
                if (!formulaAlreadyAdded) {
                    StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, currentMultiString, add);
                }
                add = false;
                currentElement = "";
                currentAmountString = "";
                currentMultiString = "";
                formulaAlreadyAdded = true;
                continue;
            }
            if (Character.isLetter(chars[i])) {
                if (Character.isUpperCase(chars[i])) {
                    if (currentElement.length() == 0) {
                        currentElement = currentElement + String.valueOf(chars[i]);
                        formulaAlreadyAdded = false;
                        continue;
                    }
                    StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, currentMultiString, add);
                    currentElement = String.valueOf(chars[i]);
                    currentAmountString = "";
                    continue;
                }
                if (currentElement.length() == 1 && currentAmountString.length() == 0) {
                    currentElement = currentElement + String.valueOf(chars[i]);
                    continue;
                }
                throw new ChemicalFormulaException("The formula \"" + formula + "\" is invalid! An element must not start lower case!");
            }
            if (!Character.isDigit(chars[i])) continue;
            if (currentElement.length() > 0) {
                currentAmountString = currentAmountString + String.valueOf(chars[i]);
                continue;
            }
            currentMultiString = currentMultiString + String.valueOf(chars[i]);
        }
        StaticUtils.addFormulaPartToHash(categorized, currentElement, currentAmountString, currentMultiString, add);
        return categorized;
    }

    private static void addFormulaPartToHash(Hashtable<String, Integer> categorized, String currentElement, String currentAmountString, String currentMultiString, boolean add) {
        if (currentElement != null && currentElement.length() > 0) {
            int finalAmount = 0;
            if (categorized.containsKey(currentElement)) {
                finalAmount = categorized.get(currentElement);
            }
            int amountToChange = 1;
            if (currentAmountString != null && currentAmountString.length() > 0) {
                amountToChange = Integer.parseInt(currentAmountString);
            }
            int multi = 1;
            if (currentMultiString != null && currentMultiString.length() > 0) {
                multi = Integer.parseInt(currentMultiString);
            }
            finalAmount = add ? (finalAmount += amountToChange * multi) : (finalAmount -= amountToChange * multi);
            categorized.put(currentElement, finalAmount);
        }
    }

    public static String getFormulaInHillNotation(Hashtable<String, Integer> formAnal, boolean space) {
        return StaticUtils.getFormulaInHillNotation(formAnal, space, false);
    }

    private static String getFormulaInHillNotation(Hashtable<String, Integer> formAnal, boolean space, boolean plusSign) {
        String hillNotation = "";
        if (formAnal.containsKey("C") && formAnal.get("C") != 0) {
            hillNotation = hillNotation + (plusSign && formAnal.get("C") > 0 ? "+" : "") + (formAnal.get("C") < 0 ? "-" : "") + "C" + StaticUtils.getHillNotationNumber("C", formAnal) + (space ? " " : "");
        }
        if (formAnal.containsKey("H") && formAnal.get("H") != 0) {
            hillNotation = hillNotation + (plusSign && formAnal.get("H") > 0 ? "+" : "") + (formAnal.get("H") < 0 ? "-" : "") + "H" + StaticUtils.getHillNotationNumber("H", formAnal) + (space ? " " : "");
        }
        ArrayList<String> list = new ArrayList<String>(formAnal.keySet());
        Collections.sort(list);
        for (String element : list) {
            if (element.equalsIgnoreCase("C") || element.equalsIgnoreCase("H") || formAnal.get(element) == 0) continue;
            hillNotation = hillNotation + (plusSign && formAnal.get(element) > 0 ? "+" : "") + (formAnal.get(element) < 0 ? "-" : "") + element + StaticUtils.getHillNotationNumber(element, formAnal) + (space ? " " : "");
        }
        return hillNotation.trim();
    }

    public static String getFormulaInHillNotation_PlusFirst(Hashtable<String, Integer> formAnal, boolean space) {
        Hashtable<String, Integer> added = new Hashtable<String, Integer>();
        Hashtable<String, Integer> subtracted = new Hashtable<String, Integer>();
        String hillNotationPlusFirst = "";
        for (String element : formAnal.keySet()) {
            if (formAnal.get(element) > 0) {
                added.put(element, formAnal.get(element));
                continue;
            }
            if (formAnal.get(element) >= 0) continue;
            subtracted.put(element, formAnal.get(element));
        }
        if (added.size() > 0) {
            hillNotationPlusFirst = hillNotationPlusFirst + StaticUtils.getFormulaInHillNotation(added, space, true) + (subtracted.size() > 0 ? " " : "");
        }
        if (subtracted.size() > 0) {
            hillNotationPlusFirst = hillNotationPlusFirst + StaticUtils.getFormulaInHillNotation(subtracted, space, true);
        }
        return hillNotationPlusFirst;
    }

    private static String getHillNotationNumber(String element, Hashtable<String, Integer> formAnal) {
        String number = "";
        int amount = Math.abs(formAnal.get(element));
        if (amount > 1) {
            number = String.valueOf(amount);
        }
        return number;
    }

    public static String generateLipidNameString(String name, Integer doubleBonds, Integer omegaPos, String oxState) {
        String nameString = name;
        if (doubleBonds != null && doubleBonds > -1) {
            nameString = nameString + ":" + String.valueOf(doubleBonds);
            if (oxState != null && !oxState.equals("")) {
                nameString = nameString + ";" + oxState;
            }
        }
        if (omegaPos != null && omegaPos > -1) {
            nameString = nameString + "(n-" + String.valueOf(omegaPos) + ")";
        }
        return nameString;
    }

    public static String generateLipidNameString(String name, Integer doubleBonds, String rt, String oxState) {
        String nameString = StaticUtils.generateLipidNameString(name, doubleBonds, -1, oxState);
        if (rt != null && rt.length() > 0) {
            nameString = nameString + "_" + rt;
        }
        return nameString;
    }

    public static String encodeLipidNameForCreatingCombis(FattyAcidVO vo, boolean includePrefix, boolean includeOmegaPosition) {
        return StaticUtils.encodeLipidNameForCreatingCombis(vo.getChainType(), includePrefix ? vo.getPrefix() : "", vo.getcAtoms(), vo.getDoubleBonds(), vo.getOhNumber(), includeOmegaPosition ? vo.getOmegaPosition() : -1, vo.getOxState());
    }

    private static String encodeLipidNameForCreatingCombis(short chainType, String prefix, int cAtoms, int doubleBonds, int ohNumber, int omega, String oxState) {
        StringBuilder sb = new StringBuilder();
        if (chainType < 3) {
            sb.append("FA");
        } else if (chainType == 3) {
            sb.append("LCB");
        }
        sb.append("^" + String.valueOf(ohNumber) + "@");
        if (chainType == 1) {
            sb.append(ALKYL_COMBI_PREFIX);
        } else if (chainType == 2) {
            sb.append(ALKENYL_COMBI_PREFIX);
        }
        sb.append(prefix);
        sb.append(StaticUtils.generateLipidNameString(String.valueOf(cAtoms), (Integer)doubleBonds, omega, oxState));
        return sb.toString();
    }

    public static FattyAcidVO decodeLipidNameForCreatingCombis(String encoded) throws LipidCombinameEncodingException {
        String[] cAndDbsAndOx;
        int ohNumber;
        short chainType;
        StringTokenizer tokenizer = new StringTokenizer(encoded, "@");
        if (tokenizer.countTokens() != 2) {
            throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" cannot be decoded because it does not contain \"" + "@" + "\" or its usage is incorrect");
        }
        String typeInfo = tokenizer.nextToken();
        String chainInfo = tokenizer.nextToken();
        tokenizer = new StringTokenizer(typeInfo, "^");
        if (tokenizer.countTokens() != 2) {
            throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" cannot be decoded because it does not contain \"" + "^" + "\" or its usage is incorrect");
        }
        String typeString = tokenizer.nextToken();
        String ohString = tokenizer.nextToken();
        if (typeString.equalsIgnoreCase("FA")) {
            chainType = 0;
        } else if (typeString.equalsIgnoreCase("LCB")) {
            chainType = 3;
        } else {
            throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" cannot be decoded because it does not start with \"" + "FA" + "\" or \"" + "LCB" + "\"");
        }
        try {
            ohNumber = Integer.parseInt(ohString);
        }
        catch (NumberFormatException nfx) {
            throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" is irregular, because the value followed by \"" + "^" + "\" must be integer format");
        }
        if (chainInfo.startsWith("{")) {
            if (chainInfo.indexOf("}") == -1) {
                throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" is irregular, because if it contains a \"" + "{" + "\" must contain \"" + "}" + "\"");
            }
            if (chainType >= 3) {
                throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" is irregular, because expressions that contain \"" + "{" + "\" must start with \"" + "FA" + "\"");
            }
            if (!chainInfo.startsWith(ALKYL_COMBI_PREFIX) && !chainInfo.startsWith(ALKENYL_COMBI_PREFIX)) {
                throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" is irregular - in the contents of \"" + "{" + "..." + "}" + "\" is only \"" + "O-" + "\" or \"" + "P-" + "\" permitted");
            }
            if (chainInfo.startsWith(ALKYL_COMBI_PREFIX)) {
                chainType = 1;
                chainInfo = chainInfo.substring(ALKYL_COMBI_PREFIX.length());
            } else if (chainInfo.startsWith(ALKENYL_COMBI_PREFIX)) {
                chainType = 2;
                chainInfo = chainInfo.substring(ALKENYL_COMBI_PREFIX.length());
            }
        }
        StringBuilder prefixBuilder = new StringBuilder();
        char[] chars = chainInfo.toCharArray();
        for (int i = 0; i < chars.length && !Character.isDigit(chars[i]); ++i) {
            prefixBuilder.append(chars[i]);
        }
        String prefix = prefixBuilder.toString();
        if (prefix.length() > 0) {
            chainInfo = chainInfo.substring(prefix.length());
        }
        try {
            cAndDbsAndOx = StaticUtils.parseCAndDbsFromChainId(chainInfo);
        }
        catch (Exception ex) {
            throw new LipidCombinameEncodingException("The combiname \"" + encoded + "\" is irregular. The chain info \"" + chainInfo + "\" is not of the format $CAtoms$:$DoubleBonds$");
        }
        return new FattyAcidVO(chainType, prefix, Integer.parseInt(cAndDbsAndOx[0]), Integer.parseInt(cAndDbsAndOx[1]), ohNumber, -1.0, null, cAndDbsAndOx[2]);
    }

    public static Vector<FattyAcidVO> decodeLipidNamesFromChainCombi(String encodedCombi) throws LipidCombinameEncodingException {
        Vector<String> encodedParts = StaticUtils.splitChainCombiToEncodedStrings(encodedCombi, "<->");
        Vector<FattyAcidVO> decoded = new Vector<FattyAcidVO>();
        for (String encoded : encodedParts) {
            decoded.add(StaticUtils.decodeLipidNameForCreatingCombis(encoded));
        }
        return decoded;
    }

    public static Vector<String> splitChainCombiToEncodedStrings(String encodedCombi, String sep) throws LipidCombinameEncodingException {
        String combiPartial = new String(encodedCombi);
        Vector<String> encodedParts = new Vector<String>();
        while (combiPartial.length() > 0) {
            String toAdd = "";
            if (combiPartial.indexOf(sep) == -1) {
                toAdd = combiPartial;
                combiPartial = "";
            } else {
                toAdd = combiPartial.substring(0, combiPartial.indexOf(sep));
                combiPartial = combiPartial.substring(combiPartial.indexOf(sep) + sep.length());
            }
            encodedParts.add(toAdd);
        }
        return encodedParts;
    }

    public static boolean existsFile(String pathName) {
        File file = new File(pathName);
        return file.exists();
    }

    public static boolean isWithinTolerance(double tolerance, double ref, double value) {
        return ref - tolerance <= value && value <= ref + tolerance;
    }

    public static String[] extractMoleculeRtAndModFromMoleculeName(String moleculeName) {
        String mod;
        String rt;
        String mol;
        String[] molRtAndMod;
        block4: {
            block5: {
                molRtAndMod = new String[3];
                mol = null;
                rt = null;
                mod = null;
                if (moleculeName.indexOf("_") == -1) break block5;
                try {
                    Double.valueOf(moleculeName.substring(moleculeName.lastIndexOf("_") + 1));
                    rt = moleculeName.substring(moleculeName.lastIndexOf("_") + 1);
                    mol = moleculeName.substring(0, moleculeName.lastIndexOf("_"));
                }
                catch (NumberFormatException nfx) {
                    mod = moleculeName.substring(moleculeName.lastIndexOf("_") + 1);
                    mol = moleculeName.substring(0, moleculeName.lastIndexOf("_"));
                    if (mol.indexOf("_") == -1) break block4;
                    try {
                        Double.valueOf(mol.substring(mol.lastIndexOf("_") + 1));
                        rt = mol.substring(mol.lastIndexOf("_") + 1);
                        mol = moleculeName.substring(0, mol.lastIndexOf("_"));
                        break block4;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                break block4;
            }
            mol = moleculeName;
        }
        molRtAndMod[0] = mol;
        molRtAndMod[1] = rt;
        molRtAndMod[2] = mod;
        return molRtAndMod;
    }

    public static float calculateDiff(float v1, float v2) {
        float diff = v1 - v2;
        if (diff < 0.0f) {
            diff *= -1.0f;
        }
        return diff;
    }

    public static Vector<Double> calculateChemicalFormulaIntensityDistribution(ElementConfigParser elementParser, String chemicalFormula, int isosDesired, boolean nh4Corr) throws SpectrummillParserException {
        Vector<Double> negDistri;
        Vector<Vector<Double>> bothDistris = elementParser.calculateChemicalFormulaIntensityDistribution(chemicalFormula, isosDesired, nh4Corr);
        Vector<Double> distri = bothDistris.get(0);
        if (bothDistris.size() > 1 && StaticUtils.useNegativeDistribution(distri, negDistri = bothDistris.get(1))) {
            distri = negDistri;
        }
        return distri;
    }

    public static boolean useNegativeDistribution(Vector<Double> posDistri, Vector<Double> negDistri) {
        return negDistri.get(1) > posDistri.get(1);
    }

    public static boolean isAPermutedVersion(String one, String two, String sep) throws LipidCombinameEncodingException {
        Vector<String> chains = StaticUtils.splitChainCombiToEncodedStrings(one, sep);
        for (String combi : StaticUtils.getPermutedChainNames(chains, sep)) {
            if (!combi.equalsIgnoreCase(two)) continue;
            return true;
        }
        return false;
    }

    public static Hashtable<Integer, Vector<RangeColor>> createRangeColorVOs(LipidParameterSet paramUncasted, String selectedMSn, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding, boolean isAlex123) throws LipidCombinameEncodingException {
        String selected = null;
        if (selectedMSn != null && selectedMSn.length() > 0) {
            selected = new String(selectedMSn);
            selected = (String)StaticUtils.cleanEmptyFAPositionsAndEncodeToLDACombiName(selected, faHydroxyEncoding, lcbHydroxyEncoding, isAlex123, null)[0];
        }
        Hashtable<Integer, Object> rangeColorLevels = null;
        if (paramUncasted instanceof LipidomicsMSnSet) {
            LipidomicsMSnSet param = (LipidomicsMSnSet)paramUncasted;
            rangeColorLevels = new Hashtable<Integer, Object>();
            Hashtable<String, CgProbe> headFrags = new Hashtable<String, CgProbe>(param.getHeadGroupFragments());
            while (headFrags.size() > 0) {
                String highestArea = "";
                float area = 0.0f;
                for (String name : headFrags.keySet()) {
                    if (!(headFrags.get((Object)name).Area > area)) continue;
                    area = headFrags.get((Object)name).Area;
                    highestArea = name;
                }
                CgProbe probe = headFrags.get(highestArea);
                RangeColor vo = new RangeColor(highestArea, MSMapViewer.COLOR_BROWN, probe, probe.Mz - probe.LowerMzBand, probe.Mz + probe.UpperMzBand);
                Object rangeColors = new Vector();
                if (rangeColorLevels.containsKey(probe.getMsLevel())) {
                    rangeColors = (Vector)rangeColorLevels.get(probe.getMsLevel());
                }
                ((Vector)rangeColors).add(vo);
                rangeColorLevels.put(probe.getMsLevel(), rangeColors);
                headFrags.remove(highestArea);
            }
            Hashtable<String, Hashtable<String, CgProbe>> chainFrags = param.getChainFragments();
            Hashtable<String, Double> relAreas = param.getChainCombinationRelativeAreas();
            Vector<String> combiOrdered = new Vector<String>();
            boolean ohInCombi = false;
            if (param.getStatus() < 3) {
                if (relAreas != null && relAreas.size() > 0) {
                    combiOrdered.add(relAreas.keySet().iterator().next());
                }
            } else {
                for (String combi : relAreas.keySet()) {
                    Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(combi);
                    if (StaticUtils.areThereOhInCombi(chains)) {
                        ohInCombi = true;
                    }
                    boolean set = false;
                    for (int i = 0; i != combiOrdered.size(); ++i) {
                        if (!(relAreas.get(combi) > relAreas.get(combiOrdered.get(i)))) continue;
                        combiOrdered.add(i, combi);
                        set = true;
                        break;
                    }
                    if (set) continue;
                    combiOrdered.add(combi);
                }
            }
            int colorCount = 1;
            Hashtable<String, String> usedFAs = new Hashtable<String, String>();
            Iterator iterator = combiOrdered.iterator();
            while (iterator.hasNext()) {
                String combiOriginal;
                String combi = combiOriginal = (String)iterator.next();
                if (isAlex123) {
                    combi = combi.replaceAll("/", "<->");
                }
                if (selected != null && selected.length() > 0 && !StaticUtils.isAPermutedVersion(selected, combi, "<->")) continue;
                String name = combi;
                for (String oneOrder : combiOrdered) {
                    if (!StaticUtils.isAPermutedVersion(oneOrder, combi, "<->")) continue;
                    name = oneOrder;
                }
                Vector<String> fas = StaticUtils.splitChainCombiToEncodedStrings(name, "<->");
                for (int i = 0; i != fas.size(); ++i) {
                    String fa = fas.get(i);
                    Hashtable<Object, Object> frags = new Hashtable();
                    String faStored = StaticUtils.getStoredFAName(fa, chainFrags);
                    if (faStored != null) {
                        frags = chainFrags.get(faStored);
                    }
                    Color color = StaticUtils.getFragemntColor(colorCount);
                    for (String key : frags.keySet()) {
                        String faStoredReadable;
                        String fragmentName = key;
                        if (!fragmentName.contains(faStoredReadable = StaticUtils.getHumanReadableChainName(StaticUtils.decodeLipidNameForCreatingCombis(faStored), faHydroxyEncoding, lcbHydroxyEncoding, ohInCombi, isAlex123))) {
                            fragmentName = StaticUtils.getChainFragmentDisplayName(fragmentName, StaticUtils.getHumanReadableChainName(StaticUtils.decodeLipidNameForCreatingCombis(faStored), faHydroxyEncoding, lcbHydroxyEncoding, ohInCombi));
                        }
                        if (usedFAs.containsKey(fragmentName)) continue;
                        usedFAs.put(fragmentName, fragmentName);
                        CgProbe probe = (CgProbe)frags.get(key);
                        RangeColor vo = new RangeColor(fragmentName, color, probe, probe.Mz - probe.LowerMzBand, probe.Mz + probe.UpperMzBand);
                        Vector rangeColors = new Vector();
                        if (rangeColorLevels.containsKey(probe.getMsLevel())) {
                            rangeColors = (Vector)rangeColorLevels.get(probe.getMsLevel());
                        }
                        rangeColors.add(vo);
                        rangeColorLevels.put(probe.getMsLevel(), rangeColors);
                    }
                    ++colorCount;
                }
            }
        }
        return rangeColorLevels;
    }

    public static String getStoredFAName(String fa, Hashtable<String, Hashtable<String, CgProbe>> chainFrags) {
        if (!(chainFrags.containsKey(fa) || chainFrags.containsKey("FA " + fa) || chainFrags.containsKey("LCB " + fa))) {
            return null;
        }
        String faStored = "";
        if (chainFrags.containsKey(fa)) {
            faStored = fa;
        } else if (chainFrags.containsKey("FA " + fa)) {
            faStored = "FA " + fa;
        } else if (chainFrags.containsKey("LCB " + fa)) {
            faStored = "LCB " + fa;
        } else if (chainFrags.containsKey("O-" + fa)) {
            faStored = "O-" + fa;
        }
        return faStored;
    }

    public static Hashtable<Color, Vector<CgProbe>> get3DColorHash(Vector<RangeColor> rangeColors) {
        Hashtable<Color, Vector<CgProbe>> colors = new Hashtable<Color, Vector<CgProbe>>();
        if (rangeColors == null) {
            return colors;
        }
        for (RangeColor color : rangeColors) {
            Vector<CgProbe> probes = new Vector<CgProbe>();
            if (colors.containsKey(color.getColor())) {
                probes = colors.get(color.getColor());
            }
            probes.add(color.getProbe());
            colors.put(color.getColor(), probes);
        }
        return colors;
    }

    private static Color getFragemntColor(int colorCount) {
        if (colorCount == 1) {
            return MSMapViewer.COLOR_RED;
        }
        if (colorCount == 2) {
            return MSMapViewer.COLOR_BLUE;
        }
        if (colorCount == 3) {
            return MSMapViewer.COLOR_GREEN;
        }
        if (colorCount == 4) {
            return MSMapViewer.COLOR_VIOLET;
        }
        if (colorCount == 5) {
            return MSMapViewer.COLOR_ORANGE;
        }
        if (colorCount == 6) {
            return MSMapViewer.COLOR_TURQUOISE;
        }
        if (colorCount == 7) {
            return MSMapViewer.COLOR_PINK;
        }
        if (colorCount == 8) {
            return MSMapViewer.COLOR_GREEN_PASTEL;
        }
        if (colorCount == 9) {
            return MSMapViewer.COLOR_BLUE_PASTEL;
        }
        if (colorCount == 10) {
            return MSMapViewer.COLOR_GOLD;
        }
        if (colorCount == 11) {
            return MSMapViewer.COLOR_GREEN_BLUE;
        }
        return Color.BLACK;
    }

    public static String getRuleName(String className, String modName) {
        String ruleName = className;
        if (modName != null && modName.length() > 0) {
            ruleName = ruleName + "_" + modName;
        }
        return ruleName;
    }

    public static String getRuleFileName(String className, String modName) {
        return StaticUtils.getRuleName(className, modName) + RULE_FILE_SUFFIX;
    }

    public static Object[] cleanEmptyFAPositionsAndEncodeToLDACombiName(String identification, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding, boolean isAlexOhEncoding, LipidomicsConstants lipidomicsConstants) throws LipidCombinameEncodingException {
        Object[] result = new Object[4];
        int positions = 0;
        String name = identification.replaceAll("/", "_");
        while (name.startsWith(EMPTY_AT_BEGINNING) || name.indexOf(EMPTY_IN_MIDDLE) != -1 || name.endsWith(EMPTY_AT_END)) {
            ++positions;
            if (name.endsWith(EMPTY_AT_END)) {
                name = name.substring(0, name.length() - EMPTY_AT_END.length());
                continue;
            }
            if (name.startsWith(EMPTY_AT_BEGINNING)) {
                name = name.substring(EMPTY_AT_BEGINNING.length());
                continue;
            }
            if (name.indexOf(EMPTY_IN_MIDDLE) == -1) continue;
            name = name.substring(0, name.indexOf(EMPTY_IN_MIDDLE)) + name.substring(name.indexOf(EMPTY_IN_MIDDLE) + EMPTY_AT_END.length());
        }
        Vector<FattyAcidVO> chains = StaticUtils.decodeFAsFromHumanReadableName(name, faHydroxyEncoding, lcbHydroxyEncoding, isAlexOhEncoding, lipidomicsConstants);
        positions += chains.size();
        boolean containsAlkyl = false;
        boolean containsAlkenyl = false;
        for (FattyAcidVO chain : chains) {
            if (chain.getChainType() == 1) {
                containsAlkyl = true;
            }
            if (chain.getChainType() != 2) continue;
            containsAlkenyl = true;
        }
        result[0] = StaticUtils.encodeLipidCombi(chains);
        result[1] = positions;
        result[2] = containsAlkyl;
        result[3] = containsAlkenyl;
        return result;
    }

    public static int checkMS2Evidence(LipidParameterSet set) {
        int evd = 0;
        if (set.getPercentalSplit() >= 0.0f) {
            evd = 1;
        } else if (set.getLowerRtHardLimit() >= 0.0f || set.getUpperRtHardLimit() >= 0.0f) {
            evd = 2;
        } else if (set instanceof LipidomicsMSnSet) {
            evd = 3;
        }
        return evd;
    }

    public static Vector checkFileStorage(File file, String suffix, Component parentComponent) {
        Vector<Comparable<File>> results = new Vector<Comparable<File>>();
        boolean store = true;
        File fileToStore = new File(file.getAbsolutePath());
        if (fileToStore.exists()) {
            if (JOptionPane.showConfirmDialog(parentComponent, "The file " + fileToStore.getName() + " exists! Replace existing file?") != 0) {
                store = false;
            }
        } else if (fileToStore.getName().indexOf(".") == -1 && (fileToStore = new File(fileToStore.getAbsoluteFile() + "." + suffix)).exists() && JOptionPane.showConfirmDialog(parentComponent, "The file " + fileToStore.getName() + " exists! Replace existing file?") != 0) {
            store = false;
        }
        results.add(fileToStore);
        results.add(Boolean.valueOf(store));
        return results;
    }

    public static String sortFASequenceUnassigned(String key, String separator) throws LipidCombinameEncodingException {
        Vector<String> fas = StaticUtils.splitChainCombiToEncodedStrings(key, separator);
        Hashtable<Integer, Integer> emptyFas = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> unassignedFAs = new Hashtable<Integer, Integer>();
        for (int i = 0; i != fas.size(); ++i) {
            if (fas.get(i).equalsIgnoreCase("-")) {
                emptyFas.put(i, i);
                continue;
            }
            unassignedFAs.put(i, i);
        }
        Vector assignedFAs = new Vector();
        while (unassignedFAs.size() > 0) {
            Vector<Integer> lowestCarbonNumbers = new Vector();
            int lowestCarbonNumber = Integer.MAX_VALUE;
            Iterator iterator = unassignedFAs.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String carbonPart = fas.get(i).substring(0, fas.get(i).indexOf(":"));
                while (carbonPart.length() > 0 && !Character.isDigit(carbonPart.toCharArray()[0])) {
                    carbonPart = carbonPart.substring(1);
                }
                int carbonNumber = Integer.parseInt(carbonPart);
                if (carbonNumber < lowestCarbonNumber) {
                    lowestCarbonNumbers = new Vector<Integer>();
                    lowestCarbonNumbers.add(i);
                    lowestCarbonNumber = carbonNumber;
                    continue;
                }
                if (carbonNumber != lowestCarbonNumber) continue;
                lowestCarbonNumbers.add(i);
            }
            if (lowestCarbonNumbers.size() == 1) {
                assignedFAs.add(lowestCarbonNumbers.get(0));
                unassignedFAs.remove(lowestCarbonNumbers.get(0));
                continue;
            }
            int containsOmega = 0;
            Vector<Integer> lowestDoubleBonds = new Vector<Integer>();
            int lowestDoubleBondNumber = Integer.MAX_VALUE;
            for (int j = 0; j != lowestCarbonNumbers.size(); ++j) {
                int doubleBonds;
                int indexInFA = (Integer)lowestCarbonNumbers.get(j);
                String fa = fas.get(indexInFA);
                String dbString = fa.substring(fa.indexOf(":") + 1);
                if (dbString.indexOf("(n-") != -1) {
                    dbString = dbString.substring(0, dbString.indexOf("(n-"));
                    ++containsOmega;
                }
                if (dbString.indexOf(";") != -1) {
                    dbString = dbString.substring(0, dbString.indexOf(";"));
                }
                if (dbString.indexOf("(") != -1) {
                    dbString = dbString.substring(0, dbString.indexOf("("));
                }
                if ((doubleBonds = Integer.parseInt(dbString)) < lowestDoubleBondNumber) {
                    lowestDoubleBonds = new Vector();
                    lowestDoubleBonds.add(j);
                    lowestDoubleBondNumber = doubleBonds;
                    continue;
                }
                if (doubleBonds != lowestDoubleBondNumber) continue;
                lowestDoubleBonds.add(j);
            }
            if (lowestDoubleBonds.size() > 1 && lowestDoubleBonds.size() == containsOmega) {
                Vector<Integer> lowestOmegas = new Vector<Integer>();
                int lowestOmegaNumber = Integer.MAX_VALUE;
                for (int i = 0; i < lowestDoubleBonds.size(); ++i) {
                    int indexInFA = (Integer)lowestDoubleBonds.get(i);
                    String fa = fas.get(indexInFA);
                    if (fa.indexOf("(n-") == -1) continue;
                    String omegaString = fa.substring(fa.indexOf("(n-") + 3, fa.indexOf(")"));
                    int omega = Integer.parseInt(omegaString);
                    if (omega < lowestOmegaNumber) {
                        lowestOmegas = new Vector();
                        lowestOmegas.add(i);
                        lowestOmegaNumber = omega;
                        continue;
                    }
                    if (omega != lowestOmegaNumber) continue;
                    lowestOmegas.add(i);
                }
                for (Integer nrInLowestDBs : lowestOmegas) {
                    int indexInFA = (Integer)lowestDoubleBonds.get(nrInLowestDBs);
                    assignedFAs.add(indexInFA);
                    unassignedFAs.remove(indexInFA);
                }
                continue;
            }
            for (Integer nrInLowestCs : lowestDoubleBonds) {
                int indexInFA = (Integer)lowestCarbonNumbers.get(nrInLowestCs);
                assignedFAs.add(indexInFA);
                unassignedFAs.remove(indexInFA);
            }
        }
        for (Integer indexInFA : emptyFas.keySet()) {
            assignedFAs.add(indexInFA);
        }
        String faString = "";
        for (Integer faNr : assignedFAs) {
            if (faString.length() > 0) {
                faString = faString + "_";
            }
            faString = faString + fas.get(faNr);
        }
        return faString;
    }

    public static String getChainFragmentDisplayName(String name, String faName) {
        String displayName = name + "(" + faName + ")";
        if (StaticUtils.isAnAlex123Fragment(name)) {
            String chainPrefix = "FA";
            if (name.equals("LCB") || name.startsWith("LCB ") || name.startsWith("-LCB ")) {
                chainPrefix = "LCB";
            }
            if (name.indexOf(faName) == -1) {
                if (name.equals(chainPrefix)) {
                    displayName = chainPrefix + " " + faName;
                } else if (name.startsWith(chainPrefix + " ")) {
                    displayName = chainPrefix + " " + faName + name.substring((chainPrefix + " ").length());
                } else if (name.startsWith("-" + chainPrefix + " ")) {
                    displayName = "-" + chainPrefix + " " + faName + name.substring(("-" + chainPrefix + " ").length());
                }
            } else {
                displayName = name;
            }
        }
        return displayName;
    }

    public static boolean isAnAlex123Fragment(String name) {
        boolean useAlex = false;
        try {
            Class.forName("at.tugraz.genome.lda.Settings");
            useAlex = Settings.useAlex();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return useAlex && (name.equals("FA") || name.startsWith("FA ") || name.startsWith("-FA ") || name.equals("LCB") || name.startsWith("LCB ") || name.startsWith("-LCB ") || name.equals("O-") || name.startsWith("O-") || name.startsWith("-O-"));
    }

    public static Object[] parseChainFaAndFragmentNameFromExcel(String readableFragmentName, short chainType, int oh, boolean useOldEncoding) throws LipidCombinameEncodingException {
        Object[] result = new Object[2];
        String faName = "";
        String fragmentName = "";
        String oxState = "";
        if (readableFragmentName.startsWith("FA ") || readableFragmentName.startsWith("-FA ") || readableFragmentName.startsWith("LCB ") || readableFragmentName.startsWith("-LCB ") || readableFragmentName.startsWith("O-") || readableFragmentName.startsWith("-O-")) {
            int start = 0;
            String prefix = "FA";
            if (readableFragmentName.startsWith("LCB ") || readableFragmentName.startsWith("-LCB ")) {
                prefix = "LCB";
            }
            if (readableFragmentName.startsWith("O-") || readableFragmentName.startsWith("-O-")) {
                prefix = "O-";
            }
            fragmentName = readableFragmentName.startsWith(prefix + " ") || readableFragmentName.startsWith("O-") ? prefix : "-" + prefix;
            if (prefix.equalsIgnoreCase("FA") || prefix.equalsIgnoreCase("LCB")) {
                fragmentName = fragmentName + " ";
            }
            start = fragmentName.length();
            boolean isChain = true;
            int stop = start;
            char[] chars = readableFragmentName.toCharArray();
            if (chars.length > start + 1 && chars[start + 1] == '-' && (chars[start] == 'O' || chars[start] == 'P')) {
                stop += 2;
            }
            while (isChain && stop < readableFragmentName.length()) {
                if (Character.isDigit(chars[stop]) || chars[stop] == ':' || chars[stop] == ";".toCharArray()[0]) {
                    ++stop;
                    continue;
                }
                isChain = false;
            }
            faName = readableFragmentName.substring(start, stop);
            if (faName.indexOf(";") != -1) {
                faName = faName.substring(0, faName.indexOf(";"));
            }
            fragmentName = fragmentName + readableFragmentName.substring(stop);
        } else {
            faName = readableFragmentName.substring(readableFragmentName.indexOf("(") + 1, readableFragmentName.lastIndexOf(")"));
            fragmentName = readableFragmentName.substring(0, readableFragmentName.indexOf("("));
        }
        if (faName.contains(";")) {
            oxState = faName.substring(faName.indexOf(";") + 1);
        }
        Object[] prefixCAndDbs = null;
        try {
            prefixCAndDbs = StaticUtils.parsePrefixCAndDbsFromChainId(faName);
        }
        catch (Exception e) {
            throw new LipidCombinameEncodingException("The chain-id: \"" + readableFragmentName + "\" cannot be decoded");
        }
        result[0] = new FattyAcidVO(chainType, (String)prefixCAndDbs[0], (Integer)prefixCAndDbs[1], (Integer)prefixCAndDbs[2], oh, -1.0, null, oxState);
        result[1] = fragmentName.trim();
        if (readableFragmentName.startsWith("FA ") || readableFragmentName.startsWith("-FA ") || readableFragmentName.startsWith("LCB ") || readableFragmentName.startsWith("-LCB ") || readableFragmentName.startsWith("O-") || readableFragmentName.startsWith("-O-")) {
            result[1] = readableFragmentName;
        }
        return result;
    }

    public static Vector<String> getPermutedChainNames(Vector<String> singleCombiParts, String sep) {
        String currentName = "";
        Vector<String> permutedNames = StaticUtils.addPermutedPart(currentName, singleCombiParts, sep);
        return permutedNames;
    }

    private static Vector<String> addPermutedPart(String currentName, Vector<String> singleCombiParts, String sep) {
        Vector<String> permutedNames = new Vector<String>();
        for (int i = 0; i != singleCombiParts.size(); ++i) {
            String name = new String(currentName);
            name = name + singleCombiParts.get(i) + (sep != null ? sep : "_");
            Vector<String> subCombiParts = new Vector<String>(singleCombiParts);
            subCombiParts.remove(i);
            if (subCombiParts.size() > 0) {
                permutedNames.addAll(StaticUtils.addPermutedPart(name, subCombiParts, sep != null ? sep : "_"));
                continue;
            }
            name = name.substring(0, name.length() - (sep != null ? sep.length() : "_".length()));
            permutedNames.add(name);
        }
        return permutedNames;
    }

    public static boolean areAllChainsTheSame(String combiName) throws LipidCombinameEncodingException {
        Vector<String> fas = StaticUtils.splitChainCombiToEncodedStrings(combiName.replaceAll("/", "_"), "_");
        boolean theSame = true;
        for (int i = 1; i != fas.size(); ++i) {
            if (fas.get(i).equalsIgnoreCase(fas.get(0))) continue;
            theSame = false;
            break;
        }
        return theSame;
    }

    public static boolean checkChemicalFormula(String formula) {
        if (formula.contains("-")) {
            new WarningMessage(new JFrame(), "Error", "The formula " + formula + " must not contain any negative values!");
            return false;
        }
        char[] formulaChars = formula.toCharArray();
        String formulaToCheck = "";
        boolean isPreviousDigit = false;
        for (int i = 0; i != formulaChars.length; ++i) {
            char currentChar = formulaChars[i];
            if (isPreviousDigit && !Character.isDigit(currentChar)) {
                formulaToCheck = formulaToCheck + " ";
            }
            formulaToCheck = formulaToCheck + String.valueOf(currentChar);
            isPreviousDigit = Character.isDigit(currentChar);
        }
        ElementConfigParser aaParser = Settings.getElementParser();
        try {
            aaParser.calculateTheoreticalMass(formulaToCheck, false);
            return true;
        }
        catch (SpectrummillParserException e) {
            new WarningMessage(new JFrame(), "Error", "The formula " + formula + " is not OK! " + e.getMessage());
            return false;
        }
    }

    public static boolean isThereChainInformationAvailable(String speciesName, Vector<LipidParameterSet> sets) throws LipidCombinameEncodingException {
        boolean available = false;
        for (LipidParameterSet set : sets) {
            if (!StaticUtils.isThereChainInformationAvailable(speciesName, set)) continue;
            available = true;
            break;
        }
        return available;
    }

    public static boolean isThereChainInformationAvailable(String speciesName, LipidParameterSet set) throws LipidCombinameEncodingException {
        if (set instanceof LipidomicsMSnSet && ((LipidomicsMSnSet)set).getStatus() > 2) {
            LipidomicsMSnSet msn = (LipidomicsMSnSet)set;
            boolean isSelfIdentification = false;
            Vector<Object> identified = msn.getMSnIdentificationNames();
            if (identified.size() == 1 && identified.get(0) instanceof String && ((String)identified.get(0)).equalsIgnoreCase(speciesName)) {
                isSelfIdentification = true;
            }
            if (!isSelfIdentification) {
                return true;
            }
        }
        return false;
    }

    public static short determineEvidenceStateOfHit(LipidParameterSet set) {
        int ev = StaticUtils.checkMS2Evidence(set);
        switch (ev) {
            case 0: {
                return 0;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static double readPercentPermilleValue(String inValue) throws NumberFormatException {
        boolean percent = false;
        boolean permille = false;
        String value = new String(inValue);
        if (value.endsWith("%")) {
            percent = true;
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("\u2030")) {
            permille = true;
            value = value.substring(0, value.length() - 1);
        }
        try {
            double doubleValue = Double.parseDouble(value);
            if (percent) {
                doubleValue /= 100.0;
            } else if (permille) {
                doubleValue /= 1000.0;
            }
            return doubleValue;
        }
        catch (NumberFormatException nfx) {
            throw new NumberFormatException("The value " + inValue + " has not the correct format!");
        }
    }

    public static String[] parseCAndDbsFromChainId(String chainId) throws Exception {
        String[] cAndDbs = chainId.split(":|\\;");
        String[] cad = new String[3];
        if (cAndDbs.length == 2) {
            cad[2] = "";
        } else if (cAndDbs.length == 3) {
            cad[2] = cAndDbs[2];
        } else {
            throw new Exception("The chain id \"" + chainId + "\" is not valid!");
        }
        try {
            Integer.parseInt(cAndDbs[0]);
        }
        catch (NumberFormatException nfx) {
            throw new Exception("The chain id \"" + chainId + "\" is not valid!");
        }
        try {
            Integer.parseInt(cAndDbs[1]);
        }
        catch (NumberFormatException nfx) {
            throw new Exception("The chain id \"" + chainId + "\" is not valid!");
        }
        cad[0] = cAndDbs[0];
        cad[1] = cAndDbs[1];
        return cad;
    }

    public static String getHumanReadableCombiName(String combiName, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        return StaticUtils.getHumanReadableCombiName(StaticUtils.decodeLipidNamesFromChainCombi(combiName), faEncoding, lcbEncoding);
    }

    public static String getHumanReadableCombiName(Vector<FattyAcidVO> chains, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding) throws LipidCombinameEncodingException {
        StringBuilder combi = new StringBuilder();
        boolean ohPresent = StaticUtils.areThereOhInCombi(chains);
        for (FattyAcidVO chain : chains) {
            if (combi.length() != 0) {
                combi.append("_");
            }
            combi.append(StaticUtils.getHumanReadableChainName(chain, faEncoding, lcbEncoding, ohPresent));
        }
        return StaticUtils.sortFASequenceUnassigned(combi.toString(), "_");
    }

    public static boolean areThereOhInCombi(Vector<FattyAcidVO> chains) {
        boolean ohPresent = false;
        for (FattyAcidVO chain : chains) {
            if (chain.getOhNumber() <= 0) continue;
            ohPresent = true;
            break;
        }
        return ohPresent;
    }

    public static String getHumanReadableChainName(FattyAcidVO chain, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding, boolean ohInCombi) throws LipidCombinameEncodingException {
        return StaticUtils.getHumanReadableChainName(chain, faEncoding, lcbEncoding, ohInCombi, false);
    }

    public static String getHumanReadableChainName(FattyAcidVO chain, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding, boolean ohInCombi, boolean useAlexEncoding) throws LipidCombinameEncodingException {
        HydroxyEncoding encoding = null;
        if (chain.getChainType() == 0 || chain.getChainType() == 1 || chain.getChainType() == 2) {
            encoding = faEncoding;
        } else if (chain.getChainType() == 3) {
            encoding = lcbEncoding;
        }
        StringBuilder encoded = new StringBuilder();
        if (useAlexEncoding) {
            encoded.append(chain.getCarbonDbsId());
            if (chain.getOhNumber() > 0) {
                encoded.append(";" + chain.getOhNumber());
            }
        } else {
            if (chain.getChainType() == 1) {
                encoded.append("O-");
            } else if (chain.getChainType() == 2) {
                encoded.append("P-");
            }
            if (ohInCombi) {
                if (encoding == null) {
                    throw new LipidCombinameEncodingException("For lipid species containing OH groups, the corresponding encoding must be defined. For \"" + chain.getChainId() + "\", this is not the case!");
                }
                try {
                    encoded.append(encoding.getEncodedPrefix((short)chain.getOhNumber()));
                }
                catch (HydroxylationEncodingException e) {
                    throw new LipidCombinameEncodingException(e);
                }
            }
            encoded.append(chain.getCarbonDbsId());
        }
        return encoded.toString();
    }

    public static String getHumanReadableChainType(short chainType) {
        if (chainType == 0) {
            return "$CHAIN".substring(1);
        }
        if (chainType == 1) {
            return "$ALKYLCHAIN".substring(1);
        }
        if (chainType == 2) {
            return "$ALKENYLCHAIN".substring(1);
        }
        if (chainType == 3) {
            return "$LCB".substring(1);
        }
        return "ERROR: the chain type \"" + chainType + "\" is not allowed!";
    }

    public static String encodeLipidCombi(Vector<FattyAcidVO> chains) {
        Vector<String> chainIds = new Vector<String>();
        for (FattyAcidVO chain : chains) {
            chainIds.add(chain.getChainId());
        }
        return StaticUtils.encodeLipidCombiFromIds(chainIds);
    }

    public static String encodeLipidCombiFromIds(Vector<String> chainIds) {
        StringBuilder encoded = new StringBuilder();
        for (String chainId : chainIds) {
            if (encoded.length() != 0) {
                encoded.append("<->");
            }
            encoded.append(chainId);
        }
        return encoded.toString();
    }

    public static Vector<FattyAcidVO> decodeFAsFromHumanReadableName(String humanReadable, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding, boolean isAlexOhEncodingname, LipidomicsConstants lipidomicsConstants) throws LipidCombinameEncodingException {
        String[] hrChains;
        Vector<FattyAcidVO> chains = new Vector<FattyAcidVO>();
        String toSplit = humanReadable.replaceAll("/", "_");
        for (String hrChain : hrChains = toSplit.split("_")) {
            chains.add(StaticUtils.decodeHumanReadableChain(hrChain, faHydroxyEncoding, lcbHydroxyEncoding, isAlexOhEncodingname, lipidomicsConstants));
        }
        return chains;
    }

    public static String getHumanReadableWODoubleBondPositions(String doubleBondPositionsHumanReadable) {
        String regex = String.format("\\%s.*?\\%s", "(n-", ")");
        return doubleBondPositionsHumanReadable.replaceAll(regex, "");
    }

    public static String removeSNPositions(String snPositionsHumanReadable) {
        String regex = "\\s\\(sn-.*?\\)";
        return snPositionsHumanReadable.replaceAll(regex, "");
    }

    public static String removeModification(String withModification) {
        String regex = "\\;.*?[_\\/\\d$]";
        if (withModification.indexOf(";") != -1) {
            return withModification.replaceAll(regex, "");
        }
        return withModification;
    }

    public static FattyAcidVO decodeHumanReadableChain(String humanReadable, HydroxyEncoding faHydroxyEncoding, HydroxyEncoding lcbHydroxyEncoding, boolean isAlexOhEncodingname, LipidomicsConstants lipidomicsConstants) throws LipidCombinameEncodingException {
        int i;
        humanReadable = StaticUtils.removeSNPositions(humanReadable);
        short chainType = 0;
        String prefix = "";
        int cAtoms = -1;
        int dbs = -1;
        int oh = 0;
        int omegaPos = -1;
        String rest = humanReadable;
        String oxState = "";
        if (rest.startsWith("O-")) {
            rest = rest.substring("O-".length());
            chainType = 1;
        } else if (rest.startsWith("P-")) {
            rest = rest.substring("P-".length());
            chainType = 2;
        }
        char[] charsOfRest = rest.toCharArray();
        for (i = 0; !Character.isDigit(charsOfRest[i]) && i < charsOfRest.length; ++i) {
        }
        String beforeNumberString = rest.substring(0, i);
        rest = rest.substring(i);
        if (beforeNumberString.length() > 0) {
            int endIndex;
            for (endIndex = beforeNumberString.length(); endIndex != 0; --endIndex) {
                String substring = beforeNumberString.substring(0, endIndex);
                try {
                    oh = faHydroxyEncoding.getHydroxyNumber(substring).shortValue();
                    break;
                }
                catch (HydroxylationEncodingException hydroxylationEncodingException) {
                    try {
                        oh = lcbHydroxyEncoding.getHydroxyNumber(substring).shortValue();
                        if (chainType == 1 || chainType == 2) {
                            throw new LipidCombinameEncodingException("The chain-id: \"" + humanReadable + "\" cannot be decoded");
                        }
                        chainType = 3;
                        break;
                    }
                    catch (HydroxylationEncodingException hydroxylationEncodingException2) {
                        continue;
                    }
                }
            }
            prefix = beforeNumberString.substring(endIndex);
        }
        if (isAlexOhEncodingname && rest.indexOf(";") != -1) {
            try {
                oh = Integer.parseInt(rest.substring(rest.lastIndexOf(";") + 1));
                rest = rest.substring(0, rest.lastIndexOf(";"));
            }
            catch (NumberFormatException nfx) {
                throw new LipidCombinameEncodingException("The chain-id: \"" + humanReadable + "\" cannot be decoded");
            }
        }
        String chainModSeparator = ";";
        if (lipidomicsConstants != null) {
            chainModSeparator = lipidomicsConstants.getModSeparatorDependingOnVersion();
        }
        if (rest.indexOf(":") != -1) {
            try {
                String dbsPart = rest.substring(rest.lastIndexOf(":") + 1);
                if (rest.indexOf(chainModSeparator) != -1) {
                    oxState = dbsPart.substring(dbsPart.indexOf(chainModSeparator) + 1);
                    dbsPart = dbsPart.substring(0, dbsPart.indexOf(chainModSeparator));
                }
                if (dbsPart.indexOf("(n-") != -1 && dbsPart.indexOf(")") != -1) {
                    dbs = Integer.parseInt(dbsPart.substring(0, dbsPart.indexOf("(n-")));
                    omegaPos = Integer.parseInt(dbsPart.substring(dbsPart.indexOf("(n-") + "(n-".length(), dbsPart.lastIndexOf(")")));
                } else {
                    dbs = Integer.parseInt(dbsPart);
                }
                rest = rest.substring(0, rest.lastIndexOf(":"));
            }
            catch (NumberFormatException nfx) {
                throw new LipidCombinameEncodingException("The chain-id: \"" + humanReadable + "\" cannot be decoded");
            }
        }
        try {
            cAtoms = Integer.parseInt(rest);
        }
        catch (NumberFormatException nfx) {
            throw new LipidCombinameEncodingException("The chain-id: \"" + humanReadable + "\" cannot be decoded");
        }
        FattyAcidVO fa = new FattyAcidVO(chainType, prefix, cAtoms, dbs, oh, -1.0, null, oxState);
        fa.setOmegaPosition(omegaPos);
        return fa;
    }

    public static Object[] parsePrefixCAndDbsFromChainId(String chainId) throws LipidCombinameEncodingException {
        Object[] prefixCAndDbs = new Object[5];
        String rest = chainId;
        String prefix = "";
        short chainType = 0;
        if (chainId.startsWith("O-")) {
            chainType = 1;
            rest = rest.substring("O-".length());
        } else if (chainId.startsWith("P-")) {
            chainType = 2;
            rest = rest.substring("P-".length());
        }
        char[] chars = rest.toCharArray();
        int i = 0;
        while (!Character.isDigit(chars[i])) {
            ++i;
        }
        prefix = rest.substring(0, i);
        rest = rest.substring(i);
        String[] cAndDbAndOx = null;
        try {
            cAndDbAndOx = StaticUtils.parseCAndDbsFromChainId(rest);
        }
        catch (Exception e) {
            throw new LipidCombinameEncodingException("The chain-id: \"" + chainId + "\" cannot be decoded");
        }
        prefixCAndDbs[0] = prefix;
        prefixCAndDbs[1] = Integer.parseInt(cAndDbAndOx[0]);
        prefixCAndDbs[2] = Integer.parseInt(cAndDbAndOx[1]);
        prefixCAndDbs[3] = chainType;
        prefixCAndDbs[4] = cAndDbAndOx[2];
        return prefixCAndDbs;
    }

    public static FattyAcidVO decodeAlex123Chain(String encoded, String species) throws LipidCombinameEncodingException {
        short type = 0;
        int oh = 0;
        int cs = 0;
        int dbs = 0;
        String prefix = "";
        String part = new String(encoded);
        if (part.startsWith(Settings.getInternalStandardDefaultInput())) {
            prefix = Settings.getInternalStandardDefaultInput();
            part = part.substring(Settings.getInternalStandardDefaultInput().length());
        }
        if (part.startsWith("FA ")) {
            type = 0;
            part = part.substring("FA ".length());
        }
        if (part.startsWith("LCB ")) {
            type = 3;
            part = part.substring("LCB ".length());
        }
        if (part.startsWith("O-")) {
            type = 1;
            part = part.substring("O-".length());
        }
        if (part.startsWith("O-")) {
            type = 1;
            part = part.substring("O-".length());
        }
        if (part.startsWith("P-")) {
            type = 2;
            part = part.substring("P-".length());
        }
        if (part.startsWith("P-")) {
            type = 2;
            part = part.substring("P-".length());
        }
        if (part.indexOf("+") != -1) {
            int end;
            prefix = prefix + part.substring(part.indexOf("+"));
            char[] chars = prefix.toCharArray();
            for (end = chars.length; end > 0 && Character.isDigit(chars[end - 1]); --end) {
            }
            prefix = prefix + prefix.substring(0, end);
            part = part.substring(0, part.indexOf("+"));
        }
        if (part.indexOf(";") != -1) {
            type = 3;
            try {
                oh = Integer.parseInt(part.substring(part.indexOf(";") + 1));
                part = part.substring(0, part.indexOf(";"));
            }
            catch (NumberFormatException nfx) {
                throw new LipidCombinameEncodingException("The molecular species \"" + encoded + "\" of the species \"" + species + "\" cannot be decoded");
            }
        }
        if (part.indexOf(":") != -1) {
            try {
                dbs = Integer.parseInt(part.substring(part.indexOf(":") + 1));
                part = part.substring(0, part.indexOf(":"));
            }
            catch (NumberFormatException nfx) {
                throw new LipidCombinameEncodingException("The molecular species \"" + encoded + "\" of the species \"" + species + "\" cannot be decoded");
            }
        }
        try {
            cs = Integer.parseInt(part);
        }
        catch (NumberFormatException nfx) {
            throw new LipidCombinameEncodingException("The molecular species \"" + encoded + "\" of the species \"" + species + "\" cannot be decoded");
        }
        return new FattyAcidVO(type, prefix, cs, dbs, oh, -1.0, null, "");
    }

    public static String encodeAlexMolSpeciesName(String className, Vector<FattyAcidVO> chains) {
        StringBuilder sb = new StringBuilder();
        sb.append(className + " ");
        boolean first = true;
        for (FattyAcidVO chain : chains) {
            if (!first) {
                sb.append("-");
            } else {
                first = false;
            }
            sb.append(chain.getCarbonDbsId());
            if (chain.getOhNumber() <= 0) continue;
            sb.append(";" + String.valueOf(chain.getOhNumber()));
        }
        return sb.toString();
    }

    public static Vector<Vector<FattyAcidVO>> getAllPotentialChainCombinationForThisRule(IntensityRuleVO rule, Vector<FattyAcidVO> fas) {
        Vector<Vector<FattyAcidVO>> combis = new Vector<Vector<FattyAcidVO>>();
        Set<Short> chainTypesOfRule = rule.getAvailableTypes();
        for (Short type : chainTypesOfRule) {
            if (type == -1) continue;
            combis = StaticUtils.addChainsOfOneType(type, fas, combis);
        }
        return combis;
    }

    private static Vector<Vector<FattyAcidVO>> addChainsOfOneType(short type, Vector<FattyAcidVO> chains, Vector<Vector<FattyAcidVO>> oldCombis) {
        Vector<Vector<FattyAcidVO>> combis = new Vector<Vector<FattyAcidVO>>();
        Vector<FattyAcidVO> sameType = new Vector<FattyAcidVO>();
        for (FattyAcidVO fattyAcidVO : chains) {
            if (fattyAcidVO.getChainType() != type) continue;
            boolean add = true;
            for (FattyAcidVO otherFa : sameType) {
                if (!otherFa.getChainId().equalsIgnoreCase(fattyAcidVO.getChainId())) continue;
                add = false;
                break;
            }
            if (!add) continue;
            sameType.add(fattyAcidVO);
        }
        if (sameType.size() == 0) {
            return oldCombis;
        }
        if (oldCombis.size() == 0) {
            for (FattyAcidVO fattyAcidVO : sameType) {
                Vector<FattyAcidVO> combiFas = new Vector<FattyAcidVO>();
                combiFas.add(fattyAcidVO);
                combis.add(combiFas);
            }
        } else {
            for (Vector vector : oldCombis) {
                for (FattyAcidVO fa : sameType) {
                    Vector<FattyAcidVO> combiFas = new Vector<FattyAcidVO>(vector);
                    combiFas.add(fa);
                    combis.add(combiFas);
                }
            }
        }
        return combis;
    }

    public static Vector<String> getAllAffectedChainCombinations(Vector<String> validChainCombinations, Vector<String> chainsOfRule) throws LipidCombinameEncodingException {
        Vector<String> affectedCombinations = new Vector<String>();
        for (String id : validChainCombinations) {
            int amount;
            Hashtable<String, Integer> chainAmounts = new Hashtable<String, Integer>();
            for (String chain : StaticUtils.splitChainCombiToEncodedStrings(id, "<->")) {
                amount = chainAmounts.containsKey(chain) ? (Integer)chainAmounts.get(chain) : 0;
                chainAmounts.put(chain, ++amount);
            }
            boolean affected = true;
            for (String chain : chainsOfRule) {
                if (chainAmounts.containsKey(chain)) {
                    amount = (Integer)chainAmounts.get(chain);
                    if (--amount < 1) {
                        chainAmounts.remove(chain);
                        continue;
                    }
                    chainAmounts.put(chain, amount);
                    continue;
                }
                affected = false;
                break;
            }
            if (!affected) continue;
            affectedCombinations.add(id);
        }
        return affectedCombinations;
    }

    public static Vector<String> sortChainCombinations(Set<String> unsorted) throws LipidCombinameEncodingException {
        int count;
        if (unsorted.size() < 2) {
            return new Vector<String>(unsorted);
        }
        Hashtable<String, Vector<FattyAcidVO>> unsortedHash = new Hashtable<String, Vector<FattyAcidVO>>();
        for (String combi : unsorted) {
            unsortedHash.put(combi, StaticUtils.decodeLipidNamesFromChainCombi(combi));
        }
        String encodedFA = null;
        int nrOfChains = ((Vector)unsortedHash.values().iterator().next()).size();
        int[][] positions = new int[unsorted.size()][nrOfChains - 1];
        Hashtable<Integer, Integer> nrOfOptionsEachLevel = new Hashtable<Integer, Integer>();
        for (int i = 0; i != nrOfChains - 1; ++i) {
            Hashtable there = new Hashtable();
            Vector<FattyAcidVO> unsortedFAs = new Vector<FattyAcidVO>();
            for (Vector fas : unsortedHash.values()) {
                encodedFA = StaticUtils.encodeLipidNameForCreatingCombis((FattyAcidVO)fas.get(i), true, true);
                if (there.containsKey(encodedFA)) continue;
                there.put(encodedFA, encodedFA);
                unsortedFAs.add((FattyAcidVO)fas.get(i));
            }
            Vector<FattyAcidVO> sortedFAs = StaticUtils.sortChainVOs(unsortedFAs);
            nrOfOptionsEachLevel.put(i, sortedFAs.size());
            count = 0;
            for (Vector fas : unsortedHash.values()) {
                String fa1Encoded = StaticUtils.encodeLipidNameForCreatingCombis((FattyAcidVO)fas.get(i), true, true);
                for (int j = 0; j != sortedFAs.size(); ++j) {
                    if (!fa1Encoded.equalsIgnoreCase(StaticUtils.encodeLipidNameForCreatingCombis(sortedFAs.get(j), true, true))) continue;
                    positions[count][i] = j;
                }
                ++count;
            }
        }
        count = 0;
        ArrayList<IntegerStringVO> toSort = new ArrayList<IntegerStringVO>();
        for (String combi : unsortedHash.keySet()) {
            int multFactor = 1;
            int totalValue = 0;
            for (int i = nrOfChains - 2; i != -1; --i) {
                totalValue += positions[count][i] * multFactor;
                multFactor *= ((Integer)nrOfOptionsEachLevel.get(i)).intValue();
            }
            toSort.add(new IntegerStringVO(combi, totalValue));
            ++count;
        }
        Collections.sort(toSort, new GeneralComparator("at.tugraz.genome.lda.vos.IntegerStringVO", "getValue", "java.lang.Integer"));
        Vector<String> sorted = new Vector<String>();
        for (IntegerStringVO vo : toSort) {
            sorted.add(vo.getKey());
        }
        return sorted;
    }

    public static Vector<String> sortChainNames(Vector<String> unsorted, boolean ohInCombi, boolean excludePrefix) throws LipidCombinameEncodingException {
        Vector<FattyAcidVO> fas = new Vector<FattyAcidVO>();
        for (String name : unsorted) {
            FattyAcidVO fa = StaticUtils.decodeHumanReadableChain(name, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
            if (excludePrefix) {
                fa.setPrefix("");
            }
            fas.add(fa);
        }
        Vector<FattyAcidVO> sortedChains = StaticUtils.sortChainVOs(fas);
        Vector<String> sorted = new Vector<String>();
        for (FattyAcidVO vo : sortedChains) {
            sorted.add(StaticUtils.getHumanReadableChainName(vo, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), ohInCombi));
        }
        return sorted;
    }

    public static Vector<FattyAcidVO> sortChainVOs(Vector<FattyAcidVO> unsorted) {
        String encoded;
        Hashtable<Integer, Hashtable> hash = new Hashtable<Integer, Hashtable>();
        Hashtable<String, Integer> frequencyOfFA = new Hashtable<String, Integer>();
        for (FattyAcidVO fa : unsorted) {
            encoded = StaticUtils.encodeLipidNameForCreatingCombis(fa, true, true);
            if (!frequencyOfFA.containsKey(encoded)) {
                frequencyOfFA.put(encoded, 0);
            }
            frequencyOfFA.put(encoded, (Integer)frequencyOfFA.get(encoded) + 1);
            Hashtable sameCarbons = new Hashtable();
            if (hash.containsKey(fa.getcAtoms())) {
                sameCarbons = (Hashtable)hash.get(fa.getcAtoms());
            }
            Hashtable sameDbs = new Hashtable();
            if (sameCarbons.containsKey(fa.getDoubleBonds())) {
                sameDbs = (Hashtable)sameCarbons.get(fa.getDoubleBonds());
            }
            Hashtable sameOh = new Hashtable();
            if (sameDbs.containsKey(fa.getOhNumber())) {
                sameOh = (Hashtable)sameDbs.get(fa.getOhNumber());
            }
            Hashtable sameOmega = new Hashtable();
            if (sameOh.containsKey(fa.getOmegaPosition())) {
                sameOmega = (Hashtable)sameOh.get(fa.getOmegaPosition());
            }
            Hashtable sameType = new Hashtable();
            if (sameOmega.containsKey(fa.getChainType())) {
                sameType = (Hashtable)sameOmega.get(fa.getChainType());
            }
            sameType.put(fa.getPrefix(), fa);
            sameOmega.put(fa.getChainType(), sameType);
            sameOh.put(fa.getOmegaPosition(), sameOmega);
            sameDbs.put(fa.getOhNumber(), sameOh);
            sameCarbons.put(fa.getDoubleBonds(), sameDbs);
            hash.put(fa.getcAtoms(), sameCarbons);
        }
        Vector<FattyAcidVO> sorted = new Vector<FattyAcidVO>();
        ArrayList carbons = new ArrayList(hash.keySet());
        Collections.sort(carbons);
        for (Integer carbon : carbons) {
            ArrayList dbs = new ArrayList(((Hashtable)hash.get(carbon)).keySet());
            Collections.sort(dbs);
            for (Integer db : dbs) {
                ArrayList ohs = new ArrayList(((Hashtable)((Hashtable)hash.get(carbon)).get(db)).keySet());
                Collections.sort(ohs);
                for (Integer oh : ohs) {
                    ArrayList sameOmega = new ArrayList(((Hashtable)((Hashtable)((Hashtable)hash.get(carbon)).get(db)).get(oh)).keySet());
                    Collections.sort(sameOmega);
                    for (Integer omega : sameOmega) {
                        ArrayList sameType = new ArrayList(((Hashtable)((Hashtable)((Hashtable)((Hashtable)hash.get(carbon)).get(db)).get(oh)).get(omega)).keySet());
                        Collections.sort(sameType);
                        for (int i = sameType.size() - 1; i != -1; --i) {
                            FattyAcidVO fac;
                            ArrayList prefixes = new ArrayList(((Hashtable)((Hashtable)((Hashtable)((Hashtable)((Hashtable)hash.get(carbon)).get(db)).get(oh)).get(omega)).get(sameType.get(i))).keySet());
                            if (prefixes.contains("")) {
                                fac = (FattyAcidVO)((Hashtable)((Hashtable)((Hashtable)((Hashtable)((Hashtable)hash.get(carbon)).get(db)).get(oh)).get(omega)).get(sameType.get(i))).get("");
                                encoded = StaticUtils.encodeLipidNameForCreatingCombis(fac, true, true);
                                for (int j = 0; j != (Integer)frequencyOfFA.get(encoded); ++j) {
                                    sorted.add(fac);
                                }
                                prefixes.remove("");
                            }
                            Collections.sort(prefixes);
                            for (String prefix : prefixes) {
                                fac = (FattyAcidVO)((Hashtable)((Hashtable)((Hashtable)((Hashtable)((Hashtable)hash.get(carbon)).get(db)).get(oh)).get(omega)).get(sameType.get(i))).get(prefix);
                                encoded = StaticUtils.encodeLipidNameForCreatingCombis(fac, true, true);
                                for (int j = 0; j != (Integer)frequencyOfFA.get(encoded); ++j) {
                                    sorted.add(fac);
                                }
                            }
                        }
                    }
                }
            }
        }
        return sorted;
    }

    public static void extractIsoLabelInformation(Set<String> labels, Set<String> availableSingleLabels, Hashtable<String, String> singleLabelLookup, Hashtable<String, Integer> availableLabels) {
        for (String label : labels) {
            if (availableLabels.containsKey(label)) continue;
            char[] labelChars = label.toCharArray();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i != label.length(); ++i) {
                char ch = labelChars[i];
                if (sb.length() == 0) {
                    sb.append(ch);
                    continue;
                }
                if (label.substring(i, label.length()).startsWith(sb.toString())) {
                    int current = i;
                    int iter = 1;
                    while (label.substring(current, label.length()).startsWith(sb.toString())) {
                        current += sb.length();
                        ++iter;
                    }
                    if (current == label.length()) {
                        availableSingleLabels.add(sb.toString());
                        singleLabelLookup.put(label, sb.toString());
                        availableLabels.put(label, iter);
                        break;
                    }
                }
                sb.append(ch);
            }
            if (availableLabels.containsKey(label)) continue;
            availableSingleLabels.add(sb.toString());
            singleLabelLookup.put(label, sb.toString());
            availableLabels.put(label, 1);
        }
    }

    public static boolean isChemicalFormulaTheSame(Hashtable<String, Integer> one, Hashtable<String, Integer> two) {
        if (one.size() != two.size()) {
            return false;
        }
        for (String element : one.keySet()) {
            if (two.containsKey(element) && one.get(element) == two.get(element)) continue;
            return false;
        }
        return true;
    }

    public static Object[] translateAlexNomenclatureToLDA(String alexClass, String alexSpecies, String alexMolSpecies) throws LipidCombinameEncodingException {
        Object[] classSpeciesMol = new Object[3];
        String species = "";
        String molSpecies = null;
        String className = alexClass;
        if (className.startsWith("IS ")) {
            className = className.substring("IS ".length());
            species = Settings.getInternalStandardDefaultInput();
        }
        if (alexClass.endsWith(" O-")) {
            className = "O-" + className.substring(0, alexClass.length() - " O-".length());
            species = species + alexSpecies.substring(alexClass.length() - " O-".length() + 1);
            if (alexMolSpecies != null && alexMolSpecies.length() > 0) {
                molSpecies = alexMolSpecies.substring(alexClass.length() - " O-".length() + 1);
            }
        } else if (alexClass.endsWith(" P-")) {
            className = "P-" + className.substring(0, alexClass.length() - " P-".length());
            species = species + alexSpecies.substring(alexClass.length() - " P-".length() + 1);
            if (alexMolSpecies != null && alexMolSpecies.length() > 0) {
                molSpecies = alexMolSpecies.substring(alexClass.length() - " P-".length() + 1);
            }
        } else {
            species = species + alexSpecies.substring(alexClass.length() + 1);
            if (alexMolSpecies != null && alexMolSpecies.length() > 0) {
                molSpecies = alexMolSpecies.substring(alexClass.length() + 1);
            }
        }
        FattyAcidVO speciesVO = StaticUtils.decodeAlex123Chain(species, species);
        classSpeciesMol[0] = className;
        classSpeciesMol[1] = speciesVO;
        if (alexMolSpecies != null && alexMolSpecies.length() > 0) {
            Vector<FattyAcidVO> chains = new Vector<FattyAcidVO>();
            Vector<String> parts = StaticUtils.getAlexChainParts(molSpecies);
            for (String part : parts) {
                chains.add(StaticUtils.decodeAlex123Chain(part, species));
            }
            chains = StaticUtils.sortChainVOs(chains);
            classSpeciesMol[2] = StaticUtils.encodeLipidCombi(chains);
        } else {
            classSpeciesMol[2] = molSpecies;
        }
        return classSpeciesMol;
    }

    private static Vector<String> getAlexChainParts(String combi) {
        Vector<String> parts = new Vector<String>();
        String rest = combi.replaceAll("/", "-");
        int cut = rest.length();
        while (rest.substring(0, cut).indexOf("-") != -1) {
            int last = rest.substring(0, cut).lastIndexOf("-");
            if (last + 1 >= "O-".length() && "O-".equalsIgnoreCase(rest.substring(last - "O-".length() + "-".length(), last + "-".length()))) {
                cut = last;
                continue;
            }
            if (last + 1 >= "O-".length() && "O-".equalsIgnoreCase(rest.substring(last - "O-".length() + "-".length(), last + "-".length()))) {
                cut = last;
                continue;
            }
            if (last + 1 >= "P-".length() && "O-".equalsIgnoreCase(rest.substring(last - "P-".length() + "-".length(), last + "-".length()))) {
                cut = last;
                continue;
            }
            if (last + 1 >= "P-".length() && "O-".equalsIgnoreCase(rest.substring(last - "P-".length() + "-".length(), last + "-".length()))) {
                cut = last;
                continue;
            }
            parts.add(0, rest.substring(last + 1));
            rest = rest.substring(0, last);
            cut = rest.length();
        }
        parts.add(0, rest);
        return parts;
    }

    public static String[] extractFormulaAndAdductName(String contents) {
        String[] formulaAndName = new String[4];
        String formula = "";
        String adductName = "";
        String charge = "1";
        String multi = "1";
        String formNameString = contents.substring(contents.indexOf("(") + 1, contents.indexOf(")"));
        if (formNameString.indexOf("form") != -1 && formNameString.indexOf("name") != -1) {
            String nearFormString = formNameString.substring(formNameString.indexOf("form"));
            formula = nearFormString.substring(nearFormString.indexOf("[") + 1, nearFormString.indexOf("]")).trim();
            String nearNameString = formNameString.substring(formNameString.indexOf("name"));
            adductName = nearNameString.substring(nearNameString.indexOf("[") + 1, nearNameString.indexOf("]")).trim();
            if (formNameString.indexOf("charge=") != -1) {
                String afterChargeString = formNameString.substring(formNameString.indexOf("charge=") + "charge=".length());
                try {
                    charge = String.valueOf(StaticUtils.extractDigitsAfterEqualSign(afterChargeString));
                }
                catch (NumberFormatException nfx) {
                    System.out.println("Warning: The charge entry in the column header \"" + contents + "\" is not integer format! Setting it to \"1\"");
                }
            }
            if (formNameString.indexOf("mult=") != -1) {
                String afterMultiString = formNameString.substring(formNameString.indexOf("mult=") + "mult=".length());
                try {
                    multi = String.valueOf(StaticUtils.extractDigitsAfterEqualSign(afterMultiString));
                }
                catch (NumberFormatException nfx) {
                    System.out.println("Warning: The mult entry in the column header \"" + contents + "\" is not integer format! Setting it to \"1\"");
                }
            }
        } else {
            adductName = formNameString;
        }
        formulaAndName[0] = formula;
        formulaAndName[1] = adductName;
        formulaAndName[2] = charge;
        formulaAndName[3] = multi;
        return formulaAndName;
    }

    private static int extractDigitsAfterEqualSign(String afterString) {
        afterString.trim();
        return Math.abs(Integer.parseInt(afterString));
    }

    public static String getHumanReadableCombiName(String combiName, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding, boolean chainPositionsFixed) throws LipidCombinameEncodingException {
        return StaticUtils.getHumanReadableCombiName(StaticUtils.decodeLipidNamesFromChainCombi(combiName), faEncoding, lcbEncoding, chainPositionsFixed);
    }

    public static String getHumanReadableCombiName(Vector<FattyAcidVO> chains, HydroxyEncoding faEncoding, HydroxyEncoding lcbEncoding, boolean chainPositionsFixed) throws LipidCombinameEncodingException {
        if (!chainPositionsFixed) {
            Collections.sort(chains);
        }
        StringBuilder combi = new StringBuilder();
        boolean ohPresent = StaticUtils.areThereOhInCombi(chains);
        for (FattyAcidVO chain : chains) {
            if (combi.length() != 0) {
                if (!chainPositionsFixed) {
                    combi.append("_");
                } else {
                    combi.append("/");
                }
            }
            combi.append(StaticUtils.getHumanReadableChainName(chain, faEncoding, lcbEncoding, ohPresent));
        }
        return combi.toString();
    }

    public static Range[] determinePeakRanges(LipidParameterSet param) {
        float lowerValley = param.getIsotopicProbes().get((int)0).get((int)0).LowerValley;
        float upperValley = param.getIsotopicProbes().get((int)0).get((int)0).UpperValley;
        float peak = param.getIsotopicProbes().get((int)0).get((int)0).Peak;
        float shorterDistance = Math.abs(peak - lowerValley) <= Math.abs(peak - upperValley) ? Math.abs(peak - lowerValley) : Math.abs(peak - upperValley);
        int n = 3;
        int minimumThreshold = LipidomicsConstants.getMinimumThresholdForHighConfidenceRTMatch();
        float mediumAccuracyCutoff = shorterDistance / (float)n * 2.0f;
        float highAccuracyCutoff = shorterDistance / (float)n;
        if (shorterDistance < (float)(minimumThreshold * n)) {
            highAccuracyCutoff = minimumThreshold;
            mediumAccuracyCutoff = shorterDistance > (float)minimumThreshold ? shorterDistance : (float)minimumThreshold;
        }
        Range[] peakRanges = new Range[]{new Range(lowerValley / 60.0f, upperValley / 60.0f), new Range((peak - mediumAccuracyCutoff) / 60.0f, (peak + mediumAccuracyCutoff) / 60.0f), new Range((peak - highAccuracyCutoff) / 60.0f, (peak + highAccuracyCutoff) / 60.0f)};
        return peakRanges;
    }

    public static Vector<DoubleBondPositionVO> getAssignedDoubleBondPositions(Vector<DoubleBondPositionVO> paramOmegaInfo) {
        Vector<DoubleBondPositionVO> assignedHits = new Vector<DoubleBondPositionVO>();
        for (int i = 0; i < paramOmegaInfo.size(); ++i) {
            if (!paramOmegaInfo.get(i).getIsAssigned()) continue;
            assignedHits.add(paramOmegaInfo.get(i));
        }
        return assignedHits;
    }

    public static Vector<DoubleBondPositionVO> getHighAccuracyDoubleBondPositions(Vector<DoubleBondPositionVO> paramOmegaInfo) {
        Vector<DoubleBondPositionVO> highAccuracyHits = new Vector<DoubleBondPositionVO>();
        for (int i = 0; i < paramOmegaInfo.size(); ++i) {
            if (paramOmegaInfo.get(i).getAccuracy() <= 1) continue;
            highAccuracyHits.add(paramOmegaInfo.get(i));
        }
        return highAccuracyHits;
    }

    public static Vector<DoubleBondPositionVO> findUnambiguousDoubleBondPositions(Vector<DoubleBondPositionVO> highAccuracyHits) {
        Vector<DoubleBondPositionVO> assignedHits = new Vector<DoubleBondPositionVO>();
        int n = highAccuracyHits.size();
        if (n == 1) {
            assignedHits.add(highAccuracyHits.get(0));
            return assignedHits;
        }
        if (n == 2) {
            if (!highAccuracyHits.get(0).getMolecularSpecies().equals(highAccuracyHits.get(1).getMolecularSpecies())) {
                assignedHits.add(highAccuracyHits.get(0));
                assignedHits.add(highAccuracyHits.get(1));
                return assignedHits;
            }
        } else if (n > 2) {
            if (!highAccuracyHits.get(0).getMolecularSpecies().equals(highAccuracyHits.get(1).getMolecularSpecies())) {
                assignedHits.add(highAccuracyHits.get(0));
            }
            for (int i = 1; i < n - 1; ++i) {
                if (highAccuracyHits.get(i).getMolecularSpecies().equals(highAccuracyHits.get(i - 1).getMolecularSpecies()) || highAccuracyHits.get(i).getMolecularSpecies().equals(highAccuracyHits.get(i + 1).getMolecularSpecies())) continue;
                assignedHits.add(highAccuracyHits.get(i));
            }
            if (!highAccuracyHits.get(n - 2).getMolecularSpecies().equals(highAccuracyHits.get(n - 1).getMolecularSpecies())) {
                assignedHits.add(highAccuracyHits.get(n - 1));
            }
        }
        return assignedHits;
    }

    public static Vector<DoubleBondPositionVO> findUnambiguousDoubleBondPositionsNew(LipidParameterSet param) {
        Vector<DoubleBondPositionVO> assignedHits = new Vector<DoubleBondPositionVO>();
        LinkedHashMap<String, LinkedHashMap<Integer, ArrayList<DoubleBondPositionVO>>> container = StaticUtils.sortDoubleBondPositionVOsOfID(param);
        for (String molecularSpecies : container.keySet()) {
            DoubleBondPositionVO combined;
            LinkedHashMap<Integer, ArrayList<DoubleBondPositionVO>> speciesOfHit = container.get(molecularSpecies);
            ArrayList<DoubleBondPositionVO> highAccuracy = speciesOfHit.get(2);
            if (highAccuracy.size() > 1 && (combined = StaticUtils.combineUnambiguousDoubleBondPositions(highAccuracy, param.getPreciseRT())) != null) {
                highAccuracy.removeAll(highAccuracy);
                highAccuracy.add(combined);
                param.addOmegaInformation(combined);
            }
            if (highAccuracy.size() == 1) {
                assignedHits.add(highAccuracy.get(0));
                continue;
            }
            if (!highAccuracy.isEmpty()) continue;
            ArrayList<DoubleBondPositionVO> intermediateConfidence = speciesOfHit.get(1);
            ArrayList<DoubleBondPositionVO> notHighAccuracy = new ArrayList<DoubleBondPositionVO>(intermediateConfidence);
            notHighAccuracy.addAll((Collection<DoubleBondPositionVO>)speciesOfHit.get(0));
            if (notHighAccuracy.size() > 1 && !intermediateConfidence.isEmpty()) {
                intermediateConfidence.removeAll(intermediateConfidence);
                DoubleBondPositionVO combined2 = StaticUtils.combineUnambiguousDoubleBondPositions(notHighAccuracy, param.getPreciseRT());
                if (combined2 != null) {
                    intermediateConfidence.add(combined2);
                    param.addOmegaInformation(combined2);
                }
            }
            if (intermediateConfidence.size() != 1) continue;
            assignedHits.add(intermediateConfidence.get(0));
        }
        return assignedHits;
    }

    private static DoubleBondPositionVO combineUnambiguousDoubleBondPositions(ArrayList<DoubleBondPositionVO> vos, Double rt) {
        ArrayList<Vector<Integer>> patterns = new ArrayList<Vector<Integer>>();
        for (DoubleBondPositionVO vo : vos) {
            patterns.add(vo.getPositionAssignmentPattern());
        }
        Vector<Integer> combinedPattern = StaticUtils.computeConsensusPattern(patterns);
        boolean anyPositionDefined = false;
        for (Integer pos : combinedPattern) {
            if (pos <= 0) continue;
            anyPositionDefined = true;
        }
        DoubleBondPositionVO newVO = null;
        if (anyPositionDefined) {
            DoubleBondPositionVO closest = vos.get(0);
            Double closestDiff = Math.abs(closest.getExpectedRetentionTime() - rt);
            for (DoubleBondPositionVO vo : vos) {
                if (!(Math.abs(vo.getExpectedRetentionTime() - rt) < closestDiff)) continue;
                closest = vo;
            }
            newVO = new DoubleBondPositionVO(closest);
            Vector<FattyAcidVO> newChainCombination = new Vector<FattyAcidVO>();
            Integer i = 0;
            while (i < newVO.getChainCombination().size()) {
                FattyAcidVO fattyAcid = newVO.getChainCombination().get(i);
                fattyAcid.setOmegaPosition(combinedPattern.get(i));
                newChainCombination.add(fattyAcid);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            newVO.setChainCombination(newChainCombination);
        }
        return newVO;
    }

    private static Vector<Integer> computeConsensusPattern(ArrayList<Vector<Integer>> patterns) {
        Vector<Integer> combinedPattern = new Vector<Integer>();
        LinkedHashMap patternOverlap = new LinkedHashMap();
        for (Vector<Integer> pattern : patterns) {
            for (int j = 0; j < pattern.size(); ++j) {
                if (!patternOverlap.containsKey(j)) {
                    patternOverlap.put(j, new HashSet());
                }
                ((HashSet)patternOverlap.get(j)).add(pattern.get(j));
            }
        }
        Iterator<Vector<Integer>> iterator = patternOverlap.keySet().iterator();
        while (iterator.hasNext()) {
            int chainPos = (Integer)((Object)iterator.next());
            ArrayList consensus = new ArrayList((Collection)patternOverlap.get(chainPos));
            int numberOfPos = 0;
            Iterator iterator2 = consensus.iterator();
            while (iterator2.hasNext()) {
                int pos = (Integer)iterator2.next();
                if (pos <= 0) continue;
                ++numberOfPos;
            }
            if (numberOfPos == 1) {
                if (consensus.contains(-1)) {
                    combinedPattern.add(chainPos, -1);
                    continue;
                }
                combinedPattern.add(chainPos, (Integer)consensus.get(0));
                continue;
            }
            combinedPattern.add(chainPos, -1);
        }
        return combinedPattern;
    }

    private static LinkedHashMap<String, LinkedHashMap<Integer, ArrayList<DoubleBondPositionVO>>> sortDoubleBondPositionVOsOfID(LipidParameterSet param) {
        LinkedHashMap<String, LinkedHashMap<Integer, ArrayList<DoubleBondPositionVO>>> container = new LinkedHashMap<String, LinkedHashMap<Integer, ArrayList<DoubleBondPositionVO>>>();
        for (DoubleBondPositionVO vo : param.getOmegaInformation()) {
            Integer accuracy;
            String molecularSpecies = vo.getMolecularSpecies();
            if (!container.containsKey(molecularSpecies)) {
                container.put(molecularSpecies, new LinkedHashMap());
                container.get(molecularSpecies).put(2, new ArrayList());
                container.get(molecularSpecies).put(1, new ArrayList());
                container.get(molecularSpecies).put(0, new ArrayList());
            }
            if ((accuracy = Integer.valueOf(vo.getAccuracy() == 0 ? 1 : vo.getAccuracy())) == 2) {
                container.get(molecularSpecies).get(accuracy).add(vo);
                continue;
            }
            if (Math.abs(param.getPreciseRT() - vo.getExpectedRetentionTime()) * 60.0 < (double)LipidomicsConstants.getMaximumThresholdForIntermediateConfidenceRTMatch()) {
                container.get(molecularSpecies).get(accuracy).add(vo);
                continue;
            }
            container.get(molecularSpecies).get(0).add(vo);
        }
        return container;
    }

    public static Set<String> getMolecularSpeciesSet(Vector<DoubleBondPositionVO> omegaInfo) {
        HashSet<String> molecularSpeciesSet = new HashSet<String>();
        for (DoubleBondPositionVO doubleBondPositionVO : omegaInfo) {
            molecularSpeciesSet.add(doubleBondPositionVO.getMolecularSpecies());
        }
        return molecularSpeciesSet;
    }

    public static Vector<DoubleBondPositionVO> getDoubleBondAssignmentsOfMolecularSpecies(Vector<DoubleBondPositionVO> omegaInfo, String molecularSpecies) {
        Vector<DoubleBondPositionVO> doubleBondAssignmentsOfMolecularSpecies = new Vector<DoubleBondPositionVO>();
        for (DoubleBondPositionVO labeledChainCombiVO : omegaInfo) {
            if (!labeledChainCombiVO.getMolecularSpecies().equals(molecularSpecies)) continue;
            doubleBondAssignmentsOfMolecularSpecies.add(labeledChainCombiVO);
        }
        return doubleBondAssignmentsOfMolecularSpecies;
    }

    public static boolean isChainCombinationEquivalent(String doubleBondPositionsHumanReadable, String molecularSpecies) {
        boolean isChainCombinationEquivalent = false;
        String noDoubleBonds = StaticUtils.getHumanReadableWODoubleBondPositions(doubleBondPositionsHumanReadable);
        Object[] arrayNoDoubleBonds = StaticUtils.splitChainCombinationsAtChainSeparators(noDoubleBonds);
        Object[] arrayIdentifications = StaticUtils.splitChainCombinationsAtChainSeparators(molecularSpecies);
        if (arrayNoDoubleBonds != null && arrayIdentifications != null) {
            Arrays.sort(arrayNoDoubleBonds);
            Arrays.sort(arrayIdentifications);
            if (Arrays.equals(arrayNoDoubleBonds, arrayIdentifications)) {
                isChainCombinationEquivalent = true;
            }
        }
        return isChainCombinationEquivalent;
    }

    public static String[] splitChainCombinationsAtChainSeparators(String s) {
        String str = new String(s);
        String[] splitString = new String[]{str};
        if (str.contains("_")) {
            splitString = str.split("_");
        } else if (str.contains("/")) {
            splitString = str.split("/");
        }
        return splitString;
    }

    public static float calculatedMzTolValue(float mz, float tolerance, short tolUnit) {
        float tol = 0.0f;
        if (tolUnit == 0) {
            tol = tolerance;
        } else if (tolUnit == 1) {
            tol = mz * 1.0E-6f * tolerance;
        }
        return tol;
    }
}

