/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.utils;

import at.tugraz.genome.lda.exception.LMException;
import at.tugraz.genome.lda.utils.LevenbergMarquardtOptimizer;
import at.tugraz.genome.util.FloatMatrix;

public class LMQuadraticTwoVariables
extends LevenbergMarquardtOptimizer {
    private float[][] values_;
    private float[][] observations_;

    public LMQuadraticTwoVariables(float[][] xValues, float[] observations, FloatMatrix parameters) {
        this.values_ = xValues;
        this.observations_ = new float[observations.length][1];
        for (int i = 0; i != observations.length; ++i) {
            this.observations_[i][0] = observations[i];
        }
        if (parameters != null) {
            this.resultParams_ = parameters;
        }
    }

    @Override
    public void fit() throws LMException {
        float[][] parameters = null;
        if (this.values_.length < 6) {
            throw new LMException("There are too less observations for a model fit!");
        }
        if (this.resultParams_ == null) {
            parameters = new float[6][1];
            parameters[0][0] = 10.0f;
            parameters[1][0] = 0.1f;
            parameters[2][0] = -1.0f;
            parameters[3][0] = -10.0f;
            parameters[4][0] = 1.0f;
            parameters[5][0] = 1.0f;
        } else {
            parameters = this.resultParams_.A;
        }
        this.fit(parameters);
    }

    @Override
    protected FloatMatrix calculateEquationResults(float[][] values, FloatMatrix paramsVector) {
        float[][] results = new float[values.length][1];
        for (int i = 0; i != values.length; ++i) {
            float equationResult = (float)Math.pow(values[i][0], 2.0) * paramsVector.A[0][0];
            equationResult += values[i][0] * paramsVector.A[1][0];
            equationResult += (float)Math.pow(values[i][1], 2.0) * paramsVector.A[2][0];
            equationResult += values[i][1] * paramsVector.A[3][0];
            equationResult += values[i][0] * values[i][1] * paramsVector.A[4][0];
            results[i][0] = equationResult += paramsVector.A[5][0];
        }
        return new FloatMatrix(results);
    }

    @Override
    protected FloatMatrix calculateJacobianMatrix(float[][] values, float[][] parameters) {
        float[][] jacobian = new float[values.length][6];
        for (int i = 0; i != values.length; ++i) {
            jacobian[i][0] = (float)Math.pow(values[i][0], 2.0);
            jacobian[i][1] = values[i][0];
            jacobian[i][2] = (float)Math.pow(values[i][1], 2.0);
            jacobian[i][3] = values[i][1];
            jacobian[i][4] = values[i][0] * values[i][1];
            jacobian[i][5] = 1.0f;
        }
        return new FloatMatrix(jacobian);
    }

    @Override
    public float calculateFitValue(float[] input) throws LMException {
        if (input.length != 2) {
            throw new LMException("The input must consist of two variables");
        }
        float[][] values = new float[1][2];
        values[0][0] = input[0];
        values[0][1] = input[1];
        float result = this.calculateEquationResults((float[][])values, (FloatMatrix)this.resultParams_).A[0][0];
        return result;
    }

    @Override
    protected float[][] getValues() {
        return this.values_;
    }

    @Override
    protected float[][] getObservations() {
        return this.observations_;
    }
}

