/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.utils;

import at.tugraz.genome.lda.exception.LMException;
import at.tugraz.genome.lda.utils.LevenbergMarquardtOptimizer;
import at.tugraz.genome.util.FloatMatrix;

public class LMEulerTwoVariables
extends LevenbergMarquardtOptimizer {
    private float[][] values_;
    private float[][] observations_;

    public LMEulerTwoVariables(float[][] values, float[] observations, FloatMatrix parameters) {
        this.values_ = values;
        this.observations_ = new float[observations.length][1];
        for (int i = 0; i != observations.length; ++i) {
            this.observations_[i][0] = observations[i];
        }
        if (parameters != null) {
            this.resultParams_ = parameters;
        }
    }

    @Override
    public void fit() throws LMException {
        float[][] parameters = null;
        if (this.values_.length < 5) {
            throw new LMException("There are too less observations for a model fit!");
        }
        if (this.resultParams_ == null) {
            parameters = new float[5][1];
            parameters[0][0] = 1.0f;
            parameters[1][0] = 0.01f;
            parameters[2][0] = 10.0f;
            parameters[3][0] = 0.3f;
            parameters[4][0] = 1.0f;
        } else {
            parameters = this.resultParams_.A;
        }
        this.fit(parameters);
    }

    @Override
    protected FloatMatrix calculateEquationResults(float[][] values, FloatMatrix paramsVector) {
        float[][] results = new float[values.length][1];
        for (int i = 0; i != values.length; ++i) {
            float equationResult = (float)((double)paramsVector.A[0][0] * Math.exp(paramsVector.A[1][0] * values[i][0]));
            equationResult += (float)((double)paramsVector.A[2][0] * Math.exp(-1.0 * (double)(paramsVector.A[3][0] * values[i][1])));
            results[i][0] = equationResult += paramsVector.A[4][0];
        }
        return new FloatMatrix(results);
    }

    @Override
    protected FloatMatrix calculateJacobianMatrix(float[][] values, float[][] parameters) {
        float[][] jacobian = new float[values.length][5];
        for (int i = 0; i != values.length; ++i) {
            jacobian[i][0] = (float)Math.exp(parameters[1][0] * values[i][0]);
            jacobian[i][1] = (float)((double)(values[i][0] * parameters[0][0]) * Math.exp(parameters[1][0] * values[i][0]));
            jacobian[i][2] = (float)Math.exp(-1.0 * (double)(parameters[3][0] * values[i][1]));
            jacobian[i][3] = (float)(-1.0 * (double)(values[i][1] * parameters[2][0]) * Math.exp(-1.0 * (double)(parameters[3][0] * values[i][1])));
            jacobian[i][4] = 1.0f;
        }
        return new FloatMatrix(jacobian);
    }

    @Override
    protected float[][] getValues() {
        return this.values_;
    }

    @Override
    protected float[][] getObservations() {
        return this.observations_;
    }

    @Override
    public float calculateFitValue(float[] input) throws LMException {
        if (input.length != 2) {
            throw new LMException("The input must consist of two variables");
        }
        float[][] values = new float[1][2];
        values[0][0] = input[0];
        values[0][1] = input[1];
        float result = this.calculateEquationResults((float[][])values, (FloatMatrix)this.resultParams_).A[0][0];
        return result;
    }

    @Override
    protected float getLambdaStartValue() {
        return 1000.0f;
    }

    @Override
    protected float getLambdaMultiplierStartValue() {
        return 1.2f;
    }
}

