/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.swing.ResultDisplaySettings;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StandardSelectionOverview
extends JDialog {
    private static final long serialVersionUID = -6125157095806596556L;
    private Hashtable<String, ResultDisplaySettings> displayNames_;
    private ActionListener parent_;
    private Hashtable<String, JLabel> labelTexts_;
    private Hashtable<String, Hashtable<String, Integer>> isLookup_;
    private Hashtable<String, Hashtable<String, Integer>> esLookup_;
    private JButton buttonOK_;
    private JButton buttonCancel_;
    private JPanel informationPanel_;

    public StandardSelectionOverview(Hashtable<String, ResultDisplaySettings> displayNames, ActionListener parent, Hashtable<String, Hashtable<String, Integer>> isLookup, Hashtable<String, Hashtable<String, Integer>> esLookup) {
        this.displayNames_ = displayNames;
        this.parent_ = parent;
        this.isLookup_ = isLookup;
        this.esLookup_ = esLookup;
        this.setLayout(new BorderLayout());
        this.setLocation(380, 240);
        this.initOverview();
        this.initButtonPanel();
        this.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private void initOverview() {
        JLabel topPanel = new JLabel("The following standards are used for comparison of the classes");
        this.add((Component)topPanel, "North");
        this.informationPanel_ = new JPanel();
        this.informationPanel_.setLayout(new GridBagLayout());
        this.labelTexts_ = new Hashtable();
        int count = 0;
        for (String className : this.displayNames_.keySet()) {
            JLabel classLabel = new JLabel(className + ": ");
            this.informationPanel_.add((Component)classLabel, new GridBagConstraints(0, count, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
            JLabel infoLabel = new JLabel("");
            this.informationPanel_.add((Component)infoLabel, new GridBagConstraints(1, count, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
            this.labelTexts_.put(className, infoLabel);
            ++count;
        }
        this.add((Component)this.informationPanel_, "Center");
    }

    private void initButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.buttonOK_ = new JButton("OK");
        this.buttonOK_.addActionListener(this.parent_);
        this.buttonOK_.setActionCommand("acceptSelectedStandards");
        this.buttonOK_.setToolTipText("<html>Accept settings</html>");
        buttonPanel.add((Component)this.buttonOK_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.buttonCancel_ = new JButton("Cancel");
        this.buttonCancel_.addActionListener(this.parent_);
        this.buttonCancel_.setActionCommand("cancelSelectedStandards");
        this.buttonCancel_.setToolTipText("<html>Cancel operation</html>");
        buttonPanel.add((Component)this.buttonCancel_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.add((Component)buttonPanel, "South");
    }

    public void refreshInformationSections() {
        for (String className : this.displayNames_.keySet()) {
            ResultDisplaySettingsVO settings = this.displayNames_.get(className).getSettingsVO();
            JLabel infoLabel = this.labelTexts_.get(className);
            String labelText = "";
            if (settings.getISStandMethod() == 0 && settings.getESStandMethod() == 0) {
                labelText = "no standard available - class is neglected!";
            } else {
                if (settings.getISStandMethod() != 0) {
                    labelText = labelText + "IS: ";
                    if (settings.getISStandMethod() == 1) {
                        labelText = labelText + "most reliable";
                    } else if (settings.getISStandMethod() == 2) {
                        labelText = labelText + "median";
                    } else {
                        Hashtable<String, Integer> isLook = this.isLookup_.get(className);
                        for (String name : isLook.keySet()) {
                            if (settings.getISStandMethod() != isLook.get(name).intValue()) continue;
                            labelText = labelText + name;
                            break;
                        }
                    }
                    if (settings.getESStandMethod() != 0) {
                        labelText = labelText + " -> ";
                    }
                }
                if (settings.getESStandMethod() != 0) {
                    labelText = labelText + "ES: ";
                    if (settings.getESStandMethod() == 1) {
                        labelText = labelText + "most reliable";
                    } else if (settings.getESStandMethod() == 2) {
                        labelText = labelText + "median";
                    } else {
                        Hashtable<String, Integer> esLook = this.esLookup_.get(className);
                        for (String name : esLook.keySet()) {
                            if (settings.getESStandMethod() != esLook.get(name).intValue()) continue;
                            labelText = labelText + name;
                            break;
                        }
                    }
                }
            }
            infoLabel.setText(labelText);
        }
        this.invalidate();
        this.doLayout();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void cleanup() {
        this.buttonOK_.removeActionListener(this.parent_);
        this.buttonCancel_.removeActionListener(this.parent_);
        this.parent_ = null;
    }
}

