/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.swing.AbsoluteQuantSettingsPanel;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ResultDisplaySettings
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -3256022094343148530L;
    protected static final String CHANGE_IS_STATUS = "changeIStatus";
    protected static final String CHANGE_ES_STATUS = "changeESStatus";
    protected static final String CHANGE_DIL_STATUS = "changeDilutionStatus";
    public static final String APPLY_DISPLAY_SETTINGS = "AcceptDisplaySettings";
    public static final String APPLY_DISPLAY_SETTINGS_TO_ALL = "ApplyDisplaySettingsToAllLipidClasses";
    protected static final String STANDARD_MOST_RELIABLE = "most reliable standard";
    protected static final String STANDARD_MEDIAN = "median";
    private JComboBox<String> displayType_;
    protected JCheckBox considerInternalStandards_;
    private JComboBox<String> isType_;
    protected JCheckBox considerExternalStandards_;
    private JComboBox<String> esType_;
    protected JCheckBox considerDilution_;
    protected JComboBox<String> unitMagnitude_;
    protected JCheckBox useAU_;
    protected JLabel isLabel_;
    protected JLabel esLabel_;
    protected JLabel dilLabel_;
    protected JLabel unitLabel_;
    protected JLabel useAULabel_;
    protected Hashtable<String, Integer> isLookup_;
    protected Hashtable<String, Integer> esLookup_;
    protected boolean isAvailability_;
    protected boolean esAvailability_;
    protected boolean absoluteSettings_;
    protected boolean hasSampleWeight_;
    protected boolean hasProtein_;
    protected boolean hasNeutralLipid_;
    protected Vector<ActionListener> parents_;

    public ResultDisplaySettings(boolean isAvailability, boolean esAvailability, Hashtable<String, Integer> isLookup, Hashtable<String, Integer> esLookup, boolean absoluteSettings, AbsoluteQuantSettingsPanel panel) {
        this.setLayout(new GridBagLayout());
        this.isAvailability_ = isAvailability;
        this.esAvailability_ = esAvailability;
        this.isLookup_ = isLookup;
        this.esLookup_ = esLookup;
        if (absoluteSettings) {
            this.initRemoveAbsSettings(panel);
        }
        this.absoluteSettings_ = absoluteSettings;
        this.parents_ = new Vector();
        this.setLocation(380, 240);
        JLabel label = new JLabel("value type: ");
        label.setToolTipText("<html>The quantitative type that is used for the geration of the heat map.<br/>A detailed description about the types can be found in the user<br>manual chapter 5.2  or in the Help component of the software.</html>");
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.displayType_ = new JComboBox();
        if (this.absoluteSettings_) {
            if (this.isAvailability_) {
                this.addAllDisplayTypes();
            } else if (this.esAvailability_) {
                this.addWithoutEndVolume();
            } else {
                this.addJustRelative();
            }
            if (this.hasSampleWeight_) {
                this.displayType_.addItem("relative to sample weight");
            }
            if (this.hasProtein_) {
                this.displayType_.addItem("relation to protein content");
            }
            if (this.hasNeutralLipid_) {
                this.displayType_.addItem("relation to neutral lipid content");
            }
        } else {
            this.addJustRelative();
        }
        this.displayType_.addItemListener(new SelectionItemListener());
        this.displayType_.setSelectedItem("Relative Value");
        this.displayType_.setToolTipText("<html>The quantitative type that is used for the geration of the heat map.<br/>A detailed description about the types can be found in the user<br>manual chapter 5.2  or in the Help component of the software.</html>");
        this.add(this.displayType_, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 1, 1), 0, 0));
        if (this.isAvailability_) {
            this.isLabel_ = new JLabel("internal standard correction: ");
            this.isLabel_.setToolTipText("<html>Should the values be corrected with the internal standard?</html>");
            this.add((Component)this.isLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.considerInternalStandards_ = new JCheckBox();
            this.considerInternalStandards_.setActionCommand(CHANGE_IS_STATUS);
            this.considerInternalStandards_.addActionListener(this);
            this.considerInternalStandards_.setSelected(true);
            this.considerInternalStandards_.setToolTipText("<html>Should the values be corrected with the internal standard?</html>");
            this.add((Component)this.considerInternalStandards_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.isType_ = new JComboBox();
            this.isType_.addItem(STANDARD_MOST_RELIABLE);
            this.isType_.addItem(STANDARD_MEDIAN);
            for (String isName : this.isLookup_.keySet()) {
                this.isType_.addItem(isName);
            }
            this.isType_.setToolTipText("<html>The possible correction types are:<br/>most reliable standard: correction on LDA method<br/>median: correction on the median of all available standars<br/>correction on a single standard</html>");
            this.add(this.isType_, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        if (this.esAvailability_) {
            this.esLabel_ = new JLabel("external standard correction: ");
            this.esLabel_.setToolTipText("<html>Should the values be corrected with the external standard?</html>");
            this.add((Component)this.esLabel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.considerExternalStandards_ = new JCheckBox();
            this.considerExternalStandards_.setActionCommand(CHANGE_ES_STATUS);
            this.considerExternalStandards_.addActionListener(this);
            this.considerExternalStandards_.setSelected(true);
            this.considerExternalStandards_.setToolTipText("<html>Should the values be corrected with the external standard?</html>");
            this.add((Component)this.considerExternalStandards_, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.esType_ = new JComboBox();
            this.esType_.addItem(STANDARD_MOST_RELIABLE);
            this.esType_.addItem(STANDARD_MEDIAN);
            for (String esName : this.esLookup_.keySet()) {
                this.esType_.addItem(esName);
            }
            this.esType_.setToolTipText("<html>The possible correction types are:<br/>most reliable standard: correction on LDA method<br/>median: correction on the median of all available standars<br/>correction on a single standard</html>");
            this.add(this.esType_, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        if (this.absoluteSettings_) {
            this.dilLabel_ = new JLabel("consider dilution: ");
            this.dilLabel_.setToolTipText("<html>Should the dilution be considered?</html>");
            this.add((Component)this.dilLabel_, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.considerDilution_ = new JCheckBox();
            this.considerDilution_.setSelected(true);
            this.considerDilution_.setActionCommand(CHANGE_DIL_STATUS);
            this.considerDilution_.addActionListener(this);
            this.considerDilution_.setToolTipText("<html>Should the dilution be considered?</html>");
            this.add((Component)this.considerDilution_, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.unitLabel_ = new JLabel("divisor unit: ");
            this.unitLabel_.setToolTipText("<html>The display units for the divisors; e.g. m for /mL of a concentration</html>");
            this.unitLabel_.setEnabled(false);
            this.add((Component)this.unitLabel_, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.unitMagnitude_ = new JComboBox<String>(StaticUtils.physicalMagnitudes_);
            this.unitMagnitude_.setPreferredSize(new Dimension(42, 18));
            this.unitMagnitude_.setToolTipText("<html>The display units for the divisors; e.g. m for /mL of a concentration</html>");
            this.unitMagnitude_.setSelectedItem("m");
            this.unitMagnitude_.setEnabled(false);
            this.add(this.unitMagnitude_, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            if (this.isAvailability_ || this.esAvailability_) {
                this.useAULabel_ = new JLabel("use AU: ");
                this.useAULabel_.setEnabled(false);
                this.useAULabel_.setToolTipText("<html>Should arbitrary units be used or absolute entities?</html>");
                this.add((Component)this.useAULabel_, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
                this.useAU_ = new JCheckBox();
                this.useAU_.setSelected(true);
                this.useAU_.setEnabled(false);
                this.useAU_.setToolTipText("<html>Should arbitrary units be used or absolute entities?</html>");
                this.add((Component)this.useAU_, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            }
        }
        JButton buttonOK = new JButton("Apply");
        buttonOK.setActionCommand(APPLY_DISPLAY_SETTINGS);
        buttonOK.setToolTipText("<html>Accept settings</html>");
        this.add((Component)buttonOK, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        buttonOK.addActionListener(this);
        JButton buttonApplyToAll = new JButton("Apply to all");
        buttonApplyToAll.setActionCommand(APPLY_DISPLAY_SETTINGS_TO_ALL);
        buttonApplyToAll.setToolTipText("<html>Apply these settings to all lipid classes, as far as applicable</html>");
        this.add((Component)buttonApplyToAll, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        buttonApplyToAll.addActionListener(this);
        this.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private void initRemoveAbsSettings(AbsoluteQuantSettingsPanel panel) {
        this.hasProtein_ = false;
        this.hasNeutralLipid_ = false;
        this.hasSampleWeight_ = false;
        try {
            if (panel.getSettingsVO().getVolumeSettings().size() > 0 && panel.getSettingsVO().getVolumeSettings().values().iterator().next().getProteinConc() != null) {
                this.hasProtein_ = true;
            }
            if (panel.getSettingsVO().getVolumeSettings().size() > 0 && panel.getSettingsVO().getVolumeSettings().values().iterator().next().getNeutralLipidConc() != null) {
                this.hasNeutralLipid_ = true;
            }
            if (panel.getSettingsVO().getVolumeSettings().size() > 0 && panel.getSettingsVO().getVolumeSettings().values().iterator().next().getSampleWeight() != null) {
                this.hasSampleWeight_ = true;
            }
        }
        catch (AbsoluteSettingsInputException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(CHANGE_IS_STATUS)) {
            if (this.considerInternalStandards_.isSelected()) {
                this.isType_.setEnabled(true);
            } else {
                this.isType_.setEnabled(false);
            }
            this.checkAUEnable();
        } else if (e.getActionCommand().equalsIgnoreCase(CHANGE_ES_STATUS)) {
            if (this.considerExternalStandards_.isSelected()) {
                this.esType_.setEnabled(true);
            } else {
                this.esType_.setEnabled(false);
            }
            this.checkAUEnable();
        } else if (e.getActionCommand().equalsIgnoreCase(APPLY_DISPLAY_SETTINGS) || e.getActionCommand().equalsIgnoreCase(APPLY_DISPLAY_SETTINGS_TO_ALL)) {
            String type = (String)this.displayType_.getSelectedItem();
            boolean acceptSettings = true;
            if (type.equalsIgnoreCase("amount sample-volume") || type.equalsIgnoreCase("conc. sample-volume") || type.equalsIgnoreCase("weight sample-volume") || type.equalsIgnoreCase("relation to measured neutral lipid")) {
                if (this.considerInternalStandards_ != null && this.considerExternalStandards_ != null) {
                    if (!this.considerInternalStandards_.isSelected() && !this.considerExternalStandards_.isSelected()) {
                        new WarningMessage(new JFrame(), "Warning", "For the display of \"" + type + "\" the internal- or external standard has to be selected!");
                        acceptSettings = false;
                    }
                } else if (this.considerInternalStandards_ != null) {
                    if (!this.considerInternalStandards_.isSelected()) {
                        new WarningMessage(new JFrame(), "Warning", "For the display of \"" + type + "\" the internal standard has to be selected!");
                        acceptSettings = false;
                    }
                } else if (this.considerExternalStandards_ != null && !this.considerExternalStandards_.isSelected()) {
                    new WarningMessage(new JFrame(), "Warning", "For the display of \"" + type + "\" the external standard has to be selected!");
                    acceptSettings = false;
                }
            }
            if (acceptSettings) {
                this.setVisible(false);
                for (ActionListener parent : this.parents_) {
                    parent.actionPerformed(e);
                }
            }
        }
    }

    private void addJustRelative() {
        this.displayType_.removeAllItems();
        this.displayType_.addItem("relative value");
        this.displayType_.addItem("relative to base peak");
        this.displayType_.addItem("relative to measured class amount");
        this.displayType_.addItem("relative to highest total peak");
        this.displayType_.addItem("relative to total amount");
    }

    private void addAllDisplayTypes() {
        this.addJustRelative();
        this.displayType_.addItem("amount end-volume");
        this.displayType_.addItem("conc. end-volume");
        this.displayType_.addItem("weight end-volume");
        this.addProbeVolumeSettings();
    }

    private void addWithoutEndVolume() {
        this.addJustRelative();
        this.addProbeVolumeSettings();
    }

    private void addProbeVolumeSettings() {
        this.displayType_.addItem("amount sample-volume");
        this.displayType_.addItem("conc. sample-volume");
        this.displayType_.addItem("weight sample-volume");
        this.displayType_.addItem("relation to measured neutral lipid");
    }

    private void enableProbeSettings() {
        this.enableSettings();
        this.enableDilutionSetting(true);
        this.considerDilution_.setSelected(true);
        this.enableDilutionSetting(false);
    }

    private void enableStandSettings() {
        this.enableIntStandSetting(true);
        this.enableExtStandSetting(true);
    }

    private void enableSettings() {
        this.enableStandSettings();
        this.enableDilutionSetting(true);
    }

    private void disableSettings() {
        if (this.considerInternalStandards_ != null) {
            this.considerInternalStandards_.setSelected(false);
        }
        if (this.considerExternalStandards_ != null) {
            this.considerExternalStandards_.setSelected(false);
        }
        if (this.considerDilution_ != null) {
            this.considerDilution_.setSelected(false);
        }
        this.enableIntStandSetting(false);
        this.enableExtStandSetting(false);
        this.enableDilutionSetting(false);
        this.enableMagnitudeSetting(false);
        this.disableAUSettings(false);
    }

    private void enableIntStandSetting(boolean enable) {
        if (this.considerInternalStandards_ != null) {
            this.isLabel_.setEnabled(enable);
            this.considerInternalStandards_.setEnabled(enable);
            if (this.considerInternalStandards_.isSelected()) {
                this.isType_.setEnabled(enable);
            } else {
                this.isType_.setEnabled(false);
            }
        }
    }

    private void enableExtStandSetting(boolean enable) {
        if (this.considerExternalStandards_ != null) {
            this.esLabel_.setEnabled(enable);
            this.considerExternalStandards_.setEnabled(enable);
            this.esType_.setEnabled(enable);
            if (this.considerExternalStandards_.isSelected()) {
                this.esType_.setEnabled(enable);
            } else {
                this.esType_.setEnabled(false);
            }
        }
    }

    private void enableDilutionSetting(boolean enable) {
        if (this.considerDilution_ != null) {
            this.dilLabel_.setEnabled(enable);
            this.considerDilution_.setEnabled(enable);
        }
    }

    private void enableMagnitudeSetting(boolean enable) {
        if (this.unitMagnitude_ != null) {
            this.unitLabel_.setEnabled(enable);
            this.unitMagnitude_.setEnabled(enable);
        }
    }

    private void checkAUEnable() {
        if (this.useAU_ != null) {
            String displayType = (String)this.displayType_.getSelectedItem();
            if (displayType.equalsIgnoreCase("relation to protein content") || displayType.equalsIgnoreCase("relation to neutral lipid content")) {
                if (this.considerInternalStandards_ != null && this.considerInternalStandards_.isSelected() || this.considerExternalStandards_ != null && this.considerExternalStandards_.isSelected()) {
                    this.useAU_.setEnabled(true);
                    this.useAULabel_.setEnabled(true);
                } else {
                    this.useAU_.setSelected(true);
                    this.useAU_.setEnabled(false);
                    this.useAULabel_.setEnabled(false);
                }
            } else {
                this.useAU_.setEnabled(false);
                this.useAULabel_.setEnabled(false);
            }
        }
    }

    private void disableAUSettings(boolean selected) {
        if (this.useAU_ != null) {
            this.useAU_.setSelected(selected);
            this.useAU_.setEnabled(false);
            this.useAULabel_.setEnabled(false);
        }
    }

    public ResultDisplaySettingsVO getSettingsVO() {
        int useIs = 0;
        int useEs = 0;
        boolean useDilution = false;
        boolean useAU = false;
        if (this.considerInternalStandards_ != null && this.considerInternalStandards_.isSelected()) {
            useIs = ((String)this.isType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MOST_RELIABLE) ? 1 : (((String)this.isType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MEDIAN) ? 2 : this.isLookup_.get((String)this.isType_.getSelectedItem()));
        }
        if (this.considerExternalStandards_ != null && this.considerExternalStandards_.isSelected()) {
            useEs = ((String)this.esType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MOST_RELIABLE) ? 1 : (((String)this.esType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MEDIAN) ? 2 : this.esLookup_.get((String)this.esType_.getSelectedItem()));
        }
        if (this.considerDilution_ != null && this.considerDilution_.isSelected()) {
            useDilution = true;
        }
        if (this.useAU_ != null && this.useAU_.isSelected()) {
            useAU = true;
        }
        String unitMagnitude = "";
        if (this.unitMagnitude_ != null && this.unitMagnitude_.getSelectedItem() != null) {
            unitMagnitude = (String)this.unitMagnitude_.getSelectedItem();
        }
        return new ResultDisplaySettingsVO((String)this.displayType_.getSelectedItem(), useIs, useEs, useDilution, useAU, unitMagnitude);
    }

    public void copySettings(ResultDisplaySettings other) {
        String valueType = (String)other.displayType_.getSelectedItem();
        for (int i = 0; i < this.displayType_.getItemCount(); ++i) {
            if (!this.displayType_.getItemAt(i).equals(valueType)) continue;
            this.displayType_.setSelectedIndex(i);
            SelectionItemListener dummyListener = new SelectionItemListener();
            dummyListener.itemSelected();
        }
        if (this.considerInternalStandards_ != null) {
            this.considerInternalStandards_.setSelected(other.considerInternalStandards_.isSelected());
            if (this.considerInternalStandards_.isSelected()) {
                if (((String)other.isType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MOST_RELIABLE)) {
                    this.isType_.setSelectedItem(STANDARD_MOST_RELIABLE);
                } else if (((String)other.isType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MEDIAN)) {
                    this.isType_.setSelectedItem(STANDARD_MEDIAN);
                }
            }
        }
        if (this.considerExternalStandards_ != null) {
            this.considerExternalStandards_.setSelected(other.considerExternalStandards_.isSelected());
            if (this.considerExternalStandards_.isSelected()) {
                if (((String)other.esType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MOST_RELIABLE)) {
                    this.esType_.setSelectedItem(STANDARD_MOST_RELIABLE);
                } else if (((String)other.esType_.getSelectedItem()).equalsIgnoreCase(STANDARD_MEDIAN)) {
                    this.esType_.setSelectedItem(STANDARD_MEDIAN);
                }
            }
        }
        if (this.considerDilution_ != null) {
            this.considerDilution_.setSelected(other.considerDilution_.isSelected());
        }
        this.checkAUEnable();
        if (this.unitMagnitude_ != null) {
            this.unitMagnitude_.setSelectedItem((String)other.unitMagnitude_.getSelectedItem());
        }
    }

    public void addActionListener(ActionListener parent) {
        this.parents_.add(parent);
    }

    public void removeActionListener(ActionListener parent) {
        this.parents_.remove(parent);
    }

    private class SelectionItemListener
    implements ItemListener {
        private SelectionItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.itemSelected();
            }
        }

        public void itemSelected() {
            if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relative value")) {
                ResultDisplaySettings.this.enableSettings();
                ResultDisplaySettings.this.enableMagnitudeSetting(false);
                ResultDisplaySettings.this.disableAUSettings(true);
            } else if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relative to base peak") || ((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relative to measured class amount") || ((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relative to highest total peak") || ((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relative to total amount")) {
                ResultDisplaySettings.this.disableSettings();
            } else if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("amount end-volume") || ((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("conc. end-volume") || ((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("weight end-volume")) {
                ResultDisplaySettings.this.enableIntStandSetting(true);
                if (ResultDisplaySettings.this.considerInternalStandards_ != null) {
                    ResultDisplaySettings.this.considerInternalStandards_.setSelected(true);
                }
                ResultDisplaySettings.this.enableIntStandSetting(false);
                ResultDisplaySettings.this.isType_.setEnabled(true);
                ResultDisplaySettings.this.enableExtStandSetting(true);
                if (ResultDisplaySettings.this.considerExternalStandards_ != null) {
                    ResultDisplaySettings.this.considerExternalStandards_.setSelected(false);
                }
                ResultDisplaySettings.this.enableExtStandSetting(false);
                ResultDisplaySettings.this.enableDilutionSetting(true);
                ResultDisplaySettings.this.considerDilution_.setSelected(false);
                ResultDisplaySettings.this.enableDilutionSetting(false);
                if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("conc. end-volume")) {
                    ResultDisplaySettings.this.enableMagnitudeSetting(true);
                } else {
                    ResultDisplaySettings.this.enableMagnitudeSetting(false);
                }
                ResultDisplaySettings.this.disableAUSettings(false);
            } else if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("amount sample-volume") || ((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("conc. sample-volume") || ((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("weight sample-volume")) {
                ResultDisplaySettings.this.enableProbeSettings();
                ResultDisplaySettings.this.disableAUSettings(false);
                if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("conc. sample-volume")) {
                    ResultDisplaySettings.this.enableMagnitudeSetting(true);
                } else {
                    ResultDisplaySettings.this.enableMagnitudeSetting(false);
                }
            } else if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relative to sample weight")) {
                ResultDisplaySettings.this.enableProbeSettings();
                ResultDisplaySettings.this.enableMagnitudeSetting(true);
                ResultDisplaySettings.this.disableAUSettings(false);
            } else if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relation to protein content")) {
                ResultDisplaySettings.this.enableProbeSettings();
                ResultDisplaySettings.this.enableMagnitudeSetting(true);
                ResultDisplaySettings.this.checkAUEnable();
            } else if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relation to neutral lipid content")) {
                ResultDisplaySettings.this.enableProbeSettings();
                ResultDisplaySettings.this.enableMagnitudeSetting(true);
                ResultDisplaySettings.this.checkAUEnable();
            } else if (((String)ResultDisplaySettings.this.displayType_.getSelectedItem()).equalsIgnoreCase("relation to measured neutral lipid")) {
                ResultDisplaySettings.this.enableProbeSettings();
                ResultDisplaySettings.this.enableMagnitudeSetting(true);
                ResultDisplaySettings.this.disableAUSettings(false);
            }
        }
    }
}

