/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.swing.GroupPanel;
import at.tugraz.genome.lda.swing.InputDialog;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class GroupsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 208895624290731494L;
    private Vector<String> groups_ = new Vector();
    private Hashtable<String, Vector<File>> filesOfGroup_ = new Hashtable();
    private Hashtable<String, GroupPanel> panelOfGroup_ = new Hashtable();
    private final int itemsInRow_ = 3;
    private int maxWidth_;
    private final int scrollBarWidth_ = 10;

    public GroupsPanel() {
        this.setLayout(new GridBagLayout());
    }

    public void addGroup(String groupName, Vector<File> selectedFiles, int maxWidth) {
        this.groups_.add(groupName);
        this.filesOfGroup_.put(groupName, selectedFiles);
        this.maxWidth_ = maxWidth;
        this.visualizeGroups();
    }

    private void visualizeGroups() {
        this.removeAll();
        int count = 0;
        int insetLeft = 5;
        int insetRight = 5;
        JPanel panelToAddGroupPanel = this;
        if (this.groups_.size() > 3) {
            panelToAddGroupPanel = new JPanel();
        }
        for (String group : this.groups_) {
            GroupPanel groupPanel = new GroupPanel(group, this.filesOfGroup_.get(group), this.maxWidth_ / 3 - insetLeft - insetRight - 10, this);
            this.panelOfGroup_.put(group, groupPanel);
            panelToAddGroupPanel.add((Component)groupPanel, new GridBagConstraints(count % 3, count / 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, insetLeft, 2, insetRight), 0, 0));
            ++count;
        }
        if (this.groups_.size() > 3) {
            panelToAddGroupPanel.setPreferredSize(new Dimension(this.maxWidth_ - insetLeft - insetRight - 10, (count / 3 + 1) * 150));
            JScrollPane scrollPane = new JScrollPane(panelToAddGroupPanel);
            scrollPane.setPreferredSize(new Dimension(this.maxWidth_, 170));
            this.add(scrollPane);
        }
        this.invalidate();
        this.updateUI();
    }

    public Vector<String> getGroups() {
        return this.groups_;
    }

    public void removeAllGroups() {
        this.removeAll();
        this.groups_ = new Vector();
        this.filesOfGroup_ = new Hashtable();
        this.panelOfGroup_ = new Hashtable();
        this.invalidate();
        this.updateUI();
    }

    public void removeFiles(Vector<File> filesToRemove) {
        Vector<String> newGroups = new Vector<String>();
        for (String group : this.groups_) {
            Vector<File> newFiles = new Vector<File>();
            for (File file : this.filesOfGroup_.get(group)) {
                boolean remove = false;
                for (File removeFile : filesToRemove) {
                    if (!file.getAbsolutePath().equalsIgnoreCase(removeFile.getAbsolutePath())) continue;
                    remove = true;
                }
                if (remove) continue;
                newFiles.add(file);
            }
            if (newFiles.size() > 0) {
                this.filesOfGroup_.put(group, newFiles);
                newGroups.add(group);
                continue;
            }
            this.filesOfGroup_.remove(group);
            this.panelOfGroup_.remove(group);
        }
        this.groups_ = newGroups;
        this.visualizeGroups();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GroupPanel panel;
        JTable table;
        int[] selectedColumns;
        String groupName;
        String command = e.getActionCommand();
        if (command.startsWith("renameGroup;")) {
            groupName = command.substring("renameGroup;".length());
            InputDialog dlg = new InputDialog(new JFrame(), "Rename group", "Enter the group name", String.valueOf(groupName));
            String newGroupName = dlg.getEnteredText();
            if (newGroupName != null && newGroupName.length() > 0) {
                newGroupName = newGroupName.trim();
                Vector<File> selectedFiles = this.filesOfGroup_.get(groupName);
                this.filesOfGroup_.remove(groupName);
                this.filesOfGroup_.put(newGroupName, selectedFiles);
                this.panelOfGroup_.put(newGroupName, this.panelOfGroup_.get(groupName));
                this.panelOfGroup_.remove(groupName);
                Vector<String> newGroups = new Vector<String>();
                for (String group : this.groups_) {
                    if (group.equalsIgnoreCase(groupName)) {
                        newGroups.add(newGroupName);
                        continue;
                    }
                    newGroups.add(group);
                }
                this.groups_ = newGroups;
                this.visualizeGroups();
            } else {
                new WarningMessage(new JFrame(), "Warning", "You have to specifiy a name for the group!");
            }
        }
        if (command.startsWith("removeItems;") && (selectedColumns = (table = (panel = this.panelOfGroup_.get(groupName = command.substring("removeItems;".length()))).getTable()).getSelectedRows()) != null && selectedColumns.length > 0) {
            ArrayList<Integer> selectedList = new ArrayList<Integer>();
            for (int i = 0; i != selectedColumns.length; ++i) {
                selectedList.add(selectedColumns[i]);
            }
            Collections.sort(selectedList);
            Vector<File> filesOfGroup = this.filesOfGroup_.get(groupName);
            for (int i = selectedList.size() - 1; i != -1; --i) {
                filesOfGroup.remove((Integer)selectedList.get(i));
            }
            if (filesOfGroup.size() > 0) {
                this.filesOfGroup_.put(groupName, filesOfGroup);
                panel.updateFiles(filesOfGroup);
            } else {
                command = "deleteGroup;" + groupName;
            }
        }
        if (command.startsWith("deleteGroup;")) {
            groupName = command.substring("deleteGroup;".length());
            for (int i = 0; i != this.groups_.size(); ++i) {
                if (!this.groups_.get(i).equalsIgnoreCase(groupName)) continue;
                this.filesOfGroup_.remove(groupName);
                this.panelOfGroup_.remove(groupName);
                this.groups_.remove(i);
                break;
            }
            this.visualizeGroups();
        }
    }

    public Set<String> getExpsOfGroupOneExpBelongsTo(String expirementName, Vector<String> allExperimentNames) {
        String fileName;
        Vector<String> groupsTheExpBelongsTo = new Vector<String>();
        Hashtable<String, Vector<File>> groupFiles = this.filesOfGroup_;
        for (String group : this.groups_) {
            boolean belongsToGroup = false;
            for (File file : groupFiles.get(group)) {
                fileName = StaticUtils.extractFileName(file.getAbsolutePath());
                if (!fileName.contains(expirementName)) continue;
                belongsToGroup = true;
            }
            if (!belongsToGroup) continue;
            groupsTheExpBelongsTo.add(group);
        }
        if (groupsTheExpBelongsTo.size() > 0) {
            Hashtable<String, String> expsUpdate = new Hashtable<String, String>();
            for (String group : groupsTheExpBelongsTo) {
                block3: for (File file : groupFiles.get(group)) {
                    fileName = StaticUtils.extractFileName(file.getAbsolutePath());
                    for (String expName : allExperimentNames) {
                        if (!fileName.contains(expName)) continue;
                        expsUpdate.put(expName, expName);
                        continue block3;
                    }
                }
            }
            return expsUpdate.keySet();
        }
        return new HashSet<String>();
    }

    public Hashtable<String, Vector<File>> getGroupFiles() {
        return this.filesOfGroup_;
    }
}

