/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.utils.StaticUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class GroupPanel
extends JPanel {
    private static final long serialVersionUID = -7820284034078799038L;
    private String groupName_;
    private Vector<File> selectedFiles_ = new Vector();
    private JTable selectedTable_;
    private int maxWidth_;
    ActionListener parentListener_;
    private ImageIcon editIcon_ = new ImageIcon(this.getClass().getResource("/images/Edit.gif"));
    private ImageIcon removeFilesIcon_ = new ImageIcon(this.getClass().getResource("/images/removeFiles.gif"));
    private ImageIcon deleteIcon_ = new ImageIcon(this.getClass().getResource("/images/Delete.gif"));

    public GroupPanel(String groupName, Vector<File> selectedFiles, int maxWidth, ActionListener parentListener) {
        this.groupName_ = groupName;
        this.setLayout(new BorderLayout());
        this.selectedFiles_ = selectedFiles;
        this.maxWidth_ = maxWidth;
        this.parentListener_ = parentListener;
        this.createComponents();
    }

    private void createComponents() {
        this.createTopMenu();
        this.generateTable();
    }

    private void createTopMenu() {
        JPanel topMenuPanel = new JPanel();
        topMenuPanel.setLayout(new GridBagLayout());
        JLabel name = new JLabel(this.groupName_);
        name.setToolTipText("<html>The name of the group.</html>");
        topMenuPanel.add((Component)name, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton rename = new JButton("Rename", this.editIcon_);
        rename.setIconTextGap(2);
        rename.setMargin(new Insets(2, 2, 2, 2));
        rename.addActionListener(this.parentListener_);
        rename.setActionCommand("renameGroup;" + this.groupName_);
        rename.setToolTipText("<html>Rename the group.</html>");
        topMenuPanel.add((Component)rename, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton remove = new JButton("Remove", this.removeFilesIcon_);
        remove.setIconTextGap(2);
        remove.setMargin(new Insets(2, 2, 2, 2));
        remove.addActionListener(this.parentListener_);
        remove.setActionCommand("removeItems;" + this.groupName_);
        remove.setToolTipText("<html>Removes selected files from the table below.<br/>The items have to be selected before in the table below.</html>");
        topMenuPanel.add((Component)remove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton delete = new JButton("Delete Group", this.deleteIcon_);
        delete.setIconTextGap(2);
        delete.setMargin(new Insets(2, 2, 2, 2));
        delete.addActionListener(this.parentListener_);
        delete.setActionCommand("deleteGroup;" + this.groupName_);
        delete.setToolTipText("<html>Deletes the enitre group.</html>");
        topMenuPanel.add((Component)delete, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        rename.setPreferredSize(new Dimension(this.maxWidth_ / 3, rename.getPreferredSize().height));
        remove.setPreferredSize(new Dimension(this.maxWidth_ / 3, remove.getPreferredSize().height));
        delete.setPreferredSize(new Dimension(this.maxWidth_ / 3, delete.getPreferredSize().height));
        this.add((Component)topMenuPanel, "North");
    }

    private void generateTable() {
        Object[][] tableData = new String[this.selectedFiles_.size()][1];
        for (int i = 0; i != this.selectedFiles_.size(); ++i) {
            String fileName;
            tableData[i][0] = fileName = StaticUtils.extractFileName(this.selectedFiles_.get(i).getAbsolutePath());
        }
        Object[] columnNames = new String[]{"File Name"};
        this.selectedTable_ = new JTable(tableData, columnNames);
        ListSelectionModel selectionModel = this.selectedTable_.getSelectionModel();
        this.selectedTable_.setSelectionModel(selectionModel);
        selectionModel.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.selectedTable_);
        scrollPane.setPreferredSize(new Dimension(this.maxWidth_, 95));
        if (tableData == null || tableData.length > 0) {
            // empty if block
        }
        this.add((Component)scrollPane, "Center");
    }

    public JTable getTable() {
        return this.selectedTable_;
    }

    public void updateFiles(Vector<File> files) {
        this.selectedFiles_ = files;
        this.removeAll();
        this.createComponents();
        this.invalidate();
        this.updateUI();
    }
}

