/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.swing.ExportButton;
import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExportPanel
extends JPanel {
    private static final long serialVersionUID = 1684790632349952418L;
    public static final String EXPORT_SVG = "exportSVG";
    public static final String EXPORT_PNG = "exportPNG";
    public static final String EXPORT_EXCEL = "exportExcel";
    public static final String EXPORT_TEXT = "exportText";
    public static final String EXPORT_CHROMS = "exportChroms";
    public static final String EXPORT_MZTAB = "exportMztab";
    public static final String EXPORT_RDB = "exportRdb";
    public static final String EXPORT_MAF = "exportMAF";
    public static final String EXPORT_SUMMARY = "exportSummary";
    private ActionListener parent_;

    public ExportPanel(Color background, Color font, ActionListener parent) {
        this(background, font, parent, false, false, false, false);
    }

    public ExportPanel(Color background, Color font, ActionListener parent, boolean chroms, boolean mzTab, boolean rdb, boolean pictureOnly) {
        this.parent_ = parent;
        if (background != null) {
            this.setBackground(background);
        }
        JLabel label = null;
        if (!pictureOnly) {
            // empty if block
        }
        ExportButton png = new ExportButton("PNG", EXPORT_PNG, font, background, "<html>Export image to PNG format (portable image format).</html>", this.parent_);
        this.add(png);
        label = new JLabel(" | ");
        label.setForeground(font);
        this.add(label);
        ExportButton svg = new ExportButton("SVG", EXPORT_SVG, font, background, "<html>Export image to SVG format (scalable vector graphics).</html>", this.parent_);
        this.add(svg);
        if (pictureOnly) {
            return;
        }
        label = new JLabel(" | ");
        label.setForeground(font);
        this.add(label);
        ExportButton excel = new ExportButton("Excel", EXPORT_EXCEL, font, background, "<html>Export data in Excel format.</html>", this.parent_);
        this.add(excel);
        if (mzTab) {
            label = new JLabel(" | ");
            label.setForeground(font);
            this.add(label);
            ExportButton mztab = new ExportButton("mzTab", EXPORT_MZTAB, font, background, "<html>Export data in mzTab format.</html>", this.parent_);
            this.add(mztab);
        }
        if (rdb) {
            label = new JLabel(" | ");
            label.setForeground(font);
            this.add(label);
            ExportButton rdbButton = new ExportButton("RDB", EXPORT_RDB, font, background, "<html>Export data in relational database format.</html>", this.parent_);
            this.add(rdbButton);
        }
        label = new JLabel(" | ");
        label.setForeground(font);
        this.add(label);
        ExportButton text = new ExportButton("Text", EXPORT_TEXT, font, background, "<html>Export data tab-delimited plain text format.</html>", this.parent_);
        this.add(text);
        if (chroms) {
            label = new JLabel(" | ");
            label.setForeground(font);
            this.add(label);
            ExportButton chrom = new ExportButton("Chroms", EXPORT_CHROMS, font, background, "<html>Export the chromatograms in a picture.</html>", this.parent_);
            this.add(chrom);
        }
    }
}

