/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.swing.ExpVolumeListener;
import at.tugraz.genome.lda.swing.PhysicalUnitInput;
import at.tugraz.genome.lda.vos.ProbeVolConcVO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExpVolumeSettingsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 9166132661566566048L;
    private String expName_;
    private PhysicalUnitInput probeVolume_;
    private PhysicalUnitInput endVolume_;
    private PhysicalUnitInput sampleWeight_;
    private PhysicalUnitInput proteinConc_;
    private PhysicalUnitInput neutralConc_;
    private ExpVolumeListener parent_;

    public ExpVolumeSettingsPanel(String expName, ExpVolumeListener parent) {
        this.expName_ = expName;
        this.parent_ = parent;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Sample volume: ");
        label.setToolTipText("<html>The extracted volume before further processing (time point of adding of external standard).</html>");
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.probeVolume_ = new PhysicalUnitInput("m", "<html>The extracted volume before further processing (time point of adding of external standard).</html>");
        this.add((Component)this.probeVolume_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("L");
        label.setToolTipText("<html>The extracted volume before further processing (time point of adding of external standard).</html>");
        this.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        label = new JLabel("End volume: ");
        label.setToolTipText("<html>The extracted volume after processing (time point of adding of internal standard).</html>");
        this.add((Component)label, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.endVolume_ = new PhysicalUnitInput("\u03bc", "<html>The extracted volume after processing (time point of adding of internal standard).</html>");
        this.add((Component)this.endVolume_, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("L");
        label.setToolTipText("<html>The extracted volume after processing (time point of adding of internal standard).</html>");
        this.add((Component)label, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        JButton button = new JButton("Apply to all");
        button.addActionListener(this);
        button.setActionCommand("applyVolumeSettingsAll");
        button.setFont(button.getFont().deriveFont(10.0f));
        button.setMargin(new Insets(1, 5, 1, 5));
        button.setToolTipText("<html>Apply this value to all input fields of this kind.</html>");
        this.add((Component)button, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        button = new JButton("Apply to group");
        button.addActionListener(this);
        button.setActionCommand("applyVolumeSettingsGroup");
        button.setFont(button.getFont().deriveFont(10.0f));
        button.setMargin(new Insets(1, 5, 1, 5));
        button.setToolTipText("<html>Apply this value to all group members this experiment belongs to.</html>");
        this.add((Component)button, new GridBagConstraints(7, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        label = new JLabel("Sample weight: ");
        label.setToolTipText("<html>The extracted sample weight (losses of analytes before addition of external standard are neglected).</html>");
        this.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.sampleWeight_ = new PhysicalUnitInput("m", "<html>The extracted sample weight (losses of analytes before addition of external standard are neglected).</html>");
        this.add((Component)this.sampleWeight_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("g");
        label.setToolTipText("<html>The extracted sample weight (losses of analytes before addition of external standard are neglected).</html>");
        this.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        label = new JLabel("Protein conc.: ");
        label.setToolTipText("<html>The protein content in the sample.</html>");
        this.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.proteinConc_ = new PhysicalUnitInput("m", "<html>The protein content in the sample.</html>");
        this.add((Component)this.proteinConc_, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("g/L");
        label.setToolTipText("<html>The protein content in the sample.</html>");
        this.add((Component)label, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        label = new JLabel("Neutral lipid con.: ");
        label.setToolTipText("<html>The neutral lipid content in the sample.</html>");
        this.add((Component)label, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.neutralConc_ = new PhysicalUnitInput("m", "<html>The neutral lipid content in the sample.</html>");
        this.add((Component)this.neutralConc_, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("g/L");
        label.setToolTipText("<html>The neutral lipid content in the sample.</html>");
        this.add((Component)label, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        button = new JButton("Apply to all");
        button.addActionListener(this);
        button.setActionCommand("applyProteinLipidSettingsAll");
        button.setFont(button.getFont().deriveFont(10.0f));
        button.setMargin(new Insets(1, 5, 1, 5));
        button.setToolTipText("<html>Apply this value to all input fields of this kind.</html>");
        this.add((Component)button, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        button = new JButton("Apply to group");
        button.addActionListener(this);
        button.setActionCommand("applyProteinLipidSettingsGroup");
        button.setFont(button.getFont().deriveFont(10.0f));
        button.setMargin(new Insets(1, 5, 1, 5));
        button.setToolTipText("<html>Apply this value to all group members this experiment belongs to.</html>");
        this.add((Component)button, new GridBagConstraints(7, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equalsIgnoreCase("applyVolumeSettingsAll")) {
            this.parent_.applyVolumeSettingsToAll(this.expName_);
        }
        if (command.equalsIgnoreCase("applyVolumeSettingsGroup")) {
            this.parent_.applyVolumeSettingsToGroup(this.expName_);
        }
        if (command.equalsIgnoreCase("applyProteinLipidSettingsAll")) {
            this.parent_.applyProteinLipidSettingsToAll(this.expName_);
        }
        if (command.equalsIgnoreCase("applyProteinLipidSettingsGroup")) {
            this.parent_.applyProteinLipidSettingsToGroup(this.expName_);
        }
    }

    public void setVolumeInputValues(ExpVolumeSettingsPanel otherPanel) {
        this.probeVolume_.setInputValue(otherPanel.probeVolume_);
        this.endVolume_.setInputValue(otherPanel.endVolume_);
        this.sampleWeight_.setInputValue(otherPanel.sampleWeight_);
    }

    public void setProteinLipidContentValues(ExpVolumeSettingsPanel otherPanel) {
        this.proteinConc_.setInputValue(otherPanel.proteinConc_);
        this.neutralConc_.setInputValue(otherPanel.neutralConc_);
    }

    public PhysicalUnitInput getProbeVolume() {
        return this.probeVolume_;
    }

    public PhysicalUnitInput getEndVolume() {
        return this.endVolume_;
    }

    public PhysicalUnitInput getSampleWeight() {
        return this.sampleWeight_;
    }

    public PhysicalUnitInput getProteinConc() {
        return this.proteinConc_;
    }

    public PhysicalUnitInput getNeutralConc() {
        return this.neutralConc_;
    }

    public void cleanSettings() {
        this.probeVolume_.setDefault();
        this.endVolume_.setDefault();
        this.sampleWeight_.setDefault();
        this.proteinConc_.setDefault();
        this.neutralConc_.setDefault();
    }

    public ProbeVolConcVO getSettingsVO() throws AbsoluteSettingsInputException {
        Double probeVol = this.probeVolume_.getInputValue();
        if (probeVol == null) {
            throw new AbsoluteSettingsInputException("For the absolute quantitation the probe volume is mandatory");
        }
        Double endVol = this.endVolume_.getInputValue();
        if (endVol == null) {
            throw new AbsoluteSettingsInputException("For the absolute quantitation the end volume is mandatory");
        }
        return new ProbeVolConcVO(probeVol, endVol, this.sampleWeight_.getInputValue(), this.proteinConc_.getInputValue(), this.neutralConc_.getInputValue());
    }
}

