/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.NumberOutOfRangeException;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.verifier.DoubleVerifier;
import at.tugraz.genome.lda.verifier.IntegerVerifier;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jogamp.java3d.utils.applet.MainFrame;

public class EditOmegaAssignmentJTable
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ActionListener parent_;
    private static final String TITLE = "Edit \u03c9-C=C assignment";
    private static final String BUTTON_CHANGE_SELECTED_SPECIES = "Change Selected";
    private static final String COMMAND_CHANGE_SELECTED_SPECIES = "changeSelectedSpecies";
    private static final String BUTTON_ADD_NEW_SPECIES = "Add New";
    private static final String COMMAND_ADD_NEW_SPECIES = "addNewSpecies";
    private static final String BUTTON_REMOVE_SELECTED_SPECIES = "Remove Selected";
    private static final String COMMAND_REMOVE_SELECTED_SPECIES = "removeSelectedSpecies";
    private static final String BUTTON_ASSIGN_SELECTED_SPECIES = "Assign Selected";
    private static final String COMMAND_ASSIGN_SELECTED_SPECIES = "assignSelectedSpecies";
    private static final String BUTTON_SAVE_CHANGES = "Save Changes";
    private static final String COMMAND_SAVE_CHANGES = "saveOmegaAssignmentChanges";
    private static final String BUTTON_CANCEL = "Cancel";
    private static final String COMMAND_CANCEL = "cancel";
    private final String[] accuracy_ = new String[]{"low", "medium", "high"};
    private JTextField positionChainFirst_;
    private JTextField positionChainSecond_;
    private JTextField positionChainThird_;
    private JTextField expectedRT_;
    private LipidParameterSet localLipidParameterSet_;
    private LipidParameterSet lipidParameterSet_;
    private String molecularSpecies_;
    private Vector<FattyAcidVO> chainCombination_;
    private Vector<DoubleBondPositionVO> localDoubleBondPositionVOs_;
    private JTable table_;
    private DefaultTableModel model_;
    private static boolean saveLipidParameterSet_;

    public EditOmegaAssignmentJTable(LipidParameterSet param, String molecularSpecies, Vector<FattyAcidVO> chainCombination, ActionListener parent, MainFrame frame) {
        super(TITLE);
        this.lipidParameterSet_ = param;
        this.localLipidParameterSet_ = new LipidParameterSet(param);
        this.molecularSpecies_ = molecularSpecies;
        this.localDoubleBondPositionVOs_ = StaticUtils.getDoubleBondAssignmentsOfMolecularSpecies(this.localLipidParameterSet_.getOmegaInformation(), this.molecularSpecies_);
        this.chainCombination_ = chainCombination;
        this.parent_ = parent;
        saveLipidParameterSet_ = true;
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        this.setSize(850, 300);
        this.setVisible(true);
        String[] individualChains = this.getIndividualChains(this.molecularSpecies_);
        JPanel panelNorth = this.createPanelNorth(individualChains);
        String[] headers = new String[]{"Molecular Species", "RT Deviation /s", "Expected RT /min", "Accuracy", "Assigned"};
        this.model_ = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 4: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        for (String header : headers) {
            this.model_.addColumn(header);
        }
        this.addRows();
        this.table_ = new JTable(this.model_);
        this.table_.setAutoCreateRowSorter(false);
        this.table_.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                ListSelectionModel lsm = (ListSelectionModel)event.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = EditOmegaAssignmentJTable.this.table_.getSelectedRow();
                    DoubleBondPositionVO labeledChainCombinationVO = (DoubleBondPositionVO)EditOmegaAssignmentJTable.this.localDoubleBondPositionVOs_.get(selectedRow);
                    Vector<FattyAcidVO> fattyAcidVOs = labeledChainCombinationVO.getChainCombination();
                    int count = 0;
                    EditOmegaAssignmentJTable.this.expectedRT_.setText(EditOmegaAssignmentJTable.this.getStringWithTwoDecimals(labeledChainCombinationVO.getExpectedRetentionTime()));
                    for (FattyAcidVO fattyAcidVO : fattyAcidVOs) {
                        if (((FattyAcidVO)EditOmegaAssignmentJTable.this.chainCombination_.get(count)).getDoubleBonds() > 0) {
                            String value = String.valueOf(fattyAcidVO.getOmegaPosition());
                            if (value.equals("-1")) {
                                value = null;
                            }
                            switch (count) {
                                case 0: {
                                    EditOmegaAssignmentJTable.this.positionChainFirst_.setText(value);
                                    break;
                                }
                                case 1: {
                                    EditOmegaAssignmentJTable.this.positionChainSecond_.setText(value);
                                    break;
                                }
                                case 2: {
                                    EditOmegaAssignmentJTable.this.positionChainThird_.setText(value);
                                }
                            }
                        }
                        ++count;
                    }
                }
            }
        });
        JPanel panelSouth = this.createPanelSouth();
        Container container = this.getContentPane();
        container.add((Component)panelNorth, "North");
        container.add((Component)new JScrollPane(this.table_), "Center");
        container.add((Component)panelSouth, "South");
    }

    public static String getSaveChangesCommand() {
        return COMMAND_SAVE_CHANGES;
    }

    private String getStringWithTwoDecimals(double d) {
        return String.format("%.2f", d);
    }

    private String[] getIndividualChains(String molecularSpecies) {
        String[] individualChains = new String[]{molecularSpecies};
        if (molecularSpecies.contains("_")) {
            individualChains = molecularSpecies.split("_");
        } else if (molecularSpecies.contains("/")) {
            individualChains = molecularSpecies.split("/");
        }
        return individualChains;
    }

    private JButton createJButton(String buttonText, String commandText, String toolTipText) {
        JButton jButton = new JButton(buttonText);
        jButton.setActionCommand(commandText);
        jButton.setToolTipText(toolTipText);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedRow = this.table_.getSelectedRow();
        int[] omegaPositions = new int[]{-1, -1, -1};
        float expectedRT = this.getMeasuredRT();
        switch (e.getActionCommand()) {
            case "changeSelectedSpecies": {
                if (selectedRow > -1) {
                    DoubleBondPositionVO selected = this.localDoubleBondPositionVOs_.get(selectedRow);
                    double currentRT = selected.getExpectedRetentionTime();
                    try {
                        expectedRT = Float.parseFloat(this.expectedRT_.getText());
                        selected.setExpectedRetentionTime(expectedRT);
                        this.determineAccuracy(selected);
                    }
                    catch (NumberOutOfRangeException ex) {
                        int dialogResult = this.getConfirmDialogResult(expectedRT);
                        if (dialogResult == 1 || dialogResult == -1) {
                            selected.setExpectedRetentionTime(currentRT);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    Vector<FattyAcidVO> fattyAcidVOs = selected.getChainCombination();
                    int count = 0;
                    for (FattyAcidVO fattyAcidVO : fattyAcidVOs) {
                        if (this.chainCombination_.get(count).getDoubleBonds() > 0) {
                            switch (count) {
                                case 0: {
                                    try {
                                        omegaPositions[count] = Integer.parseInt(this.positionChainFirst_.getText());
                                        fattyAcidVO.setOmegaPosition(omegaPositions[count]);
                                    }
                                    catch (Exception exception) {}
                                    break;
                                }
                                case 1: {
                                    try {
                                        omegaPositions[count] = Integer.parseInt(this.positionChainSecond_.getText());
                                        fattyAcidVO.setOmegaPosition(omegaPositions[count]);
                                    }
                                    catch (Exception exception) {}
                                    break;
                                }
                                case 2: {
                                    try {
                                        omegaPositions[count] = Integer.parseInt(this.positionChainThird_.getText());
                                        fattyAcidVO.setOmegaPosition(omegaPositions[count]);
                                        break;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        ++count;
                    }
                    this.model_.setValueAt(selected.getDoubleBondPositionsHumanReadable(), selectedRow, 0);
                    this.model_.setValueAt(this.getStringWithTwoDecimals(this.getDeltaRT(expectedRT)), selectedRow, 1);
                    this.model_.setValueAt(Float.valueOf(expectedRT), selectedRow, 2);
                    this.model_.setValueAt(this.accuracy_[selected.getAccuracy()], selectedRow, 3);
                    this.model_.setValueAt(selected.getIsAssigned(), selectedRow, 4);
                    break;
                }
                new WarningMessage(new JFrame(), "Error", "No element was selected.");
                break;
            }
            case "addNewSpecies": {
                try {
                    omegaPositions[0] = Integer.parseInt(this.positionChainFirst_.getText());
                }
                catch (Exception selected) {
                    // empty catch block
                }
                try {
                    omegaPositions[1] = Integer.parseInt(this.positionChainSecond_.getText());
                }
                catch (Exception selected) {
                    // empty catch block
                }
                try {
                    omegaPositions[2] = Integer.parseInt(this.positionChainThird_.getText());
                }
                catch (Exception selected) {
                    // empty catch block
                }
                try {
                    expectedRT = Float.parseFloat(this.expectedRT_.getText());
                }
                catch (Exception selected) {
                    // empty catch block
                }
                boolean anyOmegaPositionsSet = false;
                for (int omegaPosition : omegaPositions) {
                    if (omegaPosition <= 0) continue;
                    anyOmegaPositionsSet = true;
                    break;
                }
                if (!anyOmegaPositionsSet) {
                    new WarningMessage(new JFrame(), "Error", "Select at least one valid \u03c9 - double bond position!");
                    break;
                }
                DoubleBondPositionVO newDoubleBondPositionVO = this.initiateNewDoubleBondPositionVO(omegaPositions, expectedRT);
                try {
                    this.determineAccuracy(newDoubleBondPositionVO);
                }
                catch (NumberOutOfRangeException ex) {
                    int dialogResult = this.getConfirmDialogResult(expectedRT);
                    if (dialogResult == 1 || dialogResult == -1) break;
                }
                this.localDoubleBondPositionVOs_.add(newDoubleBondPositionVO);
                this.localLipidParameterSet_.addOmegaInformation(newDoubleBondPositionVO);
                Object[] newRow = this.createRow(newDoubleBondPositionVO);
                this.model_.addRow(newRow);
                this.table_.setModel(this.model_);
                break;
            }
            case "assignSelectedSpecies": {
                if (selectedRow > -1) {
                    for (int i = 0; i < this.table_.getRowCount(); ++i) {
                        this.localDoubleBondPositionVOs_.get(i).setIsAssigned(false);
                        this.model_.setValueAt(false, i, 4);
                    }
                    this.localDoubleBondPositionVOs_.get(selectedRow).setIsAssigned(true);
                    this.model_.setValueAt(true, selectedRow, 4);
                    break;
                }
                new WarningMessage(new JFrame(), "Error", "No element was selected.");
                break;
            }
            case "removeSelectedSpecies": {
                int[] selectedRows = this.table_.getSelectedRows();
                this.table_.clearSelection();
                for (int i = 0; i < selectedRows.length; ++i) {
                    DoubleBondPositionVO removed = this.localDoubleBondPositionVOs_.remove(selectedRow);
                    this.localLipidParameterSet_.getOmegaInformation().remove(removed);
                    this.model_.removeRow(selectedRows[i] - i);
                }
                break;
            }
            case "saveOmegaAssignmentChanges": {
                Vector<DoubleBondPositionVO> temp = this.lipidParameterSet_.getOmegaInformation();
                this.lipidParameterSet_.setOmegaInformation(this.localLipidParameterSet_.getOmegaInformation());
                this.parent_.actionPerformed(e);
                if (!saveLipidParameterSet_) {
                    this.lipidParameterSet_.setOmegaInformation(temp);
                    break;
                }
                this.dispose();
                break;
            }
            case "cancel": {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private int getConfirmDialogResult(float expectedRT) {
        int dialogResult = JOptionPane.showConfirmDialog(null, String.format("<html>The expected retention time (%s min) is not inside the range of this peak!<br>(Peak range: %s - %s min)<br>Would you like to keep these changes anyway?</html>", Float.valueOf(expectedRT), this.getStringWithTwoDecimals(this.localLipidParameterSet_.getIsotopicProbes().get((int)0).get((int)0).LowerValley / 60.0f), this.getStringWithTwoDecimals(this.localLipidParameterSet_.getIsotopicProbes().get((int)0).get((int)0).UpperValley / 60.0f)), "Warning", 0);
        return dialogResult;
    }

    public static void setSaveLipidParameterSet(boolean saveLipidParameterSet) {
        saveLipidParameterSet_ = saveLipidParameterSet;
    }

    private DoubleBondPositionVO initiateNewDoubleBondPositionVO(int[] omegaPositions, float expectedRT) {
        Vector<FattyAcidVO> chainCombination = new Vector<FattyAcidVO>();
        int count = 0;
        for (FattyAcidVO fattyAcid : this.chainCombination_) {
            chainCombination.add(new FattyAcidVO(fattyAcid));
            chainCombination.get(count).setOmegaPosition(omegaPositions[count]);
            ++count;
        }
        DoubleBondPositionVO newDoubleBondPositionVO = new DoubleBondPositionVO(chainCombination, expectedRT, 0, this.molecularSpecies_, false);
        return newDoubleBondPositionVO;
    }

    private void determineAccuracy(DoubleBondPositionVO doubleBondPositionVO) throws NumberOutOfRangeException {
        double expectedRT = doubleBondPositionVO.getExpectedRetentionTime();
        Range[] peakRanges = StaticUtils.determinePeakRanges(this.localLipidParameterSet_);
        Range peakLimits = peakRanges[0];
        Range mediumAccuracy = peakRanges[1];
        Range highAccuracy = peakRanges[2];
        doubleBondPositionVO.setAccuracy(0);
        if (peakLimits.insideRange(expectedRT)) {
            if (mediumAccuracy.insideRange(expectedRT)) {
                doubleBondPositionVO.setAccuracy(1);
            }
            if (highAccuracy.insideRange(expectedRT)) {
                doubleBondPositionVO.setAccuracy(2);
            }
        } else {
            throw new NumberOutOfRangeException();
        }
    }

    private float getMeasuredRT() {
        return Float.parseFloat(this.localLipidParameterSet_.getRt());
    }

    private double getDeltaRT(double d) {
        return Math.abs((double)this.getMeasuredRT() - d) * 60.0;
    }

    private JPanel createPanelNorth(String[] individualChains) {
        JPanel panelNorth = new JPanel(new BorderLayout());
        JPanel addNewSpeciesPanel = new JPanel();
        JPanel measuredRTPanel = new JPanel();
        JLabel label = new JLabel(String.format("Measured RT: %s min", this.getStringWithTwoDecimals(this.getMeasuredRT())));
        label.setToolTipText("<html>The measured retention time for this analyte.</html>");
        measuredRTPanel.add(label);
        JButton changeSelectedSpeciesButton = this.createJButton(BUTTON_CHANGE_SELECTED_SPECIES, COMMAND_CHANGE_SELECTED_SPECIES, "<html>Change selected molecular species to specified \u03c9 - double bondpositions and expected retention time.</html>");
        JButton addNewSpeciesButton = this.createJButton(BUTTON_ADD_NEW_SPECIES, COMMAND_ADD_NEW_SPECIES, "<html>Add new molecular species with specified \u03c9 - double bondpositions and expected retention time.</html>");
        int count = 0;
        for (String chain : individualChains) {
            if (this.chainCombination_.get(count).getDoubleBonds() > 0) {
                label = new JLabel(String.format("%s n-", chain));
                label.setToolTipText("<html>Enter the \u03c9 - double bond position for this species.</html>");
                addNewSpeciesPanel.add(label);
                switch (count) {
                    case 0: {
                        this.positionChainFirst_ = new JTextField(2);
                        this.positionChainFirst_.setInputVerifier(new IntegerVerifier());
                        this.positionChainFirst_.setToolTipText("<html>Enter the \u03c9 - double bond position for this species.</html>");
                        addNewSpeciesPanel.add(this.positionChainFirst_);
                        break;
                    }
                    case 1: {
                        this.positionChainSecond_ = new JTextField(2);
                        this.positionChainSecond_.setInputVerifier(new IntegerVerifier());
                        this.positionChainSecond_.setToolTipText("<html>Enter the \u03c9 - double bond position for this species.</html>");
                        addNewSpeciesPanel.add(this.positionChainSecond_);
                        break;
                    }
                    case 2: {
                        this.positionChainThird_ = new JTextField(2);
                        this.positionChainThird_.setInputVerifier(new IntegerVerifier());
                        this.positionChainThird_.setToolTipText("<html>Enter the \u03c9 - double bond position for this species.</html>");
                        addNewSpeciesPanel.add(this.positionChainThird_);
                    }
                }
            }
            ++count;
        }
        addNewSpeciesPanel.add(Box.createHorizontalStrut(5));
        label = new JLabel("Expected RT /min: ");
        label.setToolTipText("<html>Enter the expected retention time for this \u03c9 - double bond position assignment.</html>");
        addNewSpeciesPanel.add(label);
        this.expectedRT_ = new JTextField(4);
        this.expectedRT_.setInputVerifier(new DoubleVerifier(true));
        this.expectedRT_.setToolTipText("<html>Enter the expected retention time for this \u03c9 - double bond position assignment.</html>");
        addNewSpeciesPanel.add(this.expectedRT_);
        addNewSpeciesPanel.add(Box.createHorizontalStrut(5));
        addNewSpeciesPanel.add(changeSelectedSpeciesButton);
        addNewSpeciesPanel.add(addNewSpeciesButton);
        panelNorth.add((Component)measuredRTPanel, "East");
        panelNorth.add((Component)addNewSpeciesPanel, "West");
        return panelNorth;
    }

    private JPanel createPanelSouth() {
        JPanel panelSouth = new JPanel(new BorderLayout());
        JPanel editPanel = new JPanel();
        JPanel cancelPanel = new JPanel();
        JButton assignSelectedSpeciesButton = this.createJButton(BUTTON_ASSIGN_SELECTED_SPECIES, COMMAND_ASSIGN_SELECTED_SPECIES, "<html>Assign selected molecular species to this signal.</html>");
        JButton removeSelectedSpeciesButton = this.createJButton(BUTTON_REMOVE_SELECTED_SPECIES, COMMAND_REMOVE_SELECTED_SPECIES, "<html>Remove selected molecular species.</html>");
        JButton saveButton = this.createJButton(BUTTON_SAVE_CHANGES, COMMAND_SAVE_CHANGES, "<html>Save changes to result file.</html>");
        JButton cancelButton = this.createJButton(BUTTON_CANCEL, COMMAND_CANCEL, "<html>Cancel operation</html>");
        editPanel.add(assignSelectedSpeciesButton);
        editPanel.add(removeSelectedSpeciesButton);
        editPanel.add(saveButton);
        cancelPanel.add(cancelButton);
        panelSouth.add((Component)editPanel, "West");
        panelSouth.add((Component)cancelPanel, "East");
        return panelSouth;
    }

    private void addRows() {
        for (DoubleBondPositionVO doubleBondPositionVO : this.localDoubleBondPositionVOs_) {
            Object[] row = this.createRow(doubleBondPositionVO);
            this.model_.addRow(row);
        }
    }

    private Object[] createRow(DoubleBondPositionVO doubleBondPositionVO) {
        Object[] row = new Object[]{doubleBondPositionVO.getDoubleBondPositionsHumanReadable(), this.getStringWithTwoDecimals(this.getDeltaRT(doubleBondPositionVO.getExpectedRetentionTime())), this.getStringWithTwoDecimals(doubleBondPositionVO.getExpectedRetentionTime()), this.accuracy_[doubleBondPositionVO.getAccuracy()], doubleBondPositionVO.getIsAssigned()};
        return row;
    }
}

