/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.interfaces.ColorChangeListener;
import at.tugraz.genome.lda.utils.ColorSequence;
import at.tugraz.genome.maspectras.utils.ColorEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ColorChooserDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -5108488715688689425L;
    public static final int DEFAULT_TYPE = 0;
    public static final int EXPERIMENT_TYPE = 1;
    public static final int GROUP_TYPE = 2;
    private JColorChooser colorChooser_;
    private Color defaultColor_ = Color.WHITE;
    private Hashtable<String, Color> expColors_;
    private Hashtable<String, Color> groupColors_;
    private ColorChangeListener changeListener_;
    private int currentType_;
    private String currentName_;

    public ColorChooserDialog(JFrame parent, String title, Vector<String> expNames, Vector<String> groupNames, ColorChangeListener changeListener) {
        super(parent, title, true);
        this.expColors_ = this.createColorScheme(expNames);
        this.groupColors_ = this.createColorScheme(groupNames);
        this.changeListener_ = changeListener;
        this.setLocation(380, 240);
        this.setLayout(new BorderLayout());
        this.colorChooser_ = new JColorChooser();
        this.add((Component)this.colorChooser_, "Center");
        JPanel buttonPane = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.addActionListener(this);
        cancelButton.setActionCommand("CancelColorSelection");
        cancelButton.setToolTipText("<html>Cancel operation</html>");
        JButton okButton = new JButton("OK");
        buttonPane.add(okButton);
        okButton.addActionListener(this);
        okButton.setActionCommand("AcceptColorSelection");
        okButton.setToolTipText("<html>Accept settings</html>");
        this.add((Component)buttonPane, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(false);
    }

    public void showColorChooser(String title, int type, String name) {
        this.currentType_ = type;
        this.currentName_ = name;
        this.setTitle(title);
        Color initColor = this.getColor(type, name);
        this.colorChooser_.setColor(initColor);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("AcceptColorSelection")) {
            Color selectedColor = this.colorChooser_.getColor();
            if (this.currentType_ == 0) {
                this.defaultColor_ = selectedColor;
            } else if (this.currentType_ == 1) {
                this.expColors_.put(this.currentName_, selectedColor);
            } else if (this.currentType_ == 2) {
                this.groupColors_.put(this.currentName_, selectedColor);
            }
            this.setVisible(false);
            this.changeListener_.updateColorChange();
        } else if (e.getActionCommand().equalsIgnoreCase("CancelColorSelection")) {
            this.setVisible(false);
        }
    }

    private Hashtable<String, Color> createColorScheme(Vector<String> valueNames) {
        Hashtable<String, Color> colors = new Hashtable<String, Color>();
        if (valueNames != null) {
            Vector colorChannels = new ColorEncoder(valueNames.size()).getChannels();
            Color[] defaultColors = ColorSequence.getDefaultColors();
            int count = 0;
            for (String name : valueNames) {
                Color color = null;
                if (valueNames.size() > defaultColors.length) {
                    int[] rgb = (int[])colorChannels.get(count);
                    color = new Color(rgb[0], rgb[1], rgb[2]);
                } else {
                    color = defaultColors[count];
                }
                colors.put(name, color);
                ++count;
            }
        }
        return colors;
    }

    public Color getColor(int type, String name) {
        if (type == 0) {
            return this.defaultColor_;
        }
        if (type == 1) {
            return this.expColors_.get(name);
        }
        if (type == 2) {
            return this.groupColors_.get(name);
        }
        return Color.BLACK;
    }

    public void cleanup() {
        this.changeListener_ = null;
    }
}

