/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.SampleLookup;
import at.tugraz.genome.lda.analysis.exception.CalculationNotPossibleException;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RetentionTimeGroupingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.export.ExcelAndTextExporter;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.swing.BarChart;
import at.tugraz.genome.lda.swing.ColorChooserDialog;
import at.tugraz.genome.lda.swing.ExportPanel;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ExportOptionsVO;
import at.tugraz.genome.lda.vos.ResultCompGroupVO;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class BarChartPainter
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -8728298412578227539L;
    public static final int TYPE_MOLECULE = 0;
    public static final int TYPE_EXPERIMENT = 1;
    public static final int TYPE_CLASSES = 2;
    private Vector<String> moleculeNames_;
    private JComboBox<String> quantType_;
    private JPanel barChartPanel_;
    private ButtonGroup barDisplayGroup_;
    private JRadioButton singleSided_;
    private JRadioButton doubleSided_;
    private ButtonGroup barScaleGroup_;
    private JRadioButton logarithmicScale_;
    private JRadioButton normalScale_;
    private JComboBox<String> magnitudeChooser_;
    private BarChart barChart_;
    private JRadioButton standardDeviation_;
    private JTextField multStandardDeviation_;
    private JRadioButton standardErrorMean_;
    protected JCheckBox exportDeviation_;
    private JRadioButton columnAnalyte_;
    private JRadioButton columnExperiment_;
    protected JCheckBox exportRT_;
    protected JCheckBox exportRTDev_;
    protected JComboBox<String> maxIsotopes_;
    private Hashtable<String, Hashtable<String, ResultCompVO>> analysisResultsHash_;
    private boolean repaintingBarChart_;
    private Vector<String> originalValueNames_;
    private boolean showSDFields_;
    private int maximumIsotopes_;
    private ResultDisplaySettingsVO settingVO_;
    private String preferredUnit_;
    private String unit_;
    private JFileChooser exportFileChooser_;
    private int type_;
    private String groupName_;
    private Hashtable<String, Hashtable<String, Double>> valuesToPaint_ = new Hashtable();
    private Hashtable<String, Hashtable<String, Double>> sdsToPaint_ = new Hashtable();
    private Hashtable<String, Hashtable<String, Double>> singleResultValues_ = new Hashtable();
    private Hashtable<String, Integer> corrTypeISLookup_;
    private Hashtable<String, Integer> corrTypeESLookup_;
    ArrayList<String> modifications_;
    private String yAxisText_;
    ColorChooserDialog colorChooser_;
    private boolean bigConstructor_ = false;
    private int colorType_;
    private SampleLookup sampleLookup_;
    private boolean useSampleLookup_;
    private boolean rtGrouped_;
    private boolean isGroupedView_;

    public BarChartPainter(int type, String groupName, String moleculeName, Hashtable<String, ResultCompVO> analysisResults, Vector<String> sortedValueNames, SampleLookup lookup, boolean useSampleLookup, boolean showSDFields, int maxIsotopes, boolean rtGrouped, boolean isGroupedView, ResultDisplaySettingsVO settingVO, String preferredUnit, String unit, Hashtable<String, Integer> corrTypeISLookup, Hashtable<String, Integer> corrTypeESLookup, ArrayList<String> modifications, ColorChooserDialog colorChooser) {
        this(type, groupName, lookup, useSampleLookup, sortedValueNames, showSDFields, maxIsotopes, rtGrouped, isGroupedView, settingVO, preferredUnit, unit, corrTypeISLookup, corrTypeESLookup, modifications, colorChooser);
        this.moleculeNames_.add(moleculeName);
        this.analysisResultsHash_.put(moleculeName, analysisResults);
        this.bigConstructor_ = false;
        this.init();
    }

    public BarChartPainter(int type, String groupName, Vector<String> moleculeNames, Hashtable<String, Hashtable<String, ResultCompVO>> analysisResults, Vector<String> sortedValueNames, SampleLookup lookup, boolean useSampleLookup, boolean showSDFields, int maxIsotopes, boolean rtGrouped, boolean isGroupedView, ResultDisplaySettingsVO settingVO, String preferredUnit, String unit, Hashtable<String, Integer> corrTypeISLookup, Hashtable<String, Integer> corrTypeESLookup, ArrayList<String> modifications, ColorChooserDialog colorChooser) {
        this(type, groupName, lookup, useSampleLookup, sortedValueNames, showSDFields, maxIsotopes, rtGrouped, isGroupedView, settingVO, preferredUnit, unit, corrTypeISLookup, corrTypeESLookup, modifications, colorChooser);
        this.analysisResultsHash_ = analysisResults;
        this.moleculeNames_ = moleculeNames;
        this.bigConstructor_ = true;
        this.init();
    }

    private BarChartPainter(int type, String groupName, SampleLookup lookup, boolean useSampleLookup, Vector<String> sortedValueNames, boolean showSDFields, int maxIsotopes, boolean rtGrouped, boolean isGroupedView, ResultDisplaySettingsVO settingVO, String preferredUnit, String unit, Hashtable<String, Integer> corrTypeISLookup, Hashtable<String, Integer> corrTypeESLookup, ArrayList<String> modifications, ColorChooserDialog colorChooser) {
        this.analysisResultsHash_ = new Hashtable();
        this.sampleLookup_ = lookup;
        this.useSampleLookup_ = useSampleLookup;
        this.moleculeNames_ = new Vector();
        this.type_ = type;
        this.groupName_ = groupName;
        this.originalValueNames_ = sortedValueNames;
        this.maximumIsotopes_ = maxIsotopes;
        this.rtGrouped_ = rtGrouped;
        this.isGroupedView_ = isGroupedView;
        this.showSDFields_ = showSDFields;
        this.settingVO_ = settingVO;
        this.preferredUnit_ = preferredUnit;
        this.unit_ = unit;
        this.modifications_ = modifications;
        if (this.modifications_ == null) {
            this.modifications_ = new ArrayList();
        }
        this.setLayout(new BorderLayout());
        this.barChartPanel_ = new JPanel();
        this.barChartPanel_.setLayout(new BorderLayout());
        this.add((Component)this.barChartPanel_, "Center");
        this.corrTypeISLookup_ = corrTypeISLookup;
        this.corrTypeESLookup_ = corrTypeESLookup;
        this.colorChooser_ = colorChooser;
    }

    private void init() {
        this.colorType_ = 0;
        if (this.bigConstructor_) {
            this.colorType_ = 1;
            if (this.showSDFields_) {
                this.colorType_ = 2;
            }
        }
        this.createTopMenu();
        ExportPanel expPanel = new ExportPanel(Color.WHITE, Color.BLACK, this);
        this.add((Component)expPanel, "South");
        this.repaintingBarChart_ = false;
        this.exportFileChooser_ = new JFileChooser();
        this.exportFileChooser_.setPreferredSize(new Dimension(600, 500));
    }

    private void createTopMenu() {
        JPanel menuPanel = new JPanel();
        menuPanel.setLayout(new BorderLayout());
        this.add((Component)menuPanel, "North");
        Font titleFont = new Font("Helvetica", 0, 24);
        String titleName = "";
        if (this.moleculeNames_.size() < 2) {
            titleName = this.moleculeNames_.get(0);
        }
        JLabel title = new JLabel(titleName);
        title.setFont(titleFont);
        title.setHorizontalAlignment(0);
        menuPanel.add((Component)title, "North");
        this.maxIsotopes_ = new JComboBox();
        for (int i = 0; i != this.maximumIsotopes_; ++i) {
            this.maxIsotopes_.addItem(String.valueOf(i));
        }
        this.maxIsotopes_.setSelectedItem(String.valueOf(this.maximumIsotopes_ - 1));
        this.quantType_ = new JComboBox();
        this.quantType_.addItem("area absolute");
        this.quantType_.addItem("percentual values");
        if (this.type_ != 2) {
            this.quantType_.addItem("area relative to molecule");
        }
        if (this.settingVO_.getISStandMethod() != 0 || this.settingVO_.getESStandMethod() != 0) {
            this.quantType_.addItem("area relative to standard");
        }
        if (!this.settingVO_.getType().equalsIgnoreCase("relative value")) {
            this.quantType_.addItem("absolute quantity");
        }
        this.repaintingBarChart_ = true;
        if (this.type_ != 2) {
            this.quantType_.setSelectedItem("area relative to molecule");
        } else {
            this.quantType_.setSelectedItem("percentual values");
        }
        this.repaintingBarChart_ = false;
        SelectionItemListener quantTypeListener = new SelectionItemListener("ChangeChart");
        this.quantType_.addItemListener(quantTypeListener);
        this.quantType_.setToolTipText("<html>The quantitative type that is used for the geration of the bar chart.<br/>A detailed description about the types can be found in the user<br>manual chapter 5.3  or in the Help component of the software.</html>");
        this.magnitudeChooser_ = new JComboBox();
        this.addEmptyItemToChooser();
        this.magnitudeChooser_.setEnabled(false);
        SelectionItemListener magnListener = new SelectionItemListener("ChangeMagnitude");
        this.magnitudeChooser_.addItemListener(magnListener);
        this.magnitudeChooser_.setToolTipText("<html>Selection of corresponding unit magnifier.</html>");
        this.barDisplayGroup_ = new ButtonGroup();
        this.singleSided_ = new JRadioButton("single-sided");
        this.singleSided_.addItemListener(new SelectionItemListener("ChangeSided"));
        this.singleSided_.setToolTipText("<html>Paints the bar chart into one (positive) direction</html>");
        this.barDisplayGroup_.add(this.singleSided_);
        this.doubleSided_ = new JRadioButton("double-sided");
        this.doubleSided_.addItemListener(new SelectionItemListener("ChangeSided"));
        this.doubleSided_.setToolTipText("<html>Paints the bar chart relative to the reference value (pos and neg direction).</html>");
        this.barDisplayGroup_.add(this.doubleSided_);
        this.barScaleGroup_ = new ButtonGroup();
        this.logarithmicScale_ = new JRadioButton("logarithmic");
        this.logarithmicScale_.addItemListener(new SelectionItemListener("ChangeLog"));
        this.logarithmicScale_.setToolTipText("<html>Paints the values in logarithmic scale.</html>");
        this.barScaleGroup_.add(this.logarithmicScale_);
        this.normalScale_ = new JRadioButton("linear");
        this.normalScale_.setSelected(true);
        this.normalScale_.addItemListener(new SelectionItemListener("ChangeLog"));
        this.normalScale_.setToolTipText("<html>Paints the values in linear scale.</html>");
        this.barScaleGroup_.add(this.normalScale_);
        SelectionItemListener isotopeListener = new SelectionItemListener("ChangeIsotope");
        this.maxIsotopes_.addItemListener(isotopeListener);
        this.maxIsotopes_.setToolTipText("<html>Upper limit for the additional isotopic peaks used for the quantitative value.</html>");
        JPanel menuItemsBar = new JPanel();
        JLabel typeLabel = new JLabel("quant-type: ");
        typeLabel.setToolTipText("<html>The quantitative type that is used for the geration of the bar chart.<br/>A detailed description about the types can be found in the user<br>manual chapter 5.3  or in the Help component of the software.</html>");
        menuItemsBar.add(typeLabel);
        menuItemsBar.add(this.quantType_);
        menuItemsBar.add(this.magnitudeChooser_);
        menuItemsBar.add(this.singleSided_);
        menuItemsBar.add(this.doubleSided_);
        menuItemsBar.add(this.logarithmicScale_);
        menuItemsBar.add(this.normalScale_);
        menuItemsBar.add(this.maxIsotopes_);
        JLabel isotpesLabel = new JLabel("isotopes");
        isotpesLabel.setToolTipText("<html>Upper limit for the additional isotopic peaks used for the quantitative value.</html>");
        menuItemsBar.add(isotpesLabel);
        if (this.settingVO_.getType().equalsIgnoreCase("relative value")) {
            this.quantType_.setSelectedItem("area absolute");
        } else {
            this.quantType_.setSelectedItem("absolute quantity");
        }
        menuPanel.add((Component)menuItemsBar, "Center");
        JPanel expAndSD = new JPanel();
        expAndSD.setLayout(new BorderLayout());
        menuPanel.add((Component)expAndSD, "South");
        if (this.showSDFields_) {
            JPanel sdItemsBar = new JPanel();
            expAndSD.add((Component)sdItemsBar, "North");
            ButtonGroup deviationGroup = new ButtonGroup();
            this.standardDeviation_ = new JRadioButton("standard deviation");
            this.standardDeviation_.setSelected(true);
            this.standardDeviation_.addItemListener(new SelectionItemListener("ChangeSD"));
            this.standardDeviation_.setToolTipText("<html>Paints standard deviation as error bars.</html>");
            deviationGroup.add(this.standardDeviation_);
            sdItemsBar.add(this.standardDeviation_);
            this.multStandardDeviation_ = new JTextField(3);
            this.multStandardDeviation_.setText("1.0");
            this.multStandardDeviation_.addKeyListener(new ReturnKeyListener());
            this.multStandardDeviation_.setInputVerifier(new DoubleVerifier());
            this.multStandardDeviation_.addFocusListener(new SDFocusListener());
            this.multStandardDeviation_.setToolTipText("<html>Multiplicative factor for the error bars of the standard deviation.</html>");
            sdItemsBar.add(this.multStandardDeviation_);
            this.standardErrorMean_ = new JRadioButton("standard error mean");
            this.standardErrorMean_.addItemListener(new SelectionItemListener("ChangeSD"));
            this.standardErrorMean_.setToolTipText("<html>Paints standard error as error bars.</html>");
            deviationGroup.add(this.standardErrorMean_);
            sdItemsBar.add(this.standardErrorMean_);
        }
        JPanel expItemsBar = new JPanel();
        expAndSD.add((Component)expItemsBar, "South");
        if (this.showSDFields_) {
            this.exportDeviation_ = new JCheckBox("export deviation value");
            this.exportDeviation_.setSelected(false);
            this.exportDeviation_.setToolTipText("<html>Should the deviation values be exported (standard deviation or standard error)?</html>");
            expItemsBar.add(this.exportDeviation_);
        }
        ButtonGroup columnGroup = new ButtonGroup();
        this.columnAnalyte_ = new JRadioButton("analyte in column");
        this.columnAnalyte_.setSelected(true);
        this.columnAnalyte_.setToolTipText("<html>Table setup: analytes in columns and experiments/groups in rows</html>");
        columnGroup.add(this.columnAnalyte_);
        expItemsBar.add(this.columnAnalyte_);
        this.columnExperiment_ = new JRadioButton("exp in column");
        this.columnExperiment_.setSelected(false);
        this.columnExperiment_.setToolTipText("<html>Table setup: experiments/groups in columns and analytes in rows</html>");
        columnGroup.add(this.columnExperiment_);
        expItemsBar.add(this.columnExperiment_);
        if (this.type_ != 2) {
            this.exportRT_ = new JCheckBox("export retention-time");
            this.exportRT_.setActionCommand("changeRTSelectionStatus");
            this.exportRT_.addActionListener(this);
            this.exportRT_.setSelected(false);
            this.exportRT_.setToolTipText("<html>Should the retention time be exported?</html>");
            expItemsBar.add(this.exportRT_);
            if (this.showSDFields_) {
                this.exportRTDev_ = new JCheckBox("export RT-stdev");
                this.exportRTDev_.addActionListener(this);
                this.exportRTDev_.setSelected(false);
                this.exportRTDev_.setEnabled(false);
                this.exportRTDev_.setToolTipText("<html>Should the standard deviation of the retention time be exported?</html>");
                expItemsBar.add(this.exportRTDev_);
            }
        }
    }

    public void createPaintingArea() {
        Vector result;
        ResultDisplaySettingsVO standardizedSet;
        this.barChartPanel_.removeAll();
        this.valuesToPaint_ = new Hashtable();
        this.sdsToPaint_ = new Hashtable();
        double lowestValue = 0.0;
        double highestValue = 0.0;
        int maxIsotope = Integer.parseInt((String)this.maxIsotopes_.getSelectedItem());
        this.yAxisText_ = null;
        String subTitle = "";
        String standardText = "";
        if (this.settingVO_.getISStandMethod() != 0 || this.settingVO_.getESStandMethod() != 0) {
            standardText = "standardized:   ";
            if (this.settingVO_.getISStandMethod() != 0) {
                standardText = standardText + "IS=";
                standardText = this.settingVO_.getISStandMethod() == 1 ? standardText + "most reliable standard" : (this.settingVO_.getISStandMethod() == 2 ? standardText + "median method" : standardText + this.getStandardName(this.corrTypeISLookup_, this.settingVO_.getISStandMethod()));
            }
            if (this.settingVO_.getISStandMethod() != 0 && this.settingVO_.getESStandMethod() != 0) {
                standardText = standardText + "   ";
            }
            if (this.settingVO_.getESStandMethod() != 0) {
                standardText = standardText + "ES=";
                standardText = this.settingVO_.getESStandMethod() == 1 ? standardText + "most reliable standard" : (this.settingVO_.getESStandMethod() == 2 ? standardText + "median method" : standardText + this.getStandardName(this.corrTypeESLookup_, this.settingVO_.getESStandMethod()));
            }
        }
        if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("area absolute")) {
            standardizedSet = new ResultDisplaySettingsVO(this.settingVO_);
            standardizedSet.setType("relative value");
            boolean useAbsolute = false;
            if (this.type_ == 2) {
                useAbsolute = true;
            }
            Vector result2 = this.extractLowestHighestValue("getArea", "getAreaSD", "getAreaSE", maxIsotope, standardizedSet, useAbsolute, this.preferredUnit_);
            lowestValue = (Double)result2.get(0);
            highestValue = (Double)result2.get(1);
            this.valuesToPaint_ = (Hashtable)result2.get(2);
            this.sdsToPaint_ = (Hashtable)result2.get(3);
            this.singleResultValues_ = (Hashtable)result2.get(4);
            this.yAxisText_ = "area [AU]";
            if (this.type_ == 2) {
                this.yAxisText_ = this.unit_;
            } else {
                subTitle = "arbitrary area value";
            }
        }
        if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("percentual values")) {
            try {
                standardizedSet = new ResultDisplaySettingsVO(this.settingVO_);
                subTitle = "relative to total amount of ";
                if (this.type_ == 0 && this.bigConstructor_ || this.type_ == 1) {
                    subTitle = subTitle + "selected molecules";
                } else if (this.type_ == 0) {
                    subTitle = subTitle + "selected samples";
                } else if (this.type_ == 2) {
                    subTitle = subTitle + "classes";
                }
                if (this.type_ != 2) {
                    this.calculatePercentualValues(maxIsotope);
                    standardizedSet.setPercent(true);
                } else {
                    standardizedSet.setType("percentual value");
                }
                standardizedSet.setDivisorMagnitude("");
                Vector result3 = this.extractLowestHighestValue("getArea", "getAreaSD", "getAreaSE", maxIsotope, standardizedSet, true, "%");
                lowestValue = (Double)result3.get(0);
                highestValue = (Double)result3.get(1);
                this.valuesToPaint_ = (Hashtable)result3.get(2);
                this.sdsToPaint_ = (Hashtable)result3.get(3);
                this.singleResultValues_ = (Hashtable)result3.get(4);
                this.yAxisText_ = "percent [%]";
            }
            catch (CalculationNotPossibleException cnp) {
                new WarningMessage(new JFrame(), "Error", cnp.getMessage());
                return;
            }
        }
        if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("area relative to molecule")) {
            result = this.extractLowestHighestValue("getRelativeValue", "getRelativeValueSD", "getRelativeValueSE", maxIsotope, this.settingVO_, false, this.preferredUnit_);
            lowestValue = (Double)result.get(0);
            highestValue = (Double)result.get(1);
            this.valuesToPaint_ = (Hashtable)result.get(2);
            this.sdsToPaint_ = (Hashtable)result.get(3);
            this.singleResultValues_ = (Hashtable)result.get(4);
            this.yAxisText_ = "rel. median";
            subTitle = "relative to median";
        }
        if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("area relative to standard")) {
            result = this.extractLowestHighestValue("getRelativeToMedian", "getRelativeToMedianSD", "getRelativeToMedianSE", maxIsotope, this.settingVO_, false, this.preferredUnit_);
            lowestValue = (Double)result.get(0);
            highestValue = (Double)result.get(1);
            this.valuesToPaint_ = (Hashtable)result.get(2);
            this.sdsToPaint_ = (Hashtable)result.get(3);
            this.singleResultValues_ = (Hashtable)result.get(4);
            this.yAxisText_ = "rel. standard";
            subTitle = "relative to standard";
        }
        if (lowestValue == 1.0 && highestValue == 1.0) {
            highestValue = 10.0;
            lowestValue = 0.1;
        }
        String sdText = "";
        if (this.showSDFields_) {
            sdText = this.standardDeviation_ != null ? (this.standardDeviation_.isSelected() ? "+/- " + this.multStandardDeviation_.getText() + "*SD" : "+/- SE") : "+/- 1.0*SD";
        }
        if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("absolute quantity")) {
            Vector result4 = this.extractLowestHighestValue("getArea", "getAreaSD", "getAreaSE", maxIsotope, this.settingVO_, true, (String)this.magnitudeChooser_.getSelectedItem());
            lowestValue = (Double)result4.get(0);
            highestValue = (Double)result4.get(1);
            this.valuesToPaint_ = (Hashtable)result4.get(2);
            this.sdsToPaint_ = (Hashtable)result4.get(3);
            this.singleResultValues_ = (Hashtable)result4.get(4);
            this.yAxisText_ = this.unit_.substring(0, this.unit_.indexOf("[") + 1) + (String)this.magnitudeChooser_.getSelectedItem() + this.unit_.substring(this.unit_.indexOf("[") + 1 + this.preferredUnit_.length());
            if (this.settingVO_.getType().equalsIgnoreCase("relative to base peak")) {
                subTitle = "relative to highest peak of the " + this.groupName_ + " class";
            } else if (this.settingVO_.getType().equalsIgnoreCase("relative to measured class amount")) {
                subTitle = "relative to the total amount of " + this.groupName_ + " class";
            } else if (this.settingVO_.getType().equalsIgnoreCase("relative to highest total peak")) {
                subTitle = "relative to the highest found peak";
            } else if (this.settingVO_.getType().equalsIgnoreCase("relative to total amount")) {
                subTitle = "relative to the total of all quantified peaks";
            } else if (this.settingVO_.getType().equalsIgnoreCase("amount end-volume")) {
                subTitle = "amount in end volume";
            } else if (this.settingVO_.getType().equalsIgnoreCase("conc. end-volume")) {
                subTitle = "concentration in end volume";
            } else if (this.settingVO_.getType().equalsIgnoreCase("weight end-volume")) {
                subTitle = "weight in end volume";
            } else if (this.settingVO_.getType().equalsIgnoreCase("amount sample-volume")) {
                subTitle = "amount in sample volume";
            } else if (this.settingVO_.getType().equalsIgnoreCase("conc. sample-volume")) {
                subTitle = "concentration in probe volume";
            } else if (this.settingVO_.getType().equalsIgnoreCase("weight sample-volume")) {
                subTitle = "weight in sample volume";
            } else if (this.settingVO_.getType().equalsIgnoreCase("relative to sample weight")) {
                subTitle = "relative to sample weight";
            } else if (this.settingVO_.getType().equalsIgnoreCase("relation to protein content")) {
                subTitle = "relative to protein content";
            } else if (this.settingVO_.getType().equalsIgnoreCase("relation to neutral lipid content")) {
                subTitle = "relative to indepently measured neutrel lipid content";
            } else if (this.settingVO_.getType().equalsIgnoreCase("relation to measured neutral lipid")) {
                subTitle = "relative to total class content measured by MS";
            }
        }
        this.barChart_ = new BarChart(this.doubleSided_.isSelected(), this.logarithmicScale_.isSelected(), this.valuesToPaint_, this.sdsToPaint_, this.groupName_, subTitle, standardText, this.moleculeNames_, this.useSampleLookup_ ? this.sampleLookup_ : null, this.originalValueNames_, lowestValue, highestValue, this.yAxisText_, sdText, this.colorChooser_, this.colorType_);
        this.barChartPanel_.add((Component)this.barChart_, "Center");
        this.barChartPanel_.invalidate();
        this.barChartPanel_.updateUI();
    }

    private Vector extractLowestHighestValue(String valueGetterMethod, String sdGetterMethod, String seGetterMethod, int maxIsotopes, ResultDisplaySettingsVO settingVO, boolean absolute, String preferredUnit) {
        Vector<Serializable> results = new Vector<Serializable>();
        Double highestTotalValue = 0.0;
        Double lowestTotalValue = Double.MAX_VALUE;
        Hashtable valuesToPaint = new Hashtable();
        Hashtable sdsToPaint = new Hashtable();
        Hashtable originalFileValues = new Hashtable();
        try {
            Class[] classes = new Class[]{Integer.TYPE, ResultDisplaySettingsVO.class};
            Method valueGetter = ResultCompVO.class.getMethod(valueGetterMethod, classes);
            Method sdGetter = ResultCompGroupVO.class.getMethod(sdGetterMethod, classes);
            Method seGetter = ResultCompGroupVO.class.getMethod(seGetterMethod, classes);
            Object[] getterParameters = new Object[2];
            getterParameters[1] = settingVO;
            for (String molName : this.analysisResultsHash_.keySet()) {
                Hashtable<String, Double> valuesToPaintMol = new Hashtable<String, Double>();
                Hashtable<String, Double> sdsToPaintMol = new Hashtable<String, Double>();
                for (String name : this.analysisResultsHash_.get(molName).keySet()) {
                    ResultCompVO compVO = this.analysisResultsHash_.get(molName).get(name);
                    int isotopes = this.extractCorrectIsotopesSetting(maxIsotopes, settingVO, valueGetterMethod, compVO);
                    if (isotopes < maxIsotopes) {
                        this.maxIsotopes_.setSelectedItem(String.valueOf(isotopes));
                    }
                    getterParameters[0] = isotopes;
                    double standValue = (Double)valueGetter.invoke((Object)compVO, getterParameters);
                    if (absolute) {
                        standValue = StaticUtils.getAreaInCorrespondingUnit(standValue, preferredUnit);
                    }
                    valuesToPaintMol.put(name, standValue);
                    if (standValue > highestTotalValue) {
                        highestTotalValue = standValue;
                    }
                    if (standValue > 0.0 && standValue < lowestTotalValue) {
                        lowestTotalValue = standValue;
                    }
                    if (this.type_ != 1) {
                        if (!originalFileValues.containsKey(molName)) {
                            originalFileValues.put(molName, new Hashtable());
                        }
                    } else if (!originalFileValues.containsKey(name)) {
                        originalFileValues.put(name, new Hashtable());
                    }
                    if (compVO instanceof ResultCompGroupVO) {
                        ResultCompGroupVO groupVO = (ResultCompGroupVO)compVO;
                        double standValueSD = (Double)sdGetter.invoke((Object)groupVO, getterParameters);
                        if (absolute) {
                            standValueSD = StaticUtils.getAreaInCorrespondingUnit(standValueSD, preferredUnit);
                        }
                        if (this.standardDeviation_ != null) {
                            if (this.standardDeviation_.isSelected()) {
                                standValueSD *= Double.parseDouble(this.multStandardDeviation_.getText());
                            } else {
                                standValueSD = (Double)seGetter.invoke((Object)groupVO, getterParameters);
                                if (absolute) {
                                    standValueSD = StaticUtils.getAreaInCorrespondingUnit(standValueSD, preferredUnit);
                                }
                            }
                        }
                        sdsToPaintMol.put(name, standValueSD);
                        if (Double.valueOf(standValueSD) != Double.NaN && Double.valueOf(standValueSD) != Double.NEGATIVE_INFINITY && Double.valueOf(standValueSD) != Double.POSITIVE_INFINITY) {
                            if (standValue + standValueSD > highestTotalValue) {
                                highestTotalValue = standValue + standValueSD;
                            }
                            if (standValue - standValueSD > 0.0 && standValue - standValueSD < lowestTotalValue) {
                                lowestTotalValue = standValue - standValueSD;
                            }
                        }
                        for (String expName : groupVO.getGroupingPartners().keySet()) {
                            if (this.type_ != 1 ? ((Hashtable)originalFileValues.get(molName)).containsKey(expName) : ((Hashtable)originalFileValues.get(name)).containsKey(expName)) continue;
                            ResultCompVO expCompVO = groupVO.getGroupingPartners().get(expName);
                            double expStandValue = (Double)valueGetter.invoke((Object)expCompVO, getterParameters);
                            if (absolute) {
                                expStandValue = StaticUtils.getAreaInCorrespondingUnit(expStandValue, preferredUnit);
                            }
                            if (this.type_ != 1) {
                                ((Hashtable)originalFileValues.get(molName)).put(expName, expStandValue);
                                continue;
                            }
                            ((Hashtable)originalFileValues.get(name)).put(expName, expStandValue);
                        }
                        continue;
                    }
                    if (this.type_ != 1) {
                        ((Hashtable)originalFileValues.get(molName)).put(name, standValue);
                        continue;
                    }
                    ((Hashtable)originalFileValues.get(name)).put(name, standValue);
                }
                valuesToPaint.put(molName, valuesToPaintMol);
                sdsToPaint.put(molName, sdsToPaintMol);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        results.add(lowestTotalValue);
        results.add(highestTotalValue);
        results.add(valuesToPaint);
        results.add(sdsToPaint);
        results.add(originalFileValues);
        return results;
    }

    private boolean verifySDFactInput() {
        try {
            Double.parseDouble(this.multStandardDeviation_.getText());
            return true;
        }
        catch (NumberFormatException nfx) {
            new WarningMessage(new JFrame(), "Error", "SD value input must be in double format (xxx.xxx) and not " + this.multStandardDeviation_.getText());
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("changeRTSelectionStatus")) {
            if (this.exportRTDev_ != null) {
                if (this.exportRT_ != null && this.exportRT_.isSelected()) {
                    this.exportRTDev_.setEnabled(true);
                } else {
                    this.exportRTDev_.setSelected(false);
                    this.exportRTDev_.setEnabled(false);
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("exportPNG")) {
            this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("PNG (*.png)", "png"));
            int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
            if (returnVal == 0) {
                File fileToStore = this.exportFileChooser_.getSelectedFile();
                Vector results = StaticUtils.checkFileStorage(fileToStore, "png", this);
                fileToStore = (File)results.get(0);
                if (((Boolean)results.get(1)).booleanValue()) {
                    try {
                        ImageIO.write((RenderedImage)this.barChart_.getImage(), "PNG", fileToStore);
                    }
                    catch (IOException ex) {
                        new WarningMessage(new JFrame(), "Error", ex.getMessage());
                    }
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("exportSVG")) {
            this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("SVG (*.svg)", "svg"));
            int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
            if (returnVal == 0) {
                File fileToStore = this.exportFileChooser_.getSelectedFile();
                Vector results = StaticUtils.checkFileStorage(fileToStore, "svg", this);
                fileToStore = (File)results.get(0);
                if (((Boolean)results.get(1)).booleanValue()) {
                    try {
                        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                        String svgNS = "http://www.w3.org/2000/svg";
                        Document document = domImpl.createDocument(svgNS, "svg", null);
                        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                        this.barChart_.drawBarchart(svgGenerator, true);
                        boolean useCSS = true;
                        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileToStore));
                        OutputStreamWriter out = new OutputStreamWriter((OutputStream)stream, "UTF-8");
                        svgGenerator.stream(out, useCSS);
                        ((Writer)out).close();
                    }
                    catch (IOException ex) {
                        new WarningMessage(new JFrame(), "Error", ex.getMessage());
                    }
                }
            }
        } else if (e.getActionCommand().equalsIgnoreCase("exportExcel") || e.getActionCommand().equalsIgnoreCase("exportText")) {
            int exportType = 0;
            String sdValue = null;
            if (this.standardDeviation_ != null && this.exportDeviation_.isSelected()) {
                if (this.standardDeviation_.isSelected()) {
                    exportType = 1;
                    sdValue = this.multStandardDeviation_.getText();
                } else {
                    exportType = 2;
                }
            }
            boolean exportRTDev = false;
            if (this.exportRTDev_ != null && this.exportRTDev_.isSelected()) {
                exportRTDev = true;
            }
            boolean exportRT = false;
            if (this.exportRT_ != null && this.exportRT_.isSelected()) {
                exportRT = true;
            }
            int roundValue = 6;
            if (this.barChart_.getRoundValue() + 2 > roundValue) {
                roundValue = this.barChart_.getRoundValue() + 2;
            }
            ExportOptionsVO exportVO = new ExportOptionsVO(exportType, sdValue, this.columnAnalyte_.isSelected(), exportRT, exportRTDev, false, roundValue, 0);
            if (e.getActionCommand().equalsIgnoreCase("exportExcel")) {
                this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("Microsoft Office Excel Woorkbook (*.xlsx)", "xlsx"));
                int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
                if (returnVal == 0) {
                    File fileToStore = this.exportFileChooser_.getSelectedFile();
                    Vector results = StaticUtils.checkFileStorage(fileToStore, "xlsx", this);
                    fileToStore = (File)results.get(0);
                    if (((Boolean)results.get(1)).booleanValue()) {
                        try {
                            int maxIsotope = Integer.parseInt((String)this.maxIsotopes_.getSelectedItem());
                            Vector resultsVector = this.extractResultsVector();
                            String headerTitle = StaticUtils.getAreaTypeString(this.settingVO_);
                            boolean exportDoubleBondPositionsForClass = exportVO.isExportDoubleBondPositions();
                            short speciesType = exportVO.getSpeciesType();
                            if (exportDoubleBondPositionsForClass) {
                                int numberOfChains = 2;
                                try {
                                    numberOfChains = Integer.parseInt(RulesContainer.getAmountOfChains(StaticUtils.getRuleName(this.groupName_, this.modifications_.get(0))));
                                }
                                catch (NoRuleException | RulesException | SpectrummillParserException | IOException ex) {
                                    ex.printStackTrace();
                                }
                                if (numberOfChains > 1 && speciesType == 0) {
                                    exportDoubleBondPositionsForClass = false;
                                } else if (numberOfChains == 1 && speciesType != 0) {
                                    speciesType = 0;
                                }
                            }
                            ExcelAndTextExporter.exportToFile(this.type_ != 2, speciesType, exportDoubleBondPositionsForClass, this.groupName_, new BufferedOutputStream(new FileOutputStream(fileToStore)), true, maxIsotope, (Vector)resultsVector.get(0), this.rtGrouped_, this.isGroupedView_, (Vector)resultsVector.get(1), (Hashtable)resultsVector.get(2), this.sampleLookup_.getSampleResultFullPaths(), this.sampleLookup_.getSamplesOfGroups(), (Hashtable)resultsVector.get(3), this.yAxisText_, headerTitle, exportVO, this.sampleLookup_.getComparativeResultsLookup(), this.modifications_);
                        }
                        catch (NumberFormatException ex) {
                            ex.printStackTrace();
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (FileNotFoundException ex) {
                            ex.printStackTrace();
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (ExcelInputFileException | ExportException | LipidCombinameEncodingException | SpectrummillParserException ex) {
                            ex.printStackTrace();
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (RetentionTimeGroupingException ex) {
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                    }
                }
            } else if (e.getActionCommand().equalsIgnoreCase("exportText")) {
                this.exportFileChooser_.setFileFilter(new FileNameExtensionFilter("Text (*.txt)", "txt"));
                int returnVal = this.exportFileChooser_.showSaveDialog(new JFrame());
                if (returnVal == 0) {
                    File fileToStore = this.exportFileChooser_.getSelectedFile();
                    Vector results = StaticUtils.checkFileStorage(fileToStore, "txt", this);
                    fileToStore = (File)results.get(0);
                    if (((Boolean)results.get(1)).booleanValue()) {
                        try {
                            int maxIsotope = Integer.parseInt((String)this.maxIsotopes_.getSelectedItem());
                            Vector resultsVector = this.extractResultsVector();
                            String headerTitle = StaticUtils.getAreaTypeString(this.settingVO_);
                            boolean exportDoubleBondPositionsForClass = exportVO.isExportDoubleBondPositions();
                            short speciesType = exportVO.getSpeciesType();
                            if (exportDoubleBondPositionsForClass) {
                                int numberOfChains = 2;
                                try {
                                    numberOfChains = Integer.parseInt(RulesContainer.getAmountOfChains(StaticUtils.getRuleName(this.groupName_, this.modifications_.get(0))));
                                }
                                catch (NoRuleException | RulesException | SpectrummillParserException | IOException ex) {
                                    System.out.println(ex.getMessage());
                                }
                                if (numberOfChains > 1 && speciesType == 0) {
                                    exportDoubleBondPositionsForClass = false;
                                } else if (numberOfChains == 1 && speciesType != 0) {
                                    speciesType = 0;
                                }
                            }
                            if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("area absolute")) {
                                headerTitle = "Area";
                            } else if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("area relative to molecule")) {
                                headerTitle = "Relative to Median";
                            } else if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("area relative to standard")) {
                                headerTitle = "Relative to Standard";
                            }
                            ExcelAndTextExporter.exportToFile(this.type_ != 2, speciesType, exportDoubleBondPositionsForClass, this.groupName_, new BufferedOutputStream(new FileOutputStream(fileToStore)), false, maxIsotope, (Vector)resultsVector.get(0), this.rtGrouped_, this.isGroupedView_, (Vector)resultsVector.get(1), (Hashtable)resultsVector.get(2), this.sampleLookup_.getSampleResultFullPaths(), this.sampleLookup_.getSamplesOfGroups(), (Hashtable)resultsVector.get(3), this.yAxisText_, headerTitle, exportVO, this.sampleLookup_.getComparativeResultsLookup(), this.modifications_);
                        }
                        catch (NumberFormatException ex) {
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (FileNotFoundException ex) {
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (IOException ex) {
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (ExcelInputFileException | ExportException | LipidCombinameEncodingException | SpectrummillParserException ex) {
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                        catch (RetentionTimeGroupingException ex) {
                            new WarningMessage(new JFrame(), "Error", ex.getMessage());
                        }
                    }
                }
            }
        }
    }

    private Vector extractResultsVector() {
        Vector<Cloneable> results = new Vector<Cloneable>();
        Vector<String> molNames = new Vector<String>();
        Vector<String> expNames = new Vector<String>();
        Hashtable<String, String> expHash = new Hashtable<String, String>();
        Hashtable resultsHash = new Hashtable();
        if (this.type_ == 0 || this.type_ == 2) {
            molNames.addAll(this.moleculeNames_);
            expNames.addAll(this.originalValueNames_);
            for (String expName : this.originalValueNames_) {
                expHash.put(expName, this.sampleLookup_.getDisplayName(expName));
            }
            for (String molName : this.moleculeNames_) {
                Hashtable resultHash = new Hashtable();
                for (String expName : this.sampleLookup_.getComparativeResultsLookup().getExpNamesInSequence()) {
                    Vector<Double> resultsVect = new Vector<Double>();
                    resultsVect.add(this.singleResultValues_.get(molName).get(expName));
                    String displayName = expName;
                    resultHash.put(displayName, resultsVect);
                }
                resultsHash.put(molName, resultHash);
            }
        } else if (this.type_ == 1) {
            molNames.addAll(this.originalValueNames_);
            String rightExp = null;
            if (this.isGroupedView_) {
                rightExp = this.moleculeNames_.get(0);
            } else {
                for (String expName : this.sampleLookup_.getComparativeResultsLookup().getExpNamesInSequence()) {
                    if (!this.sampleLookup_.getDisplayName(expName).equalsIgnoreCase(this.moleculeNames_.get(0))) continue;
                    rightExp = expName;
                }
            }
            expNames.add(rightExp);
            expHash.put(rightExp, this.moleculeNames_.get(0));
            for (String molName : this.valuesToPaint_.values().iterator().next().keySet()) {
                Hashtable resultHash = new Hashtable();
                if (this.isGroupedView_) {
                    for (String expName : this.sampleLookup_.getSamplesOfGroups().get(rightExp)) {
                        Vector<Double> resultsVect = new Vector<Double>();
                        resultsVect.add(this.singleResultValues_.get(molName).get(expName));
                        resultHash.put(expName, resultsVect);
                    }
                } else {
                    Vector<Double> resultsVect = new Vector<Double>();
                    resultsVect.add(this.valuesToPaint_.values().iterator().next().get(molName));
                    resultHash.put(rightExp, resultsVect);
                }
                resultsHash.put(molName, resultHash);
            }
        }
        results.add(molNames);
        results.add(expNames);
        results.add(expHash);
        results.add(resultsHash);
        return results;
    }

    private int extractCorrectIsotopesSetting(int maxIsotopes, ResultDisplaySettingsVO settingVO, String valueGetterMethod, ResultCompVO compVO) {
        int isotopes = maxIsotopes;
        if (!settingVO.getType().equalsIgnoreCase("relative to measured class amount") && !settingVO.getType().equalsIgnoreCase("relative to total amount") || valueGetterMethod.equalsIgnoreCase("getRelativeValue")) {
            isotopes = compVO.getAvailableIsotopeNr(maxIsotopes);
        }
        return isotopes;
    }

    /*
     * WARNING - void declaration
     */
    private void calculatePercentualValues(int maxIsotope) throws CalculationNotPossibleException {
        ResultDisplaySettingsVO settingVO = new ResultDisplaySettingsVO(this.settingVO_);
        settingVO.setDivisorMagnitude("");
        boolean isGrouped = false;
        Vector<Object> separateEntities_ = new Vector();
        Vector<Object> valuesToSum_ = new Vector();
        if (this.bigConstructor_) {
            valuesToSum_ = this.moleculeNames_;
            separateEntities_ = new Vector<String>(this.originalValueNames_);
        } else {
            valuesToSum_ = new Vector<String>(this.originalValueNames_);
            separateEntities_ = this.moleculeNames_;
        }
        for (String string : separateEntities_) {
            double totalArea = 0.0;
            double totalStd = 0.0;
            Hashtable<String, Double> singleExpAreas = new Hashtable<String, Double>();
            for (String string2 : valuesToSum_) {
                int isotopes;
                ResultCompVO compVO = null;
                compVO = this.bigConstructor_ ? this.analysisResultsHash_.get(string2).get(string) : this.analysisResultsHash_.get(string).get(string2);
                double area = compVO.getArea(isotopes = this.extractCorrectIsotopesSetting(maxIsotope, settingVO, "", compVO), settingVO);
                if (area > 0.0 && !Double.isNaN(area) && !Double.isInfinite(area)) {
                    totalArea += area;
                }
                if (!(compVO instanceof ResultCompGroupVO)) continue;
                isGrouped = true;
                ResultCompGroupVO groupVO = (ResultCompGroupVO)compVO;
                for (String string3 : groupVO.getGroupingPartners().keySet()) {
                    double singleExpArea = 0.0;
                    if (singleExpAreas.containsKey(string3)) {
                        singleExpArea = (Double)singleExpAreas.get(string3);
                    }
                    singleExpAreas.put(string3, singleExpArea += groupVO.getGroupingPartners().get(string3).getArea(compVO.getAvailableIsotopeNr(isotopes), settingVO));
                }
            }
            Vector<Double> sumAreas = new Vector<Double>();
            Hashtable<String, void> hashtable = new Hashtable<String, void>();
            for (int i = 0; i != this.maximumIsotopes_; ++i) {
                sumAreas.add(totalArea);
                for (String origExp : singleExpAreas.keySet()) {
                    void var18_27;
                    Vector vector = new Vector();
                    if (hashtable.containsKey(origExp)) {
                        Vector vector2 = (Vector)hashtable.get(origExp);
                    }
                    if (!this.bigConstructor_ && this.type_ == 0) {
                        var18_27.add(1.0);
                    } else {
                        var18_27.add(singleExpAreas.get(origExp));
                    }
                    hashtable.put(origExp, var18_27);
                }
            }
            Vector<Double> sumMeans = new Vector<Double>();
            Vector<Double> sumSds = new Vector<Double>();
            if (isGrouped) {
                double totalMean = 0.0;
                Vector<Double> stdevs = new Vector<Double>();
                for (String string4 : valuesToSum_) {
                    ResultCompGroupVO compVO = null;
                    compVO = this.bigConstructor_ ? (ResultCompGroupVO)this.analysisResultsHash_.get(string4).get(string) : (ResultCompGroupVO)this.analysisResultsHash_.get(string).get(string4);
                    Vector<Double> valuesForMean = new Vector<Double>();
                    int isotopes = this.extractCorrectIsotopesSetting(maxIsotope, settingVO, "", compVO);
                    for (String origExpName : compVO.getGroupingPartners().keySet()) {
                        ResultCompVO groupVO = compVO.getGroupingPartners().get(origExpName);
                        groupVO.setSumValueForPercentage((Vector)hashtable.get(origExpName));
                        ResultDisplaySettingsVO newVO = new ResultDisplaySettingsVO(settingVO);
                        newVO.setPercent(true);
                        newVO.setDivisorMagnitude("");
                        double ratio = groupVO.getRatioToPercentualValue(groupVO.getAvailableIsotopeNr(isotopes), newVO);
                        if (!(ratio > 0.0) || Double.isNaN(ratio) || Double.isInfinite(ratio)) continue;
                        valuesForMean.add(ratio);
                    }
                    double mean = Calculator.mean(valuesForMean);
                    double stdev = Calculator.stddeviation(valuesForMean);
                    if (!(mean > 0.0) || Double.isNaN(mean) || Double.isInfinite(mean)) continue;
                    totalMean += mean;
                    stdevs.add(stdev);
                }
                totalStd = Calculator.calculateSumStdevErrorPropagated(stdevs);
                for (int i = 0; i != this.maximumIsotopes_; ++i) {
                    sumMeans.add(totalMean);
                    sumSds.add(totalStd);
                }
            }
            for (String string5 : valuesToSum_) {
                ResultCompVO compVO = null;
                compVO = this.bigConstructor_ ? this.analysisResultsHash_.get(string5).get(string) : this.analysisResultsHash_.get(string).get(string5);
                compVO.setSumValueForPercentage(sumAreas);
                if (!isGrouped) continue;
                ((ResultCompGroupVO)compVO).setSumValueForPercentage(sumAreas);
                ((ResultCompGroupVO)compVO).setSumPercentualMeans(sumMeans);
                ((ResultCompGroupVO)compVO).setSumPercentualSds(sumSds);
                Hashtable<String, ResultCompVO> hashes = ((ResultCompGroupVO)compVO).getGroupingPartners();
                for (String origExp : hashes.keySet()) {
                    ResultCompVO groupVO = hashes.get(origExp);
                    groupVO.setSumValueForPercentage((Vector)hashtable.get(origExp));
                }
            }
        }
    }

    private String getStandardName(Hashtable<String, Integer> hash, int isMethod) {
        String standName = "";
        for (String oneStandName : hash.keySet()) {
            if (isMethod != hash.get(oneStandName)) continue;
            return oneStandName;
        }
        return standName;
    }

    private void addEmptyItemToChooser() {
        this.magnitudeChooser_.addItem("    ");
    }

    private void enableMagnitudeChooser() {
        this.magnitudeChooser_.removeAllItems();
        if (((String)this.quantType_.getSelectedItem()).equalsIgnoreCase("absolute quantity")) {
            if (this.preferredUnit_.equalsIgnoreCase("") || this.preferredUnit_.equalsIgnoreCase("m") || this.preferredUnit_.equalsIgnoreCase("\u03bc") || this.preferredUnit_.equalsIgnoreCase("n") || this.preferredUnit_.equalsIgnoreCase("p") || this.preferredUnit_.equalsIgnoreCase("f") || this.preferredUnit_.equalsIgnoreCase("a")) {
                this.magnitudeChooser_.addItem("");
                this.magnitudeChooser_.addItem("m");
                this.magnitudeChooser_.addItem("\u03bc");
                this.magnitudeChooser_.addItem("n");
                this.magnitudeChooser_.addItem("p");
                this.magnitudeChooser_.addItem("f");
                this.magnitudeChooser_.addItem("a");
            } else if (this.preferredUnit_.equalsIgnoreCase("%") || this.preferredUnit_.equalsIgnoreCase("\u2030")) {
                this.magnitudeChooser_.addItem("%");
                this.magnitudeChooser_.addItem("\u2030");
            }
            this.magnitudeChooser_.setSelectedItem(this.preferredUnit_);
        }
        this.magnitudeChooser_.setEnabled(true);
    }

    private void disableMagnitudeChooser() {
        this.magnitudeChooser_.removeAllItems();
        this.addEmptyItemToChooser();
        this.magnitudeChooser_.setEnabled(false);
    }

    private class SelectionItemListener
    implements ItemListener {
        private String m_ctrl;

        public SelectionItemListener(String ctrl) {
            this.m_ctrl = ctrl;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.m_ctrl.equalsIgnoreCase("ChangeChart") && e.getStateChange() == 1) {
                BarChartPainter.this.repaintingBarChart_ = true;
                if (((String)BarChartPainter.this.quantType_.getSelectedItem()).equalsIgnoreCase("area absolute")) {
                    BarChartPainter.this.singleSided_.setSelected(true);
                    BarChartPainter.this.singleSided_.setEnabled(false);
                    BarChartPainter.this.doubleSided_.setEnabled(false);
                    BarChartPainter.this.disableMagnitudeChooser();
                    BarChartPainter.this.createPaintingArea();
                }
                if (((String)BarChartPainter.this.quantType_.getSelectedItem()).equalsIgnoreCase("percentual values")) {
                    BarChartPainter.this.singleSided_.setSelected(true);
                    BarChartPainter.this.singleSided_.setEnabled(false);
                    BarChartPainter.this.doubleSided_.setEnabled(false);
                    BarChartPainter.this.disableMagnitudeChooser();
                    BarChartPainter.this.createPaintingArea();
                }
                if (((String)BarChartPainter.this.quantType_.getSelectedItem()).equalsIgnoreCase("area relative to molecule")) {
                    BarChartPainter.this.doubleSided_.setSelected(true);
                    BarChartPainter.this.singleSided_.setEnabled(true);
                    BarChartPainter.this.doubleSided_.setEnabled(true);
                    BarChartPainter.this.disableMagnitudeChooser();
                    BarChartPainter.this.createPaintingArea();
                }
                if (((String)BarChartPainter.this.quantType_.getSelectedItem()).equalsIgnoreCase("area relative to standard")) {
                    BarChartPainter.this.doubleSided_.setSelected(true);
                    BarChartPainter.this.singleSided_.setEnabled(true);
                    BarChartPainter.this.doubleSided_.setEnabled(true);
                    BarChartPainter.this.disableMagnitudeChooser();
                    BarChartPainter.this.createPaintingArea();
                }
                if (((String)BarChartPainter.this.quantType_.getSelectedItem()).equalsIgnoreCase("absolute quantity")) {
                    BarChartPainter.this.singleSided_.setSelected(true);
                    BarChartPainter.this.singleSided_.setEnabled(false);
                    BarChartPainter.this.doubleSided_.setEnabled(false);
                    BarChartPainter.this.enableMagnitudeChooser();
                    BarChartPainter.this.createPaintingArea();
                }
                BarChartPainter.this.repaintingBarChart_ = false;
            }
            if (this.m_ctrl.equalsIgnoreCase("ChangeSided") || this.m_ctrl.equalsIgnoreCase("ChangeLog") || this.m_ctrl.equalsIgnoreCase("ChangeMedian")) {
                if (this.m_ctrl.equalsIgnoreCase("ChangeSided")) {
                    if (BarChartPainter.this.singleSided_.isSelected()) {
                        BarChartPainter.this.logarithmicScale_.setText("logarithmic");
                        BarChartPainter.this.logarithmicScale_.setToolTipText("<html>Paints the values in logarithmic scale.</html>");
                        BarChartPainter.this.normalScale_.setText("linear");
                        BarChartPainter.this.normalScale_.setToolTipText("<html>Paints the values in linear scale.</html>");
                    } else {
                        BarChartPainter.this.logarithmicScale_.setText("log10");
                        BarChartPainter.this.logarithmicScale_.setToolTipText("<html>Paints the values in decadic logarithm.</html>");
                        BarChartPainter.this.normalScale_.setText("log2");
                        BarChartPainter.this.normalScale_.setToolTipText("<html>Paints the values in binary scale.</html>");
                    }
                }
                if (!BarChartPainter.this.repaintingBarChart_ && e.getStateChange() == 1) {
                    BarChartPainter.this.createPaintingArea();
                }
            }
            if (this.m_ctrl.equalsIgnoreCase("ChangeSD") && e.getStateChange() == 1) {
                if (BarChartPainter.this.standardDeviation_.isSelected()) {
                    BarChartPainter.this.multStandardDeviation_.setEnabled(true);
                } else {
                    BarChartPainter.this.multStandardDeviation_.setEnabled(false);
                }
                BarChartPainter.this.createPaintingArea();
            }
            if (this.m_ctrl.equalsIgnoreCase("ChangeIsotope") && e.getStateChange() == 1) {
                BarChartPainter.this.createPaintingArea();
            }
            if (this.m_ctrl.equalsIgnoreCase("ChangeMagnitude") && !BarChartPainter.this.repaintingBarChart_) {
                BarChartPainter.this.createPaintingArea();
            }
        }
    }

    private class SDFocusListener
    implements FocusListener {
        private SDFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            BarChartPainter.this.createPaintingArea();
        }
    }

    private class DoubleVerifier
    extends InputVerifier {
        private DoubleVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            return BarChartPainter.this.verifySDFactInput();
        }
    }

    private class ReturnKeyListener
    implements KeyListener {
        private ReturnKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && BarChartPainter.this.verifySDFactInput()) {
                BarChartPainter.this.createPaintingArea();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

