/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class MSnNamingVO {
    private int status_;
    private String ms1Name_;
    private Set<String> faNames_;
    private Set<String> positionNames_;
    private Set<String> rts_;
    private float higherLevelStop_;
    private float higherLevelStart_;
    private Range mergingRange_;
    private float mergingTime_;

    public MSnNamingVO(LipidomicsMSnSet set, float mergingTime) throws LipidCombinameEncodingException {
        this(set.getNameStringWithoutRt(), set.getMSnIdentificationNames(), set.getStatus(), set.getRt(), mergingTime);
    }

    public MSnNamingVO(String ms1Name, Vector<Object> nameObject, int status, String rt, float mergingTime) {
        this.status_ = status;
        this.mergingTime_ = mergingTime;
        this.higherLevelStop_ = Float.MAX_VALUE;
        this.higherLevelStart_ = 0.0f;
        this.rts_ = new HashSet<String>();
        this.addPermanentRt(rt);
        this.ms1Name_ = ms1Name;
        this.faNames_ = new HashSet<String>();
        this.positionNames_ = new HashSet<String>();
        if (this.status_ > 2) {
            for (Object names : nameObject) {
                if (names instanceof Vector) {
                    for (String name : (Vector)names) {
                        this.positionNames_.add(name);
                        this.detectAllPotentialFaCombinations(name);
                    }
                    continue;
                }
                String name = (String)names;
                if (this.status_ == 4 && name.indexOf("/") != -1) {
                    this.positionNames_.add(name);
                }
                this.detectAllPotentialFaCombinations(name);
            }
        }
    }

    private void detectAllPotentialFaCombinations(String name) {
        String nm = name.replaceAll("/", "_");
        String[] faArray = nm.split("_");
        Vector<String> fas = new Vector<String>();
        for (String fa : faArray) {
            fas.add(fa);
        }
        this.faNames_.addAll(StaticUtils.getPermutedChainNames(fas, "_"));
    }

    private void addPermanentRt(String rt) {
        this.rts_.add(rt);
        this.calculateInfluenceRange();
    }

    private void calculateInfluenceRange() {
        float stop;
        float lowestRt = Float.MAX_VALUE;
        float highestRt = 0.0f;
        for (String rtString : this.rts_) {
            float rTime = Float.parseFloat(rtString);
            if (rTime < lowestRt) {
                lowestRt = rTime;
            }
            if (!(rTime > highestRt)) continue;
            highestRt = rTime;
        }
        float start = lowestRt - this.mergingTime_;
        if (this.higherLevelStart_ > start) {
            start = this.higherLevelStart_;
        }
        if (this.higherLevelStop_ < (stop = highestRt + this.mergingTime_)) {
            stop = this.higherLevelStop_;
        }
        this.mergingRange_ = new Range(start, stop);
    }

    public int getStatus() {
        return this.status_;
    }

    public boolean insideRange(MSnNamingVO other) {
        boolean insideRange = false;
        for (String rtString : other.rts_) {
            if (!this.insideRange(Float.parseFloat(rtString))) continue;
            insideRange = true;
            break;
        }
        return insideRange;
    }

    public boolean insideRange(float rt) {
        return this.mergingRange_.insideRange(rt);
    }

    public boolean hasSameEvidence(int status, MSnNamingVO other) {
        if (status == 4) {
            for (String name : this.positionNames_) {
                for (String otherName : other.positionNames_) {
                    if (!name.equalsIgnoreCase(otherName)) continue;
                    return true;
                }
            }
        } else if (status == 3) {
            for (String name : this.faNames_) {
                for (String otherName : other.faNames_) {
                    if (!name.equalsIgnoreCase(otherName)) continue;
                    return true;
                }
            }
        } else if (status == 2 && this.ms1Name_.equalsIgnoreCase(other.ms1Name_)) {
            return true;
        }
        return false;
    }

    public void mergeWithOther(MSnNamingVO other) {
        Range thisRange = this.getRtHardRange();
        Range otherRange = other.getRtHardRange();
        if (thisRange.getStart() < otherRange.getStart()) {
            if (other.higherLevelStop_ < this.higherLevelStop_) {
                this.higherLevelStop_ = other.higherLevelStop_;
            }
        } else if (other.higherLevelStart_ > this.higherLevelStart_) {
            this.higherLevelStart_ = other.higherLevelStart_;
        }
        for (String rt : other.rts_) {
            this.addPermanentRt(rt);
        }
        this.positionNames_.addAll(other.positionNames_);
        this.faNames_.addAll(other.faNames_);
    }

    public boolean insideCombinedRtRange(MSnNamingVO other) {
        if (this.rts_.size() < 2) {
            return false;
        }
        Range range = this.getRtHardRange();
        for (String rtString : other.rts_) {
            float rt = Float.parseFloat(rtString);
            if (!range.insideRange(rt)) continue;
            return true;
        }
        return false;
    }

    public float absoluteDistanceToHardRange(float rt) {
        Range range = this.getRtHardRange();
        if (range.insideRange(rt)) {
            return 0.0f;
        }
        if (rt < range.getStart()) {
            return range.getStart() - rt;
        }
        return rt - range.getStop();
    }

    private Range getRtHardRange() {
        float start = Float.MAX_VALUE;
        float stop = 0.0f;
        for (String rtString : this.rts_) {
            float rt = Float.parseFloat(rtString);
            if (rt < start) {
                start = rt;
            }
            if (!(rt > stop)) continue;
            stop = rt;
        }
        Range range = new Range(start, stop);
        return range;
    }

    public void setHigherLevelLimits(MSnNamingVO other) {
        Range thisRange = this.getRtHardRange();
        Range otherRange = other.getRtHardRange();
        if (thisRange.getStart() < otherRange.getStart()) {
            float border;
            this.higherLevelStop_ = border = (thisRange.getStop() + otherRange.getStart()) / 2.0f;
            other.higherLevelStart_ = border;
            this.calculateInfluenceRange();
            other.calculateInfluenceRange();
        } else {
            float border;
            this.higherLevelStart_ = border = (otherRange.getStop() + thisRange.getStart()) / 2.0f;
            other.higherLevelStop_ = border;
            this.calculateInfluenceRange();
            other.calculateInfluenceRange();
        }
    }

    public String getMs1Name() {
        return this.ms1Name_;
    }

    public String toString() {
        String result = "Range: " + this.mergingRange_.getStart() + "-" + this.mergingRange_.getStop() + "\n";
        for (String rt : this.rts_) {
            result = result + rt + "\n";
        }
        return result;
    }
}

