/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.RuleHydroxyRequirementSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ShortStringVO;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import at.tugraz.genome.maspectras.parser.spectrummill.vos.SmChemicalElementVO;
import java.util.Hashtable;
import java.util.Vector;

public class FragmentRuleVO {
    public static final String PRECURSOR_NAME = "$PRECURSOR";
    public static final String CHAIN_NAME = "$CHAIN";
    public static final String ALKYL_CHAIN_NAME = "$ALKYLCHAIN";
    public static final String ALKENYL_CHAIN_NAME = "$ALKENYLCHAIN";
    public static final String LCB_NAME = "$LCB";
    private static final int NO_FRAGMENT = 0;
    private static final int ADD_FRAGMENT = 1;
    private static final int MINUS_FRAGMENT = -1;
    public static final short MANDATORY_UNDEFINED = -1;
    public static final short MANDATORY_FALSE = 0;
    public static final short MANDATORY_TRUE = 1;
    public static final short MANDATORY_OTHER = 2;
    public static final short MANDATORY_QUANT = 3;
    public static final short MANDATORY_CLASS = 4;
    private String name_;
    private int charge_;
    private int msLevel_;
    private short mandatory_;
    private boolean containsPrecursor_;
    private int chainAction_;
    private short chainType_;
    private Hashtable<String, Integer> elementAmounts_;
    private String formula_;
    private RuleHydroxyRequirementSet allowedOHs_;
    private RuleHydroxyRequirementSet combiOHs_;
    private Hashtable<String, SmChemicalElementVO> elementDetails_;
    private Vector<String> selfDefinedParts_;

    public FragmentRuleVO(String name, String formula, int charge, int msLevel, short mandatory, Hashtable<String, FragmentRuleVO> headFragments, Hashtable<String, FragmentRuleVO> chainFragments, ElementConfigParser elementParser) throws RulesException {
        this(name, formula, charge, msLevel, mandatory, null, null, headFragments, chainFragments, elementParser);
    }

    public FragmentRuleVO(String name, String formula, int charge, int msLevel, short mandatory, RuleHydroxyRequirementSet allowedOHs, RuleHydroxyRequirementSet combiOHs, Hashtable<String, FragmentRuleVO> headFragments, Hashtable<String, FragmentRuleVO> chainFragments, ElementConfigParser elementParser) throws RulesException {
        this.name_ = name;
        this.charge_ = charge;
        this.msLevel_ = msLevel;
        this.mandatory_ = mandatory;
        this.formula_ = formula;
        this.chainType_ = (short)-1;
        this.allowedOHs_ = allowedOHs;
        this.combiOHs_ = combiOHs;
        if (charge < 1) {
            throw new RulesException("The charge state of an analyte must be greater or equal 1");
        }
        this.categorizeFormula(formula, headFragments, chainFragments, elementParser);
    }

    public String getFormula() {
        return this.formula_;
    }

    public String getName() {
        return this.name_;
    }

    public int getCharge() {
        return this.charge_;
    }

    public int getMsLevel() {
        return this.msLevel_;
    }

    public short isMandatory(short ohNumber) {
        if (ohNumber == -1 || this.allowedOHs_ == null) {
            return this.mandatory_;
        }
        return this.allowedOHs_.getEntry(ohNumber).get(0).getMandatory();
    }

    public boolean hasCombiOhRequirements() {
        return this.combiOHs_ != null;
    }

    public short isMandatoryInCombi(short chainType, short ohNumber) {
        short mand = -1;
        if (this.combiOHs_ != null && this.combiOHs_.hasEntry(ohNumber)) {
            mand = this.combiOHs_.getMandatory(chainType, ohNumber);
        }
        return mand;
    }

    public short isMandatory() {
        return this.mandatory_;
    }

    private void categorizeFormula(String formula, Hashtable<String, FragmentRuleVO> headFragments, Hashtable<String, FragmentRuleVO> chainFragments, ElementConfigParser elementParser) throws RulesException {
        this.elementAmounts_ = new Hashtable();
        this.elementDetails_ = new Hashtable();
        String form = new String(formula);
        Object[] result = FragmentRuleVO.containsPrecursor(form);
        form = (String)result[1];
        this.containsPrecursor_ = (Boolean)result[0];
        result = FragmentRuleVO.containsChain(form);
        form = (String)result[1];
        this.chainAction_ = (Integer)result[0];
        this.chainType_ = ((Integer)result[2]).shortValue();
        result = FragmentRuleVO.containsSelfDefinedFragments(form, FragmentRuleVO.getStringKeyHash(headFragments), FragmentRuleVO.getStringKeyHash(chainFragments));
        this.selfDefinedParts_ = (Vector)result[0];
        Vector plusOrMinus = (Vector)result[1];
        for (int i = 0; i != this.selfDefinedParts_.size(); ++i) {
            String selfDefinedName = this.selfDefinedParts_.get(i);
            FragmentRuleVO ruleVO = null;
            if (headFragments.containsKey(selfDefinedName)) {
                ruleVO = headFragments.get(selfDefinedName);
            } else if (chainFragments.containsKey(selfDefinedName)) {
                ruleVO = chainFragments.get(selfDefinedName);
            }
            int ruleActivity = (Integer)plusOrMinus.get(i);
            if (ruleVO.containsPrecursor_) {
                this.containsPrecursor_ = true;
            }
            if (chainFragments.containsKey(selfDefinedName)) {
                this.chainType_ = ruleVO.getChainType();
            }
            this.chainAction_ += ruleActivity * ruleVO.chainAction_;
            for (String element : ruleVO.elementAmounts_.keySet()) {
                int elementAmount = 0;
                if (this.elementAmounts_.containsKey(element)) {
                    elementAmount = this.elementAmounts_.get(element);
                } else {
                    this.elementDetails_.put(element, ruleVO.elementDetails_.get(element));
                }
                this.elementAmounts_.put(element, elementAmount += ruleActivity * ruleVO.elementAmounts_.get(element));
            }
        }
        form = (String)result[2];
        try {
            Hashtable<String, Integer> elements = StaticUtils.categorizeFormula(form);
            for (String element : elements.keySet()) {
                if (!elementParser.isElementAvailable(element)) {
                    throw new RulesException("The formula " + formula + " contains the element " + element + " that has not been defined in the " + Settings.getElementConfigPath() + "! Please define the element there, in order to use it!");
                }
                int elementAmount = 0;
                if (this.elementAmounts_.containsKey(element)) {
                    elementAmount = this.elementAmounts_.get(element);
                } else {
                    this.elementDetails_.put(element, elementParser.getElementDetails(element));
                }
                this.elementAmounts_.put(element, elementAmount += elements.get(element).intValue());
            }
            if (!this.elementDetails_.containsKey("H")) {
                this.elementDetails_.put("H", elementParser.getElementDetails("H"));
            }
            if (!this.elementDetails_.containsKey("O")) {
                this.elementDetails_.put("O", elementParser.getElementDetails("O"));
            }
        }
        catch (ChemicalFormulaException e) {
            throw new RulesException("The formula " + formula + " contains fragments that have not been defined before! Fragments have to be defined in previous rows, before they can be used!");
        }
    }

    public static void isFormulaValid(String formula, Hashtable<String, FragmentRuleVO> headFragments, Hashtable<String, FragmentRuleVO> chainFragments, ElementConfigParser elementParser) throws RulesException {
        String form = new String(formula);
        Object[] result = FragmentRuleVO.containsPrecursor(form);
        form = (String)result[1];
        result = FragmentRuleVO.containsChain(form);
        form = (String)result[1];
        result = FragmentRuleVO.containsSelfDefinedFragments(form, FragmentRuleVO.getStringKeyHash(headFragments), FragmentRuleVO.getStringKeyHash(chainFragments));
        form = (String)result[2];
        try {
            Hashtable<String, Integer> elements = StaticUtils.categorizeFormula(form);
            for (String element : elements.keySet()) {
                if (elementParser.isElementAvailable(element)) continue;
                throw new RulesException("The formula " + formula + " contains the element " + element + " that has not been defined in the " + Settings.getElementConfigPath() + "! Please define the element there, in order to use it!");
            }
        }
        catch (ChemicalFormulaException e) {
            throw new RulesException("The formula " + formula + " contains fragments that have not been defined before! Fragments have to be defined in previous columns, before they can be used!");
        }
    }

    private static Object[] containsPrecursor(String formula) throws RulesException {
        boolean precursorThere = false;
        if (formula.indexOf(PRECURSOR_NAME) != -1) {
            int startIndex = formula.indexOf(PRECURSOR_NAME);
            int stopIndex = startIndex + PRECURSOR_NAME.length();
            if (startIndex != 0 && !formula.substring(--startIndex, startIndex + 1).equalsIgnoreCase("+")) {
                throw new RulesException("Only a \"+\" can be before a $PRECURSOR in a formula!");
            }
            formula = formula.substring(0, startIndex) + formula.substring(stopIndex, formula.length());
            precursorThere = true;
        }
        Object[] result = new Object[]{precursorThere, formula};
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object[] containsChain(String formula) throws RulesException {
        int chainProcedure = 0;
        int chainType = -1;
        if (formula.indexOf(CHAIN_NAME) != -1 || formula.indexOf(ALKYL_CHAIN_NAME) != -1 || formula.indexOf(ALKENYL_CHAIN_NAME) != -1 || formula.indexOf(LCB_NAME) != -1) {
            String chainName = CHAIN_NAME;
            chainType = 0;
            if (formula.indexOf(ALKYL_CHAIN_NAME) != -1) {
                chainName = ALKYL_CHAIN_NAME;
                chainType = 1;
            } else if (formula.indexOf(ALKENYL_CHAIN_NAME) != -1) {
                chainName = ALKENYL_CHAIN_NAME;
                chainType = 2;
            } else if (formula.indexOf(LCB_NAME) != -1) {
                chainName = LCB_NAME;
                chainType = 3;
            }
            int startIndex = formula.indexOf(chainName);
            int stopIndex = startIndex + chainName.length();
            if (startIndex != 0) {
                String sign;
                if ((sign = formula.substring(--startIndex, startIndex + 1)).equalsIgnoreCase("+")) {
                    chainProcedure = 1;
                } else {
                    if (!sign.equalsIgnoreCase("-")) throw new RulesException("Only a \"+\" or a \"-\" can be before a " + chainName + " in a formula");
                    chainProcedure = -1;
                }
            } else {
                chainProcedure = 1;
            }
            formula = formula.substring(0, startIndex) + formula.substring(stopIndex, formula.length());
        }
        Object[] result = new Object[]{chainProcedure, formula, chainType};
        return result;
    }

    public static Hashtable<String, Short> getStringKeyHash(Hashtable<String, FragmentRuleVO> fragHash) {
        Hashtable<String, Short> hash = new Hashtable<String, Short>();
        for (String key : fragHash.keySet()) {
            hash.put(key, fragHash.get(key).getChainType());
        }
        return hash;
    }

    private static Object[] containsSelfDefinedFragments(String formula, Hashtable<String, Short> headFragments, Hashtable<String, Short> chainFragments) throws RulesException {
        Vector<String> selfDefinedParts = new Vector<String>();
        Vector<Integer> plusOrMinus = new Vector<Integer>();
        Vector<ShortStringVO> lengthSortedFragmentNames = FragmentRuleVO.getLengthSortedFragmentNames(headFragments, chainFragments);
        for (ShortStringVO name : lengthSortedFragmentNames) {
            Object[] result;
            Integer fragmentAction;
            String fragmentName = name.getKey();
            if (Settings.getElementParser().isElementAvailable(fragmentName)) {
                fragmentName = "$" + fragmentName;
            }
            if ((fragmentAction = (Integer)(result = FragmentRuleVO.checkSelfDefinedFragment(formula, fragmentName))[0]) == 0) continue;
            selfDefinedParts.add(name.getKey());
            plusOrMinus.add(fragmentAction);
            formula = (String)result[1];
        }
        Object[] result = new Object[]{selfDefinedParts, plusOrMinus, formula};
        return result;
    }

    public static Vector<ShortStringVO> getLengthSortedFragmentNames(Hashtable<String, Short> headFragments, Hashtable<String, Short> chainFragments) {
        return FragmentRuleVO.getLengthSortedFragmentNames(headFragments, chainFragments, null);
    }

    public static Vector<ShortStringVO> getLengthSortedFragmentNames(Hashtable<String, Short> headFragments, Hashtable<String, Short> chainFragments, Hashtable<String, Short> missed) {
        int i;
        boolean fragmentAdded;
        Vector<ShortStringVO> lengthSortedFragmentNames = new Vector<ShortStringVO>();
        for (String name : headFragments.keySet()) {
            fragmentAdded = false;
            for (i = 0; i != lengthSortedFragmentNames.size(); ++i) {
                if (name.length() <= lengthSortedFragmentNames.get(i).getKey().length()) continue;
                lengthSortedFragmentNames.add(i, new ShortStringVO(name, headFragments.get(name)));
                fragmentAdded = true;
                break;
            }
            if (fragmentAdded) continue;
            lengthSortedFragmentNames.add(new ShortStringVO(name, headFragments.get(name)));
        }
        for (String name : chainFragments.keySet()) {
            fragmentAdded = false;
            for (i = 0; i != lengthSortedFragmentNames.size(); ++i) {
                if (name.length() <= lengthSortedFragmentNames.get(i).getKey().length()) continue;
                lengthSortedFragmentNames.add(i, new ShortStringVO(name, chainFragments.get(name)));
                fragmentAdded = true;
                break;
            }
            if (fragmentAdded) continue;
            lengthSortedFragmentNames.add(new ShortStringVO(name, chainFragments.get(name)));
        }
        if (missed != null) {
            for (String name : missed.keySet()) {
                String nm = new String(name);
                if (nm.indexOf("[") != -1) {
                    nm = nm.substring(0, nm.indexOf("["));
                }
                boolean fragmentAdded2 = false;
                for (int i2 = 0; i2 != lengthSortedFragmentNames.size(); ++i2) {
                    if (nm.length() <= lengthSortedFragmentNames.get(i2).getKey().length()) continue;
                    lengthSortedFragmentNames.add(i2, new ShortStringVO(nm, missed.get(name)));
                    fragmentAdded2 = true;
                    break;
                }
                if (fragmentAdded2) continue;
                lengthSortedFragmentNames.add(new ShortStringVO(nm, missed.get(name)));
            }
        }
        return lengthSortedFragmentNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object[] checkSelfDefinedFragment(String formula, String fragment) throws RulesException {
        int fragmentAction = 0;
        if (formula.indexOf(fragment) != -1) {
            int startIndex = formula.indexOf(fragment);
            int stopIndex = startIndex + fragment.length();
            if (startIndex != 0) {
                String sign;
                if ((sign = formula.substring(--startIndex, startIndex + 1)).equalsIgnoreCase("+")) {
                    fragmentAction = 1;
                } else {
                    if (!sign.equalsIgnoreCase("-")) throw new RulesException("Only a \"+\" or a \"-\" can be before the self-defined fragment \"" + fragment + "\" in a formula!");
                    fragmentAction = -1;
                }
            } else {
                fragmentAction = 1;
            }
            formula = formula.substring(0, startIndex) + formula.substring(stopIndex, formula.length());
        }
        Object[] result = new Object[]{fragmentAction, formula};
        return result;
    }

    public String toString() {
        String toPrint = "Name: " + this.name_;
        toPrint = toPrint + "; Charge: " + this.charge_;
        toPrint = toPrint + "; MS: " + this.msLevel_;
        toPrint = toPrint + "; Mand: " + this.mandatory_;
        toPrint = toPrint + "; Formula: ";
        if (this.containsPrecursor_) {
            toPrint = toPrint + "+$PRECURSOR ";
        }
        if (this.chainAction_ == 1) {
            toPrint = toPrint + "+";
        } else if (this.chainAction_ == -1) {
            toPrint = toPrint + "-";
        }
        if (this.chainAction_ != 0) {
            if (this.chainType_ == 0) {
                toPrint = toPrint + "$CHAIN ";
            } else if (this.chainType_ == 1) {
                toPrint = toPrint + "$ALKYLCHAIN ";
            } else if (this.chainType_ == 2) {
                toPrint = toPrint + "$ALKENYLCHAIN ";
            } else if (this.chainType_ == 3) {
                toPrint = toPrint + "$LCB ";
            }
        }
        for (String element : this.elementAmounts_.keySet()) {
            if (this.elementAmounts_.get(element) > 0) {
                toPrint = toPrint + "+";
            } else if (this.elementAmounts_.get(element) < 0) {
                toPrint = toPrint + "-";
            }
            if (this.elementAmounts_.get(element) == 0) continue;
            toPrint = toPrint + element + Math.abs(this.elementAmounts_.get(element)) + " ";
        }
        if (toPrint.length() > 1) {
            toPrint = toPrint.substring(0, toPrint.length() - 1);
        }
        return toPrint;
    }

    public Vector<Object> getFormulaAndMass(String precursorFormula, double precursorMass, FattyAcidVO vo, int charge) throws RulesException {
        FattyAcidVO fa = vo;
        return this.getFormulaAndMz(precursorFormula, precursorMass, fa.getFormula(), fa.getMass(), charge);
    }

    public Vector<Object> getFormulaAndMz(String precursorFormula, double precursorMass, String chainFormula, double chainMass, int charge) throws RulesException {
        Vector<Object> formulaAndMass = new Vector<Object>();
        String formula = "";
        Double mass = 0.0;
        Hashtable<Object, Object> formulaAmounts = new Hashtable();
        if (this.containsPrecursor_) {
            mass = precursorMass;
            try {
                formulaAmounts = StaticUtils.categorizeFormula(precursorFormula);
            }
            catch (ChemicalFormulaException e) {
                throw new RulesException("The formula " + precursorFormula + " contains fragments that have not been defined before! Fragments have to be defined in previous columns, before they can be used!");
            }
        }
        if (this.chainAction_ != 0) {
            Hashtable<String, Integer> chainAmounts = null;
            try {
                chainAmounts = StaticUtils.categorizeFormula(chainFormula);
            }
            catch (ChemicalFormulaException chemicalFormulaException) {
                throw new RulesException("The formula " + chainFormula + " contains fragments that have not been defined before! Fragments have to be defined in previous columns, before they can be used!");
            }
            double d = chainMass;
            if (this.chainAction_ == 1) {
                mass = mass + d;
            } else if (this.chainAction_ == -1) {
                mass = mass - d;
            }
            for (String element : chainAmounts.keySet()) {
                int amount = 0;
                if (formulaAmounts.containsKey(element)) {
                    amount = (Integer)formulaAmounts.get(element);
                }
                if (this.chainAction_ == 1) {
                    amount += chainAmounts.get(element).intValue();
                } else if (this.chainAction_ == -1) {
                    amount -= chainAmounts.get(element).intValue();
                }
                formulaAmounts.put(element, amount);
            }
        }
        for (String string : this.elementAmounts_.keySet()) {
            int amount = 0;
            if (formulaAmounts.containsKey(string)) {
                amount = (Integer)formulaAmounts.get(string);
            }
            int elementAmount = this.elementAmounts_.get(string);
            formulaAmounts.put(string, amount += elementAmount);
            mass = mass + (double)elementAmount * this.elementDetails_.get(string).getMonoMass();
        }
        for (String string : formulaAmounts.keySet()) {
            if ((Integer)formulaAmounts.get(string) > 0) {
                formula = formula + "+";
            } else if ((Integer)formulaAmounts.get(string) < 0) {
                formula = formula + "-";
            }
            if ((Integer)formulaAmounts.get(string) == 0) continue;
            formula = formula + string + Math.abs((Integer)formulaAmounts.get(string)) + " ";
        }
        formulaAndMass.add(formula);
        formulaAndMass.add(mass / (double)charge);
        return formulaAndMass;
    }

    public short getChainType() {
        return this.chainType_;
    }

    public boolean containsOnlyAllowedFragments(Hashtable<String, FragmentRuleVO> allowedRules) {
        boolean containsOnlyAllowed = true;
        for (String fragment : this.selfDefinedParts_) {
            if (allowedRules.containsKey(fragment)) continue;
            containsOnlyAllowed = false;
            break;
        }
        return containsOnlyAllowed;
    }

    public boolean hydroxylationValid(short ohNumber) {
        if (ohNumber == -1 || this.allowedOHs_ == null) {
            return true;
        }
        return this.allowedOHs_.hasEntry(ohNumber);
    }
}

