/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.Comparator;
import java.util.Objects;

public class FattyAcidVO
implements Comparable<FattyAcidVO> {
    private short chainType_;
    private String prefix_;
    private int cAtoms_;
    private int doubleBonds_;
    private double mass_;
    private String formula_;
    private int ohNumber_;
    private int omegaPosition_;
    private String oxState_;

    public FattyAcidVO(short chainType, String prefix, int cAtoms, int doubleBonds, int ohNumber, double mass, String formula, String oxState) {
        this.chainType_ = chainType;
        this.prefix_ = prefix;
        this.cAtoms_ = cAtoms;
        this.doubleBonds_ = doubleBonds;
        this.ohNumber_ = ohNumber;
        this.mass_ = mass;
        this.formula_ = formula;
        this.omegaPosition_ = -1;
        this.oxState_ = oxState;
    }

    public FattyAcidVO(FattyAcidVO other) {
        this(other.getChainType(), other.getPrefix(), other.getcAtoms(), other.getDoubleBonds(), other.getOhNumber(), other.getMass(), other.getFormula(), other.getOxState());
        this.setOmegaPosition(other.getOmegaPosition());
    }

    public short getChainType() {
        return this.chainType_;
    }

    public void correctChainType(short chainType) {
        this.chainType_ = chainType;
    }

    public String getPrefix() {
        return this.prefix_;
    }

    public void setPrefix(String prefix) {
        this.prefix_ = prefix;
    }

    public int getcAtoms() {
        return this.cAtoms_;
    }

    public int getDoubleBonds() {
        return this.doubleBonds_;
    }

    public int getOhNumber() {
        return this.ohNumber_;
    }

    public double getMass() {
        return this.mass_;
    }

    public String getFormula() {
        return this.formula_;
    }

    public void setFormula(String formula) {
        this.formula_ = formula;
    }

    public int getOmegaPosition() {
        return this.omegaPosition_;
    }

    public void setOmegaPosition(int omegaPosition) {
        this.omegaPosition_ = omegaPosition;
    }

    public String getOxState() {
        return this.oxState_;
    }

    public String getCarbonDbsId() {
        return StaticUtils.generateLipidNameString(this.prefix_ + String.valueOf(this.cAtoms_), (Integer)this.doubleBonds_, this.omegaPosition_, this.oxState_);
    }

    public String getChainId() {
        return this.getChainIdDetailed(true, true);
    }

    public String getChainIdDetailed(boolean includePrefix, boolean includeOmegaPosition) {
        return StaticUtils.encodeLipidNameForCreatingCombis(this, includePrefix, includeOmegaPosition);
    }

    public String toString() {
        return "Name: " + this.getChainId() + " Mass: " + this.mass_ + " Formula: " + this.formula_;
    }

    public int hashCode() {
        return Objects.hash(this.cAtoms_, this.chainType_, this.doubleBonds_, this.formula_, this.mass_, this.ohNumber_, this.omegaPosition_, this.oxState_, this.prefix_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FattyAcidVO other = (FattyAcidVO)obj;
        return this.cAtoms_ == other.cAtoms_ && this.chainType_ == other.chainType_ && this.doubleBonds_ == other.doubleBonds_ && Objects.equals(this.formula_, other.formula_) && Double.doubleToLongBits(this.mass_) == Double.doubleToLongBits(other.mass_) && this.ohNumber_ == other.ohNumber_ && this.omegaPosition_ == other.omegaPosition_ && Objects.equals(this.prefix_, other.prefix_);
    }

    public boolean equalsNotConsideringOmegaPosition(FattyAcidVO other) {
        return this.cAtoms_ == other.cAtoms_ && this.chainType_ == other.chainType_ && this.doubleBonds_ == other.doubleBonds_ && Objects.equals(this.formula_, other.formula_) && Double.doubleToLongBits(this.mass_) == Double.doubleToLongBits(other.mass_) && this.ohNumber_ == other.ohNumber_ && Objects.equals(this.prefix_, other.prefix_);
    }

    @Override
    public int compareTo(FattyAcidVO other) {
        return Comparator.comparing(FattyAcidVO::getChainType).reversed().thenComparing(FattyAcidVO::getcAtoms).thenComparing(FattyAcidVO::getDoubleBonds).thenComparing(FattyAcidVO::getOhNumber).thenComparing(FattyAcidVO::getOmegaPosition).thenComparing(FattyAcidVO::getPrefix).thenComparing(FattyAcidVO::getOxState).compare(this, other);
    }
}

