/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.parser;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.vos.ExpressionForComparisonVO;
import at.tugraz.genome.lda.msn.vos.FragmentMultVO;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.msn.vos.RuleHydroxyRequirementSet;
import at.tugraz.genome.lda.msn.vos.RuleHydroxyRequirementsVO;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ShortStringVO;
import at.tugraz.genome.lda.vos.rdi.GeneralSettingsVO;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FragRuleParser {
    boolean foundGeneral_;
    boolean foundHead_;
    boolean foundChains_;
    boolean foundPosition_;
    private static final int NO_SECTION = 0;
    private static final int GENERAL_SECTION = 1;
    public static final int HEAD_SECTION = 2;
    public static final int CHAINS_SECTION = 3;
    public static final int POSITION_SECTION = 4;
    private static final int FRAGMENT_SUBSECTION = 1;
    private static final int INTENSITY_SUBSECTION = 2;
    private static final String GENERAL_SECTION_NAME = "[GENERAL]";
    private static final String HEAD_SECTION_NAME = "[HEAD]";
    private static final String CHAINS_SECTION_NAME = "[CHAINS]";
    private static final String POSITION_SECTION_NAME = "[POSITION]";
    private static final String FRAGMENT_SUBSECTION_NAME = "!FRAGMENTS";
    private static final String INTENSITY_SUBSECTION_NAME = "!INTENSITIES";
    private static final String GENERAL_CHAINS = "AmountOfChains";
    private static final String GENERAL_MS2_LIB = "ChainLibrary";
    public static final String GENERAL_CATOMS_PARSE = "CAtomsFromName";
    public static final String GENERAL_DBOND_PARSE = "DoubleBondsFromName";
    private static final String GENERAL_CUTOFF = "BasePeakCutoff";
    private static final String GENERAL_CHAIN_CUTOFF = "ChainCutoff";
    private static final String GENERAL_CHAIN_ABS_CUTOFF = "ChainFragmentAbsoluteThreshold";
    private static final String GENERAL_SPECTRUM_COVERAGE = "SpectrumCoverage";
    private static final String GENERAL_RT_PROCESSING = "RetentionTimePostprocessing";
    private static final String GENERAL_RT_PARALLEL_SERIES = "RetentionTimeParallelSeries";
    private static final String GENERAL_RT_DEV_MAX = "RetentionTimeMaxDeviation";
    private static final String GENERAL_CHAINS_ALKYL = "AlkylChains";
    private static final String GENERAL_CHAINS_ALKENYL = "AlkenylChains";
    private static final String GENERAL_SINGLE_CHAIN = "SingleChainIdentification";
    private static final String GENERAL_IDENTIFICATION_ORDER = "MSIdentificationOrder";
    private static final String GENERAL_PEAK_UNION_TIME = "EnforcePeakUnionTime";
    private static final String GENERAL_PEAK_UNION_NO_POSITION = "IgnorePositionForUnion";
    private static final String GENERAL_MS1_PEAK_CUTOFF = "ClassSpecificMS1Cutoff";
    private static final String GENERAL_ADD_POSITIONS = "AddChainPositions";
    private static final String GENERAL_ISOBAR_RATIO = "IsobarSCExclusionRatio";
    private static final String GENERAL_ISOBAR_FAR_RATIO = "IsobarSCFarExclusionRatio";
    private static final String GENERAL_ISOBAR_RT = "IsobarRtDiff";
    private static final String GENERAL_OTHER_ADDUCT_REQUIRED = "ValidOnlyWithOtherAdduct";
    private static final String GENERAL_OTHER_ADDUCT_TIME_TOLERANCE = "OtherAdductValidityTolerance";
    private static final String GENERAL_OTHER_ADDUCT_FORCE = "ForceOtherAdductValidity";
    private static final String GENERAL_CHOOSE_MORE_LIKELY_RT_WHEN_EQUAL = "ChooseMoreLikelyRtWhenOtherAdductEqual";
    private static final String GENERAL_LCB_LIB = "LCBLibrary";
    private static final String GENERAL_LCBS = "AmountOfLCBs";
    private static final String GENERAL_FA_HYDROXY_RANGE = "FaHydroxylationRange";
    private static final String GENERAL_LCB_HYDROXY_RANGE = "LcbHydroxylationRange";
    private static final String FRAGMENT_NAME = "Name";
    private static final String FRAGMENT_FORMULA = "Formula";
    private static final String FRAGMENT_CHARGE = "Charge";
    private static final String FRAGMENT_LEVEL = "MSLevel";
    private static final String FRAGMENT_MANDATORY = "mandatory";
    public static final String FRAGMENT_COMBI_HYDROXY = "combiOh";
    public static final String FRAGMENT_HYDROXY = "oh";
    private static final String ORDER_MS1_FIRST = "MS1First";
    private static final String ORDER_MSN_FIRST = "MSnFirst";
    private static final String ORDER_MSN_ONLY = "MSnOnly";
    private static final String INTENSITY_EQUATION = "Equation";
    private Hashtable<String, String> generalSettings_;
    private Hashtable<String, FragmentRuleVO> headFragments_;
    private Hashtable<String, FragmentRuleVO> chainFragments_;
    private Vector<IntensityRuleVO> headIntensities_;
    private Vector<IntensityRuleVO> chainIntensities_;
    private Vector<IntensityRuleVO> positionIntensities_;
    private RangeInteger faHydroxyRange_;
    private RangeInteger lcbHydroxyRange_;
    private Vector<String> otherRequiredAdducts_;
    private boolean allOtherAdductsHaveToBeFound_;
    private ElementConfigParser elementParser_;
    public static final String NO_HEAD_AND_CHAINS_SECTION = "The rules file must contain a [HEAD] or a [CHAINS] section!";
    private static boolean useAlex_ = false;
    private static boolean alexSet_ = false;

    public FragRuleParser(ElementConfigParser elementParser) {
        this.elementParser_ = elementParser;
    }

    public void parseFile(String filePath) throws IOException, RulesException {
        this.parseFile(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(File file) throws IOException, RulesException {
        if (!file.exists()) {
            throw new IOException("The file " + file.getAbsolutePath() + " does not exist!");
        }
        this.initParseableValues();
        this.foundGeneral_ = false;
        this.foundHead_ = false;
        this.foundChains_ = false;
        this.foundPosition_ = false;
        BufferedReader reader = null;
        int currentSection = 0;
        int subSection = 0;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(file));
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
                    subSection = 0;
                    if (line.equalsIgnoreCase(GENERAL_SECTION_NAME)) {
                        this.foundGeneral_ = true;
                        currentSection = 1;
                        continue;
                    }
                    if (line.equalsIgnoreCase(HEAD_SECTION_NAME)) {
                        this.foundHead_ = true;
                        currentSection = 2;
                        continue;
                    }
                    if (line.equalsIgnoreCase(CHAINS_SECTION_NAME)) {
                        this.foundChains_ = true;
                        currentSection = 3;
                        continue;
                    }
                    if (line.equalsIgnoreCase(POSITION_SECTION_NAME)) {
                        this.foundPosition_ = true;
                        currentSection = 4;
                        continue;
                    }
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new RulesException("A section with the name " + line + " is not supported by the fragmentation rules!");
                }
                if (line.startsWith("!")) {
                    if (currentSection == 0) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new RulesException("A subsection cannot start before a section starts! Error at line number " + ((LineNumberReader)reader).getLineNumber() + "!");
                    }
                    if (currentSection == 1) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new RulesException("The [GENERAL] section must not contain any subsections! Error at line number " + ((LineNumberReader)reader).getLineNumber() + "!");
                    }
                    if (line.equalsIgnoreCase(FRAGMENT_SUBSECTION_NAME)) {
                        subSection = 1;
                    } else if (line.equalsIgnoreCase(INTENSITY_SUBSECTION_NAME)) {
                        subSection = 2;
                    } else {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new RulesException("A section with the name " + line + " is not supported by the fragmentation rules! Error at line number " + ((LineNumberReader)reader).getLineNumber() + "!");
                    }
                    if (currentSection != 4 || subSection != 1) continue;
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new RulesException("The section [POSITION] does not support the subsection !FRAGMENTS! Error at line number " + ((LineNumberReader)reader).getLineNumber() + "!");
                }
                if (currentSection == 1) {
                    this.parseGeneralSectionEntry(line, ((LineNumberReader)reader).getLineNumber());
                    continue;
                }
                if (subSection == 1) {
                    this.parseFragmentEntry(line, ((LineNumberReader)reader).getLineNumber(), currentSection);
                    continue;
                }
                if (subSection != 2) continue;
                this.parseIntensityEntry(line, ((LineNumberReader)reader).getLineNumber(), currentSection);
            }
            if (!this.foundGeneral_) {
                throw new RulesException("The rules file does not contain the mandatory [GENERAL] section!");
            }
            if (this.generalSettings_.containsKey(GENERAL_LCBS) && Integer.parseInt(this.generalSettings_.get(GENERAL_LCBS)) > 1) {
                if (!this.generalSettings_.containsKey(GENERAL_LCB_LIB)) {
                    throw new RulesException("A rule file that has more than one \"AmountOfLCBs\", must define a \"LCBLibrary\"!");
                }
                if (this.lcbHydroxyRange_ == null) {
                    throw new RulesException("A rule file that has more than one \"AmountOfLCBs\", must define a \"LcbHydroxylationRange\"!");
                }
            }
            if (this.otherRequiredAdducts_ != null && !this.generalSettings_.containsKey(GENERAL_OTHER_ADDUCT_TIME_TOLERANCE)) {
                throw new RulesException("A rule file that contains the parameter \"ValidOnlyWithOtherAdduct\" must contain the parameter \"OtherAdductValidityTolerance\"!");
            }
            if (!this.foundHead_ && !this.foundChains_) {
                throw new RulesException(NO_HEAD_AND_CHAINS_SECTION);
            }
            if (this.headFragments_.size() == 0 && this.chainFragments_.size() == 0) {
                throw new RulesException("The rules file does not contain any fragments in the 1! There must be at least one fragment!");
            }
            this.checkIfGeneralValuesAreThere();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void initParseableValues() {
        this.generalSettings_ = new Hashtable();
        this.headFragments_ = new Hashtable();
        this.chainFragments_ = new Hashtable();
        this.headIntensities_ = new Vector();
        this.chainIntensities_ = new Vector();
        this.positionIntensities_ = new Vector();
        this.faHydroxyRange_ = null;
        this.lcbHydroxyRange_ = null;
        this.otherRequiredAdducts_ = null;
        this.allOtherAdductsHaveToBeFound_ = false;
    }

    private void parseGeneralSectionEntry(String line, int lineNumber) throws RulesException {
        if (line.length() == 0) {
            return;
        }
        if (line.indexOf("=") == -1) {
            throw new RulesException("Properties in the [GENERAL] are key/value pairs seperated by \"=\"! There is no \"=\" at line " + lineNumber + "!");
        }
        String key = line.substring(0, line.indexOf("=")).trim();
        String value = line.substring(line.indexOf("=") + 1).trim();
        if (key.equalsIgnoreCase(GENERAL_CHAINS)) {
            try {
                Integer.parseInt(value);
                this.generalSettings_.put(GENERAL_CHAINS, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of AmountOfChains must be integer, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_CHAINS_ALKYL)) {
            try {
                Integer.parseInt(value);
                this.generalSettings_.put(GENERAL_CHAINS_ALKYL, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of AlkylChains must be integer, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_CHAINS_ALKENYL)) {
            try {
                Integer.parseInt(value);
                this.generalSettings_.put(GENERAL_CHAINS_ALKENYL, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of AlkenylChains must be integer, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_LCBS)) {
            try {
                Short.parseShort(value);
                this.generalSettings_.put(GENERAL_LCBS, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of AmountOfLCBs must be integer, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_FA_HYDROXY_RANGE)) {
            this.faHydroxyRange_ = this.parseRangeEntry(value, key, lineNumber, (short)0);
        } else if (key.equalsIgnoreCase(GENERAL_LCB_HYDROXY_RANGE)) {
            this.lcbHydroxyRange_ = this.parseRangeEntry(value, key, lineNumber, (short)3);
        } else if (key.equalsIgnoreCase(GENERAL_MS2_LIB)) {
            if (!value.endsWith(".xlsx") && !value.endsWith(".xls")) {
                throw new RulesException("The value of ChainLibrary must be an Excel file; the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
            this.generalSettings_.put(GENERAL_MS2_LIB, value);
        } else if (key.equalsIgnoreCase(GENERAL_LCB_LIB)) {
            if (!value.endsWith(".xlsx") && !value.endsWith(".xls")) {
                throw new RulesException("The value of LCBLibrary must be an Excel file; the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
            this.generalSettings_.put(GENERAL_LCB_LIB, value);
        } else if (key.equalsIgnoreCase(GENERAL_CATOMS_PARSE)) {
            try {
                Pattern.compile(value);
                if (value.indexOf("(") == -1 || value.indexOf(")") == -1) {
                    throw new RulesException("The value of CAtomsFromName must be a Java regex containing \"(\" and \")\"; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
                }
                this.generalSettings_.put(GENERAL_CATOMS_PARSE, value);
            }
            catch (PatternSyntaxException psx) {
                throw new RulesException("The value of CAtomsFromName must be a Java regex; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_DBOND_PARSE)) {
            try {
                Pattern.compile(value);
                if (value.indexOf("(") == -1 || value.indexOf(")") == -1) {
                    throw new RulesException("The value of DoubleBondsFromName must be a Java regex containing \"(\" and \")\"; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
                }
                this.generalSettings_.put(GENERAL_DBOND_PARSE, value);
            }
            catch (PatternSyntaxException psx) {
                throw new RulesException("The value of DoubleBondsFromName must be a Java regex; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_CUTOFF)) {
            FragRuleParser.readPercentPermilleValue(value, GENERAL_CUTOFF, lineNumber);
            this.generalSettings_.put(GENERAL_CUTOFF, value);
        } else if (key.equalsIgnoreCase(GENERAL_CHAIN_CUTOFF)) {
            FragRuleParser.readPercentPermilleValue(value, GENERAL_CHAIN_CUTOFF, lineNumber);
            this.generalSettings_.put(GENERAL_CHAIN_CUTOFF, value);
        } else if (key.equalsIgnoreCase(GENERAL_SPECTRUM_COVERAGE)) {
            FragRuleParser.readPercentPermilleValue(value, GENERAL_SPECTRUM_COVERAGE, lineNumber);
            this.generalSettings_.put(GENERAL_SPECTRUM_COVERAGE, value);
        } else if (key.equalsIgnoreCase(GENERAL_RT_PROCESSING)) {
            boolean rtPostProcessing = false;
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                rtPostProcessing = true;
            }
            this.generalSettings_.put(GENERAL_RT_PROCESSING, String.valueOf(rtPostProcessing));
        } else if (key.equalsIgnoreCase(GENERAL_RT_PARALLEL_SERIES)) {
            boolean rtParallelSeries = false;
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                rtParallelSeries = true;
            }
            this.generalSettings_.put(GENERAL_RT_PARALLEL_SERIES, String.valueOf(rtParallelSeries));
        } else if (key.equalsIgnoreCase(GENERAL_RT_DEV_MAX)) {
            try {
                new Float(value);
                this.generalSettings_.put(GENERAL_RT_DEV_MAX, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of RetentionTimeMaxDeviation must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_SINGLE_CHAIN)) {
            boolean singleChain = false;
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                singleChain = true;
            }
            this.generalSettings_.put(GENERAL_SINGLE_CHAIN, String.valueOf(singleChain));
        } else if (key.equalsIgnoreCase(GENERAL_IDENTIFICATION_ORDER)) {
            int msIdentificationOrder = 0;
            if (!(value.equalsIgnoreCase(ORDER_MS1_FIRST) || value.equalsIgnoreCase(ORDER_MSN_FIRST) || value.equalsIgnoreCase(ORDER_MSN_ONLY))) {
                throw new RulesException("The value \"" + value + "\" is not allowed for \"" + GENERAL_IDENTIFICATION_ORDER + "\"! Only " + ORDER_MS1_FIRST + "/" + ORDER_MSN_FIRST + "/" + ORDER_MSN_ONLY + " is allowed! Error at line number " + lineNumber + "!");
            }
            if (value.equalsIgnoreCase(ORDER_MSN_FIRST)) {
                msIdentificationOrder = 1;
            }
            if (value.equalsIgnoreCase(ORDER_MSN_ONLY)) {
                msIdentificationOrder = 2;
            }
            this.generalSettings_.put(GENERAL_IDENTIFICATION_ORDER, String.valueOf(msIdentificationOrder));
        } else if (key.equalsIgnoreCase(GENERAL_PEAK_UNION_TIME)) {
            try {
                new Float(value);
                this.generalSettings_.put(GENERAL_PEAK_UNION_TIME, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of EnforcePeakUnionTime must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_PEAK_UNION_NO_POSITION)) {
            boolean noPosition = false;
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                noPosition = true;
            }
            this.generalSettings_.put(GENERAL_PEAK_UNION_NO_POSITION, String.valueOf(noPosition));
        } else if (key.equalsIgnoreCase(GENERAL_MS1_PEAK_CUTOFF)) {
            try {
                new Float(value);
                this.generalSettings_.put(GENERAL_MS1_PEAK_CUTOFF, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of ClassSpecificMS1Cutoff must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_ADD_POSITIONS)) {
            try {
                int adds = Integer.parseInt(value);
                if (adds < 0) {
                    throw new RulesException("The value of AddChainPositions must be bigger or equal zero, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
                }
                this.generalSettings_.put(GENERAL_ADD_POSITIONS, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of AddChainPositions must be integer, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_ISOBAR_RATIO)) {
            try {
                new Float(value);
                this.generalSettings_.put(GENERAL_ISOBAR_RATIO, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of IsobarSCExclusionRatio must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_ISOBAR_FAR_RATIO)) {
            try {
                new Float(value);
                this.generalSettings_.put(GENERAL_ISOBAR_FAR_RATIO, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of IsobarSCFarExclusionRatio must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_ISOBAR_RT)) {
            try {
                new Float(value);
                this.generalSettings_.put(GENERAL_ISOBAR_RT, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of IsobarRtDiff must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_OTHER_ADDUCT_REQUIRED)) {
            this.otherRequiredAdducts_ = new Vector();
            this.allOtherAdductsHaveToBeFound_ = false;
            String[] adducts = null;
            if (value.indexOf(",") != -1) {
                this.allOtherAdductsHaveToBeFound_ = true;
                adducts = value.split(",");
            } else {
                adducts = value.indexOf(124) != -1 ? value.split(Pattern.quote("|")) : new String[]{value};
            }
            for (String adduct : adducts) {
                if (adduct.length() <= 0) continue;
                this.otherRequiredAdducts_.add(adduct.trim());
            }
        } else if (key.equalsIgnoreCase(GENERAL_OTHER_ADDUCT_TIME_TOLERANCE)) {
            try {
                float tt = new Float(value).floatValue();
                if (tt < 0.0f) {
                    throw new RulesException("The value of \"OtherAdductValidityTolerance\" must be greater than 0! Error at line number " + lineNumber + "!");
                }
                this.generalSettings_.put(GENERAL_OTHER_ADDUCT_TIME_TOLERANCE, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of OtherAdductValidityTolerance must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_CHAIN_ABS_CUTOFF)) {
            try {
                float tt = new Float(value).floatValue();
                if (tt < 0.0f) {
                    throw new RulesException("The value of \"ChainFragmentAbsoluteThreshold\" must be greater than 0! Error at line number " + lineNumber + "!");
                }
                this.generalSettings_.put(GENERAL_CHAIN_ABS_CUTOFF, value);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("The value of ChainFragmentAbsoluteThreshold must be float format; the value \"" + value + "\" is not valid! Error at line number " + lineNumber + "!");
            }
        } else if (key.equalsIgnoreCase(GENERAL_OTHER_ADDUCT_FORCE)) {
            boolean forceOtherAdduct = false;
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                forceOtherAdduct = true;
            }
            this.generalSettings_.put(GENERAL_OTHER_ADDUCT_FORCE, String.valueOf(forceOtherAdduct));
        } else if (key.equalsIgnoreCase(GENERAL_CHOOSE_MORE_LIKELY_RT_WHEN_EQUAL)) {
            boolean forceOtherAdduct = false;
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                forceOtherAdduct = true;
            }
            this.generalSettings_.put(GENERAL_CHOOSE_MORE_LIKELY_RT_WHEN_EQUAL, String.valueOf(forceOtherAdduct));
        } else {
            throw new RulesException("The section [GENERAL] does not support the property " + key + "! Error at line number " + lineNumber + "!");
        }
    }

    public static double readPercentPermilleValue(String inValue, String section, int lineNumber) throws RulesException {
        try {
            double doubleValue = StaticUtils.readPercentPermilleValue(inValue);
            String value = new String(inValue);
            if (value.endsWith("%") || value.endsWith("\u2030")) {
                value = value.substring(0, value.length() - 1);
            }
            if (doubleValue < 0.0 || doubleValue >= 1.0) {
                if (doubleValue < 0.0) {
                    throw new RulesException("The " + section + " must not be negative, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
                }
                if (doubleValue >= 1.0) {
                    throw new RulesException("The " + section + " must not be bigger than 100%, the value \"" + inValue + "\" is not! Error at line number " + lineNumber + "!");
                }
            }
            return doubleValue;
        }
        catch (NumberFormatException nfx) {
            String value = new String(inValue);
            if (value.endsWith("%") || value.endsWith("\u2030")) {
                value = value.substring(0, value.length() - 1);
            }
            throw new RulesException("The value of " + section + " must be double format, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
        }
    }

    private void checkIfGeneralValuesAreThere() throws RulesException {
        short amountOfLCBs;
        int amountOfAlkenylChains;
        if (!this.generalSettings_.containsKey(GENERAL_CHAINS)) {
            throw new RulesException("The rules file must contain the property \"AmountOfChains\" in the [GENERAL] section!");
        }
        if (!this.generalSettings_.containsKey(GENERAL_MS2_LIB)) {
            throw new RulesException("The rules file must contain the property \"ChainLibrary\" in the [GENERAL] section!");
        }
        if (this.foundChains_) {
            if (!this.generalSettings_.containsKey(GENERAL_CATOMS_PARSE)) {
                throw new RulesException("The rules file must contain the property \"CAtomsFromName\" in the [GENERAL] section!");
            }
            if (!this.generalSettings_.containsKey(GENERAL_DBOND_PARSE)) {
                throw new RulesException("The rules file must contain the property \"DoubleBondsFromName\" in the [GENERAL] section!");
            }
        }
        int amountOfChains = Integer.parseInt(this.getAmountOfChains());
        int amountOfAlkylChains = Integer.parseInt(this.getAmountOfAlkylChains());
        if (amountOfAlkylChains + (amountOfAlkenylChains = Integer.parseInt(this.getAmountOfAlkenylChains())) + (amountOfLCBs = Short.parseShort(this.getAmountOfLCBs())) > amountOfChains) {
            throw new RulesException("There must not be more \"AlkylChains\", \"AlkenylChains\" and \"AmountOfLCBs\" than \"AmountOfChains\"!");
        }
        if (amountOfLCBs > 0 && !this.generalSettings_.containsKey(GENERAL_LCB_LIB)) {
            throw new RulesException("When there are \"AmountOfLCBs\" set, the rules file must contain the property \"LCBLibrary\" in the [GENERAL] section!");
        }
    }

    private void parseFragmentEntry(String line, int lineNumber, int currentSection) throws RulesException {
        if (line.length() == 0) {
            return;
        }
        int charge = 1;
        int msLevel = 2;
        short mandatory = 0;
        String name = null;
        String formula = null;
        RuleHydroxyRequirementSet ohRequirements = null;
        RuleHydroxyRequirementSet combiOhRequirements = null;
        StringTokenizer tokenizer = new StringTokenizer(line, "\t ");
        if (FragRuleParser.useAlex()) {
            tokenizer = new StringTokenizer(line, "\t");
        }
        while (tokenizer.hasMoreTokens()) {
            String kvPair = tokenizer.nextToken().trim();
            if (kvPair.indexOf("=") == -1) {
                throw new RulesException("The !FRAGMENTS are key/value pairs seperated by \"=\"! There is no \"=\" in \"" + kvPair + "\"at line " + lineNumber + "!");
            }
            String key = kvPair.substring(0, kvPair.indexOf("="));
            String value = kvPair.substring(kvPair.indexOf("=") + 1);
            if (key.equalsIgnoreCase(FRAGMENT_NAME)) {
                if (value.indexOf("$") != -1) {
                    throw new RulesException("The key Name does not support values containing \"$\"! Error at line number " + lineNumber + "!");
                }
                name = value;
                continue;
            }
            if (key.equalsIgnoreCase(FRAGMENT_FORMULA)) {
                this.checkFormula(value, lineNumber);
                formula = value;
                continue;
            }
            if (key.equalsIgnoreCase(FRAGMENT_CHARGE)) {
                try {
                    charge = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new RulesException("The value of Charge must be integer, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
                }
            }
            if (key.equalsIgnoreCase(FRAGMENT_LEVEL)) {
                try {
                    msLevel = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new RulesException("The value of MSLevel must be integer, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
                }
            }
            if (key.equalsIgnoreCase(FRAGMENT_MANDATORY)) {
                mandatory = this.parseMandatoryLevel(value, currentSection, lineNumber, true);
                continue;
            }
            if (key.equalsIgnoreCase(FRAGMENT_HYDROXY)) {
                ohRequirements = this.parseAllowedOHs(value, currentSection, lineNumber, true, false);
                continue;
            }
            if (key.equalsIgnoreCase(FRAGMENT_COMBI_HYDROXY)) {
                combiOhRequirements = this.parseAllowedOHs(value, currentSection, lineNumber, true, true);
                continue;
            }
            throw new RulesException("The section !FRAGMENTS does not support the key \"" + key + "\"! Error at line number " + lineNumber + "!");
        }
        if (name == null || name.length() == 0) {
            throw new RulesException("A !FRAGMENTS entry must contain a key called \"Name\"! Error at line number " + lineNumber + "!");
        }
        if (formula == null || formula.length() == 0) {
            throw new RulesException("A !FRAGMENTS entry must contain a key called \"Formula\"! Error at line number " + lineNumber + "!");
        }
        this.checkNamePresent(name, lineNumber);
        if (ohRequirements != null) {
            ohRequirements.setUndefinedMandatorySettings(mandatory);
        }
        if (combiOhRequirements != null) {
            combiOhRequirements.setUndefinedMandatorySettings(mandatory);
        }
        FragmentRuleVO ruleVO = new FragmentRuleVO(name, formula, charge, msLevel, mandatory, ohRequirements, combiOhRequirements, this.headFragments_, this.chainFragments_, this.elementParser_);
        if (currentSection == 2) {
            this.headFragments_.put(name, ruleVO);
        }
        if (currentSection == 3) {
            this.checkSelectedChainValid(ruleVO, lineNumber);
            this.chainFragments_.put(name, ruleVO);
        }
    }

    private void checkFormula(String formula, int lineNumber) throws RulesException {
        try {
            FragmentRuleVO.isFormulaValid(formula, this.headFragments_, this.chainFragments_, this.elementParser_);
        }
        catch (RulesException rlx) {
            throw new RulesException(rlx.getMessage() + " Error at line number " + lineNumber + "!");
        }
    }

    private void checkNamePresent(String name, int lineNumber) throws RulesException {
        if (this.headFragments_.containsKey(name)) {
            throw new RulesException("The fragment \"" + name + "\" at line " + lineNumber + " was already defined in the " + HEAD_SECTION_NAME + "! Names in rules must be unique all over the file!");
        }
        if (this.chainFragments_.containsKey(name)) {
            throw new RulesException("The fragment " + name + " at line " + lineNumber + " was already defined in the " + CHAINS_SECTION_NAME + "! Names in rules must be unique all over the file!");
        }
    }

    private void parseIntensityEntry(String line, int lineNumber, int currentSection) throws RulesException {
        if (line.length() == 0) {
            return;
        }
        boolean mandatory = false;
        RuleHydroxyRequirementSet ohRequirements = null;
        StringTokenizer tokenizer = new StringTokenizer(line, "\t ");
        if (FragRuleParser.useAlex()) {
            tokenizer = new StringTokenizer(line, "\t");
        }
        IntensityRuleVO ruleVO = null;
        while (tokenizer.hasMoreTokens()) {
            String kvPair = tokenizer.nextToken().trim();
            String key = kvPair.substring(0, kvPair.indexOf("="));
            String value = kvPair.substring(kvPair.indexOf("=") + 1);
            if (key.equalsIgnoreCase(INTENSITY_EQUATION)) {
                Integer amountOfChains = null;
                if (currentSection == 4) {
                    if (!this.generalSettings_.containsKey(GENERAL_CHAINS)) {
                        throw new RulesException("If there is a [POSITION] section, AmountOfChains has to be declared! Error at line number" + lineNumber + "!");
                    }
                    amountOfChains = new Integer(this.generalSettings_.get(GENERAL_CHAINS));
                    if (this.generalSettings_.containsKey(GENERAL_ADD_POSITIONS)) {
                        amountOfChains = amountOfChains + new Integer(this.generalSettings_.get(GENERAL_ADD_POSITIONS));
                    }
                }
                ruleVO = FragRuleParser.extractIntensityVOFromEquation(value, lineNumber, currentSection, FragmentRuleVO.getStringKeyHash(this.headFragments_), FragmentRuleVO.getStringKeyHash(this.chainFragments_), amountOfChains);
                continue;
            }
            if (key.equalsIgnoreCase(FRAGMENT_MANDATORY)) {
                mandatory = this.parseMandatoryLevel(value, currentSection, lineNumber, false) == 1;
                continue;
            }
            if (key.equalsIgnoreCase(FRAGMENT_HYDROXY)) {
                ohRequirements = this.parseAllowedOHs(value, currentSection, lineNumber, false, false);
                continue;
            }
            if (key.equalsIgnoreCase(FRAGMENT_MANDATORY)) {
                if (!(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no"))) {
                    throw new RulesException("The value of mandatory can contain the values \"true\",\"false\",\"yes\" and \"no\" only! Error at line number " + lineNumber + "!");
                }
                if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("yes")) continue;
                mandatory = true;
                continue;
            }
            throw new RulesException("The section !INTENSITIES does not support the key \"" + key + "\"! Error at line number " + lineNumber + "!");
        }
        if (ruleVO == null) {
            throw new RulesException("An entry of 2 must contain a an \"Equation=\" attribute! Error at line number " + lineNumber + "!");
        }
        if (ohRequirements != null) {
            short mand = 0;
            if (mandatory) {
                mand = 1;
            }
            ohRequirements.setUndefinedMandatorySettings(mand);
        }
        ruleVO.setMandatory(mandatory);
        ruleVO.setAllowedOHs(ohRequirements, lineNumber, currentSection == 2);
        if (currentSection == 2) {
            this.headIntensities_.add(ruleVO);
        }
        if (currentSection == 3) {
            this.chainIntensities_.add(ruleVO);
        }
        if (currentSection == 4) {
            this.positionIntensities_.add(ruleVO);
        }
    }

    public static IntensityRuleVO extractIntensityVOFromEquation(String equation, int lineNumber, int currentSection, Hashtable<String, Short> headFragments, Hashtable<String, Short> chainFragments, Integer amountOfChains) throws RulesException {
        return FragRuleParser.extractIntensityVOFromEquation(equation, lineNumber, currentSection, headFragments, chainFragments, amountOfChains, new Hashtable<String, Short>());
    }

    public static IntensityRuleVO extractIntensityVOFromEquation(String equation, int lineNumber, int currentSection, Hashtable<String, Short> headFragments, Hashtable<String, Short> chainFragments, Integer amountOfChains, Hashtable<String, Short> missed) throws RulesException {
        Boolean biggerThan = null;
        String originalEquation = "";
        originalEquation = new String(equation);
        int comparatorIdx = 0;
        if (equation.indexOf(">") != -1) {
            comparatorIdx = equation.indexOf(">");
        }
        if (equation.indexOf("<") != -1) {
            comparatorIdx = equation.indexOf("<");
        }
        ExpressionForComparisonVO biggerExpression = null;
        ExpressionForComparisonVO smallerExpression = null;
        boolean orRule = false;
        if (comparatorIdx < 1 || comparatorIdx >= equation.length() - 1) {
            if (equation.indexOf("|") == -1) {
                throw new RulesException("The value of Equation must contain a comparator sign (\">\" or \"<\"), or the OR sign (\"|\")! Error at line number " + lineNumber + "!");
            }
            if (currentSection == 4) {
                throw new RulesException("The OR sign (\"|\") is not allowed in a [POSITION] section! Error at line number " + lineNumber + "!");
            }
            String[] orFragments = equation.split("\\|");
            Vector<FragmentMultVO> frags = new Vector<FragmentMultVO>();
            for (String orFragmentFull : orFragments) {
                short type = -100;
                String orFragment = orFragmentFull.trim();
                for (String fragName : headFragments.keySet()) {
                    if (!fragName.equalsIgnoreCase(orFragment)) continue;
                    type = headFragments.get(orFragment);
                    break;
                }
                for (String fragName : chainFragments.keySet()) {
                    if (type > 100) break;
                    if (!fragName.equalsIgnoreCase(orFragment)) continue;
                    type = chainFragments.get(fragName);
                    break;
                }
                for (String fragName : missed.keySet()) {
                    if (type > 100) break;
                    if (!fragName.equalsIgnoreCase(orFragment)) continue;
                    type = missed.get(fragName);
                    break;
                }
                if (type <= -100) {
                    throw new RulesException("An \"Equation\" must contain previously declared fragments! The value \"" + orFragment + "\" of \"" + equation + "\" was not declared! Error at line " + lineNumber + "!");
                }
                frags.add(new FragmentMultVO(orFragment, type, "1", true, 0));
            }
            biggerExpression = new ExpressionForComparisonVO(frags, "1");
            smallerExpression = new ExpressionForComparisonVO(new Vector<FragmentMultVO>(), "1");
            orRule = true;
        } else {
            ExpressionForComparisonVO rightExpression;
            String leftSide = equation.substring(0, comparatorIdx);
            String rightSide = equation.substring(comparatorIdx + 1);
            String comparator = equation.substring(comparatorIdx, comparatorIdx + 1);
            biggerThan = comparator.equalsIgnoreCase(">") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            if (leftSide.indexOf(">") != -1 || leftSide.indexOf("<") != -1 || leftSide.indexOf("=") != -1) {
                throw new RulesException("The value of Equation must contain only one comparator sign (\">\" or \"<\")! The entry at line number " + lineNumber + " contains more than one!");
            }
            if (rightSide.indexOf(">") != -1 || rightSide.indexOf("<") != -1 || rightSide.indexOf("=") != -1) {
                throw new RulesException("The value of Equation must contain only one comparator sign (\">\" or \"<\")! The entry at line number " + lineNumber + " contains more than one!");
            }
            ExpressionForComparisonVO leftExpression = FragRuleParser.parseIntensityFragment(leftSide, lineNumber, currentSection, comparator, amountOfChains, headFragments, chainFragments, missed);
            biggerExpression = rightExpression = FragRuleParser.parseIntensityFragment(rightSide, lineNumber, currentSection, comparator, amountOfChains, headFragments, chainFragments, missed);
            smallerExpression = leftExpression;
            if (biggerThan.booleanValue()) {
                biggerExpression = leftExpression;
                smallerExpression = rightExpression;
            }
        }
        IntensityRuleVO ruleVO = new IntensityRuleVO(currentSection, originalEquation, biggerExpression, smallerExpression, orRule);
        return ruleVO;
    }

    private static ExpressionForComparisonVO parseIntensityFragment(String originalValue, int lineNumber, int currentSection, String comp, Integer amountOfChains, Hashtable<String, Short> headFragments, Hashtable<String, Short> chainFragments, Hashtable<String, Short> missed) throws RulesException {
        String globalMultiplier = "1";
        String value = new String(originalValue);
        Vector<ShortStringVO> lengthSortedFragmentNames = FragmentRuleVO.getLengthSortedFragmentNames(headFragments, chainFragments, missed);
        if (originalValue.indexOf("(") != -1 || originalValue.indexOf(")") != -1) {
            if (originalValue.indexOf("(") == -1) {
                throw new RulesException("An \"Equation\" containing an opening bracket must contain a closing bracket! The equation \"" + value + "\" at line " + lineNumber + " does not!");
            }
            if (originalValue.indexOf(")") == -1) {
                throw new RulesException("An \"Equation\" containing a closing bracket must contain an opening bracket! The equation \"" + value + "\" at line " + lineNumber + " does not!");
            }
            if (originalValue.indexOf("(") > originalValue.indexOf(")")) {
                throw new RulesException("An \"Equation\" must not start with a closing bracket before an opening bracket! The equation \"" + value + "\" at line " + lineNumber + " does!");
            }
            boolean isMathematicalBracket = true;
            if (FragRuleParser.useAlex()) {
                for (ShortStringVO fragment : lengthSortedFragmentNames) {
                    if (fragment.getKey().indexOf("(") == -1 || originalValue.indexOf(fragment.getKey()) == -1 || originalValue.indexOf("(") != originalValue.indexOf(fragment.getKey()) + fragment.getKey().indexOf("(")) continue;
                    isMathematicalBracket = false;
                }
            }
            if (isMathematicalBracket) {
                value = originalValue.substring(originalValue.indexOf("(") + 1, originalValue.lastIndexOf(")")).trim();
                String prevFragment = originalValue.substring(0, originalValue.indexOf("(")).trim();
                String pastFragment = originalValue.substring(originalValue.lastIndexOf(")") + 1).trim();
                String[] results = FragRuleParser.extractMultiplicationFactor(prevFragment, pastFragment, value, originalValue, lineNumber, currentSection, comp, amountOfChains);
                globalMultiplier = results[0];
            }
        }
        Vector<FragmentMultVO> fragments = new Vector<FragmentMultVO>();
        int position = -1;
        while (value.length() > 0) {
            Object[] fragmentAndValue = FragRuleParser.extractMultiplicativeExpression(value, lengthSortedFragmentNames, originalValue, lineNumber, currentSection, comp, amountOfChains);
            if (fragmentAndValue[0] == null) {
                if (fragments.size() == 0) {
                    throw new RulesException("An \"Equation\" must contain one previously declared fragment at each side of the \"" + comp + "\"! The value \"" + originalValue + "\" at line " + lineNumber + " has not!");
                }
                throw new RulesException("The \"Equation\" contains a part that cannot be interpreted: \"" + value + "\"! The problem is the equation \"" + originalValue + "\" at line " + lineNumber + "!");
            }
            FragmentMultVO fragMult = (FragmentMultVO)fragmentAndValue[0];
            if (!fragMult.getFragmentName().equalsIgnoreCase("$BASEPEAK")) {
                if (fragments.size() == 0 || fragments.size() == 1 && fragments.get(0).getFragmentName().equalsIgnoreCase("$BASEPEAK")) {
                    position = fragMult.getPosition();
                } else if (position != fragMult.getPosition()) {
                    throw new RulesException("The \"Equation\" containing position rules must have the same position on one side of the equation! The equation \"" + originalValue + "\" at line " + lineNumber + " causes the error!");
                }
            }
            fragments.add((FragmentMultVO)fragmentAndValue[0]);
            value = (String)fragmentAndValue[1];
        }
        ExpressionForComparisonVO exprVO = new ExpressionForComparisonVO(fragments, globalMultiplier);
        return exprVO;
    }

    private static Object[] extractMultiplicativeExpression(String inputValue, Vector<ShortStringVO> lengthSortedFragmentNames, String originalValue, int lineNumber, int currentSection, String comp, Integer amountOfChains) throws RulesException {
        char ch;
        Object[] multiplicativeExpressionAndRemainingValue = new Object[2];
        Object[] fragAndStart = FragRuleParser.getFragmentAndStartPosition(inputValue, lengthSortedFragmentNames);
        if ((Integer)fragAndStart[1] < 0) {
            multiplicativeExpressionAndRemainingValue[0] = null;
            multiplicativeExpressionAndRemainingValue[1] = null;
            return multiplicativeExpressionAndRemainingValue;
        }
        String name = (String)fragAndStart[0];
        int startPos = (Integer)fragAndStart[1];
        short type = (Short)fragAndStart[2];
        boolean positive = true;
        String beforeString = inputValue.substring(0, startPos).trim();
        char[] charsBefore = beforeString.toCharArray();
        int stopChar = 0;
        int i = charsBefore.length - 1;
        while (i != -1) {
            char ch2 = charsBefore[i];
            if (ch2 == '+' || ch2 == '-') {
                if (ch2 == '-') {
                    positive = false;
                }
                stopChar = i;
                break;
            }
            if (!Character.isDigit(ch2) && ch2 != '.' && ch2 != '*' && ch2 != '/' && ch2 != ' ' && ch2 != '[' && ch2 != ']') break;
            stopChar = i--;
        }
        String value = beforeString.substring(0, stopChar).trim();
        String prevFragment = beforeString.substring(stopChar).trim();
        if (prevFragment.startsWith("+") || prevFragment.startsWith("-")) {
            prevFragment = prevFragment.substring(1);
        }
        stopChar = 0;
        String afterString = inputValue.substring(startPos + name.length()).trim();
        char[] charsAfter = afterString.toCharArray();
        for (int i2 = 0; i2 != charsAfter.length && (Character.isDigit(ch = charsAfter[i2]) || ch == '.' || ch == '*' || ch == '/' || ch == ' ' || ch == '[' || ch == ']'); ++i2) {
            stopChar = i2 + 1;
        }
        value = value + afterString.substring(stopChar).trim();
        String pastFragment = afterString.substring(0, stopChar).trim();
        String[] results = FragRuleParser.extractMultiplicationFactor(prevFragment, pastFragment, value, originalValue, lineNumber, currentSection, comp, amountOfChains);
        String multString = results[0];
        String position = results[1];
        FragmentMultVO multVO = new FragmentMultVO(name, type, multString, positive, Integer.parseInt(position));
        multiplicativeExpressionAndRemainingValue[0] = multVO;
        multiplicativeExpressionAndRemainingValue[1] = value;
        return multiplicativeExpressionAndRemainingValue;
    }

    private static String[] extractMultiplicationFactor(String prevFragment, String pastFragment, String fragmentName, String originalValue, int lineNumber, int currentSection, String comp, Integer amountOfChains) throws RulesException {
        String multString = "1";
        double mult = 1.0;
        int position = 0;
        if (prevFragment.indexOf("*") != -1 && (pastFragment.indexOf("*") != -1 || pastFragment.indexOf("/") != -1)) {
            throw new RulesException("An \"Equation\" must not contain more than multiplier (\"*\" or \"/\") at each side of the \"" + comp + "\"! The value \"" + originalValue + "\" at " + lineNumber + " has more than one!");
        }
        if (prevFragment.length() > 0) {
            if (!prevFragment.endsWith("*")) {
                throw new RulesException("An \"Equation\" allows only a multiplier sign (\"*\") and a number before the declared fragment (\"+name+\")! The expression \"" + originalValue + "\" at " + lineNumber + " does not comply this rule!");
            }
            try {
                mult = Double.parseDouble(prevFragment.substring(0, prevFragment.length() - 1));
                multString = prevFragment.substring(0, prevFragment.length() - 1);
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("An \"Equation\" allows only a multiplier sign (\"*\") and a number before the declared fragment (\"+name+\")! The expression \"" + originalValue + "\" at " + lineNumber + " does not comply this rule!");
            }
        }
        if (pastFragment.length() > 0 && pastFragment.startsWith("[") && pastFragment.indexOf("]") != -1) {
            if (currentSection != 4) {
                throw new RulesException("Position specific identifiers in \"Equation\" are allowed in the [POSITION] section only! The expression \"" + originalValue + "\" at " + lineNumber + " has a position (\"[]\")!");
            }
            try {
                position = Integer.parseInt(pastFragment.substring(1, pastFragment.indexOf("]")));
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("An \"Equation\" must have an integer value for the position! The expression \"" + originalValue + "\" at " + lineNumber + " is not integer format!");
            }
            if (position < 1 || amountOfChains != null && position > amountOfChains) {
                String throwStatement = "The position specific value \"" + position + "\" is not allowed!";
                if (amountOfChains != null && position > amountOfChains) {
                    throwStatement = throwStatement + " Only values between 1 and " + amountOfChains + " are allowed!";
                }
                throwStatement = throwStatement + " Error at line number " + lineNumber + "!";
                throw new RulesException(throwStatement);
            }
            pastFragment = pastFragment.substring(pastFragment.indexOf("]") + 1);
        }
        if (pastFragment.length() > 0) {
            if (!pastFragment.startsWith("*") && !pastFragment.startsWith("/")) {
                throw new RulesException("An \"Equation\" allows only a multiplier or divisor sign (\"*\" or \"/\") and a number after the declared fragment (" + fragmentName + ")! The expression \"" + originalValue + "\" at " + lineNumber + " does not comply this rule!");
            }
            try {
                mult = Double.parseDouble(pastFragment.substring(1, pastFragment.length()));
                multString = pastFragment.substring(1, pastFragment.length());
                if (pastFragment.startsWith("/")) {
                    mult = 1.0 / mult;
                    multString = String.valueOf(mult);
                }
            }
            catch (NumberFormatException nfx) {
                throw new RulesException("An \"Equation\" allows only a multiplier or divisor sign (\"*\" or \"/\") and a number after the declared fragment (" + fragmentName + ")! The expression \"" + originalValue + "\" at " + lineNumber + " does not comply this rule!");
            }
        }
        String[] result = new String[]{multString, String.valueOf(position)};
        return result;
    }

    private static Object[] getFragmentAndStartPosition(String value, Vector<ShortStringVO> lengthSortedFragmentNames) {
        String fragment = null;
        int start = -1;
        short type = -1;
        if (value.indexOf("$BASEPEAK") != -1) {
            fragment = "$BASEPEAK";
            start = value.indexOf("$BASEPEAK");
            type = -1;
        } else {
            for (ShortStringVO frag : lengthSortedFragmentNames) {
                if (value.indexOf(frag.getKey()) == -1) continue;
                fragment = frag.getKey();
                start = value.indexOf(frag.getKey());
                type = frag.getValue();
                break;
            }
        }
        Object[] result = new Object[]{fragment, start, type};
        return result;
    }

    private void checkSelectedChainValid(FragmentRuleVO ruleVO, int lineNumber) throws RulesException {
        int amountOfChains = Integer.valueOf(this.getAmountOfChains());
        int amountOfAlkylChains = Integer.valueOf(this.getAmountOfAlkylChains());
        int amountOfAlkenylChains = Integer.valueOf(this.getAmountOfAlkenylChains());
        int amountOfLcbChains = Integer.valueOf(this.getAmountOfLCBs());
        int amountOfAcylChains = amountOfChains - amountOfAlkylChains - amountOfAlkenylChains - amountOfLcbChains;
        boolean isError = false;
        String errorMessage = "The chain type ";
        if (ruleVO.getChainType() == 0 && amountOfAcylChains < 1) {
            errorMessage = errorMessage + "$CHAIN is not allowed according to the general settings! Only ";
            isError = true;
        } else if (ruleVO.getChainType() == 1 && amountOfAlkylChains < 1) {
            errorMessage = errorMessage + "$ALKYLCHAIN is not allowed according to the general settings! Only ";
            isError = true;
        } else if (ruleVO.getChainType() == 2 && amountOfAlkenylChains < 1) {
            errorMessage = errorMessage + "$ALKENYLCHAIN is not allowed according to the general settings! Only ";
            isError = true;
        } else if (ruleVO.getChainType() == 3 && amountOfLcbChains < 1) {
            errorMessage = errorMessage + "$LCB is not allowed according to the general settings! Only ";
            isError = true;
        }
        if (isError) {
            boolean isFirst = true;
            if (amountOfAcylChains > 0) {
                errorMessage = errorMessage + "$CHAIN";
                isFirst = false;
            }
            if (amountOfAlkylChains > 0) {
                errorMessage = errorMessage + (isFirst ? "" : "/") + "$ALKYLCHAIN";
                isFirst = false;
            }
            if (amountOfAlkenylChains > 0) {
                errorMessage = errorMessage + (isFirst ? "" : "/") + "$ALKENYLCHAIN";
                isFirst = false;
            }
            if (amountOfLcbChains > 0) {
                errorMessage = errorMessage + (isFirst ? "" : "/") + "$LCB";
                isFirst = false;
            }
            errorMessage = errorMessage + " is allowed";
            throw new RulesException(errorMessage);
        }
    }

    public String getChainLibrary() {
        return this.generalSettings_.get(GENERAL_MS2_LIB);
    }

    public String getLcbLibrary() {
        return this.generalSettings_.get(GENERAL_LCB_LIB);
    }

    public String getCAtomsFromNamePattern() {
        return this.generalSettings_.get(GENERAL_CATOMS_PARSE);
    }

    public String getDoubleBondsFromNamePattern() {
        return this.generalSettings_.get(GENERAL_DBOND_PARSE);
    }

    public String getAmountOfChains() {
        return this.generalSettings_.get(GENERAL_CHAINS);
    }

    public String getAmountOfAlkylChains() {
        int alkylChains = 0;
        if (this.generalSettings_.containsKey(GENERAL_CHAINS_ALKYL)) {
            alkylChains = Integer.parseInt(this.generalSettings_.get(GENERAL_CHAINS_ALKYL));
        }
        return String.valueOf(alkylChains);
    }

    public String getAmountOfAlkenylChains() {
        int alkenylChains = 0;
        if (this.generalSettings_.containsKey(GENERAL_CHAINS_ALKENYL)) {
            alkenylChains = Integer.parseInt(this.generalSettings_.get(GENERAL_CHAINS_ALKENYL));
        }
        return String.valueOf(alkenylChains);
    }

    public String getAmountOfLCBs() {
        int lcbs = 0;
        if (this.generalSettings_.containsKey(GENERAL_LCBS)) {
            lcbs = Short.parseShort(this.generalSettings_.get(GENERAL_LCBS));
        }
        return String.valueOf(lcbs);
    }

    public double getBasePeakCutoff() throws RulesException {
        double cutoff = 0.0;
        if (this.generalSettings_.containsKey(GENERAL_CUTOFF)) {
            cutoff = FragRuleParser.readPercentPermilleValue(this.getBasePeakCutoffAsString(), GENERAL_CUTOFF, -1);
        }
        return cutoff;
    }

    public String getBasePeakCutoffAsString() {
        String cutoff = "0";
        if (this.generalSettings_.containsKey(GENERAL_CUTOFF)) {
            cutoff = this.generalSettings_.get(GENERAL_CUTOFF);
        }
        return cutoff;
    }

    public double getChainCutoff() throws RulesException {
        double cutoff = -1.0;
        if (this.generalSettings_.containsKey(GENERAL_CHAIN_CUTOFF)) {
            cutoff = FragRuleParser.readPercentPermilleValue(this.getChainCutoffAsString(), GENERAL_CHAIN_CUTOFF, -1);
        }
        return cutoff;
    }

    public String getChainCutoffAsString() {
        String cutoff = "-1";
        if (this.generalSettings_.containsKey(GENERAL_CHAIN_CUTOFF)) {
            cutoff = this.generalSettings_.get(GENERAL_CHAIN_CUTOFF);
        }
        return cutoff;
    }

    public double getSpectrumCoverageMin() throws RulesException {
        String cutoffString;
        double cutoff = 0.0;
        if (this.generalSettings_.containsKey(GENERAL_SPECTRUM_COVERAGE) && (cutoffString = this.getSpectrumCoverageMinAsString()) != null) {
            cutoff = FragRuleParser.readPercentPermilleValue(cutoffString, GENERAL_SPECTRUM_COVERAGE, -1);
        }
        return cutoff;
    }

    public String getSpectrumCoverageMinAsString() {
        String cutoff = null;
        if (this.generalSettings_.containsKey(GENERAL_SPECTRUM_COVERAGE)) {
            cutoff = this.generalSettings_.get(GENERAL_SPECTRUM_COVERAGE);
        }
        return cutoff;
    }

    public boolean isRtPostprocessing() {
        boolean rtPostprocessing = false;
        if (this.generalSettings_.containsKey(GENERAL_RT_PROCESSING) && this.generalSettings_.get(GENERAL_RT_PROCESSING).equalsIgnoreCase("true")) {
            rtPostprocessing = true;
        }
        return rtPostprocessing;
    }

    public boolean correctRtForParallelModel() {
        boolean correctRtParallelModel = false;
        if (this.generalSettings_.containsKey(GENERAL_RT_PARALLEL_SERIES) && this.generalSettings_.get(GENERAL_RT_PARALLEL_SERIES).equalsIgnoreCase("true")) {
            correctRtParallelModel = true;
        }
        return correctRtParallelModel;
    }

    public String getRetentionTimeMaxDeviation() {
        String rtMaxDev = null;
        if (this.generalSettings_.containsKey(GENERAL_RT_DEV_MAX)) {
            rtMaxDev = this.generalSettings_.get(GENERAL_RT_DEV_MAX);
        }
        return rtMaxDev;
    }

    public boolean isSingleChainIdentification() {
        boolean singleChain = false;
        if (this.generalSettings_.containsKey(GENERAL_SINGLE_CHAIN) && this.generalSettings_.get(GENERAL_SINGLE_CHAIN).equalsIgnoreCase("true")) {
            singleChain = true;
        }
        return singleChain;
    }

    public boolean isUnionWithoutPosition() {
        boolean noPosition = false;
        if (this.generalSettings_.containsKey(GENERAL_PEAK_UNION_NO_POSITION) && this.generalSettings_.get(GENERAL_PEAK_UNION_NO_POSITION).equalsIgnoreCase("true")) {
            noPosition = true;
        }
        return noPosition;
    }

    public String getPeakUnionTime() {
        String time = null;
        if (this.generalSettings_.containsKey(GENERAL_PEAK_UNION_TIME)) {
            time = this.generalSettings_.get(GENERAL_PEAK_UNION_TIME);
        }
        return time;
    }

    public String getMS1PeakCutoff() {
        String cutoff = null;
        if (this.generalSettings_.containsKey(GENERAL_MS1_PEAK_CUTOFF)) {
            cutoff = this.generalSettings_.get(GENERAL_MS1_PEAK_CUTOFF);
        }
        return cutoff;
    }

    public String getIsobarExclusionRatio() {
        String cutoff = null;
        if (this.generalSettings_.containsKey(GENERAL_ISOBAR_RATIO)) {
            cutoff = this.generalSettings_.get(GENERAL_ISOBAR_RATIO);
        }
        return cutoff;
    }

    public String getIsobarFarExclusionRatio() {
        String cutoff = null;
        if (this.generalSettings_.containsKey(GENERAL_ISOBAR_FAR_RATIO)) {
            cutoff = this.generalSettings_.get(GENERAL_ISOBAR_FAR_RATIO);
        }
        return cutoff;
    }

    public String getIsobarFarRtDifference() {
        String cutoff = null;
        if (this.generalSettings_.containsKey(GENERAL_ISOBAR_RT)) {
            cutoff = this.generalSettings_.get(GENERAL_ISOBAR_RT);
        }
        return cutoff;
    }

    public int getMSIdentificationOrder() {
        int msIdentificationOrder = 0;
        if (this.generalSettings_.containsKey(GENERAL_IDENTIFICATION_ORDER)) {
            msIdentificationOrder = Integer.parseInt(this.generalSettings_.get(GENERAL_IDENTIFICATION_ORDER));
        }
        return msIdentificationOrder;
    }

    public Hashtable<String, FragmentRuleVO> getHeadFragmentRules() {
        return this.headFragments_;
    }

    public int[] getSpectrumLevelRange() {
        int[] range = new int[2];
        int lowestLevel = Integer.MAX_VALUE;
        int highestLevel = 0;
        for (FragmentRuleVO ruleVO : this.headFragments_.values()) {
            if (ruleVO.getMsLevel() < lowestLevel) {
                lowestLevel = ruleVO.getMsLevel();
            }
            if (ruleVO.getMsLevel() <= highestLevel) continue;
            highestLevel = ruleVO.getMsLevel();
        }
        for (FragmentRuleVO ruleVO : this.chainFragments_.values()) {
            if (ruleVO.getMsLevel() < lowestLevel) {
                lowestLevel = ruleVO.getMsLevel();
            }
            if (ruleVO.getMsLevel() <= highestLevel) continue;
            highestLevel = ruleVO.getMsLevel();
        }
        range[0] = lowestLevel;
        range[1] = highestLevel;
        return range;
    }

    public Integer getAddChainPositions() {
        int addChains = 0;
        if (this.generalSettings_.containsKey(GENERAL_ADD_POSITIONS)) {
            addChains = Integer.parseInt(this.generalSettings_.get(GENERAL_ADD_POSITIONS));
        }
        return addChains;
    }

    public int getAllowedChainPositions() {
        return Integer.parseInt(this.getAmountOfChains()) + this.getAddChainPositions();
    }

    public Vector<IntensityRuleVO> getHeadIntensityRules() {
        return this.headIntensities_;
    }

    public Hashtable<String, FragmentRuleVO> getChainFragmentRules() {
        return this.chainFragments_;
    }

    public Vector<IntensityRuleVO> getChainIntensityRules() {
        return this.chainIntensities_;
    }

    public Vector<IntensityRuleVO> getPositionIntensityRules() {
        return this.positionIntensities_;
    }

    public RangeInteger getFaHydroxyRange() {
        if (this.faHydroxyRange_ != null) {
            return this.faHydroxyRange_;
        }
        return new RangeInteger(0, 0);
    }

    public RangeInteger getLcbHydroxyRange() {
        return this.lcbHydroxyRange_;
    }

    public boolean requiresOtherValidAdduct() {
        return this.otherRequiredAdducts_ != null && this.otherRequiredAdducts_.size() > 0;
    }

    public Vector<String> getOtherRequiredAdducts() {
        return this.otherRequiredAdducts_;
    }

    public boolean areAllOtherAdductsRequired() {
        return this.allOtherAdductsHaveToBeFound_;
    }

    public float getOtherTimeTolerance() {
        float timeTolerance = 0.0f;
        if (this.generalSettings_.containsKey(GENERAL_OTHER_ADDUCT_TIME_TOLERANCE)) {
            timeTolerance = Float.parseFloat(this.generalSettings_.get(GENERAL_OTHER_ADDUCT_TIME_TOLERANCE));
        }
        return timeTolerance;
    }

    public float getChainAbsoluteThreshold() {
        float threshold = 0.0f;
        if (this.generalSettings_.containsKey(GENERAL_CHAIN_ABS_CUTOFF)) {
            threshold = Float.parseFloat(this.generalSettings_.get(GENERAL_CHAIN_ABS_CUTOFF));
        }
        return threshold;
    }

    public boolean forceOtherAdductValidity() {
        boolean forceOther = false;
        if (this.generalSettings_.containsKey(GENERAL_OTHER_ADDUCT_FORCE)) {
            forceOther = Boolean.parseBoolean(this.generalSettings_.get(GENERAL_OTHER_ADDUCT_FORCE));
        }
        return forceOther;
    }

    public boolean choseMoreLikelyRtWhenEqualMSn() {
        boolean forceOther = false;
        if (this.generalSettings_.containsKey(GENERAL_CHOOSE_MORE_LIKELY_RT_WHEN_EQUAL)) {
            forceOther = Boolean.parseBoolean(this.generalSettings_.get(GENERAL_CHOOSE_MORE_LIKELY_RT_WHEN_EQUAL));
        }
        return forceOther;
    }

    public static void writeRules(String dir, String lipidClass, String lipidAdduct, GeneralSettingsVO generalSettings, Vector<FragmentRuleVO> headFragments, Vector<IntensityRuleVO> headIntensityRules, Vector<FragmentRuleVO> chainFragments, Vector<IntensityRuleVO> chainIntensityRules, Vector<IntensityRuleVO> positionIntensityRules) throws IOException, RulesException {
        String filename = StaticUtils.getRuleFileName(lipidClass, lipidAdduct);
        File file = dir == "default" ? new File(RulesContainer.currentRulesDir_ + "/" + filename) : new File(dir + "/" + filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("[GENERAL]\n");
        bw.write("AmountOfChains=");
        if (generalSettings.getAmountOfChains() != null) {
            bw.write(generalSettings.getAmountOfChains().toString());
        }
        bw.write("\nChainLibrary=");
        if (generalSettings.getChainLibrary() != null) {
            bw.write(generalSettings.getChainLibrary());
        }
        if (generalSettings.getLcbLibrary() != null) {
            bw.write("\nLCBLibrary=" + generalSettings.getLcbLibrary());
        }
        bw.write("\nCAtomsFromName=");
        if (generalSettings.getCarbonAtomsRule() != null) {
            bw.write(generalSettings.getCarbonAtomsRule());
        }
        bw.write("\nDoubleBondsFromName=");
        if (generalSettings.getDoubleBondsRule() != null) {
            bw.write(generalSettings.getDoubleBondsRule());
        }
        if (generalSettings.getAmountOfAlkylChains() != null && generalSettings.getAmountOfAlkylChains() > 0) {
            bw.write("\nAlkylChains=" + String.valueOf(generalSettings.getAmountOfAlkylChains()));
        }
        if (generalSettings.getAmountOfAlkenylChains() != null && generalSettings.getAmountOfAlkenylChains() > 0) {
            bw.write("\nAlkenylChains=" + String.valueOf(generalSettings.getAmountOfAlkenylChains()));
        }
        if (generalSettings.getAmountOfLCBs() != null && generalSettings.getAmountOfLCBs() > 0) {
            bw.write("\nAmountOfLCBs=" + String.valueOf(generalSettings.getAmountOfLCBs()));
        }
        if (generalSettings.getFaHydroxyRangeStart() > -1 && generalSettings.getFaHydroxyRangeStop() > -1) {
            if (generalSettings.getFaHydroxyRangeStart() == generalSettings.getFaHydroxyRangeStop()) {
                bw.write("\nFaHydroxylationRange=" + String.valueOf(generalSettings.getFaHydroxyRangeStart()));
            } else {
                bw.write("\nFaHydroxylationRange=" + String.valueOf(generalSettings.getFaHydroxyRangeStart()) + "-" + String.valueOf(generalSettings.getFaHydroxyRangeStop()));
            }
        }
        if (generalSettings.getLcbHydroxyRangeStart() > -1 && generalSettings.getLcbHydroxyRangeStop() > -1) {
            if (generalSettings.getLcbHydroxyRangeStart() == generalSettings.getLcbHydroxyRangeStop()) {
                bw.write("\nLcbHydroxylationRange=" + String.valueOf(generalSettings.getLcbHydroxyRangeStart()));
            } else {
                bw.write("\nLcbHydroxylationRange=" + String.valueOf(generalSettings.getLcbHydroxyRangeStart()) + "-" + String.valueOf(generalSettings.getLcbHydroxyRangeStop()));
            }
        }
        bw.write("\nBasePeakCutoff=");
        if (generalSettings.getBasePeakCutoff() != null) {
            bw.write(generalSettings.getBasePeakCutoff());
        }
        if (generalSettings.getChainCutoff() != null) {
            bw.write("\nChainCutoff=" + String.valueOf(generalSettings.getChainCutoff()));
        }
        if (generalSettings.getSpectrumCoverage() != null) {
            bw.write("\nSpectrumCoverage=" + generalSettings.getSpectrumCoverage());
        }
        bw.write("\n");
        if (generalSettings.isRtPostProcessing()) {
            bw.write("RetentionTimePostprocessing=" + String.valueOf(generalSettings.isRtPostProcessing()) + "\n");
        }
        if (generalSettings.isRtParallelSeries()) {
            bw.write("RetentionTimeParallelSeries=" + String.valueOf(generalSettings.isRtParallelSeries()) + "\n");
        }
        if (generalSettings.getRtMaxDeviation() != null) {
            bw.write("RetentionTimeMaxDeviation=" + String.valueOf(generalSettings.getRtMaxDeviation()) + "\n");
        }
        if (generalSettings.isAllowSingleChain()) {
            bw.write("SingleChainIdentification=" + String.valueOf(generalSettings.isAllowSingleChain()) + "\n");
        }
        if (generalSettings.getMsIdentificationOrder() != 0) {
            bw.write("MSIdentificationOrder=");
            if (generalSettings.getMsIdentificationOrder() == 1) {
                bw.write("MSnFirst\n");
            } else if (generalSettings.getMsIdentificationOrder() == 2) {
                bw.write("MSnOnly\n");
            } else {
                bw.close();
                throw new RulesException("The value " + generalSettings.getMsIdentificationOrder() + " is not allowed for writing " + GENERAL_IDENTIFICATION_ORDER);
            }
        }
        if (generalSettings.getAddChainPositions() != null && generalSettings.getAddChainPositions() > 0) {
            bw.write("AddChainPositions=" + String.valueOf(generalSettings.getAddChainPositions()) + "\n");
        }
        FragRuleParser.writeSection(bw, HEAD_SECTION_NAME, headFragments, headIntensityRules);
        FragRuleParser.writeSection(bw, CHAINS_SECTION_NAME, chainFragments, chainIntensityRules);
        if (chainFragments.size() != 0 && positionIntensityRules != null && positionIntensityRules.size() > 0) {
            FragRuleParser.writeSection(bw, POSITION_SECTION_NAME, null, positionIntensityRules);
        }
        bw.close();
    }

    private static void writeSection(BufferedWriter bw, String section, Vector<FragmentRuleVO> fragments, Vector<IntensityRuleVO> intRules) throws IOException {
        boolean writeIntensities = false;
        boolean fragmentsWritten = false;
        if (section.equalsIgnoreCase(POSITION_SECTION_NAME)) {
            bw.write("\n");
            bw.write(section + "\n");
            writeIntensities = true;
        }
        if (fragments != null && fragments.size() != 0) {
            writeIntensities = true;
            bw.write("\n");
            bw.write(section + "\n");
            bw.write("!FRAGMENTS\n");
            for (int i = 0; i < fragments.size(); ++i) {
                FragRuleParser.writeFragmentRule(bw, fragments.get(i));
            }
            fragmentsWritten = true;
        }
        if (writeIntensities && intRules != null && intRules.size() != 0) {
            if (fragmentsWritten) {
                bw.write("\n");
            }
            bw.write("!INTENSITIES\n");
            int headIntensityRulesSize = intRules.size();
            if (headIntensityRulesSize != 0) {
                for (int i = 0; i < headIntensityRulesSize; ++i) {
                    FragRuleParser.writeIntensityRule(bw, intRules.get(i));
                }
            }
        }
    }

    private static void writeFragmentRule(BufferedWriter bw, FragmentRuleVO rule) throws IOException {
        String mandatory = "false";
        if (rule.isMandatory() == 1) {
            mandatory = "true";
        } else if (rule.isMandatory() == 2) {
            mandatory = "other";
        }
        bw.write("Name=" + rule.getName() + "\t" + FRAGMENT_FORMULA + "=" + rule.getFormula() + "\t" + FRAGMENT_CHARGE + "=" + Integer.toString(rule.getCharge()) + "\t" + FRAGMENT_LEVEL + "=" + Integer.toString(rule.getMsLevel()) + "\tmandatory=" + mandatory + "\n");
    }

    private static void writeIntensityRule(BufferedWriter bw, IntensityRuleVO rule) throws IOException {
        String mandatory = "false";
        if (rule.isMandatory()) {
            mandatory = "true";
        }
        bw.write("Equation=" + rule.getRuleIdentifier() + "\tmandatory=" + mandatory + "\n");
    }

    private static boolean useAlex() {
        if (!alexSet_) {
            alexSet_ = true;
            try {
                Class.forName("at.tugraz.genome.lda.Settings");
                useAlex_ = Settings.useAlex();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return useAlex_;
    }

    private RangeInteger parseRangeEntry(String value, String param, int lineNumber, short chainType) throws RulesException {
        int stop;
        int start;
        block8: {
            if (value.indexOf("-") != -1) {
                String[] splitted = value.split("-");
                try {
                    start = this.parseHydroxyEncodedValue(splitted[0], lineNumber, chainType);
                    stop = this.parseHydroxyEncodedValue(splitted[1], lineNumber, chainType);
                    if (stop < start) {
                        throw new RulesException("The parameter \"" + param + "\" is a range where the lower value must come first; the value \"" + value + "\") at line " + lineNumber + " does not comply!");
                    }
                    break block8;
                }
                catch (RulesException nfx) {
                    if (nfx.getMessage().indexOf("The value of") != -1 && nfx.getMessage().indexOf("must be in your") != -1) {
                        throw nfx;
                    }
                    nfx.printStackTrace();
                    throw new RulesException("The parameter \"" + param + "\" must be a single integer, or a range in the format $lower$-$higher$; the value \"" + value + "\" at line " + lineNumber + " does not comply!");
                }
            }
            try {
                int number;
                start = number = this.parseHydroxyEncodedValue(value, lineNumber, chainType);
                stop = number;
            }
            catch (RulesException nfx) {
                if (nfx.getMessage().indexOf("The value of") != -1 && nfx.getMessage().indexOf("must be in your") != -1) {
                    throw nfx;
                }
                throw new RulesException("The parameter \"" + param + "\" must be a single integer, or a range in the format $lower$-$higher$; the value \"" + value + "\" at line " + lineNumber + " does not comply!");
            }
        }
        return new RangeInteger(start, stop);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseHydroxyEncodedValue(String value, int lineNumber, short chainType) throws RulesException {
        String hydroxyEncoded = new String(value);
        int hydroxyNumber = -1;
        try {
            hydroxyNumber = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (hydroxyNumber > -1) {
            try {
                if (hydroxyNumber <= 0) return hydroxyNumber;
                if (chainType == 0) {
                    hydroxyEncoded = Settings.getFaHydroxyEncoding().getEncodedPrefix((short)hydroxyNumber);
                    return hydroxyNumber;
                }
                if (chainType != 3) throw new RulesException("The chain type \"" + chainType + "\" is not allowed!");
                hydroxyEncoded = Settings.getLcbHydroxyEncoding().getEncodedPrefix((short)hydroxyNumber);
                return hydroxyNumber;
            }
            catch (HydroxylationEncodingException hex) {
                throw new RulesException("The value of " + value + " must be in your hydroxylationEncoding.txt, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
        } else {
            try {
                if (hydroxyNumber <= 0) return hydroxyNumber;
                if (chainType == 0) {
                    return Settings.getFaHydroxyEncoding().getHydroxyNumber(hydroxyEncoded).shortValue();
                }
                if (chainType != 3) throw new RulesException("The chain type \"" + chainType + "\" is not allowed!");
                return Settings.getLcbHydroxyEncoding().getHydroxyNumber(hydroxyEncoded).shortValue();
            }
            catch (HydroxylationEncodingException hex) {
                throw new RulesException("The value of " + hydroxyEncoded + " must be in your hydroxylationEncoding.txt, the value \"" + value + "\" is not! Error at line number " + lineNumber + "!");
            }
        }
    }

    private short parseMandatoryLevel(String value, int currentSection, int lineNumber, boolean extendedOptions) throws RulesException {
        int mandatory = 0;
        if (extendedOptions) {
            if (!(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("other") || value.equalsIgnoreCase("quant") || value.equalsIgnoreCase("class"))) {
                throw new RulesException("The value of mandatory can contain the values \"true\",\"false\",\"yes\",\"no\",\"class\", and \"other\" only! Error at line number " + lineNumber + "!");
            }
        } else if (!(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no"))) {
            throw new RulesException("The value of mandatory can contain the values \"true\",\"false\",\"yes\" and \"no\" only! Error at line number " + lineNumber + "!");
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            mandatory = 1;
        } else if (value.equalsIgnoreCase("other")) {
            mandatory = 2;
        } else if (value.equalsIgnoreCase("quant")) {
            mandatory = 3;
        } else if (value.equalsIgnoreCase("class")) {
            if (currentSection != 3) {
                throw new RulesException("The value \"class\" of mandatory is allowed only in \"[CHAINS]\"! Error at line number " + lineNumber + "!");
            }
            mandatory = 4;
        }
        return (short)mandatory;
    }

    private RuleHydroxyRequirementSet parseAllowedOHs(String value, int currentSection, int lineNumber, boolean fragmentDef, boolean combiOh) throws RulesException {
        HashSet<String> allowedOHs = new HashSet<String>();
        String[] ohParts = value.split(",");
        Vector<RuleHydroxyRequirementsVO> ohVOs = new Vector<RuleHydroxyRequirementsVO>();
        for (String ohPart : ohParts) {
            short ohMandatory = -1;
            String oh = ohPart;
            if (ohPart.indexOf("=") != -1) {
                oh = ohPart.substring(0, ohPart.indexOf("="));
                try {
                    ohMandatory = this.parseMandatoryLevel(ohPart.substring(ohPart.indexOf("=") + 1), currentSection, lineNumber, fragmentDef);
                }
                catch (RulesException rex) {
                    throw new RulesException("The same applies for the mandatory definition of \"oh\" as for \"mandatory\": " + rex.getMessage());
                }
            }
            short ohNumber = -1;
            short chainType = -1;
            try {
                if (oh.startsWith("$CHAIN")) {
                    chainType = 0;
                    oh = oh.substring("$CHAIN".length());
                } else if (oh.startsWith("$ALKYLCHAIN")) {
                    chainType = 1;
                    oh = oh.substring("$ALKYLCHAIN".length());
                } else if (oh.startsWith("$ALKENYLCHAIN")) {
                    chainType = 2;
                    oh = oh.substring("$ALKENYLCHAIN".length());
                } else if (oh.startsWith("$LCB")) {
                    chainType = 3;
                    oh = oh.substring("$LCB".length());
                }
                ohNumber = Short.parseShort(oh);
            }
            catch (NumberFormatException nfx) {
                try {
                    ohNumber = Settings.getLcbHydroxyEncoding().getHydroxyNumber(oh);
                }
                catch (HydroxylationEncodingException e) {
                    throw new RulesException("The OH-Number \"" + oh + "\" of \"" + FRAGMENT_HYDROXY + "\" is whether an integer number nor present in the hydroxylation encodings! Error at line number " + lineNumber + "!");
                }
            }
            if ((fragmentDef && !combiOh || currentSection == 2) && chainType != -1) {
                throw new RulesException("Hydroxylation specifications are neither for !FRAGMENTS nor for [HEAD] sections allowed! Error at line number " + lineNumber + "!");
            }
            try {
                Settings.getLcbHydroxyEncoding().getEncodedPrefix(ohNumber);
            }
            catch (HydroxylationEncodingException e) {
                try {
                    Settings.getFaHydroxyEncoding().getEncodedPrefix(ohNumber);
                }
                catch (HydroxylationEncodingException ex) {
                    throw new RulesException("The OH-Number \"" + ohNumber + "\" of \"" + FRAGMENT_HYDROXY + "\" is not present in the hydroxylation encodings! Error at line number " + lineNumber + "!");
                }
            }
            String id = String.valueOf(chainType) + "," + String.valueOf(ohNumber);
            if (allowedOHs.contains(id)) {
                throw new RulesException("There is two times the same OH definition (" + ohPart + ") at at line number " + lineNumber + "!");
            }
            allowedOHs.add(id);
            ohVOs.add(new RuleHydroxyRequirementsVO(ohNumber, chainType, ohMandatory));
        }
        return new RuleHydroxyRequirementSet(ohVOs);
    }
}

