/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.AdductVO;
import java.util.ArrayList;
import java.util.Hashtable;

public class LipidClassVO {
    private String lClass_;
    private boolean adductInsensitiveRtFilter_;
    private boolean pickBestMatchBySpectrumCoverage_;
    private int ohRangeFrom_;
    private int ohRangeTo_;
    private double rtRangeFrom_;
    private double rtRangeTo_;
    private ArrayList<AdductVO> adducts_;
    private String headGroupFormulaString_;
    private Hashtable<String, Integer> headgroupFormula_;
    private int minChainC_;
    private int maxChainC_;
    private int minChainDB_;
    private int maxChainDB_;
    private int numberOfFAChains_;
    private int numberOfLCBChains_;
    private String faChainList_;
    private String lcbChainList_;

    public LipidClassVO(String lClass, boolean adductInsensitiveRtFilter, boolean pickBestMatchBySpectrumCoverage, int ohRangeFrom, int ohRangeTo, double rtRangeFrom, double rtRangeTo, ArrayList<AdductVO> adducts, String headgroupFormula, int minChainC, int maxChainC, int minChainDB, int maxChainDB, int numberOfFAChains, int numberOfLCBChains, String faChainList, String lcbChainList) throws ChemicalFormulaException {
        this.lClass_ = lClass;
        this.adductInsensitiveRtFilter_ = adductInsensitiveRtFilter;
        this.pickBestMatchBySpectrumCoverage_ = pickBestMatchBySpectrumCoverage;
        this.ohRangeFrom_ = ohRangeFrom;
        this.ohRangeTo_ = ohRangeTo;
        this.rtRangeFrom_ = rtRangeFrom;
        this.rtRangeTo_ = rtRangeTo;
        this.adducts_ = adducts;
        this.headGroupFormulaString_ = headgroupFormula;
        this.headgroupFormula_ = StaticUtils.categorizeFormula(headgroupFormula, true);
        this.minChainC_ = minChainC;
        this.maxChainC_ = maxChainC;
        this.minChainDB_ = minChainDB;
        this.maxChainDB_ = maxChainDB;
        this.numberOfFAChains_ = numberOfFAChains;
        this.numberOfLCBChains_ = numberOfLCBChains;
        this.faChainList_ = faChainList;
        this.lcbChainList_ = lcbChainList;
    }

    public LipidClassVO(LipidClassVO other) throws ChemicalFormulaException {
        this(other.getLipidClass(), other.isAdductInsensitiveRtFilter(), other.isPickBestMatchBySpectrumCoverage(), other.getOhRangeFrom(), other.getOhRangeTo(), other.getRtRangeFrom(), other.getRtRangeTo(), other.getAdducts(), other.getHeadGroupFormulaString(), other.getMinChainC(), other.getMaxChainC(), other.getMinChainDB(), other.getMaxChainDB(), other.getNumberOfFAChains(), other.getNumberOfLCBChains(), other.getFAChainList(), other.getLCBChainList());
    }

    public LipidClassVO(String faChainList, String lcbChainList) {
        this.lClass_ = null;
        this.adductInsensitiveRtFilter_ = true;
        this.pickBestMatchBySpectrumCoverage_ = false;
        this.ohRangeFrom_ = 0;
        this.ohRangeTo_ = 0;
        this.rtRangeFrom_ = -1.0;
        this.rtRangeTo_ = -1.0;
        this.adducts_ = new ArrayList();
        this.headGroupFormulaString_ = null;
        this.headgroupFormula_ = null;
        this.minChainC_ = 1;
        this.maxChainC_ = 50;
        this.minChainDB_ = 0;
        this.maxChainDB_ = 12;
        this.numberOfFAChains_ = 2;
        this.numberOfLCBChains_ = 0;
        this.faChainList_ = faChainList;
        this.lcbChainList_ = lcbChainList;
    }

    public void updateFrom(LipidClassVO other) {
        if (other == null) {
            return;
        }
        this.lClass_ = other.lClass_;
        this.adductInsensitiveRtFilter_ = other.adductInsensitiveRtFilter_;
        this.pickBestMatchBySpectrumCoverage_ = other.pickBestMatchBySpectrumCoverage_;
        this.ohRangeFrom_ = other.ohRangeFrom_;
        this.ohRangeTo_ = other.ohRangeTo_;
        this.rtRangeFrom_ = other.rtRangeFrom_;
        this.rtRangeTo_ = other.rtRangeTo_;
        this.adducts_ = other.adducts_ == null ? new ArrayList() : new ArrayList<AdductVO>(other.adducts_);
        this.headGroupFormulaString_ = other.headGroupFormulaString_;
        this.headgroupFormula_ = other.headgroupFormula_ == null ? null : new Hashtable<String, Integer>(other.headgroupFormula_);
        this.minChainC_ = other.minChainC_;
        this.maxChainC_ = other.maxChainC_;
        this.minChainDB_ = other.minChainDB_;
        this.maxChainDB_ = other.maxChainDB_;
        this.numberOfFAChains_ = other.numberOfFAChains_;
        this.numberOfLCBChains_ = other.numberOfLCBChains_;
        this.faChainList_ = other.faChainList_;
        this.lcbChainList_ = other.lcbChainList_;
    }

    public String getLipidClass() {
        return this.lClass_;
    }

    public boolean isAdductInsensitiveRtFilter() {
        return this.adductInsensitiveRtFilter_;
    }

    public boolean isPickBestMatchBySpectrumCoverage() {
        return this.pickBestMatchBySpectrumCoverage_;
    }

    public int getOhNumber() {
        return this.getOhRangeFrom();
    }

    public int getOhRangeFrom() {
        return this.ohRangeFrom_;
    }

    public int getOhRangeTo() {
        return this.ohRangeTo_;
    }

    public double getRtRangeFrom() {
        return this.rtRangeFrom_;
    }

    public double getRtRangeTo() {
        return this.rtRangeTo_;
    }

    public ArrayList<AdductVO> getAdducts() {
        return this.adducts_;
    }

    public String getHeadGroupFormulaString() {
        return this.headGroupFormulaString_;
    }

    public Hashtable<String, Integer> getHeadgroupFormula() {
        return this.headgroupFormula_;
    }

    public int getMinChainC() {
        return this.minChainC_;
    }

    public int getMaxChainC() {
        return this.maxChainC_;
    }

    public int getMinChainDB() {
        return this.minChainDB_;
    }

    public int getMaxChainDB() {
        return this.maxChainDB_;
    }

    public int getNumberOfFAChains() {
        return this.numberOfFAChains_;
    }

    public int getNumberOfLCBChains() {
        return this.numberOfLCBChains_;
    }

    public String getFAChainList() {
        return this.faChainList_;
    }

    public String getLCBChainList() {
        return this.lcbChainList_;
    }

    public String getFAChainListPath() {
        return "./fattyAcids/" + this.faChainList_ + ".xlsx";
    }

    public String getLCBChainListPath() {
        return "./fattyAcids/" + this.lcbChainList_ + ".xlsx";
    }

    public void setLipidClass(String lClass) {
        this.lClass_ = lClass;
    }

    public void setAdductInsensitiveRtFilter(boolean adductInsensitiveRtFilter) {
        this.adductInsensitiveRtFilter_ = adductInsensitiveRtFilter;
    }

    public void setPickBestMatchBySpectrumCoverage(boolean pickBestMatchBySpectrumCoverage) {
        this.pickBestMatchBySpectrumCoverage_ = pickBestMatchBySpectrumCoverage;
    }

    public void setOhRangeFrom(int ohRangeFrom) {
        this.ohRangeFrom_ = ohRangeFrom;
    }

    public void setOhRangeTo(int ohRangeTo) {
        this.ohRangeTo_ = ohRangeTo;
    }

    public void setRtRangeFrom(double rtRangeFrom) {
        this.rtRangeFrom_ = rtRangeFrom;
    }

    public void setRtRangeTo(double rtRangeTo) {
        this.rtRangeTo_ = rtRangeTo;
    }

    public void setAdducts(ArrayList<AdductVO> adducts) {
        this.adducts_ = adducts;
    }

    public void setHeadGroupFormulaString(String headGroupFormulaString) throws ChemicalFormulaException {
        this.headGroupFormulaString_ = headGroupFormulaString;
        this.headgroupFormula_ = null;
        this.headgroupFormula_ = StaticUtils.categorizeFormula(headGroupFormulaString, true);
    }

    public void setMinChainC(int minChainC) {
        this.minChainC_ = minChainC;
    }

    public void setMaxChainC(int maxChainC) {
        this.maxChainC_ = maxChainC;
    }

    public void setMinChainDB(int minChainDB) {
        this.minChainDB_ = minChainDB;
    }

    public void setMaxChainDB(int maxChainDB) {
        this.maxChainDB_ = maxChainDB;
    }

    public void setNumberOfFAChains(int numberOfFAChains) {
        this.numberOfFAChains_ = numberOfFAChains;
    }

    public void setNumberOfLCBChains(int numberOfLCBChains) {
        this.numberOfLCBChains_ = numberOfLCBChains;
    }

    public void setFaChainList(String faChainList) {
        this.faChainList_ = faChainList;
    }

    public void setLCBChainList(String lcbChainList) {
        this.lcbChainList_ = lcbChainList;
    }
}

