/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.masslist.LipidClassVO;
import at.tugraz.genome.lda.vos.AdductVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class LipidClassParser {
    public static final String LIPID_CLASS_FOLDER = "." + File.separator + "massListCreation" + File.separator + "lipidClasses";
    public static final String LIPID_CLASS_SUFFIX = ".txt";
    public static final String ADDUCT_SEPARATOR = ",";
    public static final String LIPID_CLASS_NAME = "name";
    public static final String LIPID_CLASS_RT_FILTER = "adductInsensitiveRtFilter";
    public static final String LIPID_CLASS_PICK_BEST = "pickBestMatchBySpectrumCoverage";
    public static final String LIPID_CLASS_OH_RANGE_FROM = "OH_range_from";
    public static final String LIPID_CLASS_OH_RANGE_TO = "OH_range_to";
    public static final String LIPID_CLASS_RT_RANGE_FROM = "RT_range_from";
    public static final String LIPID_CLASS_RT_RANGE_TO = "RT_range_to";
    public static final String LIPID_CLASS_ADDUCTS = "adducts";
    public static final String LIPID_CLASS_FORMULA = "headgroup_formula";
    public static final String LIPID_CLASS_MIN_CHAIN_C = "min_chain_C";
    public static final String LIPID_CLASS_MAX_CHAIN_C = "max_chain_C";
    public static final String LIPID_CLASS_MIN_CHAIN_DB = "min_chain_DB";
    public static final String LIPID_CLASS_MAX_CHAIN_DB = "max_chain_DB";
    public static final String LIPID_NUMBER_FA_CHAINS = "number_of_FA_chains";
    public static final String LIPID_NUMBER_SPB_CHAINS = "number_of_SPB_chains";
    public static final String FA_LIST_NAME = "FA_chain_list_name";
    public static final String SPB_LIST_NAME = "SPB_chain_list_name";
    private ArrayList<AdductVO> allDefinedAdducts_;
    private String subfolder_ = LIPID_CLASS_FOLDER;

    public LipidClassParser(ArrayList<AdductVO> allDefinedAdducts, String subfolderName) {
        this.allDefinedAdducts_ = allDefinedAdducts;
        this.subfolder_ = subfolderName;
    }

    public ArrayList<LipidClassVO> parse() throws IOException, ChemicalFormulaException {
        ArrayList<LipidClassVO> allDefinedLipidClasses = new ArrayList<LipidClassVO>();
        File placeholderFile = null;
        LipidClassVO placeholder = null;
        File folder = new File(this.subfolder_);
        if (!folder.exists()) {
            throw new IOException(String.format("The lipid class folder '%s' does not exist!", this.subfolder_));
        }
        File[] fileCandidates = folder.listFiles();
        for (int i = 0; i < fileCandidates.length; ++i) {
            if (!fileCandidates[i].getName().endsWith(LIPID_CLASS_SUFFIX)) continue;
            try (FileInputStream in = new FileInputStream(fileCandidates[i]);){
                Properties properties = new Properties();
                properties.load(in);
                String name = properties.getProperty(LIPID_CLASS_NAME, null);
                boolean adductInsensitiveRtFilter = Boolean.parseBoolean(properties.getProperty(LIPID_CLASS_RT_FILTER, null));
                boolean pickBestMatchBySpectrumCoverage = Boolean.parseBoolean(properties.getProperty(LIPID_CLASS_PICK_BEST, null));
                int ohRangeFrom = Integer.parseInt(properties.getProperty(LIPID_CLASS_OH_RANGE_FROM, null));
                int ohRangeTo = Integer.parseInt(properties.getProperty(LIPID_CLASS_OH_RANGE_TO, null));
                double rtRangeFrom = Double.parseDouble(properties.getProperty(LIPID_CLASS_RT_RANGE_FROM, null));
                double rtRangeTo = Double.parseDouble(properties.getProperty(LIPID_CLASS_RT_RANGE_FROM, null));
                String adducts = properties.getProperty(LIPID_CLASS_ADDUCTS, null);
                String headgroupFormula = properties.getProperty(LIPID_CLASS_FORMULA, null);
                int minChainC = Integer.parseInt(properties.getProperty(LIPID_CLASS_MIN_CHAIN_C, null));
                int maxChainC = Integer.parseInt(properties.getProperty(LIPID_CLASS_MAX_CHAIN_C, null));
                int minChainDB = Integer.parseInt(properties.getProperty(LIPID_CLASS_MIN_CHAIN_DB, null));
                int maxChainDB = Integer.parseInt(properties.getProperty(LIPID_CLASS_MAX_CHAIN_DB, null));
                int numberOfFAChains = Integer.parseInt(properties.getProperty(LIPID_NUMBER_FA_CHAINS, null));
                int numberOfLCBChains = Integer.parseInt(properties.getProperty(LIPID_NUMBER_SPB_CHAINS, null));
                String faChainList = properties.getProperty(FA_LIST_NAME, null);
                String spbChainList = properties.getProperty(SPB_LIST_NAME, null);
                if (name != null && adducts != null && headgroupFormula != null && (faChainList != null || spbChainList != null)) {
                    ArrayList<AdductVO> selectedAdducts = this.matchSelectedAdducts(adducts, fileCandidates[i].getName());
                    LipidClassVO vo = new LipidClassVO(name, adductInsensitiveRtFilter, pickBestMatchBySpectrumCoverage, ohRangeFrom, ohRangeTo, rtRangeFrom, rtRangeTo, selectedAdducts, headgroupFormula, minChainC, maxChainC, minChainDB, maxChainDB, numberOfFAChains, numberOfLCBChains, faChainList, spbChainList);
                    allDefinedLipidClasses.add(vo);
                    if (name.equalsIgnoreCase("placeholder")) {
                        placeholderFile = fileCandidates[i];
                        placeholder = vo;
                    }
                    continue;
                }
                throw new IOException(String.format("The lipid class definition file '%s' does not adhere to the required format!", fileCandidates[i].getName()));
            }
            catch (NumberFormatException ex) {
                throw new IOException(String.format("The lipid class definition file '%s' does not adhere to the required format!", fileCandidates[i].getName()));
            }
        }
        if (placeholderFile != null && allDefinedLipidClasses.size() > 1) {
            placeholderFile.delete();
            allDefinedLipidClasses.remove(placeholder);
        }
        return allDefinedLipidClasses;
    }

    private ArrayList<AdductVO> matchSelectedAdducts(String adducts, String fileName) throws IOException {
        ArrayList<AdductVO> selectedAdducts = new ArrayList<AdductVO>();
        String[] adductNames = adducts.split(ADDUCT_SEPARATOR);
        for (int j = 0; j < adductNames.length; ++j) {
            boolean matched = false;
            for (AdductVO adduct : this.allDefinedAdducts_) {
                if (!adduct.getAdductName().equalsIgnoreCase(adductNames[j])) continue;
                selectedAdducts.add(adduct);
                matched = true;
            }
            if (matched) continue;
            throw new IOException(String.format("The provided adduct name '%s' for the lipid class definition file '%s' is not defined!", adductNames[j], fileName));
        }
        return selectedAdducts;
    }

    private void setClassFolderPath(String subfolder) {
        this.subfolder_ = subfolder;
    }
}

