/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.masslist.LipidClassVO;
import at.tugraz.genome.lda.vos.AdductVO;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;

public class LipidClassExporter {
    private LipidClassVO toExport_;
    private String filePath_;

    public LipidClassExporter(LipidClassVO toExport, String filePath) {
        this.toExport_ = toExport;
        this.filePath_ = filePath;
    }

    public void export() {
        try (FileOutputStream out = new FileOutputStream(LipidClassExporter.buildLipidClassPath(this.toExport_.getLipidClass(), this.filePath_));){
            out.write("## The parameter 'name' defines the name of this lipid class.\n".getBytes());
            out.write(String.format("%s=%s\n", "name", this.toExport_.getLipidClass()).getBytes());
            out.write("## When set to 'true', the parameter 'adductInsensitiveRtFilter' forces the RT filter to be calculated based on all modifications\n".getBytes());
            out.write(String.format("%s=%s\n", "adductInsensitiveRtFilter", this.toExport_.isAdductInsensitiveRtFilter()).getBytes());
            out.write("## When set to 'true', the parameter 'pickBestMatchBySpectrumCoverage' the best matches are picked from duplicates (same lipid class and scan number) by spectrum coverage.\n".getBytes());
            out.write(String.format("%s=%s\n", "pickBestMatchBySpectrumCoverage", this.toExport_.isPickBestMatchBySpectrumCoverage()).getBytes());
            out.write("## Number of 'OH groups' present in the fatty acyl (FA) and long chain base (LCB) chains of this lipid class, \n".getBytes());
            out.write("## and 'OH_range_from' and 'OH_range_to' define the lower and upper limit of the number of 'OH groups', respectively, which the algorithm identifies compounds for. \n".getBytes());
            out.write("## Which number is chosen for 'OH_number' from the biologically relevant range for sphingolipids does not influence the algorithm. \n".getBytes());
            out.write("## ATTENTION: this parameter should only be used for sphingolipids. \n".getBytes());
            out.write(String.format("%s=%s\n", "OH_range_from", this.toExport_.getOhRangeFrom()).getBytes());
            out.write(String.format("%s=%s\n", "OH_range_to", this.toExport_.getOhRangeTo()).getBytes());
            out.write("## Optional definition of the retention time (RT) range (the lower limit is defined with 'RT_range_from' and the upper limit with 'RT_range_to') that this lipid class elutes at. \n".getBytes());
            out.write(String.format("%s=%s\n", "RT_range_from", this.toExport_.getRtRangeFrom()).getBytes());
            out.write(String.format("%s=%s\n", "RT_range_to", this.toExport_.getRtRangeTo()).getBytes());
            out.write("## The parameter 'adducts' allows for the definition of adducts relevant for this lipid class. \n".getBytes());
            out.write("## The given names must correspond to names (parameter 'name') of adducts defined in .txt files in the folder ./massListCreation/adducts \n".getBytes());
            out.write("## Multiple names are separated with a comma and no spaces, e.g. adductName1,adductName2,adductName3 \n".getBytes());
            StringBuilder builder = new StringBuilder();
            builder.append(this.toExport_.getAdducts().get(0).getAdductName());
            for (int i = 1; i < this.toExport_.getAdducts().size(); ++i) {
                builder.append(",");
                builder.append(this.toExport_.getAdducts().get(i).getAdductName());
            }
            out.write(String.format("%s=%s\n", "adducts", builder.toString()).getBytes());
            out.write("## The parameter 'headgroup_formula' defines the chemical formula of the headgroup (without chains) \n".getBytes());
            out.write(String.format("%s=%s\n", "headgroup_formula", this.toExport_.getHeadGroupFormulaString()).getBytes());
            out.write("## The parameters 'min_chain_C' and 'max_chain_C' describe the minimum and maximum total number of C atoms in chains to be included in the mass list \n".getBytes());
            out.write(String.format("%s=%s\n", "min_chain_C", this.toExport_.getMinChainC()).getBytes());
            out.write(String.format("%s=%s\n", "max_chain_C", this.toExport_.getMaxChainC()).getBytes());
            out.write("## The parameters 'min_chain_DB' and 'max_chain_DB' describe the minimum and maximum total number of double bonds in chains to be considered in the mass list \n".getBytes());
            out.write(String.format("%s=%s\n", "min_chain_DB", this.toExport_.getMinChainDB()).getBytes());
            out.write(String.format("%s=%s\n", "max_chain_DB", this.toExport_.getMaxChainDB()).getBytes());
            out.write("## The parameter 'number_of_FA_chains' allows for the definition of the number of FA chains present in this lipid class. \n".getBytes());
            out.write(String.format("%s=%s\n", "number_of_FA_chains", this.toExport_.getNumberOfFAChains()).getBytes());
            out.write("## The parameter 'number_of_LCB_chains' allows for the definition of the number of LCB chains present in this lipid class. \n".getBytes());
            out.write(String.format("%s=%s\n", "number_of_SPB_chains", this.toExport_.getNumberOfLCBChains()).getBytes());
            out.write("## The parameter 'FA_chain_list_name' allows for the definition of a FA chain list name (without suffix, must be present in the folder ./fattyAcids) to base the mass list on. \n".getBytes());
            out.write("## Only compounds that are possible given the entries in the provided chain list will be included in the resulting mass list. \n".getBytes());
            out.write("## If the chain list includes stable isotope labeled chains, those will be included in all possible combinations in the generated mass list file. \n".getBytes());
            out.write(String.format("%s=%s\n", "FA_chain_list_name", this.toExport_.getFAChainList()).getBytes());
            out.write("## The parameter 'LCB_chain_list_name' allows for the definition of a LCB chain list name (without suffix, must be present in the folder ./fattyAcids) to base the mass list on. \n".getBytes());
            out.write("## Only compounds that are possible given the entries in the provided chain list will be included in the resulting mass list. \n".getBytes());
            out.write("## If the chain list includes stable isotope labeled chains, those will be included in all possible combinations in the generated mass list file. \n".getBytes());
            out.write(String.format("%s=%s\n", "SPB_chain_list_name", this.toExport_.getLCBChainList()).getBytes());
        }
        catch (IOException ex) {
            new WarningMessage(new JFrame(), "Error", "The export of the adduct definition file failed. Error message: " + ex.getMessage());
        }
    }

    public void exportDummy(AdductVO dummyAdduct) {
        try (FileOutputStream out = new FileOutputStream(LipidClassExporter.buildLipidClassPath("placeholder", this.filePath_));){
            out.write("## The parameter 'name' defines the name of this lipid class.\n".getBytes());
            out.write(String.format("%s=%s\n", "name", "placeholder").getBytes());
            out.write("## When set to 'true', the parameter 'adductInsensitiveRtFilter' forces the RT filter to be calculated based on all modifications\n".getBytes());
            out.write(String.format("%s=%s\n", "adductInsensitiveRtFilter", false).getBytes());
            out.write("## When set to 'true', the parameter 'pickBestMatchBySpectrumCoverage' the best matches are picked from duplicates (same lipid class and scan number) by spectrum coverage.\n".getBytes());
            out.write(String.format("%s=%s\n", "pickBestMatchBySpectrumCoverage", false).getBytes());
            out.write("## Number of 'OH groups' present in the fatty acyl (FA) and long chain base (LCB) chains of this lipid class, \n".getBytes());
            out.write("## and 'OH_range_from' and 'OH_range_to' define the lower and upper limit of the number of 'OH groups', respectively, which the algorithm identifies compounds for. \n".getBytes());
            out.write("## Which number is chosen for 'OH_number' from the biologically relevant range for sphingolipids does not influence the algorithm. \n".getBytes());
            out.write("## ATTENTION: this parameter should only be used for sphingolipids. \n".getBytes());
            out.write(String.format("%s=%s\n", "OH_range_from", 0).getBytes());
            out.write(String.format("%s=%s\n", "OH_range_to", 0).getBytes());
            out.write("## Optional definition of the retention time (RT) range (the lower limit is defined with 'RT_range_from' and the upper limit with 'RT_range_to') that this lipid class elutes at. \n".getBytes());
            out.write(String.format("%s=%s\n", "RT_range_from", -1.0).getBytes());
            out.write(String.format("%s=%s\n", "RT_range_to", -1.0).getBytes());
            out.write("## The parameter 'adducts' allows for the definition of adducts relevant for this lipid class. \n".getBytes());
            out.write("## The given names must correspond to names (parameter 'name') of adducts defined in .txt files in the folder ./massListCreation/adducts \n".getBytes());
            out.write("## Multiple names are separated with a comma and no spaces, e.g. adductName1,adductName2,adductName3 \n".getBytes());
            out.write(String.format("%s=%s\n", "adducts", dummyAdduct.getAdductName()).getBytes());
            out.write("## The parameter 'headgroup_formula' defines the chemical formula of the headgroup (without chains) \n".getBytes());
            out.write(String.format("%s=%s\n", "headgroup_formula", "H2O").getBytes());
            out.write("## The parameters 'min_chain_C' and 'max_chain_C' describe the minimum and maximum total number of C atoms in chains to be included in the mass list \n".getBytes());
            out.write(String.format("%s=%s\n", "min_chain_C", 0).getBytes());
            out.write(String.format("%s=%s\n", "max_chain_C", 0).getBytes());
            out.write("## The parameters 'min_chain_DB' and 'max_chain_DB' describe the minimum and maximum total number of double bonds in chains to be considered in the mass list \n".getBytes());
            out.write(String.format("%s=%s\n", "min_chain_DB", 0).getBytes());
            out.write(String.format("%s=%s\n", "max_chain_DB", 0).getBytes());
            out.write("## The parameter 'number_of_FA_chains' allows for the definition of the number of FA chains present in this lipid class. \n".getBytes());
            out.write(String.format("%s=%s\n", "number_of_FA_chains", 0).getBytes());
            out.write("## The parameter 'number_of_LCB_chains' allows for the definition of the number of LCB chains present in this lipid class. \n".getBytes());
            out.write(String.format("%s=%s\n", "number_of_SPB_chains", 0).getBytes());
            out.write("## The parameter 'FA_chain_list_name' allows for the definition of a FA chain list name (without suffix, must be present in the folder ./fattyAcids) to base the mass list on. \n".getBytes());
            out.write("## Only compounds that are possible given the entries in the provided chain list will be included in the resulting mass list. \n".getBytes());
            out.write("## If the chain list includes stable isotope labeled chains, those will be included in all possible combinations in the generated mass list file. \n".getBytes());
            out.write(String.format("%s=%s\n", "FA_chain_list_name", "").getBytes());
            out.write("## The parameter 'LCB_chain_list_name' allows for the definition of a LCB chain list name (without suffix, must be present in the folder ./fattyAcids) to base the mass list on. \n".getBytes());
            out.write("## Only compounds that are possible given the entries in the provided chain list will be included in the resulting mass list. \n".getBytes());
            out.write("## If the chain list includes stable isotope labeled chains, those will be included in all possible combinations in the generated mass list file. \n".getBytes());
            out.write(String.format("%s=%s\n", "SPB_chain_list_name", "").getBytes());
        }
        catch (IOException ex) {
            new WarningMessage(new JFrame(), "Error", "The export of the lipid class definition file failed. Error message: " + ex.getMessage());
        }
    }

    public static String buildLipidClassPath(String lipidClass, String filePath) {
        return filePath + "/" + lipidClass + ".txt";
    }
}

