/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.math3.util.Pair;

public class GradientAdjuster {
    private ArrayList<Pair<Double, Double>> dataPoints_;
    private static final Integer NO_TIE = 1;

    protected GradientAdjuster(ArrayList<Pair<Double, Double>> dataPoints) {
        Collections.sort(dataPoints, new SortByKey());
        this.dataPoints_ = dataPoints;
    }

    protected Double getGradientAdjustedValue(Double isotopeEffect, Double preciseRT) {
        Double adjustedTIE = isotopeEffect;
        for (int i = 0; i < this.dataPoints_.size() - 1; ++i) {
            Pair<Double, Double> dataPoint = this.dataPoints_.get(i);
            Pair<Double, Double> dataPointNext = this.dataPoints_.get(i + 1);
            if (!(preciseRT > dataPoint.getKey()) || !(preciseRT < dataPointNext.getKey())) continue;
            double factor = this.getAdjustmentFactorForPoint(dataPoint, dataPointNext, preciseRT);
            adjustedTIE = (isotopeEffect - (double)NO_TIE.intValue()) / factor + (double)NO_TIE.intValue();
        }
        return adjustedTIE * preciseRT;
    }

    private Double getAdjustmentFactorForPoint(Pair<Double, Double> dataPoint, Pair<Double, Double> dataPointNext, Double preciseRT) {
        double m = (dataPointNext.getValue() - dataPoint.getValue()) / (dataPointNext.getKey() - dataPoint.getKey());
        double b = dataPoint.getValue() - m * dataPoint.getKey();
        return m * preciseRT + b;
    }

    private class SortByKey
    implements Comparator<Pair<Double, Double>> {
        private SortByKey() {
        }

        @Override
        public int compare(Pair<Double, Double> arg0, Pair<Double, Double> arg1) {
            return Double.compare(arg0.getKey(), arg1.getKey());
        }
    }
}

