/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.experiment;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.lccl.IsotopeLabelVO;
import at.tugraz.genome.lda.lccl.experiment.MatchedPartnerVO;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class IsotopeEffectRegression {
    private Vector<MatchedPartnerVO> matchedIsotopologues_;
    private PolynomialSplineFunction function_;
    private final int MAX_DEUTERIUM_ALLOWED;

    protected IsotopeEffectRegression(Vector<MatchedPartnerVO> matchedIsotopologues, Vector<IsotopeLabelVO> labels) {
        this.matchedIsotopologues_ = matchedIsotopologues;
        this.MAX_DEUTERIUM_ALLOWED = this.findMaximumDeuteriumAllowed(labels);
        this.initRegression();
    }

    private int findMaximumDeuteriumAllowed(Vector<IsotopeLabelVO> labels) {
        int maxD = 0;
        for (IsotopeLabelVO label : labels) {
            if (!label.getLabelElements().containsKey("D") || label.getLabelElements().get("D") <= maxD) continue;
            maxD = label.getLabelElements().get("D");
        }
        return maxD;
    }

    protected void initRegression() {
        SplineInterpolator interpolator = new SplineInterpolator();
        Hashtable dataPoints = new Hashtable();
        for (MatchedPartnerVO matched : this.matchedIsotopologues_) {
            if (!matched.isUseForCalibration()) continue;
            LipidomicsMSnSet standard = matched.getStandard();
            double standardRT = standard.getPreciseRT();
            LipidomicsMSnSet isotopologue = matched.getIsotopologue();
            double isotopologueRT = isotopologue.getPreciseRT();
            try {
                Hashtable<String, Integer> chemicalFormula = StaticUtils.categorizeFormula(isotopologue.getChemicalFormula());
                int numberDeuterium = chemicalFormula.get("D");
                double totalIsotopeEffect = standardRT / isotopologueRT;
                if (!dataPoints.containsKey(numberDeuterium)) {
                    dataPoints.put(numberDeuterium, new ArrayList());
                }
                ((ArrayList)dataPoints.get(numberDeuterium)).add(totalIsotopeEffect);
            }
            catch (ChemicalFormulaException ex) {
                ex.printStackTrace();
            }
        }
        ArrayList numD = new ArrayList();
        numD.addAll(dataPoints.keySet());
        Collections.sort(numD);
        double[] xValues = new double[numD.size() + 1];
        double[] yValues = new double[numD.size() + 1];
        xValues[0] = 0.0;
        yValues[0] = 1.0;
        for (int i = 1; i < numD.size() + 1; ++i) {
            xValues[i] = ((Integer)numD.get(i - 1)).intValue();
            Double yValue = 0.0;
            for (Double value : (ArrayList)dataPoints.get(numD.get(i - 1))) {
                yValue = yValue + value;
            }
            yValue = yValue / (double)((ArrayList)dataPoints.get(numD.get(i - 1))).size();
            yValues[i] = yValue;
        }
        this.function_ = dataPoints.size() > 1 ? interpolator.interpolate(xValues, yValues) : null;
    }

    public double getIsotopeEffect(double numberDeuterium) {
        return this.function_.value(numberDeuterium);
    }

    public double getIsotopeEffect(int numberDeuterium) {
        return this.function_.value(numberDeuterium);
    }

    public double getRTofUnlabeledSpecies(int numberDeuterium, double retentionTime) {
        return this.getIsotopeEffect(numberDeuterium) * retentionTime;
    }

    public int getMaxNumDeuteriumAllowed() {
        return this.MAX_DEUTERIUM_ALLOWED;
    }
}

