/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.experiment;

import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.experiment.ExperimentFileChooserPanel;
import at.tugraz.genome.lda.lccl.experiment.ExperimentGraphPanel;
import at.tugraz.genome.lda.lccl.experiment.ExperimentLabelDefinitionPanel;
import at.tugraz.genome.lda.lccl.experiment.ExperimentStandardsFileChooserPanel;
import at.tugraz.genome.lda.lccl.experiment.ExperimentTableInputPanel;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.utils.UpdatablePair;
import at.tugraz.genome.lda.vos.ResultFileVO;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ExperimentStandardsDefinitionPanel
extends ExperimentTableInputPanel {
    private static final long serialVersionUID = 1L;
    private static final int EDITABLE_COLUMN = 2;
    private Vector<UpdatablePair<ResultFileVO, Integer>> positions_;

    public ExperimentStandardsDefinitionPanel(JDefaultComponents wizardComponents, ExperimentFileChooserPanel standardsFileChooserPanel) {
        super(wizardComponents, standardsFileChooserPanel, "Create RT-DB using experimental data of SIL specific for \u03c9-positions.", "Enter the \u03c9-position associated with each authentic standard file.");
    }

    @Override
    public void initDataDisplay() {
        this.cleanPanels();
        this.positions_ = new Vector();
        String[] columnNames = new String[]{"File Name", "Directory", "Enter \u03c9-position here!"};
        Object[][] tableData = this.generateTableData();
        this.getDefaultComponents().updateComponents();
        this.init(this.generateDisplayPanel(columnNames, tableData, 2));
    }

    @Override
    protected Object[][] generateTableData() {
        Object[][] tableData = new Object[this.getResultFiles().size()][3];
        int count = 0;
        for (ResultFileVO resultFileVO : this.getResultFiles()) {
            tableData[count][0] = StaticUtils.extractFileName(resultFileVO.getFileName());
            tableData[count][1] = StaticUtils.extractDirName(resultFileVO.getFileName());
            tableData[count][2] = 0;
            ++count;
            this.positions_.add(new UpdatablePair<ResultFileVO, Integer>(resultFileVO, 0));
        }
        return tableData;
    }

    @Override
    protected void updateValue(int row, int value) {
        this.positions_.get(row).setValue(value);
    }

    private Vector<UpdatablePair<ResultFileVO, Integer>> getAssignedPositions(Vector<UpdatablePair<ResultFileVO, Integer>> positions) {
        Vector<UpdatablePair<ResultFileVO, Integer>> assignedPositions = new Vector<UpdatablePair<ResultFileVO, Integer>>();
        for (UpdatablePair<ResultFileVO, Integer> position : positions) {
            if (position.getValue() <= 0) continue;
            assignedPositions.add(position);
        }
        return assignedPositions;
    }

    @Override
    protected void back() {
        try {
            this.getDefaultComponents().removeOptionPanel(this.getDefaultComponents().getCurrentPanel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.goBack();
    }

    @Override
    protected void next() {
        final Vector<UpdatablePair<ResultFileVO, Integer>> assignedPositions = this.getAssignedPositions(this.positions_);
        if (assignedPositions.size() > 0) {
            try {
                if (!(this.getDefaultComponents().getNextPanel() instanceof ExperimentGraphPanel)) {
                    this.getDefaultComponents().addOptionPanelAfterCurrent(new ExperimentGraphPanel(this.getDefaultComponents()));
                }
                this.goNext();
                this.getDefaultComponents().disableAllButtons();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExperimentGraphPanel panel = (ExperimentGraphPanel)ExperimentStandardsDefinitionPanel.this.getDefaultComponents().getCurrentPanel();
                            ExperimentStandardsFileChooserPanel standardsFileChooserPanel = (ExperimentStandardsFileChooserPanel)ExperimentStandardsDefinitionPanel.this.getFileChooserPanel();
                            ExperimentLabelDefinitionPanel labelDefinitionPanel = (ExperimentLabelDefinitionPanel)standardsFileChooserPanel.getExperimentDefinitionPanel();
                            panel.matchIsotopologues(assignedPositions, labelDefinitionPanel);
                            panel.initDataDisplay();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(new JFrame(), "An error occurred: " + ex.getMessage(), "Error", 0);
                            ExperimentStandardsDefinitionPanel.this.goBack();
                        }
                    }
                });
                thread.start();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(new JFrame(), "An error occurred: " + ex.getMessage(), "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "You must specify the \u03c9-position for at least one authentic standard file before continuing!", "Warning", 2);
        }
    }
}

