/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.experiment;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.lccl.IsotopeLabelVO;
import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.experiment.ExperimentResultFileChooserPanel;
import at.tugraz.genome.lda.lccl.experiment.ExperimentStandardsFileChooserPanel;
import at.tugraz.genome.lda.lccl.experiment.ExperimentTableInputPanel;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ResultFileVO;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ExperimentLabelDefinitionPanel
extends ExperimentTableInputPanel {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_D = "D";
    private static final String ELEMENT_13C = "Cc";
    private static final int EDITABLE_COLUMN = 3;
    private Vector<IsotopeLabelVO> unambiguousIsotopeLabels_;

    public ExperimentLabelDefinitionPanel(JDefaultComponents wizardComponents, ExperimentResultFileChooserPanel experimentFileChooserPanel) {
        super(wizardComponents, experimentFileChooserPanel, "Create RT-DB using experimental data of SIL specific for \u03c9-positions.", "Enter the \u03c9-position associated with each detected SIL.");
    }

    @Override
    public void initDataDisplay() {
        this.cleanPanels();
        String[] columnNames = new String[]{"Label ID", "Isotope", "Amount of isotope atoms", "Enter \u03c9-position here!"};
        Object[][] tableData = this.generateTableData();
        this.getDefaultComponents().updateComponents();
        this.init(this.generateDisplayPanel(columnNames, tableData, 3));
    }

    @Override
    protected Object[][] generateTableData() {
        Object[][] tableData = new Object[this.unambiguousIsotopeLabels_.size()][4];
        int count = 0;
        for (IsotopeLabelVO labelVO : this.unambiguousIsotopeLabels_) {
            int isotopeAmount;
            String isotope;
            Hashtable<String, Integer> labelElements = labelVO.getLabelElements();
            if (labelElements.containsKey(ELEMENT_D) && labelElements.containsKey(ELEMENT_13C)) {
                isotope = "<html> D and <sup>13</sup>C </html>";
                isotopeAmount = labelElements.get(ELEMENT_D) + labelElements.get(ELEMENT_13C);
            } else if (labelElements.containsKey(ELEMENT_D)) {
                isotope = ELEMENT_D;
                isotopeAmount = labelElements.get(ELEMENT_D);
            } else {
                isotope = "<html> <sup>13</sup>C </html>";
                isotopeAmount = labelElements.get(ELEMENT_13C);
            }
            tableData[count][0] = labelVO.getLabelId();
            tableData[count][1] = isotope;
            tableData[count][2] = isotopeAmount;
            tableData[count][3] = 0;
            ++count;
        }
        return tableData;
    }

    protected void parseDataForLabels() throws ChemicalFormulaException {
        Hashtable<String, IsotopeLabelVO> isotopeLabels = new Hashtable<String, IsotopeLabelVO>();
        HashSet<String> ambiguousLabels = new HashSet<String>();
        for (ResultFileVO resultFileVO : this.getResultFiles()) {
            QuantificationResult quantRes = resultFileVO.getQuantificationResult();
            Hashtable<String, Vector<LipidParameterSet>> identifications = quantRes.getIdentifications();
            for (String key : identifications.keySet()) {
                for (LipidParameterSet analyte : identifications.get(key)) {
                    IsotopeLabelVO labelVO;
                    String analyteName = analyte.getName();
                    if (!this.containsPotentialSingleLetterLabel(analyteName)) continue;
                    String labelID = analyteName.substring(0, 1);
                    Hashtable<String, Integer> categorized = StaticUtils.categorizeFormula(analyte.getAnalyteFormula());
                    if (isotopeLabels.containsKey(labelID)) {
                        labelVO = isotopeLabels.get(labelID);
                        if (this.isLabelIdentical(labelVO, categorized)) continue;
                        ambiguousLabels.add(labelID);
                        continue;
                    }
                    Hashtable<String, Integer> labelElements = this.initLabelElements(categorized);
                    labelVO = new IsotopeLabelVO(labelElements, -1, labelID);
                    isotopeLabels.put(labelID, labelVO);
                }
            }
        }
        this.unambiguousIsotopeLabels_ = this.filterAmbiguousLabels(isotopeLabels, ambiguousLabels);
        if (this.unambiguousIsotopeLabels_.size() < 1) {
            JOptionPane.showMessageDialog(new JFrame(), "<html>No unambiguous stable isotope labels were detected.<br>Label IDs must be uppercase letters (A to Z) and correspond to a defined number of D and/or <sup>13</sup>C elements.</html>", "Warning", 2);
            this.goBack();
        }
    }

    private Vector<IsotopeLabelVO> filterAmbiguousLabels(Hashtable<String, IsotopeLabelVO> isotopeLabels, Set<String> ambiguousLabels) {
        Vector<IsotopeLabelVO> unambiguousLabels = new Vector<IsotopeLabelVO>();
        for (String labelID : isotopeLabels.keySet()) {
            if (ambiguousLabels.contains(labelID)) continue;
            unambiguousLabels.add(isotopeLabels.get(labelID));
        }
        return unambiguousLabels;
    }

    private Hashtable<String, Integer> initLabelElements(Hashtable<String, Integer> categorized) {
        Hashtable<String, Integer> labelElements = new Hashtable<String, Integer>();
        if (categorized.keySet().contains(ELEMENT_D)) {
            labelElements.put("H", -categorized.get(ELEMENT_D).intValue());
            labelElements.put(ELEMENT_D, categorized.get(ELEMENT_D));
        }
        if (categorized.keySet().contains(ELEMENT_13C)) {
            labelElements.put("C", -categorized.get(ELEMENT_13C).intValue());
            labelElements.put(ELEMENT_13C, categorized.get(ELEMENT_13C));
        }
        return labelElements;
    }

    private boolean isLabelIdentical(IsotopeLabelVO labelVO, Hashtable<String, Integer> categorized) {
        Hashtable<String, Integer> labelElements = labelVO.getLabelElements();
        if (labelElements.keySet().contains(ELEMENT_D) && categorized.keySet().contains(ELEMENT_D) && labelElements.get(ELEMENT_D) == categorized.get(ELEMENT_D)) {
            return true;
        }
        return labelElements.keySet().contains(ELEMENT_13C) && categorized.keySet().contains(ELEMENT_13C) && labelElements.get(ELEMENT_13C) == categorized.get(ELEMENT_13C);
    }

    private boolean containsPotentialSingleLetterLabel(String analyteName) {
        return analyteName.length() > 1 && this.isUpperCaseLetter(analyteName.charAt(0)) && !this.isUpperCaseLetter(analyteName.charAt(1));
    }

    private boolean isUpperCaseLetter(char c) {
        return c >= 'A' && c <= 'Z';
    }

    protected void parseDataForRTCalibrationAnchors() {
        Hashtable molecularSpeciesPerResult = new Hashtable();
        for (ResultFileVO resultFileVO : this.getResultFiles()) {
            QuantificationResult quantRes = resultFileVO.getQuantificationResult();
            Hashtable<String, Vector<LipidParameterSet>> identifications = quantRes.getIdentifications();
            for (String key : identifications.keySet()) {
                for (LipidParameterSet analyte : identifications.get(key)) {
                    LipidomicsMSnSet analyteMSn;
                    Set<String> molecularSpeciesSet;
                    if (!(analyte instanceof LipidomicsMSnSet) || (molecularSpeciesSet = (analyteMSn = (LipidomicsMSnSet)analyte).getPositionInsensitiveHumanReadableNameSet(false)).size() != 1) continue;
                    String molecularSpecies = key + " " + molecularSpeciesSet.iterator().next();
                    CalibrationAnchor anchor = new CalibrationAnchor(molecularSpecies, resultFileVO.getFileName(), analyteMSn);
                    if (!molecularSpeciesPerResult.containsKey(molecularSpecies)) {
                        molecularSpeciesPerResult.put(molecularSpecies, new Vector());
                    }
                    ((Vector)molecularSpeciesPerResult.get(molecularSpecies)).add(anchor);
                }
            }
        }
        System.out.println("!!! new !!!");
        int count = 0;
        for (String molecularSpecies : molecularSpeciesPerResult.keySet()) {
            Vector anchors = (Vector)molecularSpeciesPerResult.get(molecularSpecies);
            if (anchors.size() != this.getResultFiles().size()) continue;
            HashSet<String> uniqueFileNames = new HashSet<String>();
            for (CalibrationAnchor anchor : anchors) {
                uniqueFileNames.add(anchor.getFilePath());
            }
            if (uniqueFileNames.size() != this.getResultFiles().size()) continue;
            for (CalibrationAnchor anchor : anchors) {
                System.out.println(molecularSpecies + " \t File: " + anchor.getFilePath() + " \t RT: " + anchor.getAnalyteMSn().getRt());
            }
            ++count;
        }
        System.out.println(count);
        System.out.println("data parsed");
    }

    @Override
    protected void back() {
        this.reset();
        this.goBack();
    }

    @Override
    protected void next() {
        boolean noLabelSet = true;
        boolean deuteratedLabelsPresent = false;
        for (IsotopeLabelVO labelVO : this.unambiguousIsotopeLabels_) {
            if (labelVO.getOmegaPosition() <= 0) continue;
            noLabelSet = false;
            if (!labelVO.getLabelElements().containsKey(ELEMENT_D)) continue;
            deuteratedLabelsPresent = true;
        }
        if (deuteratedLabelsPresent) {
            try {
                if (!(this.getDefaultComponents().getNextPanel() instanceof ExperimentStandardsFileChooserPanel)) {
                    this.getDefaultComponents().addOptionPanelAfterCurrent(new ExperimentStandardsFileChooserPanel(this.getDefaultComponents(), this));
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                if (this.getDefaultComponents().getNextPanel() instanceof ExperimentStandardsFileChooserPanel) {
                    this.getDefaultComponents().removeOptionPanel(this.getDefaultComponents().getNextPanel());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!noLabelSet) {
            this.goNext();
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "You must specify the \u03c9-position for at least one label before continuing!", "Warning", 2);
        }
    }

    @Override
    protected void updateValue(int row, int value) {
        this.unambiguousIsotopeLabels_.get(row).setOmegaPosition(value);
    }

    public Vector<IsotopeLabelVO> getAssignedIsotopeLabels() {
        Vector<IsotopeLabelVO> assignedIsotopeLabels = new Vector<IsotopeLabelVO>();
        for (IsotopeLabelVO label : this.unambiguousIsotopeLabels_) {
            if (label.getOmegaPosition() <= 0) continue;
            assignedIsotopeLabels.add(label);
        }
        return assignedIsotopeLabels;
    }

    class CalibrationAnchor {
        private String molecularSpecies_;
        private String filePath_;
        private LipidomicsMSnSet analyteMSn_;

        public CalibrationAnchor(String molecularSpecies, String filePath, LipidomicsMSnSet analyteMSn) {
            this.molecularSpecies_ = molecularSpecies;
            this.filePath_ = filePath;
            this.analyteMSn_ = analyteMSn;
        }

        public String getMolecularSpecies() {
            return this.molecularSpecies_;
        }

        public String getFilePath() {
            return this.filePath_;
        }

        public LipidomicsMSnSet getAnalyteMSn() {
            return this.analyteMSn_;
        }
    }
}

