/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.calibration;

import at.tugraz.genome.lda.lccl.calibration.AnchorPointVO;
import at.tugraz.genome.lda.lccl.calibration.RecalibrationPlot;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.math3.util.Pair;
import org.apache.commons.math3.util.Precision;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;

public class RecalibrationPlotMouseListener
implements ChartMouseListener {
    RecalibrationPlot plot_;

    protected RecalibrationPlotMouseListener(RecalibrationPlot plot) {
        this.plot_ = plot;
    }

    @Override
    public void chartMouseClicked(ChartMouseEvent e) {
        ChartEntity entity = e.getEntity();
        if (entity instanceof XYItemEntity) {
            XYItemEntity ce = (XYItemEntity)entity;
            Pair<Double, Double> dataPoint = null;
            if (ce.getDataset().equals(this.plot_.getCurveFitDataset())) {
                dataPoint = this.clickedOnLine(e);
            } else {
                Double xValue = ce.getDataset().getX(ce.getSeriesIndex(), ce.getItem()).doubleValue();
                Double yValue = ce.getDataset().getY(ce.getSeriesIndex(), ce.getItem()).doubleValue();
                dataPoint = new Pair<Double, Double>(xValue, yValue);
            }
            if (dataPoint != null) {
                AnchorPointVO anchorPoint = this.plot_.getPanel().findLipidClassForDataPoint(dataPoint);
                String dataType = "Combined";
                if (this.plot_.getDataStandards().contains(anchorPoint)) {
                    dataType = "standards";
                }
                new DataPointDialog(new JFrame(), "Data point selected", anchorPoint, dataType, this.plot_);
            }
        }
    }

    public Pair<Double, Double> clickedOnLine(ChartMouseEvent e) {
        ChartPanel panel = (ChartPanel)e.getTrigger().getSource();
        XYPlot xyPlot = this.plot_.getXYPlot();
        Point p = e.getTrigger().getPoint();
        double mouseX = xyPlot.getDomainAxis().java2DToValue(((Point2D)p).getX(), panel.getScreenDataArea(), xyPlot.getDomainAxisEdge());
        double mouseY = xyPlot.getRangeAxis().java2DToValue(((Point2D)p).getY(), panel.getScreenDataArea(), xyPlot.getRangeAxisEdge());
        XYDataset[] scatterDatasets = new XYDataset[]{this.plot_.getScatterPlotStandardsDataset(), this.plot_.getScatterPlotDataset()};
        double minDist = Double.MAX_VALUE;
        Double xValue = null;
        Double yValue = null;
        for (XYDataset ds : scatterDatasets) {
            for (int s = 0; s < ds.getSeriesCount(); ++s) {
                for (int i = 0; i < ds.getItemCount(s); ++i) {
                    double x = ds.getXValue(s, i);
                    double y = ds.getYValue(s, i);
                    double d2 = Math.pow(x - mouseX, 2.0) + Math.pow(y - mouseY, 2.0);
                    if (!(d2 < minDist)) continue;
                    minDist = d2;
                    xValue = x;
                    yValue = y;
                }
            }
        }
        if (xValue != null) {
            Pair<Object, Object> dataPoint = new Pair<Object, Object>(xValue, yValue);
            return dataPoint;
        }
        return null;
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent e) {
    }

    private class DataPointDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private RecalibrationPlot plot_;
        private AnchorPointVO dataPoint_;

        public DataPointDialog(JFrame parent, String title, AnchorPointVO dataPoint, String dataType, RecalibrationPlot plot) {
            super(parent, title, true);
            this.plot_ = plot;
            this.dataPoint_ = dataPoint;
            this.setLocationRelativeTo(plot);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)new JLabel("Lipid class: "), this.generateDefaultConstraints(0, 0));
            this.getContentPane().add((Component)new JLabel(dataPoint.getLipidClass()), this.generateDefaultConstraints(7, 0));
            this.getContentPane().add((Component)new JLabel("Lipid species: "), this.generateDefaultConstraints(0, 1));
            this.getContentPane().add((Component)new JLabel(dataPoint.getLipidSpecies()), this.generateDefaultConstraints(7, 1));
            this.getContentPane().add((Component)new JLabel("Retention time in original RT-DB: "), this.generateDefaultConstraints(0, 2));
            this.getContentPane().add((Component)new JLabel(String.format("%s min", Precision.round(dataPoint.getxValue(), 2))), this.generateDefaultConstraints(7, 2));
            this.getContentPane().add((Component)new JLabel("Retention time with new experimental conditions: "), this.generateDefaultConstraints(0, 3));
            this.getContentPane().add((Component)new JLabel(String.format("%s min", Precision.round(dataPoint.getxValue() - dataPoint.getyValue(), 2))), this.generateDefaultConstraints(7, 3));
            this.getContentPane().add((Component)new JLabel("Retention time difference: "), this.generateDefaultConstraints(0, 4));
            this.getContentPane().add((Component)new JLabel(String.format("%s min", Precision.round(dataPoint.getyValue(), 2))), this.generateDefaultConstraints(7, 4));
            JPanel buttonPane = new JPanel();
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataPointDialog.this.cancelButton_actionPerformed(e);
                }
            });
            buttonPane.add((Component)cancelButton, "West");
            JButton deleteButton = new JButton("Delete this data point");
            deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataPointDialog.this.deleteButton_actionPerformed(e);
                }
            });
            if (dataType.equals("standards")) {
                deleteButton.setEnabled(false);
                deleteButton.setToolTipText("Data points derived from standards cannot be deleted.");
            }
            buttonPane.add((Component)deleteButton, "East");
            this.getContentPane().add((Component)buttonPane, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setVisible(true);
        }

        private GridBagConstraints generateDefaultConstraints(int x, int y) {
            return new GridBagConstraints(x, y, 5, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 5), 0, 0);
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.setVisible(false);
            this.dispose();
        }

        private void deleteButton_actionPerformed(ActionEvent e) {
            this.plot_.getPanel().removeDataPoint(this.dataPoint_);
            this.setVisible(false);
            this.dispose();
        }
    }
}

