/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.calibration;

import at.tugraz.genome.lda.lccl.calibration.IdentificationVO;
import at.tugraz.genome.lda.lccl.calibration.RecalibrationRegression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.Pair;

public class MatchedIdentificationVO {
    private ArrayList<IdentificationVO> originals_;
    private int maxOriginals_;
    private ArrayList<IdentificationVO> matches_;
    private int maxMatches_;
    private RecalibrationRegression regression_;
    private double predictionThreshold_;
    private String matchingAlgo_;
    private Pair<IdentificationVO, IdentificationVO> highestConfidencePair_;
    private ArrayList<Pair<IdentificationVO, IdentificationVO>> acceptedMatches_ = new ArrayList();
    private int confidence_ = 0;

    protected MatchedIdentificationVO(ArrayList<IdentificationVO> originals, int maxOriginals, ArrayList<IdentificationVO> matches, int maxMatches, RecalibrationRegression regression, double predictionThreshold, String matchingAlgo) {
        this.originals_ = originals;
        this.maxOriginals_ = maxOriginals;
        this.matches_ = matches;
        this.maxMatches_ = maxMatches;
        this.regression_ = regression;
        this.predictionThreshold_ = predictionThreshold;
        this.matchingAlgo_ = matchingAlgo;
        this.findHighestConfidencePairings();
    }

    private void findHighestConfidencePairings() {
        Collections.sort(this.originals_, this.obtainAreaComparator());
        Collections.sort(this.matches_, this.obtainAreaComparator());
        IdentificationVO highestIntensityOriginal = this.originals_.get(0);
        IdentificationVO highestIntensityMatch = this.matches_.get(0);
        this.highestConfidencePair_ = new Pair<IdentificationVO, IdentificationVO>(highestIntensityOriginal, highestIntensityMatch);
        if (this.matchingAlgo_.equals("All potential matches")) {
            this.confidence_ = 1;
        }
        if ((this.isWithinRTRange() || this.matchingAlgo_.equals("Prioritize number of anchor points")) && !this.matchingAlgo_.equals("Prioritize reliability of anchor points")) {
            this.acceptedMatches_ = this.findAcceptedMatches(this.sortPredictedMatchesByTotalArea());
            if (!this.acceptedMatches_.isEmpty()) {
                this.confidence_ = 2;
            }
        } else if (this.isAlwaysFound(highestIntensityOriginal, this.maxOriginals_) && this.isAlwaysFound(highestIntensityMatch, this.maxMatches_) && this.isIntensityElutionOrderCorrelated()) {
            this.confidence_ = 1;
        }
    }

    private ArrayList<Pair<IdentificationVO, IdentificationVO>> findAcceptedMatches(PriorityQueue<Pair<IdentificationVO, IdentificationVO>> matchesArea) {
        ConcurrentHashMap.KeySetView originalSet = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView newSet = ConcurrentHashMap.newKeySet();
        PriorityQueue<Pair<IdentificationVO, IdentificationVO>> matchesRTKey = new PriorityQueue<Pair<IdentificationVO, IdentificationVO>>(this.obtainRTKeyComparator());
        PriorityQueue<Pair<IdentificationVO, IdentificationVO>> matchesRTValue = new PriorityQueue<Pair<IdentificationVO, IdentificationVO>>(this.obtainRTValueComparator());
        ArrayList<Pair<IdentificationVO, IdentificationVO>> matchesAccepted = new ArrayList<Pair<IdentificationVO, IdentificationVO>>();
        while (!matchesArea.isEmpty()) {
            Pair<IdentificationVO, IdentificationVO> match = matchesArea.poll();
            if (originalSet.contains(match.getKey()) || newSet.contains(match.getValue())) continue;
            matchesRTKey.add(match);
            matchesRTValue.add(match);
            originalSet.add(match.getKey());
            newSet.add(match.getValue());
        }
        boolean isRTConsistent = true;
        while (!matchesRTKey.isEmpty() && !matchesRTValue.isEmpty()) {
            Pair<IdentificationVO, IdentificationVO> matchRTKey = matchesRTKey.poll();
            matchesAccepted.add(matchRTKey);
            if (matchRTKey.equals(matchesRTValue.poll())) continue;
            isRTConsistent = false;
        }
        if (!isRTConsistent) {
            matchesAccepted.clear();
        }
        return matchesAccepted;
    }

    private PriorityQueue<Pair<IdentificationVO, IdentificationVO>> sortPredictedMatchesByTotalArea() {
        ConcurrentHashMap.KeySetView originalSet = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView newSet = ConcurrentHashMap.newKeySet();
        PriorityQueue<Pair<IdentificationVO, IdentificationVO>> matchesPrediction = new PriorityQueue<Pair<IdentificationVO, IdentificationVO>>(this.obtainPredictionComparator());
        PriorityQueue<Pair<IdentificationVO, IdentificationVO>> matchesArea = new PriorityQueue<Pair<IdentificationVO, IdentificationVO>>(this.obtainAreasComparator());
        for (IdentificationVO originalVO : this.originals_) {
            if (!originalVO.isMSnAvailable() || !this.isAlwaysFound(originalVO, this.maxOriginals_)) continue;
            originalSet.add(originalVO);
            for (IdentificationVO newVO : this.matches_) {
                if (!newVO.isMSnAvailable() || !this.isAlwaysFound(newVO, this.maxMatches_) || !this.matchingAlgo_.equals("Prioritize number of anchor points") && !this.isWithinPredictionThreshold(originalVO, newVO)) continue;
                newSet.add(newVO);
                matchesPrediction.add(new Pair<IdentificationVO, IdentificationVO>(originalVO, newVO));
            }
        }
        while (!(originalSet.isEmpty() && newSet.isEmpty() || matchesPrediction.isEmpty())) {
            Pair<IdentificationVO, IdentificationVO> match = matchesPrediction.poll();
            originalSet.remove(match.getKey());
            newSet.remove(match.getValue());
            matchesArea.add(match);
        }
        return matchesArea;
    }

    private boolean isWithinPredictionThreshold(IdentificationVO originalVO, IdentificationVO newVO) {
        double predictedRT = this.regression_.getTargetRT(originalVO.getAverageRT());
        double predictionDiff = Math.abs(predictedRT - newVO.getAverageRT());
        return predictionDiff < this.predictionThreshold_;
    }

    private boolean isWithinRTRange() {
        if (this.regression_ != null) {
            for (IdentificationVO vo : this.originals_) {
                try {
                    this.regression_.getTargetRT(vo.getAverageRT());
                }
                catch (OutOfRangeException ex) {
                    return false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private boolean isIntensityElutionOrderCorrelated() {
        if (this.getNumberMSn(this.originals_) == 1 && this.getNumberMSn(this.matches_) == 1 && this.areBothMSn(this.originals_.get(0), this.matches_.get(0))) {
            return true;
        }
        if (this.getNumberMSn(this.originals_) == 1 || this.getNumberMSn(this.matches_) == 1) {
            return false;
        }
        return this.originals_.size() > 1 && this.matches_.size() > 1 && this.isCorrelatedTopDown();
    }

    private boolean isCorrelatedTopDown() {
        boolean isCorrelated = false;
        for (int i = 0; i < Math.min(this.originals_.size(), this.matches_.size()) - 1; ++i) {
            if (this.areBothMSn(this.originals_.get(i), this.matches_.get(i)) && this.areBothMSn(this.originals_.get(i + 1), this.matches_.get(i + 1))) {
                if (!(this.originals_.get(i).getAverageRT() > this.originals_.get(i + 1).getAverageRT() && this.matches_.get(i).getAverageRT() > this.matches_.get(i + 1).getAverageRT() || this.originals_.get(i).getAverageRT() < this.originals_.get(i + 1).getAverageRT() && this.matches_.get(i).getAverageRT() < this.matches_.get(i + 1).getAverageRT())) {
                    return false;
                }
            } else {
                if (i == 0) {
                    return false;
                }
                return isCorrelated;
            }
            isCorrelated = true;
        }
        return isCorrelated;
    }

    private int getNumberMSn(ArrayList<IdentificationVO> vos) {
        int count = 0;
        for (IdentificationVO vo : vos) {
            if (!vo.isMSnAvailable()) continue;
            ++count;
        }
        return count;
    }

    private boolean isAlwaysFound(IdentificationVO vo, int max) {
        return vo.getIdentificationCount() == max;
    }

    private boolean areBothMSn(IdentificationVO vo1, IdentificationVO vo2) {
        return vo1.isMSnAvailable() && vo2.isMSnAvailable();
    }

    private Comparator<IdentificationVO> obtainAreaComparator() {
        return new Comparator<IdentificationVO>(){

            @Override
            public int compare(IdentificationVO o1, IdentificationVO o2) {
                return -o1.getAverageArea().compareTo(o2.getAverageArea());
            }
        };
    }

    private Comparator<Pair<IdentificationVO, IdentificationVO>> obtainAreasComparator() {
        return new Comparator<Pair<IdentificationVO, IdentificationVO>>(){

            @Override
            public int compare(Pair<IdentificationVO, IdentificationVO> o1, Pair<IdentificationVO, IdentificationVO> o2) {
                return -new Double(o1.getKey().getAverageArea() + o1.getValue().getAverageArea()).compareTo(o2.getKey().getAverageArea() + o2.getValue().getAverageArea());
            }
        };
    }

    private Comparator<Pair<IdentificationVO, IdentificationVO>> obtainRTKeyComparator() {
        return new Comparator<Pair<IdentificationVO, IdentificationVO>>(){

            @Override
            public int compare(Pair<IdentificationVO, IdentificationVO> o1, Pair<IdentificationVO, IdentificationVO> o2) {
                return o1.getKey().getAverageRT().compareTo(o2.getKey().getAverageRT());
            }
        };
    }

    private Comparator<Pair<IdentificationVO, IdentificationVO>> obtainRTValueComparator() {
        return new Comparator<Pair<IdentificationVO, IdentificationVO>>(){

            @Override
            public int compare(Pair<IdentificationVO, IdentificationVO> o1, Pair<IdentificationVO, IdentificationVO> o2) {
                return o1.getValue().getAverageRT().compareTo(o2.getValue().getAverageRT());
            }
        };
    }

    private Comparator<Pair<IdentificationVO, IdentificationVO>> obtainPredictionComparator() {
        return new Comparator<Pair<IdentificationVO, IdentificationVO>>(){

            @Override
            public int compare(Pair<IdentificationVO, IdentificationVO> o1, Pair<IdentificationVO, IdentificationVO> o2) {
                if (!MatchedIdentificationVO.this.matchingAlgo_.equals("Prioritize number of anchor points")) {
                    double predictedRT1 = MatchedIdentificationVO.this.regression_.getTargetRT(o1.getKey().getAverageRT());
                    double predictedRT2 = MatchedIdentificationVO.this.regression_.getTargetRT(o2.getKey().getAverageRT());
                    return new Double(Math.abs(predictedRT1 - o1.getValue().getAverageRT())).compareTo(Math.abs(predictedRT2 - o2.getValue().getAverageRT()));
                }
                return new Double(o1.getValue().getAverageRT()).compareTo(o2.getValue().getAverageRT());
            }
        };
    }

    public ArrayList<Pair<IdentificationVO, IdentificationVO>> getAcceptedMatches() {
        return this.acceptedMatches_;
    }

    public Pair<IdentificationVO, IdentificationVO> getHighestConfidencePair() {
        return this.highestConfidencePair_;
    }

    public int getConfidence() {
        return this.confidence_;
    }
}

