/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.calibration;

import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class IdentificationVO {
    private ArrayList<File> files_ = new ArrayList();
    private Set<String> fileAdductPairs_ = new HashSet<String>();
    private String lipidClass_;
    private String lipidSpecies_;
    private boolean isMSnAvailable_ = false;
    private ArrayList<Double> retentionTimes_ = new ArrayList();
    private ArrayList<Double> areas_ = new ArrayList();
    private double groupingParameter_;

    protected IdentificationVO(File file, String lipidClass, LipidParameterSet param, Double groupingParameter) {
        this.files_.add(file);
        this.fileAdductPairs_.add(this.computeFileAdductHash(file, param));
        this.lipidClass_ = lipidClass;
        this.lipidSpecies_ = param.getNameStringWithoutRt();
        this.isMSnAvailable_ = param instanceof LipidomicsMSnSet;
        this.retentionTimes_.add(param.getPreciseRT());
        this.areas_.add(new Double(param.getArea()));
        this.groupingParameter_ = groupingParameter;
    }

    private String computeFileAdductHash(File file, LipidParameterSet param) {
        return file.getAbsolutePath() + "::" + param.getModificationName();
    }

    protected boolean addParam(File file, LipidParameterSet param) {
        Double paramRT = param.getPreciseRT();
        for (int i = 0; i < this.retentionTimes_.size(); ++i) {
            Double rT = this.retentionTimes_.get(i);
            if (!(paramRT >= rT - this.groupingParameter_) || !(paramRT <= rT + this.groupingParameter_)) continue;
            this.files_.add(file);
            this.fileAdductPairs_.add(this.computeFileAdductHash(file, param));
            this.isMSnAvailable_ = param instanceof LipidomicsMSnSet ? true : this.isMSnAvailable_;
            this.retentionTimes_.add(param.getPreciseRT());
            this.areas_.add(new Double(param.getArea()));
            return true;
        }
        return false;
    }

    Double getAverageRT() {
        Double sum = 0.0;
        for (Double rT : this.retentionTimes_) {
            sum = sum + rT;
        }
        return sum / (double)this.retentionTimes_.size();
    }

    Double getAverageArea() {
        Double sum = 0.0;
        for (Double area : this.areas_) {
            sum = sum + area;
        }
        return sum / (double)this.areas_.size();
    }

    boolean isMSnAvailable() {
        return this.isMSnAvailable_;
    }

    protected boolean isIdentificationUnambiguous() {
        return this.fileAdductPairs_.size() == this.files_.size();
    }

    int getIdentificationCount() {
        HashSet<File> uniqueFiles = new HashSet<File>(this.files_);
        return uniqueFiles.size();
    }

    protected String getLipidClass() {
        return this.lipidClass_;
    }

    protected String getLipidSpecies() {
        return this.lipidSpecies_;
    }

    protected double getGroupingParameter() {
        return this.groupingParameter_;
    }

    public String toString() {
        return "IdentificationVO [files_=" + this.files_ + ", lipidClass_=" + this.lipidClass_ + ", lipidSpecies_=" + this.lipidSpecies_ + ", isMSnAvailable_=" + this.isMSnAvailable_ + ", retentionTimes_=" + this.retentionTimes_ + ", areas_=" + this.areas_ + "]";
    }
}

