/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl;

import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.export.ExportPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JDefaultComponents {
    JButton cancelButton_;
    JButton backButton_;
    JButton nextButton_;
    JButton exportButton_;
    List<JOptionPanel> panelList_;
    int currentIndex_;
    JPanel componentsContainer_;
    PropertyChangeSupport propertyChangeListeners_;
    protected static final String CURRENT_PANEL_PROPERTY = "currentPanel";

    protected JDefaultComponents() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.propertyChangeListeners_ = new PropertyChangeSupport(this);
        this.cancelButton_ = new JButton();
        this.backButton_ = new JButton();
        this.nextButton_ = new JButton();
        this.exportButton_ = new JButton();
        this.panelList_ = new ArrayList<JOptionPanel>();
        this.currentIndex_ = 0;
        this.componentsContainer_ = new JPanel();
        this.cancelButton_.setText("Cancel");
        this.cancelButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDefaultComponents.this.cancelButton_actionPerformed(e);
            }
        });
        this.backButton_.setText("< Back");
        this.backButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDefaultComponents.this.backButton_actionPerformed(e);
            }
        });
        this.nextButton_.setText("Next >");
        this.nextButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDefaultComponents.this.nextButton_actionPerformed(e);
            }
        });
        this.exportButton_.setText("Export");
        this.exportButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDefaultComponents.this.exportButton_actionPerformed(e);
            }
        });
        this.componentsContainer_.setLayout(new CardLayout());
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        try {
            if (this.getOptionPanelList().size() > 1) {
                for (int i = this.getOptionPanelList().size() - 1; i > 0; --i) {
                    this.removeOptionPanel(i);
                }
            }
            this.setCurrentIndex(0);
            this.getCurrentPanel();
            this.updateComponents();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void backButton_actionPerformed(ActionEvent e) {
        try {
            this.getCurrentPanel().back();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void nextButton_actionPerformed(ActionEvent e) {
        try {
            this.getCurrentPanel().next();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void exportButton_actionPerformed(ActionEvent e) {
        try {
            JOptionPanel panel = this.getCurrentPanel();
            ExportPanel exporter = (ExportPanel)panel;
            if (exporter.isPlaceholderExport() || exporter.isPlaceholderTemplate()) {
                JOptionPane.showMessageDialog(new JFrame(), "The path and file name of the template LDA mass list and the new RT-DB must be specified before the export!", "Warning", 2);
            } else {
                exporter.export();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void addOptionPanel(JOptionPanel panel) {
        this.getOptionPanelList().add(panel);
        this.componentsContainer_.add((Component)panel, this.getOptionPanelList().size() - 1 + "");
    }

    protected void addOptionPanel(int index, JOptionPanel panel) {
        this.getOptionPanelList().add(index, panel);
        this.componentsContainer_.add(panel, index + "", index);
        if (index < this.getOptionPanelList().size() - 1) {
            for (int i = index + 1; i < this.getOptionPanelList().size(); ++i) {
                this.componentsContainer_.add((Component)this.getOptionPanelList().get(i), i + "");
            }
        }
    }

    protected void addOptionPanelAfter(JOptionPanel panelToBePlacedAfter, JOptionPanel panel) {
        this.addOptionPanel(this.getOptionPanelList().indexOf(panelToBePlacedAfter) + 1, panel);
    }

    protected void addOptionPanelBefore(JOptionPanel panelToBePlacedBefore, JOptionPanel panel) {
        this.addOptionPanel(this.getOptionPanelList().indexOf(panelToBePlacedBefore) - 1, panel);
    }

    public void addOptionPanelAfterCurrent(JOptionPanel panel) {
        this.addOptionPanel(this.getCurrentIndex() + 1, panel);
    }

    public JOptionPanel removeOptionPanel(JOptionPanel panel) {
        int index = this.getOptionPanelList().indexOf(panel);
        this.getOptionPanelList().remove(panel);
        this.componentsContainer_.remove(panel);
        for (int i = index; i < this.getOptionPanelList().size(); ++i) {
            this.componentsContainer_.add((Component)this.getOptionPanelList().get(i), i + "");
        }
        return panel;
    }

    protected JOptionPanel removeOptionPanel(int index) {
        this.componentsContainer_.remove(index);
        JOptionPanel panel = this.getOptionPanelList().remove(index);
        for (int i = index; i < this.getOptionPanelList().size(); ++i) {
            this.componentsContainer_.add((Component)this.getOptionPanelList().get(i), i + "");
        }
        return panel;
    }

    protected JOptionPanel removeOptionPanelAfter(JOptionPanel panel) {
        return this.removeOptionPanel(this.getOptionPanelList().indexOf(panel) + 1);
    }

    protected JOptionPanel removeOptionPanelBefore(JOptionPanel panel) {
        return this.removeOptionPanel(this.getOptionPanelList().indexOf(panel) - 1);
    }

    protected JOptionPanel getOptionPanel(int index) {
        return this.getOptionPanelList().get(index);
    }

    protected int getIndexOfPanel(JOptionPanel panel) {
        return this.getOptionPanelList().indexOf(panel);
    }

    protected boolean onLastPanel() {
        return this.getCurrentIndex() == this.getOptionPanelList().size() - 1;
    }

    public JOptionPanel getCurrentPanel() throws Exception {
        if (this.getOptionPanelList().get(this.currentIndex_) != null) {
            return this.getOptionPanelList().get(this.currentIndex_);
        }
        throw new Exception("Requested panel not in panelList");
    }

    public JOptionPanel getNextPanel() throws Exception {
        if (this.getOptionPanelList().get(this.currentIndex_ + 1) != null) {
            return this.getOptionPanelList().get(this.currentIndex_ + 1);
        }
        throw new Exception("Requested panel not in panelList");
    }

    public void updateComponents() {
        try {
            CardLayout cl = (CardLayout)this.componentsContainer_.getLayout();
            cl.show(this.componentsContainer_, this.currentIndex_ + "");
            this.cancelButton_.setEnabled(true);
            this.backButton_.setEnabled(true);
            this.nextButton_.setEnabled(true);
            this.exportButton_.setEnabled(false);
            if (this.currentIndex_ == 0) {
                this.cancelButton_.setEnabled(false);
                this.backButton_.setEnabled(false);
                this.nextButton_.setEnabled(false);
            } else if (this.currentIndex_ == 1) {
                this.backButton_.setEnabled(false);
            } else if (this.onLastPanel()) {
                this.nextButton_.setEnabled(false);
                this.exportButton_.setEnabled(true);
            }
            this.getCurrentPanel().update();
            PropertyChangeEvent event = new PropertyChangeEvent(this, CURRENT_PANEL_PROPERTY, null, this.getCurrentPanel());
            this.propertyChangeListeners_.firePropertyChange(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disableAllButtons() {
        this.cancelButton_.setEnabled(false);
        this.backButton_.setEnabled(false);
        this.nextButton_.setEnabled(false);
        this.exportButton_.setEnabled(false);
    }

    protected List<JOptionPanel> getOptionPanelList() {
        return this.panelList_;
    }

    protected void setOptionPanelList(List<JOptionPanel> panelList) {
        this.panelList_ = panelList;
    }

    protected int getCurrentIndex() {
        return this.currentIndex_;
    }

    protected void setCurrentIndex(int aCurrentIndex) {
        this.currentIndex_ = aCurrentIndex;
    }

    protected JPanel getComponentsContainer() {
        return this.componentsContainer_;
    }

    protected void setComponentsContainer(JPanel aComponentsContainer) {
        this.componentsContainer_ = aComponentsContainer;
    }

    protected JButton getCancelButton() {
        return this.cancelButton_;
    }

    protected void setCancelButton(JButton aCancelButton) {
        this.cancelButton_ = aCancelButton;
    }

    protected JButton getBackButton() {
        return this.backButton_;
    }

    protected void setBackButton(JButton aBackButton) {
        this.backButton_ = aBackButton;
    }

    protected JButton getNextButton() {
        return this.nextButton_;
    }

    protected void setNextButton(JButton aNextButton) {
        this.nextButton_ = aNextButton;
    }

    protected JButton getExportButton() {
        return this.exportButton_;
    }

    protected void setExportButton(JButton aExportButton) {
        this.exportButton_ = aExportButton;
    }

    protected void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners_.addPropertyChangeListener(listener);
    }

    protected void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners_.removePropertyChangeListener(listener);
    }
}

