/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.dbutilities.Base64;
import at.tugraz.genome.lda.fragai.FragTargetListEntry;
import at.tugraz.genome.lda.vos.AdductVO;
import at.tugraz.genome.lda.vos.SpectrumPointVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;

public class SpectrumContainer
implements Comparable<SpectrumContainer> {
    FragTargetListEntry entry_;
    AdductVO adduct_;
    CgProbe probe_;
    File chromFile_;
    Hashtable<Integer, String> scanNrSpectrumHash_;
    Hashtable<Integer, ArrayList<SpectrumPointVO>> scanNrProcessedSpectrumHash_;
    Hashtable<Integer, Vector<Double>> scanNrPrecursorHash_;
    Hashtable<Integer, Integer> scanNrLevelHash_;

    public SpectrumContainer(FragTargetListEntry entry, AdductVO adduct, CgProbe probe, File chromFile, Hashtable<Integer, String> scanNrSpectrumHash, Hashtable<Integer, Vector<Double>> scanNrPrecursorHash, Hashtable<Integer, Integer> scanNrLevelHash) {
        this.entry_ = entry;
        this.adduct_ = adduct;
        this.probe_ = probe;
        this.chromFile_ = chromFile;
        this.scanNrSpectrumHash_ = scanNrSpectrumHash;
        this.scanNrPrecursorHash_ = scanNrPrecursorHash;
        this.scanNrLevelHash_ = scanNrLevelHash;
        this.scanNrProcessedSpectrumHash_ = this.processSpectra();
    }

    public SpectrumContainer(SpectrumContainer other) {
        this(other.getEntry(), other.getAdduct(), other.getProbe(), other.getChromFile(), other.getScanNrSpectrumHash(), other.getScanNrPrecursorHash(), other.getScanNrLevelHash());
    }

    private Hashtable<Integer, ArrayList<SpectrumPointVO>> processSpectra() {
        Hashtable<Integer, ArrayList<SpectrumPointVO>> processedSpectra = new Hashtable<Integer, ArrayList<SpectrumPointVO>>();
        for (Integer scanNr : this.getScanNrLevelHash().keySet()) {
            ArrayList<Integer> scans = new ArrayList<Integer>();
            scans.add(scanNr);
            ArrayList<SpectrumPointVO> dataPoints = this.mergeSpectra(scans);
            processedSpectra.put(scanNr, dataPoints);
        }
        return processedSpectra;
    }

    private ArrayList<SpectrumPointVO> mergeSpectra(Collection<Integer> scanNumbers) {
        Hashtable<String, SpectrumPointVO> intensityPoints = new Hashtable<String, SpectrumPointVO>();
        for (Integer scanNr : scanNumbers) {
            String spectrum = this.scanNrSpectrumHash_.get(scanNr);
            FloatBuffer buffer = ByteBuffer.wrap(Base64.decode(spectrum)).asFloatBuffer();
            int iItems = buffer.limit();
            float mzValue = 0.0f;
            for (int iItem = 0; iItem < iItems; ++iItem) {
                if (iItem % 2 == 0) {
                    mzValue = buffer.get();
                    continue;
                }
                float intensity = buffer.get();
                String mzOriginal = String.valueOf(mzValue);
                SpectrumPointVO vo = null;
                vo = intensityPoints.containsKey(mzOriginal) ? (SpectrumPointVO)intensityPoints.get(mzOriginal) : new SpectrumPointVO(mzOriginal, mzValue);
                vo.addIntensity(intensity);
                intensityPoints.put(mzOriginal, vo);
            }
        }
        ArrayList<SpectrumPointVO> vos = new ArrayList<SpectrumPointVO>(intensityPoints.values());
        Collections.sort(vos);
        return vos;
    }

    public FragTargetListEntry getEntry() {
        return this.entry_;
    }

    public AdductVO getAdduct() {
        return this.adduct_;
    }

    public CgProbe getProbe() {
        return this.probe_;
    }

    public File getChromFile() {
        return this.chromFile_;
    }

    public Hashtable<Integer, String> getScanNrSpectrumHash() {
        return this.scanNrSpectrumHash_;
    }

    public Hashtable<Integer, Vector<Double>> getScanNrPrecursorHash() {
        return this.scanNrPrecursorHash_;
    }

    public Hashtable<Integer, Integer> getScanNrLevelHash() {
        return this.scanNrLevelHash_;
    }

    public ArrayList<SpectrumPointVO> getProcessedSpectrum(Integer scanNumber) {
        return this.scanNrProcessedSpectrumHash_.get(scanNumber);
    }

    public void setProcessedSpectrum(Integer scanNumber, ArrayList<SpectrumPointVO> spectrum) {
        this.scanNrProcessedSpectrumHash_.put(scanNumber, spectrum);
    }

    public int hashCode() {
        return Objects.hash(this.adduct_, this.chromFile_, this.entry_, this.probe_, this.scanNrLevelHash_, this.scanNrPrecursorHash_, this.scanNrSpectrumHash_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpectrumContainer other = (SpectrumContainer)obj;
        return Objects.equals(this.adduct_, other.adduct_) && Objects.equals(this.chromFile_, other.chromFile_) && Objects.equals(this.entry_, other.entry_) && Objects.equals(this.probe_, other.probe_) && Objects.equals(this.scanNrLevelHash_, other.scanNrLevelHash_) && Objects.equals(this.scanNrPrecursorHash_, other.scanNrPrecursorHash_) && Objects.equals(this.scanNrSpectrumHash_, other.scanNrSpectrumHash_);
    }

    @Override
    public int compareTo(SpectrumContainer other) {
        return Comparator.comparing(sc -> sc.getEntry().getLipidClass()).thenComparing(sc -> sc.getEntry().getSpecies()).thenComparing(sc -> sc.getEntry().hashCode()).compare(this, other);
    }
}

