/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.lda.fragai.CombinedSpectrumContainer;
import at.tugraz.genome.lda.fragai.SpectrumContainer;
import at.tugraz.genome.lda.vos.SpectrumPointVO;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Worksheet;

public class SpectraTextExporter {
    private static final String HEADER_MZ = "mz Value";
    private static final String HEADER_INTENSITY = "Intensity";
    private ArrayList<SpectrumContainer> spectra_ = null;
    private ArrayList<CombinedSpectrumContainer> combinedSpectra_ = null;
    private String path_;

    public SpectraTextExporter(ArrayList<SpectrumContainer> spectra, String path) {
        this.spectra_ = spectra;
        Collections.sort(this.spectra_);
        this.path_ = path;
    }

    public SpectraTextExporter(String path, ArrayList<CombinedSpectrumContainer> combinedSpectra) {
        this.combinedSpectra_ = combinedSpectra;
        Collections.sort(this.combinedSpectra_);
        this.path_ = path;
    }

    public void exportSpectra() {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.path_));){
            String s = "2.11.1";
            Workbook wb = new Workbook(out, "Lipid Data Analyzer", s.substring(0, s.indexOf(".", s.indexOf(".") + 1)));
            if (this.spectra_ != null) {
                this.exportRawSpectra(wb);
            } else if (this.combinedSpectra_ != null) {
                this.exportCombinedSpectra(wb);
            }
            wb.finish();
            System.out.println("finished");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void exportCombinedSpectra(Workbook wb) {
        for (CombinedSpectrumContainer spectrum : this.combinedSpectra_) {
            ArrayList<SpectrumPointVO> dataPoints = spectrum.computeCombinedSpectrum();
            if (dataPoints.isEmpty()) continue;
            String sheetName = String.format("%s_%s", spectrum.getLipidClass(), spectrum.getAdduct());
            Worksheet ws = wb.newWorksheet(sheetName);
            int rowNumber = 0;
            ws.value(rowNumber, 0, "Lipid class:");
            ws.value(rowNumber, 1, spectrum.getLipidClass());
            ws.value(++rowNumber, 0, "Adduct:");
            ws.value(rowNumber, 1, spectrum.getAdduct());
            ++rowNumber;
            ArrayList<String> headerTitles = new ArrayList<String>();
            headerTitles.add(HEADER_MZ);
            headerTitles.add(HEADER_INTENSITY);
            SpectraTextExporter.createHeader(ws, headerTitles, ++rowNumber);
            for (SpectrumPointVO dataPoint : dataPoints) {
                ws.value(++rowNumber, headerTitles.indexOf(HEADER_MZ), Float.valueOf(dataPoint.getMz()));
                ws.value(rowNumber, headerTitles.indexOf(HEADER_INTENSITY), Float.valueOf(dataPoint.getIntensity()));
            }
        }
        System.out.println("done?");
    }

    private void exportRawSpectra(Workbook wb) {
        int count = 0;
        for (SpectrumContainer spectrum : this.spectra_) {
            Hashtable<Integer, Integer> scanNrLevelHash = spectrum.getScanNrLevelHash();
            for (Integer scanNr : scanNrLevelHash.keySet()) {
                String sheetName = String.format("%s_%s_%s_%s", spectrum.getEntry().getLipidClass(), spectrum.getAdduct().getAdductName(), scanNrLevelHash.get(scanNr), count++);
                Worksheet ws = wb.newWorksheet(sheetName);
                int rowNumber = 0;
                ws.value(rowNumber, 0, "Lipid class:");
                ws.value(rowNumber, 1, spectrum.getEntry().getLipidClass());
                ws.value(++rowNumber, 0, "Lipid species:");
                ws.value(rowNumber, 1, spectrum.getEntry().getSpecies());
                ws.value(++rowNumber, 0, "Adduct:");
                ws.value(rowNumber, 1, spectrum.getAdduct().getAdductName());
                ws.value(++rowNumber, 0, "Precursor mz:");
                ws.value(rowNumber, 1, spectrum.getScanNrPrecursorHash().get(scanNr).get(0));
                ws.value(++rowNumber, 0, "MS Level:");
                ws.value(rowNumber, 1, scanNrLevelHash.get(scanNr));
                ws.value(++rowNumber, 0, "Scan Number:");
                ws.value(rowNumber, 1, scanNr);
                ws.value(++rowNumber, 0, "Chrom File Name:");
                ws.value(rowNumber, 1, spectrum.getChromFile() == null ? "combined" : spectrum.getChromFile().getName());
                ++rowNumber;
                ArrayList<String> headerTitles = new ArrayList<String>();
                headerTitles.add(HEADER_MZ);
                headerTitles.add(HEADER_INTENSITY);
                SpectraTextExporter.createHeader(ws, headerTitles, ++rowNumber);
                ArrayList<SpectrumPointVO> dataPoints = spectrum.getProcessedSpectrum(scanNr);
                for (SpectrumPointVO dataPoint : dataPoints) {
                    ws.value(++rowNumber, headerTitles.indexOf(HEADER_MZ), Float.valueOf(dataPoint.getMz()));
                    ws.value(rowNumber, headerTitles.indexOf(HEADER_INTENSITY), Float.valueOf(dataPoint.getIntensity()));
                }
            }
        }
    }

    private static void createHeader(Worksheet ws, List<String> headerTitles, Integer headerRow) {
        for (int i = 0; i < headerTitles.size(); ++i) {
            ws.value((int)headerRow, i, headerTitles.get(i));
        }
        ws.range(headerRow, headerRow, headerRow, headerTitles.size()).style().bold().horizontalAlignment("center").fontName("Arial").fontSize(12).set();
    }
}

