/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.lda.BatchQuantThread;
import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.MzxmlToChromThread;
import at.tugraz.genome.lda.QuantificationThread;
import at.tugraz.genome.lda.RawToMzxmlThread;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.QuantificationException;
import at.tugraz.genome.lda.fragai.ExcelTargetListParser;
import at.tugraz.genome.lda.fragai.FragTargetListEntry;
import at.tugraz.genome.lda.fragai.SpectrumContainer;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.AdductVO;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.ChromatogramReader;
import at.tugraz.genome.maspectras.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class SpectraIdentifier
extends Thread {
    private JTextField rawDirectoryJTextField_ = new JTextField(62);

    public SpectraIdentifier(String path) {
        this.rawDirectoryJTextField_.setMinimumSize(this.rawDirectoryJTextField_.getPreferredSize());
        this.rawDirectoryJTextField_.setToolTipText("<html>Enter a folder containing the raw files of your experiment!<br>The following file types are accepted as input:<br>RAW-file:   XCalibur RAW files (XCalibur must be installed)<<br>RAW-dir:    MassLynx RAW directory (MassLynx must be installed)<br>mzXML:      mzXML format<br>mzML:       mzML format<br>chrom:      LDA quant file format</html>");
        this.rawDirectoryJTextField_.setText(path);
    }

    public ArrayList<SpectrumContainer> identifySpectra(ExcelTargetListParser parser) throws QuantificationException {
        ArrayList<SpectrumContainer> spectra = new ArrayList<SpectrumContainer>();
        this.translateAllToChrom();
        ArrayList<FragTargetListEntry> entries = parser.getTargetListEntries();
        File rawDir = new File(this.rawDirectoryJTextField_.getText());
        if (rawDir.exists() && rawDir.isDirectory()) {
            File[] chromCandidates = rawDir.listFiles();
            for (int i = 0; i != chromCandidates.length; ++i) {
                if (!chromCandidates[i].isDirectory() || !chromCandidates[i].getAbsolutePath().endsWith("chrom")) continue;
                String[] chromPaths = StringUtils.getChromFilePaths(chromCandidates[i].getAbsolutePath());
                ChromatogramReader reader = null;
                LipidomicsAnalyzer analyzer = null;
                System.out.println(chromPaths[1]);
                try {
                    reader = new ChromatogramReader(chromPaths[1], chromPaths[2], chromPaths[3], chromPaths[0], LipidomicsConstants.isSparseData(), LipidomicsConstants.getChromSmoothRange());
                    analyzer = new LipidomicsAnalyzer(chromPaths[1], chromPaths[2], chromPaths[3], chromPaths[0], false);
                }
                catch (CgException ex) {
                    continue;
                }
                QuantificationThread.setAnalyzerProperties(analyzer);
                analyzer.setGeneralBasePeakCutoff(0.0f);
                int msLevel = 1;
                float mzTolerance = 0.02f;
                for (FragTargetListEntry entry : entries) {
                    ArrayList<AdductVO> adducts = entry.getAdducts();
                    for (AdductVO adduct : adducts) {
                        float targetMz = new Float(entry.computeTheoreticalPrecursorMZValue(adduct.getAdductName())).floatValue();
                        try {
                            CgProbe probe = analyzer.calculatePeakAtExactTimePosition(new Float(entry.getRetentionTime() * 60.0).floatValue(), targetMz, mzTolerance, mzTolerance, adduct.getCharge(), msLevel);
                            Hashtable<Integer, Vector<String>> spectraRaw = reader.getMsMsSpectra(probe.Mz - LipidomicsConstants.getMs2PrecursorTolerance(), probe.Mz + LipidomicsConstants.getMs2PrecursorTolerance(), probe.LowerValley, probe.UpperValley);
                            Vector<Hashtable> rtNrSpectraAndPrecursor = reader.getRtNrSpectrumHash(spectraRaw);
                            Hashtable scanNrSpectrumHash = rtNrSpectraAndPrecursor.get(0);
                            Hashtable scanNrPrecursorHash = rtNrSpectraAndPrecursor.get(1);
                            Hashtable scanNrLevelHash = rtNrSpectraAndPrecursor.get(2);
                            spectra.add(new SpectrumContainer(entry, adduct, probe, chromCandidates[i], scanNrSpectrumHash, scanNrPrecursorHash, scanNrLevelHash));
                        }
                        catch (CgException cgException) {}
                    }
                }
            }
        }
        return spectra;
    }

    private void translateAllToChrom() {
        if (this.rawDirectoryJTextField_.getText() != null && this.rawDirectoryJTextField_.getText().length() > 0) {
            File rawDir = new File(this.rawDirectoryJTextField_.getText());
            if (rawDir.exists() && rawDir.isDirectory()) {
                Vector<File> rawFiles = this.extractRawFiles(rawDir);
                if (rawFiles.size() > 0) {
                    this.translateAllRaw(rawFiles);
                } else if (rawFiles.size() == 0) {
                    new WarningMessage(new JFrame(), "Warning", "In the specified raw directory are no quantifiable files.");
                    return;
                }
                Vector<File> mzXMLFiles = this.extractMzXMLFiles(rawDir);
                this.translateAllMzXML(mzXMLFiles);
            } else if (!rawDir.exists() || !rawDir.isDirectory()) {
                new WarningMessage(new JFrame(), "Warning", "The raw directory does not exist");
            }
        } else if (this.rawDirectoryJTextField_.getText() == null || this.rawDirectoryJTextField_.getText().length() < 1) {
            new WarningMessage(new JFrame(), "Warning", "You must specify a directory containing raw, mzXML, mzML or chrom files.");
        }
    }

    private void translateAllMzXML(Vector<File> mzXMLFiles) {
        for (File file : mzXMLFiles) {
            MzxmlToChromThread mzToChromThread = new MzxmlToChromThread(file.getAbsolutePath(), Runtime.getRuntime().availableProcessors());
            mzToChromThread.start();
            while (!mzToChromThread.finished()) {
            }
            if (mzToChromThread.getErrorString() != null) continue;
            RawToMzxmlThread.deleteMzXMLFiles(file.getAbsolutePath());
        }
    }

    private void translateAllRaw(Vector<File> rawFiles) {
        ExecutorService threadpool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (File rawFile : rawFiles) {
            String suffix = rawFile.getAbsolutePath().substring(rawFile.getAbsolutePath().lastIndexOf("."));
            if (!suffix.equalsIgnoreCase(".RAW") && !suffix.equalsIgnoreCase(".d") && !suffix.equalsIgnoreCase(".wiff")) continue;
            RawToMzxmlThread thread = this.startRawToMzXmlThread(rawFile, suffix);
            threadpool.execute(thread);
        }
        threadpool.shutdown();
        try {
            threadpool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private RawToMzxmlThread startRawToMzXmlThread(File rawFile, String suffix) {
        if (rawFile.isFile() && (Settings.getReadWPath() != null && Settings.getReadWPath().length() > 0 || Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0) || rawFile.isDirectory() && (suffix.equalsIgnoreCase(".RAW") && (Settings.getMassWolfPath() != null && Settings.getMassWolfPath().length() > 0 || Settings.getMassPlusPlusPath() != null && Settings.getMassPlusPlusPath().length() > 0) || suffix.equalsIgnoreCase(".d") && Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0)) {
            File headerFile = new File(StringUtils.getChromFilePaths(rawFile.getAbsolutePath())[1]);
            File mzXMLFile = new File(rawFile.getAbsolutePath().substring(0, rawFile.getAbsolutePath().length() - suffix.length()) + "." + LipidomicsConstants.getIntermediateFileFormat());
            if (!headerFile.exists() && !mzXMLFile.exists()) {
                boolean isMassPlusPlus = false;
                boolean watersMsConvert = false;
                String[] params = new String[3];
                if (rawFile.isFile()) {
                    if (Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0) {
                        params = BatchQuantThread.getMsConvertParams(rawFile.getAbsolutePath());
                    } else if (Settings.getReadWPath() != null && Settings.getReadWPath().length() > 0) {
                        params[0] = Settings.getReadWPath();
                        params[1] = rawFile.getAbsolutePath();
                        params[2] = "p";
                    }
                }
                if (rawFile.isDirectory()) {
                    if (suffix.equalsIgnoreCase(".RAW")) {
                        if (LipidomicsConstants.useMsconvertForWaters()) {
                            params = BatchQuantThread.getMsConvertParamsWaters(rawFile.getAbsolutePath());
                            watersMsConvert = true;
                        } else if (Settings.getMassPlusPlusPath() != null && Settings.getMassPlusPlusPath().length() > 0) {
                            params = new String[]{Settings.getMassPlusPlusPath(), "-in", rawFile.getAbsolutePath(), "-out", LipidomicsConstants.getIntermediateFileFormat().toLowerCase(), mzXMLFile.getAbsolutePath(), "-sample", "0"};
                            if (LipidomicsConstants.isMS2()) {
                                isMassPlusPlus = true;
                            }
                        } else if (Settings.getMassWolfPath() != null && Settings.getMassWolfPath().length() > 0) {
                            params = new String[]{Settings.getMassWolfPath(), "--" + LipidomicsConstants.getIntermediateFileFormat(), rawFile.getAbsolutePath(), mzXMLFile.getAbsolutePath()};
                        }
                    } else if (suffix.equalsIgnoreCase(".d") && Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0) {
                        params = BatchQuantThread.getMsConvertParams(rawFile.getAbsolutePath());
                    }
                }
                return new RawToMzxmlThread(params, isMassPlusPlus, watersMsConvert);
            }
            return null;
        }
        return null;
    }

    private Vector<File> extractRawFiles(File rawDir) {
        Vector<File> rawFiles = new Vector<File>();
        File[] rawFileCandidates = rawDir.listFiles();
        Hashtable<String, Vector> avoidDuplication = new Hashtable<String, Vector>();
        boolean mzXMLOrChromPresent = false;
        for (int i = 0; i != rawFileCandidates.length; ++i) {
            Vector theFiles;
            String fileName;
            String suffix;
            String[] fileNameAndSuffix;
            if (rawFileCandidates[i].isFile()) {
                fileNameAndSuffix = StaticUtils.extractFileNameAndSuffix(rawFileCandidates[i].getAbsolutePath());
                suffix = fileNameAndSuffix[1];
                fileName = fileNameAndSuffix[0];
                if (suffix.equalsIgnoreCase("mzXML") || suffix.equalsIgnoreCase("mzML") || suffix.equalsIgnoreCase("raw") || suffix.equalsIgnoreCase("chrom") || suffix.equalsIgnoreCase("wiff")) {
                    if (suffix.equalsIgnoreCase("mzXML") || suffix.equalsIgnoreCase("mzML") || suffix.equalsIgnoreCase("chrom")) {
                        mzXMLOrChromPresent = true;
                    }
                    theFiles = new Vector();
                    if (avoidDuplication.containsKey(fileName)) {
                        theFiles = (Vector)avoidDuplication.get(fileName);
                    }
                    theFiles.add(rawFileCandidates[i]);
                    avoidDuplication.put(fileName, theFiles);
                }
            }
            if (!rawFileCandidates[i].isDirectory()) continue;
            fileNameAndSuffix = StaticUtils.extractFileNameAndSuffix(rawFileCandidates[i].getAbsolutePath());
            suffix = fileNameAndSuffix[1];
            fileName = fileNameAndSuffix[0];
            if (!suffix.equalsIgnoreCase("raw") && !suffix.equalsIgnoreCase("d") && !suffix.equalsIgnoreCase("chrom")) continue;
            if (suffix.equalsIgnoreCase("chrom")) {
                mzXMLOrChromPresent = true;
            }
            theFiles = new Vector();
            if (avoidDuplication.containsKey(fileName)) {
                theFiles = (Vector)avoidDuplication.get(fileName);
            }
            theFiles.add(rawFileCandidates[i]);
            avoidDuplication.put(fileName, theFiles);
        }
        for (String key : avoidDuplication.keySet()) {
            String suffix;
            File file;
            int i;
            Vector theFiles = (Vector)avoidDuplication.get(key);
            if (theFiles.size() == 1) {
                String suffix2 = StaticUtils.extractFileNameAndSuffix(((File)theFiles.get(0)).getAbsolutePath())[1];
                if (mzXMLOrChromPresent && suffix2.equalsIgnoreCase("wiff")) continue;
                rawFiles.add((File)theFiles.get(0));
                continue;
            }
            int selectedIndex = -1;
            for (i = 0; i != theFiles.size(); ++i) {
                file = (File)theFiles.get(i);
                suffix = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(".") + 1);
                if (mzXMLOrChromPresent && suffix.equalsIgnoreCase("wiff") || !suffix.equalsIgnoreCase("chrom")) continue;
                selectedIndex = i;
            }
            if (selectedIndex > -1) {
                rawFiles.add((File)theFiles.get(selectedIndex));
                continue;
            }
            for (i = 0; i != theFiles.size(); ++i) {
                file = (File)theFiles.get(i);
                suffix = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(".") + 1);
                if (mzXMLOrChromPresent && suffix.equalsIgnoreCase("wiff") || !suffix.equalsIgnoreCase("mzXML") && !suffix.equalsIgnoreCase("mzML")) continue;
                rawFiles.add((File)theFiles.get(i));
            }
        }
        return rawFiles;
    }

    private Vector<File> extractMzXMLFiles(File rawDir) {
        Vector<File> files = new Vector<File>();
        File[] mzMLFileCandidates = rawDir.listFiles();
        for (int i = 0; i < mzMLFileCandidates.length; ++i) {
            if (!mzMLFileCandidates[i].isFile() || !mzMLFileCandidates[i].getAbsolutePath().endsWith("mzXML") && !mzMLFileCandidates[i].getAbsolutePath().endsWith("mzML")) continue;
            files.add(mzMLFileCandidates[i]);
        }
        return files;
    }
}

