/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.vos.AdductVO;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Objects;

public class FragTargetListEntry {
    private String lipidClass_;
    private String species_;
    private Hashtable<String, Integer> sumFormula_;
    private ArrayList<AdductVO> adducts_;
    private Double retentionTime_;
    private Double tolerance_;

    public FragTargetListEntry(String lipidClass, String species, Hashtable<String, Integer> sumFormula, ArrayList<AdductVO> adducts, Double retentionTime, Double tolerance) {
        this.lipidClass_ = lipidClass;
        this.species_ = species;
        this.sumFormula_ = sumFormula;
        this.adducts_ = adducts;
        this.retentionTime_ = retentionTime;
        this.tolerance_ = tolerance;
    }

    public String getLipidClass() {
        return this.lipidClass_;
    }

    public String getSpecies() {
        return this.species_;
    }

    public Hashtable<String, Integer> getSumFormula() {
        return this.sumFormula_;
    }

    public ArrayList<AdductVO> getAdducts() {
        return this.adducts_;
    }

    public Double computeTheoreticalPrecursorMZValue(String adductName) {
        for (AdductVO adduct : this.adducts_) {
            if (!adduct.getAdductName().equalsIgnoreCase(adductName)) continue;
            Double fullMz = 0.0;
            for (String element : this.getSumFormula().keySet()) {
                fullMz = fullMz + Settings.getElementParser().getElementDetails(element).getMonoMass() * (double)this.getSumFormula().get(element).intValue();
            }
            Double adductMz = fullMz;
            for (String element : adduct.getFormula().keySet()) {
                adductMz = adductMz + Settings.getElementParser().getElementDetails(element).getMonoMass() * (double)adduct.getFormula().get(element).intValue();
            }
            return Math.abs(adductMz / (double)adduct.getCharge());
        }
        return null;
    }

    public Double getRetentionTime() {
        return this.retentionTime_;
    }

    public Double getTolerance() {
        return this.tolerance_;
    }

    public int hashCode() {
        return Objects.hash(this.adducts_, this.lipidClass_, this.species_, this.retentionTime_, this.sumFormula_, this.tolerance_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FragTargetListEntry other = (FragTargetListEntry)obj;
        return Objects.equals(this.adducts_, other.adducts_) && Objects.equals(this.lipidClass_, other.lipidClass_) && Objects.equals(this.species_, other.species_) && Objects.equals(this.retentionTime_, other.retentionTime_) && Objects.equals(this.sumFormula_, other.sumFormula_) && Objects.equals(this.tolerance_, other.tolerance_);
    }
}

