/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.fragai.FragTargetListEntry;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.AdductVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Row;
import org.dhatim.fastexcel.reader.Sheet;

public class ExcelTargetListParser {
    private static final String HEADER_CLASS = "Class";
    private static final String HEADER_SPECIES = "Species";
    private static final String HEADER_SUM_FORMULA = "Sum Formula";
    private static final String HEADER_ADDUCTS = "Adducts";
    private static final String HEADER_RETENTION_TIME = "Retention Time";
    private static final String HEADER_TOLERANCE = "Tolerance (+-)";
    private static final String ADDUCT_START = "{";
    private static final String ADDUCT_END = "}";
    private static final String ADDUCT_REGEX = "\\}\\{";
    private static final int HEADER_ROW = 0;
    private File directory_;
    private List<String> headerTitles_;
    private ArrayList<FragTargetListEntry> targetListEntries_;

    public ExcelTargetListParser(File directory) {
        this.directory_ = directory;
        this.targetListEntries_ = new ArrayList();
    }

    public void parse() throws IOException {
        String supportedFormat = ".xlsx";
        if (!this.directory_.getAbsolutePath().endsWith(supportedFormat)) {
            throw new IOException(String.format("Only the file format '%s' is supported!", supportedFormat));
        }
        try (FileInputStream is = new FileInputStream(this.directory_.getAbsolutePath());
             ReadableWorkbook wb = new ReadableWorkbook(is);
             Stream<Sheet> sheets = wb.getSheets();){
            sheets.forEach(s -> {
                try {
                    this.readSheet((Sheet)s);
                }
                catch (ChemicalFormulaException | IOException ex) {
                    this.headerTitles_ = null;
                }
            });
        }
        if (this.headerTitles_ == null) {
            throw new IOException(String.format("The file '%s' was not parsed successfully. Ensure the required worksheet(s) and headers are named according to the template and entries are in the correct format.\n", this.directory_.toString()));
        }
    }

    private void readSheet(Sheet sheet) throws IOException, ChemicalFormulaException {
        List<Row> rows = null;
        rows = sheet.read();
        Row headerRow = rows.get(0);
        this.headerTitles_ = this.readSheetHeaderTitles(headerRow);
        List<Row> contentRows = rows.subList(1, rows.size());
        this.readContentRows(contentRows);
    }

    private void readContentRows(List<Row> contentRows) throws IOException, ChemicalFormulaException {
        if (this.headerTitles_.contains(HEADER_CLASS) && this.headerTitles_.contains(HEADER_SPECIES) && this.headerTitles_.contains(HEADER_SUM_FORMULA) && this.headerTitles_.contains(HEADER_ADDUCTS) && this.headerTitles_.contains(HEADER_RETENTION_TIME) && this.headerTitles_.contains(HEADER_TOLERANCE)) {
            for (Row row : contentRows) {
                List<Cell> cells = this.collectRowCells(row);
                String lipidClass = null;
                String species = null;
                Hashtable<String, Integer> sumFormula = null;
                ArrayList<AdductVO> adducts = null;
                Double retentionTime = null;
                Double tolerance = null;
                for (Cell cell : cells) {
                    int index = cell.getColumnIndex();
                    String rawValue = cell.getRawValue();
                    if (index == this.headerTitles_.indexOf(HEADER_CLASS)) {
                        lipidClass = rawValue;
                        continue;
                    }
                    if (index == this.headerTitles_.indexOf(HEADER_SPECIES)) {
                        species = rawValue;
                        continue;
                    }
                    if (index == this.headerTitles_.indexOf(HEADER_SUM_FORMULA)) {
                        try {
                            sumFormula = StaticUtils.categorizeFormula(rawValue);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (index == this.headerTitles_.indexOf(HEADER_ADDUCTS)) {
                        adducts = new ArrayList<AdductVO>();
                        String[] split = rawValue.split(ADDUCT_REGEX);
                        for (int i = 0; i < split.length; ++i) {
                            adducts.add(new AdductVO(split[i].replace(ADDUCT_START, "").replace(ADDUCT_END, "")));
                        }
                        continue;
                    }
                    if (index == this.headerTitles_.indexOf(HEADER_RETENTION_TIME)) {
                        retentionTime = Double.parseDouble(rawValue);
                        continue;
                    }
                    if (index != this.headerTitles_.indexOf(HEADER_TOLERANCE)) continue;
                    tolerance = Double.parseDouble(rawValue);
                }
                if (lipidClass != null && sumFormula != null && adducts != null && retentionTime != null && tolerance != null) {
                    this.targetListEntries_.add(new FragTargetListEntry(lipidClass, species, sumFormula, adducts, retentionTime, tolerance));
                    continue;
                }
                throw new IOException(String.format("The content row number %s does not contain all required entries! \n", row.getRowNum()));
            }
        } else {
            throw new IOException("The target list does not contain all required headers.");
        }
    }

    private List<String> readSheetHeaderTitles(Row headerRow) {
        try (Stream<Cell> cells = headerRow.stream();){
            List<String> list = cells.map(c -> c != null && !c.getType().equals((Object)CellType.ERROR) ? c.getText() : "null").collect(Collectors.toList());
            return list;
        }
    }

    private List<Cell> collectRowCells(Row row) {
        return row.stream().filter(c -> c != null && !c.getType().equals((Object)CellType.ERROR)).collect(Collectors.toList());
    }

    public ArrayList<FragTargetListEntry> getTargetListEntries() {
        return this.targetListEntries_;
    }
}

